/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.Drawable;
import VASSAL.command.Command;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.SingleChildInstance;
import VASSAL.counters.ColoredBorder;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Stack;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighlightLastMoved
extends AbstractConfigurable
implements Drawable,
MouseListener,
GameComponent {
    public static final String ENABLED = "enabled";
    public static final String COLOR = "color";
    public static final String THICKNESS = "thickness";
    protected ColoredBorder highlighter = new ColoredBorder(Color.RED, 2);
    protected GamePiece lastMoved;
    protected static java.util.Map<Map, HighlightLastMoved> instances = new HashMap<Map, HighlightLastMoved>();
    protected boolean enabled = true;
    protected boolean currentlyEnabled;

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Enabled?", "Color:  ", "Thickness:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{Boolean.class, Color.class, Integer.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{ENABLED, COLOR, THICKNESS};
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (COLOR.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            this.highlighter.setColor((Color)object);
        } else if (THICKNESS.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.highlighter.setThickness((Integer)object);
        } else if (ENABLED.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.enabled = (Boolean)object;
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (COLOR.equals(string)) {
            return ColorConfigurer.colorToString(this.highlighter.getColor());
        }
        if (THICKNESS.equals(string)) {
            return String.valueOf(this.highlighter.getThickness());
        }
        if (ENABLED.equals(string)) {
            return String.valueOf(this.enabled);
        }
        return null;
    }

    @Override
    public void addTo(Buildable buildable) {
        Map map = (Map)buildable;
        map.addDrawComponent(this);
        map.addLocalMouseListener(this);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        instances.put(map, this);
        this.validator = new SingleChildInstance(map, this.getClass());
    }

    @Override
    public void removeFrom(Buildable buildable) {
        Map map = (Map)buildable;
        map.removeDrawComponent(this);
        map.removeLocalMouseListener(this);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
        instances.remove(map);
    }

    @Override
    public void draw(Graphics graphics, Map map) {
        if (this.lastMoved != null && this.enabled) {
            if (this.lastMoved.getMap() == map) {
                this.highlighter.draw(this.lastMoved, graphics, (int)((double)this.lastMoved.getPosition().x * map.getZoom()), (int)((double)this.lastMoved.getPosition().y * map.getZoom()), map.getView(), map.getZoom());
            } else {
                this.lastMoved = null;
            }
        }
    }

    @Override
    public void setup(boolean bl) {
        this.currentlyEnabled = bl && this.enabled;
        this.lastMoved = null;
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    public static void setLastMoved(GamePiece gamePiece) {
        HighlightLastMoved highlightLastMoved = instances.get(gamePiece.getMap());
        if (highlightLastMoved != null) {
            highlightLastMoved.setLastMovedPiece(gamePiece);
        }
    }

    public void setLastMovedPiece(GamePiece gamePiece) {
        if (this.currentlyEnabled) {
            this.lastMoved = gamePiece.getParent() instanceof Stack ? gamePiece.getParent() : gamePiece;
            if (this.lastMoved.getMap() != null) {
                this.lastMoved.getMap().getPieceCollection().moveToFront(this.lastMoved);
            }
        }
    }

    @Override
    public boolean drawAboveCounters() {
        return true;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.lastMoved = null;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "LastMoveHighlighter");
    }

    public static String getConfigureTypeName() {
        return "Last Move Highlighter";
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }
}

