/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.CompoundPieceCollection;
import VASSAL.build.module.map.LayeredPieceCollection;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.LaunchButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerControl
extends AbstractConfigurable {
    public static final String NAME = "name";
    public static final String TOOLTIP = "tooltip";
    public static final String BUTTON_TEXT = "text";
    public static final String BUTTON_ICON = "icon";
    public static final String BUTTON_HOTKEY = "hotkey";
    public static final String COMMAND = "command";
    public static final String SKIP = "skip";
    public static final String LAYERS = "layers";
    public static final String CMD_ROTATE_UP = "Rotate Layer Order Up";
    public static final String CMD_ROTATE_DN = "Rotate Layer Order Down";
    public static final String CMD_ENABLE = "Make Layer Active";
    public static final String CMD_DISABLE = "Make Layer Inactive";
    public static final String CMD_TOGGLE = "Switch Layer between Active and Inactive";
    public static final String CMD_RESET = "Reset All Layers";
    protected LaunchButton launch;
    protected static final String[] COMMANDS = new String[]{"Rotate Layer Order Up", "Rotate Layer Order Down", "Reset All Layers", "Make Layer Active", "Make Layer Inactive", "Switch Layer between Active and Inactive"};
    protected String command = "Reset All Layers";
    protected boolean skip = true;
    protected String[] layers = new String[0];
    protected LayeredPieceCollection pieceLayers;
    protected CompoundPieceCollection pieceCollection;

    public LayerControl() {
        this.launch = new LaunchButton("Reset Layers", TOOLTIP, BUTTON_TEXT, BUTTON_HOTKEY, BUTTON_ICON, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LayerControl.this.launch();
            }
        });
    }

    public void launch() {
        if (this.command.equals(CMD_RESET)) {
            this.pieceCollection.reset();
        } else if (this.command.equals(CMD_ROTATE_UP)) {
            this.pieceCollection.rotate(true, this.skip);
        } else if (this.command.equals(CMD_ROTATE_DN)) {
            this.pieceCollection.rotate(false, this.skip);
        } else if (this.command.equals(CMD_ENABLE)) {
            for (int i = 0; i < this.layers.length; ++i) {
                try {
                    Integer.parseInt(this.layers[i]);
                    this.pieceCollection.setLayerEnabled(i, true);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    this.pieceCollection.setLayerEnabled(this.layers[i], true);
                }
            }
        } else if (this.command.equals(CMD_DISABLE)) {
            for (int i = 0; i < this.layers.length; ++i) {
                try {
                    Integer.parseInt(this.layers[i]);
                    this.pieceCollection.setLayerEnabled(i, false);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    this.pieceCollection.setLayerEnabled(this.layers[i], false);
                }
            }
        } else if (this.command.equals(CMD_TOGGLE)) {
            for (int i = 0; i < this.layers.length; ++i) {
                try {
                    Integer.parseInt(this.layers[i]);
                    this.pieceCollection.toggleLayerEnabled(i);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    this.pieceCollection.toggleLayerEnabled(this.layers[i]);
                }
            }
        } else {
            return;
        }
        this.getMap().repaint();
    }

    public LaunchButton getLaunchButton() {
        return this.launch;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Button text:  ", "Tooltip text:  ", "Button Icon:  ", "Hotkey:  ", "Action:  ", "Skip layers with no counters?", "Affect which layers? (Use layer names or numbers)"};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, Icon.class, KeyStroke.class, CommandConfig.class, Boolean.class, String[].class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{BUTTON_TEXT, TOOLTIP, BUTTON_ICON, BUTTON_HOTKEY, COMMAND, SKIP, LAYERS};
    }

    @Override
    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (COMMAND.equals(string)) {
            return this.command;
        }
        if (SKIP.equals(string)) {
            return String.valueOf(this.skip);
        }
        if (LAYERS.equals(string)) {
            return StringArrayConfigurer.arrayToString(this.layers);
        }
        return this.launch.getAttributeValueString(string);
    }

    @Override
    public void setAttribute(String string, Object stringArray) {
        if (NAME.equals(string)) {
            this.setConfigureName((String)stringArray);
            if (this.launch.getAttributeValueString(TOOLTIP) == null) {
                this.launch.setAttribute(TOOLTIP, (String)stringArray);
            }
        } else if (COMMAND.equals(string)) {
            this.command = (String)stringArray;
        } else if (SKIP.equals(string)) {
            if (stringArray instanceof String) {
                stringArray = Boolean.valueOf((String)stringArray);
            }
            this.skip = (Boolean)stringArray;
        } else if (LAYERS.equals(string)) {
            if (stringArray instanceof String) {
                stringArray = StringArrayConfigurer.stringToArray((String)stringArray);
            }
            this.layers = stringArray;
        } else {
            this.launch.setAttribute(string, stringArray);
        }
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (SKIP.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return LayerControl.this.command.equals(LayerControl.CMD_ROTATE_UP) || LayerControl.this.command.equals(LayerControl.CMD_ROTATE_DN);
                }
            };
        }
        if (LAYERS.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return LayerControl.this.command.equals(LayerControl.CMD_ENABLE) || LayerControl.this.command.equals(LayerControl.CMD_DISABLE) || LayerControl.this.command.equals(LayerControl.CMD_TOGGLE);
                }
            };
        }
        return null;
    }

    @Override
    public void addTo(Buildable buildable) {
        this.pieceLayers = (LayeredPieceCollection)buildable;
        this.pieceLayers.getToolBar().add(this.launch);
        this.pieceCollection = this.pieceLayers.getPieceCollection();
    }

    public Map getMap() {
        return this.pieceLayers.getMap();
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GamePieceLayers.htm");
    }

    public static String getConfigureTypeName() {
        return "Game Piece Layer Control";
    }

    @Override
    public void removeFrom(Buildable buildable) {
        if (this.getMap() != null) {
            this.getMap().getToolBar().remove(this.launch);
        }
    }

    public static class CommandConfig
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return COMMANDS;
        }
    }
}

