/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.CompoundPieceCollection;
import VASSAL.build.module.map.DefaultPieceCollection;
import VASSAL.build.module.map.LayerControl;
import VASSAL.configure.SingleChildInstance;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitor;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Stack;
import VASSAL.tools.TemporaryToolBar;
import javax.swing.JToolBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayeredPieceCollection
extends AbstractConfigurable {
    public static final String PROPERTY_NAME = "property";
    public static final String LAYER_ORDER = "layerOrder";
    protected Collection collection = new Collection("Layer", new String[0]);
    protected Map map;
    protected TemporaryToolBar tempToolBar;

    public LayeredPieceCollection() {
        this.setAttributeTranslatable(PROPERTY_NAME, false);
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Property name for layer:  ", "Layer Order"};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String[].class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{PROPERTY_NAME, LAYER_ORDER};
    }

    @Override
    public String getAttributeValueString(String string) {
        if (PROPERTY_NAME.equals(string)) {
            return this.collection.propertyName;
        }
        if (LAYER_ORDER.equals(string)) {
            return StringArrayConfigurer.arrayToString(this.collection.layerOrder);
        }
        return null;
    }

    @Override
    public void setAttribute(String string, Object stringArray) {
        if (PROPERTY_NAME.equals(string)) {
            this.collection.propertyName = (String)stringArray;
        } else if (LAYER_ORDER.equals(string)) {
            if (stringArray instanceof String) {
                stringArray = StringArrayConfigurer.stringToArray((String)stringArray);
            }
            Collection.access$102(this.collection, stringArray);
            this.collection.initLayers(this.collection.layerOrder.length + 1);
        }
    }

    @Override
    public void addTo(Buildable buildable) {
        this.map = (Map)buildable;
        this.validator = new SingleChildInstance(this.map, this.getClass());
        this.map.setPieceCollection(this.collection);
        if (this.tempToolBar != null) {
            this.tempToolBar.setDelegate(this.map);
        }
    }

    public JToolBar getToolBar() {
        if (this.tempToolBar == null) {
            this.tempToolBar = new TemporaryToolBar();
            if (this.map != null) {
                this.tempToolBar.setDelegate(this.map);
            }
        }
        return this.tempToolBar.getToolBar();
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{LayerControl.class};
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GamePieceLayers.htm");
    }

    public static String getConfigureTypeName() {
        return "Game Piece Layers";
    }

    @Override
    public void removeFrom(Buildable buildable) {
        this.map.setPieceCollection(new DefaultPieceCollection());
        for (LayerControl layerControl : this.getComponentsOf(LayerControl.class)) {
            layerControl.removeFrom(this);
        }
    }

    public Map getMap() {
        return this.map;
    }

    public CompoundPieceCollection getPieceCollection() {
        return this.collection;
    }

    public static class Collection
    extends CompoundPieceCollection
    implements DeckVisitor {
        private String propertyName;
        private String[] layerOrder;
        private DeckVisitorDispatcher dispatcher = new DeckVisitorDispatcher(this);

        public Collection(String string, String[] stringArray) {
            super(0);
            this.setPropertyName(string);
            this.setLayerOrder(stringArray);
        }

        public String[] getLayerOrder() {
            return this.layerOrder;
        }

        public void setLayerOrder(String[] stringArray) {
            this.layerOrder = stringArray;
            this.initLayers(stringArray.length + 1);
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String string) {
            this.propertyName = string;
        }

        public int getLayerForPiece(GamePiece gamePiece) {
            return (Integer)this.dispatcher.accept(gamePiece);
        }

        public int getLayerForName(String string) {
            for (int i = 0; i < this.layerOrder.length; ++i) {
                if (!string.equals(this.layerOrder[i])) continue;
                return i;
            }
            return -1;
        }

        public String getLayerNameForPiece(GamePiece gamePiece) {
            int n = this.getLayerForPiece(gamePiece);
            return n >= this.layerOrder.length ? "" : this.layerOrder[n];
        }

        protected boolean canPiecesMerge(GamePiece gamePiece, GamePiece gamePiece2) {
            return super.canPiecesMerge(gamePiece, gamePiece2) && this.getLayerForPiece(gamePiece) == this.getLayerForPiece(gamePiece2);
        }

        public Object visitDeck(Deck deck) {
            return new Integer(this.layerOrder.length);
        }

        public Object visitDefault(GamePiece gamePiece) {
            String string = (String)gamePiece.getProperty(this.propertyName);
            int n = this.layerOrder.length;
            for (int i = 0; i < this.layerOrder.length; ++i) {
                if (!this.layerOrder[i].equals(string)) continue;
                n = i;
                break;
            }
            return new Integer(n);
        }

        public Object visitStack(Stack stack) {
            GamePiece gamePiece = stack.topPiece();
            if (gamePiece == null) {
                return new Integer(this.layerOrder.length);
            }
            return this.visitDefault(gamePiece);
        }

        static /* synthetic */ String[] access$102(Collection collection, String[] stringArray) {
            collection.layerOrder = stringArray;
            return stringArray;
        }
    }
}

