/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitor;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Stack;
import VASSAL.tools.LaunchButton;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PieceRecenterer
extends AbstractConfigurable
implements DeckVisitor {
    public static final String BUTTON_TEXT = "text";
    public static final String ICON = "icon";
    public static final String HOTKEY = "hotkey";
    public static final String TOOLTIP = "tooltip";
    protected LaunchButton launch;
    protected Map map;
    protected DeckVisitorDispatcher dispatcher;

    public PieceRecenterer() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GameModule.getGameModule().sendAndLog(PieceRecenterer.this.recenter(PieceRecenterer.this.map));
            }
        };
        this.launch = new LaunchButton("Recenter", TOOLTIP, BUTTON_TEXT, HOTKEY, ICON, actionListener);
        this.dispatcher = new DeckVisitorDispatcher(this);
    }

    public Command recenter(Map map) {
        NullCommand nullCommand = new NullCommand();
        GamePiece[] gamePieceArray = map.getPieces();
        Rectangle rectangle = new Rectangle(0, 0, -1, -1);
        for (GamePiece gamePiece : gamePieceArray) {
            if (!Boolean.TRUE.equals(this.dispatcher.accept(gamePiece))) continue;
            Point point = gamePiece.getPosition();
            Rectangle object = gamePiece.getShape().getBounds();
            object.translate(point.x, point.y);
            rectangle.add(object);
        }
        if (rectangle.height >= 0 && rectangle.width >= 0) {
            int n = map.mapSize().width / 2 - (rectangle.x + rectangle.width / 2);
            int n2 = map.mapSize().height / 2 - (rectangle.y + rectangle.height / 2);
            for (GamePiece gamePiece : gamePieceArray) {
                if (!Boolean.TRUE.equals(this.dispatcher.accept(gamePiece))) continue;
                ChangeTracker changeTracker = new ChangeTracker(gamePiece);
                Point point = gamePiece.getPosition();
                point.translate(n, n2);
                gamePiece.setPosition(point);
                nullCommand.append(changeTracker.getChangeCommand());
            }
        }
        map.repaint();
        return nullCommand;
    }

    @Override
    public Object visitDeck(Deck deck) {
        return Boolean.TRUE;
    }

    @Override
    public Object visitDefault(GamePiece gamePiece) {
        return Boolean.TRUE;
    }

    @Override
    public Object visitStack(Stack stack) {
        return stack.getPieceCount() > 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    public static String getConfigureTypeName() {
        return "Recenter Pieces Button";
    }

    @Override
    public void addTo(Buildable buildable) {
        this.map = (Map)buildable;
        this.map.getToolBar().add(this.launch);
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Button text:  ", "Tooltip text:  ", "Button icon:  ", "Hotkey:  "};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{BUTTON_TEXT, TOOLTIP, ICON, HOTKEY};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, IconConfig.class, KeyStroke.class};
    }

    @Override
    public String getAttributeValueString(String string) {
        return this.launch.getAttributeValueString(string);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "PieceRecenterer");
    }

    @Override
    public void removeFrom(Buildable buildable) {
        this.map.getToolBar().remove(this.launch);
    }

    @Override
    public void setAttribute(String string, Object object) {
        this.launch.setAttribute(string, object);
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, "/images/recenter.gif");
        }
    }
}

