/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.BadDataReport;
import VASSAL.build.Buildable;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.NewGameIndicator;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.DrawPile;
import VASSAL.build.module.map.MenuDisplayer;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.widget.PieceSlot;
import VASSAL.command.Command;
import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.StringEnum;
import VASSAL.configure.ValidationReport;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.Stack;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.i18n.Resources;
import VASSAL.tools.AdjustableSpeedScrollPane;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.UniqueIdManager;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.menu.MenuManager;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetupStack
extends AbstractConfigurable
implements GameComponent,
UniqueIdManager.Identifyable {
    private static UniqueIdManager idMgr = new UniqueIdManager("SetupStack");
    public static final String COMMAND_PREFIX = "SETUP_STACK\t";
    protected Point pos = new Point();
    public static final String OWNING_BOARD = "owningBoard";
    public static final String X_POSITION = "x";
    public static final String Y_POSITION = "y";
    protected Map map;
    protected String owningBoardName;
    protected String id;
    public static final String NAME = "name";
    protected static NewGameIndicator indicator;
    protected StackConfigurer stackConfigurer;
    protected JButton configureButton;
    protected String location;
    protected boolean useGridLocation;
    public static final String LOCATION = "location";
    public static final String USE_GRID_LOCATION = "useGridLocation";
    protected Configurer xConfig;
    protected Configurer yConfig;
    protected Configurer locationConfig;
    protected static final Dimension DEFAULT_SIZE;
    protected static final int DELTA = 1;
    protected static final int FAST = 10;
    protected static final int FASTER = 5;
    protected static final int DEFAULT_DUMMY_SIZE = 50;

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (USE_GRID_LOCATION.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    Board board = SetupStack.this.getConfigureBoard();
                    if (board == null) {
                        return false;
                    }
                    return board.getGrid() != null;
                }
            };
        }
        if (LOCATION.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return SetupStack.this.isUseGridLocation();
                }
            };
        }
        if (X_POSITION.equals(string) || Y_POSITION.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return !SetupStack.this.isUseGridLocation();
                }
            };
        }
        return super.getAttributeVisibility(string);
    }

    protected boolean isUseGridLocation() {
        if (!this.useGridLocation) {
            return false;
        }
        Board board = this.getConfigureBoard();
        if (board == null) {
            return false;
        }
        MapGrid mapGrid = board.getGrid();
        return mapGrid != null;
    }

    protected void updatePosition() {
        if (this.isUseGridLocation() && this.location != null && !this.location.equals("")) {
            try {
                this.pos = this.getConfigureBoard().getGrid().getLocation(this.location);
            }
            catch (MapGrid.BadCoords badCoords) {
                ErrorDialog.dataError(new BadDataReport(this, "Error.setup_stack_position_error", this.location, (Throwable)badCoords));
            }
        }
    }

    @Override
    public void validate(Buildable buildable, ValidationReport validationReport) {
        if (this.isUseGridLocation()) {
            if (this.location == null) {
                validationReport.addWarning(this.getConfigureName() + Resources.getString("SetupStack.null_location"));
            } else {
                try {
                    this.getConfigureBoard().getGrid().getLocation(this.location);
                }
                catch (MapGrid.BadCoords badCoords) {
                    String string = "Bad location name " + this.location + " in " + this.getConfigureName();
                    if (badCoords.getMessage() != null) {
                        string = string + ":  " + badCoords.getMessage();
                    }
                    validationReport.addWarning(string);
                }
            }
        }
        super.validate(buildable, validationReport);
    }

    protected void updateLocation() {
        MapGrid mapGrid;
        Board board = this.getConfigureBoard();
        if (board != null && (mapGrid = board.getGrid()) != null) {
            this.location = mapGrid.locationName(this.pos);
        }
    }

    @Override
    public void setup(boolean bl) {
        if (bl && indicator.isNewGame() && this.isOwningBoardActive()) {
            Stack stack = this.initializeContents();
            this.updatePosition();
            Point point = new Point(this.pos);
            if (this.owningBoardName != null) {
                Rectangle rectangle = this.map.getBoardByName(this.owningBoardName).bounds();
                point.translate(rectangle.x, rectangle.y);
            }
            if (this.placeNonStackingSeparately()) {
                for (int i = 0; i < stack.getPieceCount(); ++i) {
                    GamePiece gamePiece = stack.getPieceAt(i);
                    if (!Boolean.TRUE.equals(gamePiece.getProperty("NoStack"))) continue;
                    stack.remove(gamePiece);
                    gamePiece.setParent(null);
                    this.map.placeAt(gamePiece, point);
                    --i;
                }
            }
            this.map.placeAt(stack, point);
        }
    }

    protected boolean placeNonStackingSeparately() {
        return true;
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Name:  ", "Belongs to Board:  ", "Use Grid Location:  ", "Location:  ", "X position:  ", "Y position:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, OwningBoardPrompt.class, Boolean.class, String.class, Integer.class, Integer.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, OWNING_BOARD, USE_GRID_LOCATION, LOCATION, X_POSITION, Y_POSITION};
    }

    @Override
    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (OWNING_BOARD.equals(string)) {
            return this.owningBoardName;
        }
        if (USE_GRID_LOCATION.equals(string)) {
            return Boolean.toString(this.useGridLocation);
        }
        if (LOCATION.equals(string)) {
            return this.location;
        }
        if (X_POSITION.equals(string)) {
            return String.valueOf(this.pos.x);
        }
        if (Y_POSITION.equals(string)) {
            return String.valueOf(this.pos.y);
        }
        return null;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (NAME.equals(string)) {
            this.setConfigureName((String)object);
        } else if (OWNING_BOARD.equals(string)) {
            this.owningBoardName = "<any>".equals(object) ? null : (String)object;
            this.updateConfigureButton();
        } else if (USE_GRID_LOCATION.equals(string)) {
            if (object instanceof String) {
                object = new Boolean((String)object);
            }
            this.useGridLocation = (Boolean)object;
        } else if (LOCATION.equals(string)) {
            this.location = (String)object;
        } else if (X_POSITION.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.pos.x = (Integer)object;
        } else if (Y_POSITION.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.pos.y = (Integer)object;
        }
    }

    @Override
    public void add(Buildable buildable) {
        super.add(buildable);
        this.updateConfigureButton();
    }

    @Override
    public void addTo(Buildable buildable) {
        if (indicator == null) {
            indicator = new NewGameIndicator(COMMAND_PREFIX);
        }
        this.map = (Map)buildable;
        idMgr.add(this);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        this.setAttributeTranslatable(NAME, false);
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{PieceSlot.class};
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("SetupStack.htm");
    }

    public static String getConfigureTypeName() {
        return "At-Start Stack";
    }

    @Override
    public void removeFrom(Buildable buildable) {
        idMgr.remove(this);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
    }

    protected boolean isOwningBoardActive() {
        boolean bl = false;
        if (this.owningBoardName == null) {
            bl = true;
        } else if (this.map.getBoardByName(this.owningBoardName) != null) {
            bl = true;
        }
        return bl;
    }

    protected Stack initializeContents() {
        Stack stack = this.createStack();
        Configurable[] configurableArray = this.getConfigureComponents();
        for (int i = 0; i < configurableArray.length; ++i) {
            if (!(configurableArray[i] instanceof PieceSlot)) continue;
            PieceSlot pieceSlot = (PieceSlot)configurableArray[i];
            GamePiece gamePiece = pieceSlot.getPiece();
            gamePiece = PieceCloner.getInstance().clonePiece(gamePiece);
            GameModule.getGameModule().getGameState().addPiece(gamePiece);
            stack.add(gamePiece);
        }
        GameModule.getGameModule().getGameState().addPiece(stack);
        return stack;
    }

    protected Stack createStack() {
        Stack stack = new Stack();
        return stack;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Configurer getConfigurer() {
        this.config = null;
        Configurer configurer = super.getConfigurer();
        this.xConfig = ((AutoConfigurer)configurer).getConfigurer(X_POSITION);
        this.yConfig = ((AutoConfigurer)configurer).getConfigurer(Y_POSITION);
        this.locationConfig = ((AutoConfigurer)configurer).getConfigurer(LOCATION);
        this.updateConfigureButton();
        ((Container)configurer.getControls()).add(this.configureButton);
        return configurer;
    }

    protected void updateConfigureButton() {
        if (this.configureButton == null) {
            this.configureButton = new JButton("Reposition Stack");
            this.configureButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SetupStack.this.configureStack();
                }
            });
        }
        this.configureButton.setEnabled(this.getConfigureBoard() != null && this.buildComponents.size() > 0);
    }

    protected void configureStack() {
        this.stackConfigurer = new StackConfigurer(this);
        this.stackConfigurer.init();
        this.stackConfigurer.setVisible(true);
    }

    protected PieceSlot getTopPiece() {
        Iterator<PieceSlot> iterator = this.getAllDescendantComponentsOf(PieceSlot.class).iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    protected Board getConfigureBoard() {
        String[] stringArray;
        Board board = null;
        if (this.map != null && !"<any>".equals(this.owningBoardName)) {
            board = this.map.getBoardPicker().getBoard(this.owningBoardName);
        }
        if (board == null && this.map != null && (stringArray = this.map.getBoardPicker().getAllowableBoardNames()).length > 0) {
            board = this.map.getBoardPicker().getBoard(stringArray[0]);
        }
        return board;
    }

    @Override
    public ComponentI18nData getI18nData() {
        ComponentI18nData componentI18nData = super.getI18nData();
        componentI18nData.setAttributeTranslatable(LOCATION, false);
        return componentI18nData;
    }

    static {
        DEFAULT_SIZE = new Dimension(800, 600);
    }

    public static class View
    extends JPanel
    implements DropTargetListener,
    DragGestureListener,
    DragSourceListener,
    DragSourceMotionListener {
        private static final long serialVersionUID = 1L;
        final int CURSOR_ALPHA = 127;
        final int EXTRA_BORDER = 4;
        protected Board myBoard;
        protected MapGrid myGrid;
        protected SetupStack myStack;
        protected GamePiece myPiece;
        protected PieceSlot slot;
        protected DragSource ds = DragSource.getDefaultDragSource();
        protected boolean isDragging = false;
        protected JLabel dragCursor;
        protected JLayeredPane drawWin;
        protected Point drawOffset = new Point();
        protected Rectangle boundingBox;
        protected int currentPieceOffsetX;
        protected int currentPieceOffsetY;
        protected int originalPieceOffsetX;
        protected int originalPieceOffsetY;
        protected Point lastDragLocation = new Point();

        public View(Board board, SetupStack setupStack) {
            this.myBoard = board;
            this.myGrid = board.getGrid();
            this.myStack = setupStack;
            this.slot = this.myStack.getTopPiece();
            if (this.slot != null) {
                this.myPiece = this.slot.getPiece();
            }
            new DropTarget(this, 2, this);
            this.ds.createDefaultDragGestureRecognizer(this, 2, this);
            this.setFocusTraversalKeysEnabled(false);
        }

        public void paint(Graphics graphics) {
            this.myBoard.draw(graphics, 0, 0, 1.0, this);
            Rectangle rectangle = new Rectangle(new Point(), this.myBoard.bounds().getSize());
            if (this.myGrid != null) {
                this.myGrid.draw(graphics, rectangle, rectangle, 1.0, false);
            }
            int n = this.myStack.pos.x;
            int n2 = this.myStack.pos.y;
            this.myStack.stackConfigurer.drawImage(graphics, n, n2, this, 1.0);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.myBoard.bounds().width, this.myBoard.bounds().height);
        }

        public void center(Point point) {
            Rectangle rectangle = this.getVisibleRect();
            if (rectangle.width == 0) {
                rectangle.width = SetupStack.DEFAULT_SIZE.width;
                rectangle.height = SetupStack.DEFAULT_SIZE.height;
            }
            int n = point.x - rectangle.width / 2;
            int n2 = point.y - rectangle.height / 2;
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            this.scrollRectToVisible(new Rectangle(n, n2, rectangle.width, rectangle.height));
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            this.scrollAtEdge(dropTargetDragEvent.getLocation(), 15);
        }

        public void scrollAtEdge(Point point, int n) {
            JScrollPane jScrollPane = this.myStack.stackConfigurer.getScroll();
            Point point2 = new Point(point.x - jScrollPane.getViewport().getViewPosition().x, point.y - jScrollPane.getViewport().getViewPosition().y);
            int n2 = 0;
            int n3 = 0;
            if (point2.x < n && point2.x >= 0) {
                n2 = -1;
            }
            if (point2.x >= jScrollPane.getViewport().getSize().width - n && point2.x < jScrollPane.getViewport().getSize().width) {
                n2 = 1;
            }
            if (point2.y < n && point2.y >= 0) {
                n3 = -1;
            }
            if (point2.y >= jScrollPane.getViewport().getSize().height - n && point2.y < jScrollPane.getViewport().getSize().height) {
                n3 = 1;
            }
            if (n2 != 0 || n3 != 0) {
                Rectangle rectangle = new Rectangle(jScrollPane.getViewport().getViewRect());
                rectangle.translate(2 * n * n2, 2 * n * n3);
                rectangle = rectangle.intersection(new Rectangle(new Point(0, 0), this.getPreferredSize()));
                this.scrollRectToVisible(rectangle);
            }
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            this.removeDragCursor();
            Point point = dropTargetDropEvent.getLocation();
            point.translate(this.currentPieceOffsetX, this.currentPieceOffsetY);
            this.myStack.pos.x = point.x;
            this.myStack.pos.y = point.y;
            this.myStack.stackConfigurer.updateDisplay();
            this.repaint();
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            this.removeDragCursor();
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            Point point = dragGestureEvent.getDragOrigin();
            Point point2 = new Point(this.myStack.pos);
            Rectangle rectangle = this.myStack.stackConfigurer.getPieceBoundingBox();
            rectangle.translate(point2.x, point2.y);
            if (!rectangle.contains(point)) {
                return;
            }
            this.originalPieceOffsetX = point2.x - point.x;
            this.originalPieceOffsetY = point2.y - point.y;
            this.drawWin = null;
            this.makeDragCursor();
            this.setDragCursor();
            SwingUtilities.convertPointToScreen(point, this.drawWin);
            this.moveDragCursor(point.x, point.y);
            try {
                dragGestureEvent.startDrag(Cursor.getPredefinedCursor(12), new StringSelection(""), this);
                dragGestureEvent.getDragSource().addDragSourceMotionListener(this);
            }
            catch (InvalidDnDOperationException invalidDnDOperationException) {
                ErrorDialog.bug(invalidDnDOperationException);
            }
        }

        protected void setDragCursor() {
            JRootPane jRootPane = SwingUtilities.getRootPane(this);
            if (jRootPane != null) {
                if (this.dragCursor.getParent() != null) {
                    this.dragCursor.getParent().remove(this.dragCursor);
                }
                this.drawWin = jRootPane.getLayeredPane();
                this.calcDrawOffset();
                this.dragCursor.setVisible(true);
                this.drawWin.add((Component)this.dragCursor, JLayeredPane.DRAG_LAYER);
            }
        }

        protected void moveDragCursor(int n, int n2) {
            if (this.drawWin != null) {
                this.dragCursor.setLocation(n - this.drawOffset.x, n2 - this.drawOffset.y);
            }
        }

        private void removeDragCursor() {
            if (this.drawWin != null) {
                if (this.dragCursor != null) {
                    this.dragCursor.setVisible(false);
                    this.drawWin.remove(this.dragCursor);
                }
                this.drawWin = null;
            }
        }

        private void calcDrawOffset() {
            if (this.drawWin != null) {
                this.drawOffset.x = -this.boundingBox.x - this.currentPieceOffsetX + 4;
                this.drawOffset.y = -this.boundingBox.y - this.currentPieceOffsetY + 4;
                SwingUtilities.convertPointToScreen(this.drawOffset, this.drawWin);
            }
        }

        private BufferedImage featherDragImage(BufferedImage bufferedImage, int n, int n2, int n3) {
            BufferedImage bufferedImage2 = ImageUtils.createCompatibleTranslucentImage(n, n2);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(new Color(255, 255, 255, 127));
            graphics2D.fillRect(0, 0, n, n2);
            for (int i = 0; i < n3; ++i) {
                int n4 = 127 * (i + 1) / n3;
                graphics2D.setColor(new Color(255, 255, 255, n4));
                graphics2D.drawRect(i, i, n - 2 * i, n2 - 2 * i);
            }
            graphics2D.setComposite(AlphaComposite.getInstance(5));
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.dispose();
            return bufferedImage2;
        }

        private void makeDragCursor() {
            if (this.dragCursor == null) {
                this.dragCursor = new JLabel();
                this.dragCursor.setVisible(false);
            }
            this.currentPieceOffsetX = this.originalPieceOffsetX;
            this.currentPieceOffsetY = this.originalPieceOffsetY;
            this.boundingBox = this.myStack.stackConfigurer.getPieceBoundingBox();
            this.calcDrawOffset();
            int n = this.boundingBox.width + 8;
            int n2 = this.boundingBox.height + 8;
            BufferedImage bufferedImage = ImageUtils.createCompatibleTranslucentImage(n, n2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            this.myStack.stackConfigurer.drawImage(graphics2D, 4 - this.boundingBox.x, 4 - this.boundingBox.y, this.dragCursor, 1.0);
            graphics2D.dispose();
            this.dragCursor.setSize(n, n2);
            bufferedImage = this.featherDragImage(bufferedImage, n, n2, 4);
            this.dragCursor.setIcon(new ImageIcon(bufferedImage));
        }

        public void dragMouseMoved(DragSourceDragEvent dragSourceDragEvent) {
            if (!dragSourceDragEvent.getLocation().equals(this.lastDragLocation)) {
                this.lastDragLocation = dragSourceDragEvent.getLocation();
                this.moveDragCursor(dragSourceDragEvent.getX(), dragSourceDragEvent.getY());
                if (this.dragCursor != null && !this.dragCursor.isVisible()) {
                    this.dragCursor.setVisible(true);
                }
            }
        }
    }

    public class StackConfigurer
    extends JFrame
    implements ActionListener,
    KeyListener,
    MouseListener {
        private static final long serialVersionUID = 1L;
        protected Board board;
        protected View view;
        protected JScrollPane scroll;
        protected SetupStack myStack;
        protected PieceSlot mySlot;
        protected GamePiece myPiece;
        protected Point savePosition;
        protected Dimension dummySize;
        protected BufferedImage dummyImage;

        public StackConfigurer(SetupStack setupStack2) {
            super("Adjust At-Start Stack");
            this.setJMenuBar(MenuManager.getInstance().getMenuBarFor(this));
            this.myStack = setupStack2;
            this.mySlot = setupStack2.getTopPiece();
            if (this.mySlot != null) {
                this.myPiece = this.mySlot.getPiece();
            }
            this.myStack.updatePosition();
            this.savePosition = new Point(this.myStack.pos);
            this.dummySize = setupStack2 instanceof DrawPile ? new Dimension(((DrawPile)setupStack2).getSize()) : new Dimension(50, 50);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    StackConfigurer.this.cancel();
                }
            });
        }

        protected void init() {
            this.board = SetupStack.this.getConfigureBoard();
            this.view = new View(this.board, this.myStack);
            this.view.addKeyListener(this);
            this.view.addMouseListener(this);
            this.view.setFocusable(true);
            this.scroll = new AdjustableSpeedScrollPane(this.view, 22, 32);
            this.scroll.setPreferredSize(DEFAULT_SIZE);
            this.add((Component)this.scroll, "Center");
            Box box = Box.createVerticalBox();
            box.add(new JLabel("Arrow Keys - Move Stack"));
            box.add(new JLabel("Ctrl/Shift Keys - Move Stack Faster  "));
            Box box2 = Box.createHorizontalBox();
            Box box3 = Box.createHorizontalBox();
            JButton jButton = new JButton("Snap to grid");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    StackConfigurer.this.snap();
                    StackConfigurer.this.view.grabFocus();
                }
            });
            box3.add(jButton);
            JButton jButton2 = new JButton("Ok");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    StackConfigurer.this.setVisible(false);
                    SetupStack.this.xConfig.setValue(String.valueOf(StackConfigurer.this.myStack.pos.x));
                    SetupStack.this.yConfig.setValue(String.valueOf(StackConfigurer.this.myStack.pos.y));
                    if (SetupStack.this.locationConfig != null) {
                        SetupStack.this.updateLocation();
                        SetupStack.this.locationConfig.setValue(SetupStack.this.location);
                    }
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.add(jButton2);
            JButton jButton3 = new JButton("Cancel");
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    StackConfigurer.this.cancel();
                    StackConfigurer.this.setVisible(false);
                }
            });
            jPanel.add(jButton3);
            Box box4 = Box.createHorizontalBox();
            box4.add(box);
            box4.add(box2);
            box4.add(box3);
            Box box5 = Box.createVerticalBox();
            box5.add(box4);
            box5.add(jPanel);
            this.add((Component)box5, "South");
            this.scroll.revalidate();
            this.updateDisplay();
            this.pack();
            this.repaint();
        }

        protected void cancel() {
            this.myStack.pos.x = this.savePosition.x;
            this.myStack.pos.y = this.savePosition.y;
        }

        public void updateDisplay() {
            if (!this.view.getVisibleRect().contains(this.myStack.pos)) {
                this.view.center(new Point(this.myStack.pos.x, this.myStack.pos.y));
            }
        }

        protected void snap() {
            MapGrid mapGrid = this.board.getGrid();
            if (mapGrid != null) {
                Point point = mapGrid.snapTo(SetupStack.this.pos);
                SetupStack.this.pos.x = point.x;
                SetupStack.this.pos.y = point.y;
                this.updateDisplay();
                this.repaint();
            }
        }

        public JScrollPane getScroll() {
            return this.scroll;
        }

        public BufferedImage getDummyImage() {
            if (this.dummyImage == null) {
                this.dummyImage = ImageUtils.createCompatibleTranslucentImage(this.dummySize.width * 2, this.dummySize.height * 2);
                Graphics2D graphics2D = this.dummyImage.createGraphics();
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(0, 0, this.dummySize.width, this.dummySize.height);
                graphics2D.setColor(Color.black);
                graphics2D.drawRect(0, 0, this.dummySize.width, this.dummySize.height);
                graphics2D.dispose();
            }
            return this.dummyImage;
        }

        public void drawDummyImage(Graphics graphics, int n, int n2) {
            this.drawDummyImage(graphics, n - this.dummySize.width / 2, n2 - this.dummySize.height / 2, null, 1.0);
        }

        public void drawDummyImage(Graphics graphics, int n, int n2, Component component, double d) {
            graphics.drawImage(this.getDummyImage(), n, n2, component);
        }

        public void drawImage(Graphics graphics, int n, int n2, Component component, double d) {
            Rectangle rectangle;
            Rectangle rectangle2 = rectangle = this.myPiece == null ? null : this.myPiece.boundingBox();
            if (rectangle == null || rectangle.width == 0 || rectangle.height == 0) {
                this.drawDummyImage(graphics, n, n2);
            } else {
                this.myPiece.draw(graphics, n, n2, component, d);
            }
        }

        public Rectangle getPieceBoundingBox() {
            Rectangle rectangle;
            Rectangle rectangle2 = rectangle = this.myPiece == null ? new Rectangle() : this.myPiece.getShape().getBounds();
            if (rectangle == null || rectangle.width == 0 || rectangle.height == 0) {
                rectangle.x = 0 - this.dummySize.width / 2;
                rectangle.y = 0 - this.dummySize.height / 2;
                rectangle.width = this.dummySize.width;
                rectangle.height = this.dummySize.height;
            }
            return rectangle;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.adjustY(-1, keyEvent);
                    break;
                }
                case 40: {
                    this.adjustY(1, keyEvent);
                    break;
                }
                case 37: {
                    this.adjustX(-1, keyEvent);
                    break;
                }
                case 39: {
                    this.adjustX(1, keyEvent);
                    break;
                }
                default: {
                    if (this.myPiece == null) break;
                    this.myPiece.keyEvent(KeyStroke.getKeyStrokeForEvent(keyEvent));
                }
            }
            this.updateDisplay();
            this.repaint();
            keyEvent.consume();
        }

        protected void adjustX(int n, KeyEvent keyEvent) {
            int n2;
            int n3 = n * 1;
            if (keyEvent.isShiftDown()) {
                n3 *= 10;
            }
            if (keyEvent.isControlDown()) {
                n3 *= 5;
            }
            if ((n2 = this.myStack.pos.x + n3) < 0) {
                n2 = 0;
            }
            if ((double)n2 >= this.board.getSize().getWidth()) {
                n2 = (int)this.board.getSize().getWidth() - 1;
            }
            this.myStack.pos.x = n2;
        }

        protected void adjustY(int n, KeyEvent keyEvent) {
            int n2;
            int n3 = n * 1;
            if (keyEvent.isShiftDown()) {
                n3 *= 10;
            }
            if (keyEvent.isControlDown()) {
                n3 *= 5;
            }
            if ((n2 = this.myStack.pos.y + n3) < 0) {
                n2 = 0;
            }
            if ((double)n2 >= this.board.getSize().getHeight()) {
                n2 = (int)this.board.getSize().getHeight() - 1;
            }
            this.myStack.pos.y = n2;
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Rectangle rectangle = this.getPieceBoundingBox();
            rectangle.translate(SetupStack.this.pos.x, SetupStack.this.pos.y);
            if (this.myPiece != null && mouseEvent.isMetaDown() && rectangle.contains(mouseEvent.getPoint())) {
                JPopupMenu jPopupMenu = MenuDisplayer.createPopup(this.myPiece);
                jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                        StackConfigurer.this.view.repaint();
                    }

                    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                        StackConfigurer.this.view.repaint();
                    }

                    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    }
                });
                if (this.view.isShowing()) {
                    jPopupMenu.show(this.view, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    public static class OwningBoardPrompt
    extends StringEnum {
        public static final String ANY = "<any>";

        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            String[] stringArray;
            if (autoConfigurable instanceof SetupStack) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(ANY);
                Map map = ((SetupStack)autoConfigurable).map;
                if (map != null) {
                    arrayList.addAll(Arrays.asList(map.getBoardPicker().getAllowableBoardNames()));
                } else {
                    for (Map map2 : Map.getMapList()) {
                        arrayList.addAll(Arrays.asList(map2.getBoardPicker().getAllowableBoardNames()));
                    }
                }
                stringArray = arrayList.toArray(new String[arrayList.size()]);
            } else {
                stringArray = new String[]{ANY};
            }
            return stringArray;
        }
    }
}

