/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.BadDataReport;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameState;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.AddPiece;
import VASSAL.command.Command;
import VASSAL.command.MoveTracker;
import VASSAL.command.NullCommand;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Highlighter;
import VASSAL.counters.PieceFilter;
import VASSAL.counters.PieceIterator;
import VASSAL.counters.Stack;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.Iterator;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackMetrics
extends AbstractConfigurable {
    protected int exSepX;
    protected int exSepY;
    protected int unexSepX;
    protected int unexSepY;
    protected boolean disabled = false;
    protected KeyStroke topKey = KeyStroke.getKeyStroke(38, 0);
    protected KeyStroke bottomKey = KeyStroke.getKeyStroke(40, 0);
    protected KeyStroke upKey = KeyStroke.getKeyStroke(39, 0);
    protected KeyStroke downKey = KeyStroke.getKeyStroke(37, 0);
    protected PieceFilter unselectedVisible;
    protected PieceFilter selectedVisible;
    protected Color blankColor;
    public static final String EXSEP_X = "exSepX";
    public static final String EXSEP_Y = "exSepY";
    public static final String UNEXSEP_X = "unexSepX";
    public static final String UNEXSEP_Y = "unexSepY";
    public static final String DISABLED = "disabled";
    public static final String TOP_KEY = "top";
    public static final String BOTTOM_KEY = "bottom";
    public static final String UP_KEY = "up";
    public static final String DOWN_KEY = "down";
    public static final String COLOR = "color";
    public static int DEFAULT_EXSEP_X = 6;
    public static int DEFAULT_EXSEP_Y = 18;
    public static int DEFAULT_UNEXSEP_X = 2;
    public static int DEFAULT_UNEXSEP_Y = 4;
    protected Map map;
    private VisibilityCondition cond = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return !StackMetrics.this.disabled;
        }
    };

    @Override
    public void setAttribute(String string, Object object) {
        if (EXSEP_X.equals(string)) {
            if (object instanceof String) {
                try {
                    this.exSepX = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    this.exSepX = DEFAULT_EXSEP_X;
                    ErrorDialog.dataError(new BadDataReport(Resources.getString("Error.bad_preference", EXSEP_X, "StackMetrics"), (String)object, numberFormatException));
                }
            } else if (object != null) {
                this.exSepX = (Integer)object;
            }
        } else if (EXSEP_Y.equals(string)) {
            if (object instanceof String) {
                try {
                    this.exSepY = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    this.exSepY = DEFAULT_EXSEP_Y;
                    ErrorDialog.dataError(new BadDataReport(Resources.getString("Error.bad_preference", EXSEP_Y, "StackMetrics"), (String)object, numberFormatException));
                }
            } else if (object != null) {
                this.exSepY = (Integer)object;
            }
        } else if (UNEXSEP_X.equals(string)) {
            if (object instanceof String) {
                try {
                    this.unexSepX = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    this.unexSepX = DEFAULT_UNEXSEP_X;
                    ErrorDialog.dataError(new BadDataReport(Resources.getString("Error.bad_preference", UNEXSEP_X, "StackMetrics"), (String)object, numberFormatException));
                }
            } else if (object != null) {
                this.unexSepX = (Integer)object;
            }
        } else if (UNEXSEP_Y.equals(string)) {
            if (object instanceof String) {
                try {
                    this.unexSepY = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    this.unexSepY = DEFAULT_UNEXSEP_Y;
                    ErrorDialog.dataError(new BadDataReport(Resources.getString("Error.bad_preference", UNEXSEP_Y, "StackMetrics"), (String)object, numberFormatException));
                }
            } else if (object != null) {
                this.unexSepY = (Integer)object;
            }
        } else if (DISABLED.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.disabled = (Boolean)object;
        } else if (TOP_KEY.equals(string)) {
            this.topKey = HotKeyConfigurer.decode((String)object);
        } else if (BOTTOM_KEY.equals(string)) {
            this.bottomKey = HotKeyConfigurer.decode((String)object);
        } else if (UP_KEY.equals(string)) {
            this.upKey = HotKeyConfigurer.decode((String)object);
        } else if (DOWN_KEY.equals(string)) {
            this.downKey = HotKeyConfigurer.decode((String)object);
        } else if (COLOR.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            this.blankColor = (Color)object;
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (EXSEP_X.equals(string)) {
            return String.valueOf(this.exSepX);
        }
        if (EXSEP_Y.equals(string)) {
            return String.valueOf(this.exSepY);
        }
        if (UNEXSEP_X.equals(string)) {
            return String.valueOf(this.unexSepX);
        }
        if (UNEXSEP_Y.equals(string)) {
            return String.valueOf(this.unexSepY);
        }
        if (DISABLED.equals(string)) {
            return String.valueOf(this.disabled);
        }
        if (TOP_KEY.equals(string)) {
            return HotKeyConfigurer.encode(this.topKey);
        }
        if (BOTTOM_KEY.equals(string)) {
            return HotKeyConfigurer.encode(this.bottomKey);
        }
        if (UP_KEY.equals(string)) {
            return HotKeyConfigurer.encode(this.upKey);
        }
        if (DOWN_KEY.equals(string)) {
            return HotKeyConfigurer.encode(this.downKey);
        }
        if (COLOR.equals(string)) {
            return this.blankColor == null ? null : ColorConfigurer.colorToString(this.blankColor);
        }
        return null;
    }

    @Override
    public void addTo(Buildable buildable) {
        this.map = (Map)buildable;
        this.map.setStackMetrics(this);
    }

    public StackMetrics() {
        this(false, DEFAULT_EXSEP_X, DEFAULT_EXSEP_Y, DEFAULT_UNEXSEP_X, DEFAULT_UNEXSEP_Y);
    }

    public StackMetrics(boolean bl, int n, int n2, int n3, int n4) {
        this.disabled = bl;
        this.exSepX = n;
        this.exSepY = n2;
        this.unexSepX = n3;
        this.unexSepY = n4;
        this.unselectedVisible = new PieceFilter(){

            public boolean accept(GamePiece gamePiece) {
                return !Boolean.TRUE.equals(gamePiece.getProperty("Invisible")) && !Boolean.TRUE.equals(gamePiece.getProperty("Selected"));
            }
        };
        this.selectedVisible = new PieceFilter(){

            public boolean accept(GamePiece gamePiece) {
                return !Boolean.TRUE.equals(gamePiece.getProperty("Invisible")) && Boolean.TRUE.equals(gamePiece.getProperty("Selected"));
            }
        };
    }

    public void draw(Stack stack, Graphics graphics, int n, int n2, Component component, double d) {
        int n3;
        int n4;
        int n5;
        GamePiece gamePiece;
        Highlighter highlighter = stack.getMap() == null ? BasicPiece.getHighlighter() : stack.getMap().getHighlighter();
        Point[] pointArray = new Point[stack.getPieceCount()];
        this.getContents(stack, pointArray, null, null, n, n2);
        PieceIterator pieceIterator = new PieceIterator(stack.getPiecesIterator(), this.unselectedVisible);
        while (pieceIterator.hasMoreElements()) {
            gamePiece = pieceIterator.nextPiece();
            n5 = stack.indexOf(gamePiece);
            n4 = n + (int)(d * (double)(pointArray[n5].x - n));
            n3 = n2 + (int)(d * (double)(pointArray[n5].y - n2));
            if (stack.isExpanded() || !pieceIterator.hasMoreElements()) {
                gamePiece.draw(graphics, n4, n3, component, d);
                continue;
            }
            this.drawUnexpanded(gamePiece, graphics, n4, n3, component, d);
        }
        pieceIterator = new PieceIterator(stack.getPiecesIterator(), this.selectedVisible);
        while (pieceIterator.hasMoreElements()) {
            gamePiece = pieceIterator.nextPiece();
            n5 = stack.indexOf(gamePiece);
            n4 = n + (int)(d * (double)(pointArray[n5].x - n));
            n3 = n2 + (int)(d * (double)(pointArray[n5].y - n2));
            gamePiece.draw(graphics, n4, n3, component, d);
            highlighter.draw(gamePiece, graphics, n4, n3, component, d);
        }
    }

    public void draw(Stack stack, Point point, Graphics graphics, Map map, double d, Rectangle rectangle) {
        Point point2;
        int n;
        GamePiece gamePiece;
        Highlighter highlighter = map.getHighlighter();
        Point point3 = map.mapCoordinates(point);
        Rectangle rectangle2 = rectangle == null ? null : map.mapRectangle(rectangle);
        Point[] pointArray = new Point[stack.getPieceCount()];
        Rectangle[] rectangleArray = rectangle2 == null ? null : new Rectangle[stack.getPieceCount()];
        this.getContents(stack, pointArray, null, rectangleArray, point3.x, point3.y);
        PieceIterator pieceIterator = new PieceIterator(stack.getPiecesIterator(), this.unselectedVisible);
        while (pieceIterator.hasMoreElements()) {
            gamePiece = pieceIterator.nextPiece();
            n = stack.indexOf(gamePiece);
            point2 = map.componentCoordinates(pointArray[n]);
            if (rectangleArray != null && !this.isVisible(rectangle2, rectangleArray[n])) continue;
            if (stack.isExpanded() || !pieceIterator.hasMoreElements()) {
                gamePiece.draw(graphics, point2.x, point2.y, map.getView(), d);
                continue;
            }
            this.drawUnexpanded(gamePiece, graphics, point2.x, point2.y, map.getView(), d);
        }
        pieceIterator = new PieceIterator(stack.getPiecesIterator(), this.selectedVisible);
        while (pieceIterator.hasMoreElements()) {
            gamePiece = pieceIterator.nextPiece();
            n = stack.indexOf(gamePiece);
            if (rectangleArray != null && !this.isVisible(rectangle2, rectangleArray[n])) continue;
            point2 = map.componentCoordinates(pointArray[n]);
            gamePiece.draw(graphics, point2.x, point2.y, map.getView(), d);
            highlighter.draw(gamePiece, graphics, point2.x, point2.y, map.getView(), d);
        }
    }

    private boolean isVisible(Rectangle rectangle, Rectangle rectangle2) {
        boolean bl = true;
        if (rectangle != null) {
            bl = rectangle.intersects(rectangle2);
        }
        return bl;
    }

    protected void drawUnexpanded(GamePiece gamePiece, Graphics graphics, int n, int n2, Component component, double d) {
        if (this.blankColor == null) {
            gamePiece.draw(graphics, n, n2, component, d);
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics.setColor(this.blankColor);
            Shape shape = gamePiece.getShape();
            AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d);
            affineTransform.translate((double)n / d, (double)n2 / d);
            shape = affineTransform.createTransformedShape(shape);
            graphics2D.fill(shape);
            graphics.setColor(Color.black);
            graphics2D.draw(shape);
        }
    }

    public Color getBlankColor() {
        return this.blankColor;
    }

    public int getContents(Stack stack, Point[] pointArray, Shape[] shapeArray, Rectangle[] rectangleArray, int n, int n2) {
        int n3 = stack.getMaximumVisiblePieceCount();
        if (pointArray != null) {
            n3 = Math.min(n3, pointArray.length);
        }
        if (rectangleArray != null) {
            n3 = Math.min(n3, rectangleArray.length);
        }
        if (shapeArray != null) {
            n3 = Math.min(n3, shapeArray.length);
        }
        int n4 = stack.isExpanded() ? this.exSepX : this.unexSepX;
        int n5 = stack.isExpanded() ? this.exSepY : this.unexSepY;
        Point point = null;
        Point point2 = null;
        Rectangle rectangle = null;
        Rectangle rectangle2 = null;
        for (int i = 0; i < n3; ++i) {
            Shape shape;
            GamePiece gamePiece = stack.getPieceAt(i);
            if (Boolean.TRUE.equals(gamePiece.getProperty("Invisible"))) {
                shape = new Rectangle(n, n2, 0, 0);
                if (pointArray != null) {
                    pointArray[i] = shape.getLocation();
                }
                if (rectangleArray != null) {
                    rectangleArray[i] = shape;
                }
                if (shapeArray == null) continue;
                shapeArray[i] = shape;
                continue;
            }
            gamePiece.setProperty("useUnrotatedShape", Boolean.TRUE);
            rectangle2 = gamePiece.getShape().getBounds();
            gamePiece.setProperty("useUnrotatedShape", Boolean.FALSE);
            point2 = new Point(0, 0);
            if (point == null) {
                rectangle = rectangle2;
                rectangle.translate(n, n2);
                point2 = point = new Point(n, n2);
            } else {
                this.nextPosition(point, rectangle, point2, rectangle2, n4, n5);
            }
            if (pointArray != null) {
                pointArray[i] = point2;
            }
            if (rectangleArray != null) {
                shape = gamePiece.boundingBox();
                shape.translate(point2.x, point2.y);
                rectangleArray[i] = shape;
            }
            if (shapeArray != null) {
                shape = gamePiece.getShape();
                shape = AffineTransform.getTranslateInstance(point2.x, point2.y).createTransformedShape(shape);
                shapeArray[i] = shape;
            }
            point = point2;
            rectangle = rectangle2;
        }
        return n3;
    }

    protected void nextPosition(Point point, Rectangle rectangle, Point point2, Rectangle rectangle2, int n, int n2) {
        int n3 = n > 0 ? rectangle.x + n - rectangle2.x : (n < 0 ? rectangle.x + rectangle.width - rectangle2.width + n - rectangle2.x : point.x - point2.x);
        int n4 = n2 > 0 ? rectangle.y + rectangle.height - rectangle2.height - rectangle2.y - n2 : (n2 < 0 ? rectangle.y - n2 - rectangle2.y : point.y - point2.y);
        rectangle2.translate(n3, n4);
        point2.translate(n3, n4);
    }

    public Point relativePosition(Stack stack, GamePiece gamePiece) {
        int n = Math.min(stack.indexOf(gamePiece), stack.getMaximumVisiblePieceCount() - 1);
        if (n < 0) {
            return new Point(0, 0);
        }
        Point[] pointArray = new Point[stack.getMaximumVisiblePieceCount()];
        this.getContents(stack, pointArray, null, null, 0, 0);
        return pointArray[n];
    }

    public boolean isStackingEnabled() {
        return !this.disabled;
    }

    @Override
    public void removeFrom(Buildable buildable) {
    }

    @Override
    public String getConfigureName() {
        return null;
    }

    public static String getConfigureTypeName() {
        return "Stacking options";
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "StackingOptions");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{DISABLED, EXSEP_X, EXSEP_Y, UNEXSEP_X, UNEXSEP_Y, COLOR, TOP_KEY, BOTTOM_KEY, UP_KEY, DOWN_KEY};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Disable stacking?", "Horizontal separation when expanded:  ", "Vertical separation when expanded:  ", "Horizontal separation when not expanded:  ", "Vertical separation when not expanded:  ", "Color of pieces when not expanded:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{Boolean.class, Integer.class, Integer.class, Integer.class, Integer.class, Color.class};
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (string.equals(EXSEP_X) || string.equals(EXSEP_Y) || string.equals(UNEXSEP_X) || string.equals(UNEXSEP_Y) || string.equals(COLOR)) {
            return this.cond;
        }
        return null;
    }

    public Stack createStack(GamePiece gamePiece) {
        return this.createStack(gamePiece, false);
    }

    public Stack createStack(GamePiece gamePiece, boolean bl) {
        return this.isStackingEnabled() || bl ? new Stack(gamePiece) : null;
    }

    public KeyStroke getMoveUpKey() {
        return this.upKey;
    }

    public KeyStroke getMoveDownKey() {
        return this.downKey;
    }

    public KeyStroke getMoveTopKey() {
        return this.topKey;
    }

    public KeyStroke getMoveBottomKey() {
        return this.bottomKey;
    }

    public Command placeOrMerge(GamePiece gamePiece, GamePiece gamePiece2) {
        if (this.disabled) {
            return gamePiece.getMap().placeAt(gamePiece2, gamePiece.getPosition());
        }
        return this.merge(gamePiece, gamePiece2);
    }

    public Command merge(GamePiece gamePiece, GamePiece gamePiece2) {
        Command command;
        if (gamePiece instanceof Stack && ((Stack)gamePiece).topPiece() != null) {
            command = this.merge(((Stack)gamePiece).topPiece(), gamePiece2);
        } else {
            int n;
            MoveTracker moveTracker = new MoveTracker(gamePiece2);
            command = new NullCommand();
            Stack stack = gamePiece.getParent();
            int n2 = n = stack == null ? 0 : stack.indexOf(gamePiece) + 1;
            if (gamePiece2 != gamePiece && gamePiece2 != stack) {
                boolean bl;
                GameState gameState = GameModule.getGameModule().getGameState();
                boolean bl2 = bl = gameState.getPieceForId(gamePiece2.getId()) == null;
                if (stack == null) {
                    if (gamePiece instanceof Stack) {
                        stack = (Stack)gamePiece;
                        n = stack.getPieceCount();
                    } else {
                        stack = this.createStack(gamePiece, true);
                        command = command.append(stack.getMap().placeAt(stack, stack.getPosition()));
                        n = 1;
                    }
                }
                if (bl) {
                    gameState.addPiece(gamePiece2);
                    command = command.append(new AddPiece(gamePiece2));
                }
                if (gamePiece2 instanceof Stack) {
                    Iterator<GamePiece> iterator = ((Stack)gamePiece2).getPiecesIterator();
                    while (iterator.hasNext()) {
                        GamePiece gamePiece3 = iterator.next();
                        MoveTracker moveTracker2 = new MoveTracker(gamePiece3);
                        stack.insertChild(gamePiece3, n++);
                        command = command.append(moveTracker2.getMoveCommand());
                    }
                } else {
                    if (gamePiece2.getParent() == stack && stack != null) {
                        --n;
                    }
                    stack.insert(gamePiece2, n);
                    command = command.append(moveTracker.getMoveCommand());
                }
            }
        }
        return command;
    }
}

