/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.SingleChildInstance;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.LaunchButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Zoomer
extends AbstractConfigurable
implements GameComponent {
    protected Map map;
    @Deprecated
    protected double zoom = 1.0;
    @Deprecated
    protected int zoomLevel = 0;
    @Deprecated
    protected int zoomStart = 1;
    @Deprecated
    protected double[] zoomFactor;
    @Deprecated
    protected int maxZoom = 4;
    protected LaunchButton zoomInButton;
    protected LaunchButton zoomPickButton;
    protected LaunchButton zoomOutButton;
    protected ZoomMenu zoomMenu;
    protected State state = new State(defaultZoomLevels, 2);
    protected static final double[] defaultZoomLevels = new double[]{0.390625, 0.625, 1.0, 1.6};
    protected static final int defaultInitialZoomLevel = 2;
    protected static final String ZOOM_START = "zoomStart";
    protected static final String ZOOM_LEVELS = "zoomLevels";
    protected static final String ZOOM_IN = "zoomInKey";
    protected static final String IN_TOOLTIP = "inTooltip";
    protected static final String IN_BUTTON_TEXT = "inButtonText";
    protected static final String IN_ICON_NAME = "inIconName";
    protected static final String IN_DEFAULT_ICON = "/images/zoomIn.gif";
    protected static final String ZOOM_PICK = "zoomPickKey";
    protected static final String PICK_TOOLTIP = "pickTooltip";
    protected static final String PICK_BUTTON_TEXT = "pickButtonText";
    protected static final String PICK_ICON_NAME = "pickIconName";
    protected static final String PICK_DEFAULT_ICON = "/images/zoom.png";
    protected static final String ZOOM_OUT = "zoomOutKey";
    protected static final String OUT_TOOLTIP = "outTooltip";
    protected static final String OUT_BUTTON_TEXT = "outButtonText";
    protected static final String OUT_ICON_NAME = "outIconName";
    protected static final String OUT_DEFAULT_ICON = "/images/zoomOut.gif";
    private static final String FACTOR = "factor";
    private static final String MAX = "max";
    private int deprecatedMax = -1;
    private double deprecatedFactor = -1.0;

    public Zoomer() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Zoomer.this.zoomIn();
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Zoomer.this.zoomOut();
            }
        };
        this.zoomMenu = new ZoomMenu();
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Zoomer.this.zoomPickButton.isShowing()) {
                    Zoomer.this.zoomMenu.show(Zoomer.this.zoomPickButton, 0, Zoomer.this.zoomPickButton.getHeight());
                }
            }
        };
        this.zoomPickButton = new LaunchButton(null, PICK_TOOLTIP, PICK_BUTTON_TEXT, ZOOM_PICK, PICK_ICON_NAME, actionListener3);
        this.zoomPickButton.setAttribute(PICK_TOOLTIP, Resources.getString("Zoomer.zoom_select"));
        this.zoomPickButton.setAttribute(PICK_ICON_NAME, PICK_DEFAULT_ICON);
        this.zoomInButton = new LaunchButton(null, IN_TOOLTIP, IN_BUTTON_TEXT, ZOOM_IN, IN_ICON_NAME, actionListener);
        this.zoomInButton.setAttribute(IN_TOOLTIP, Resources.getString("Zoomer.zoom_in"));
        this.zoomInButton.setAttribute(IN_ICON_NAME, IN_DEFAULT_ICON);
        this.zoomOutButton = new LaunchButton(null, OUT_TOOLTIP, OUT_BUTTON_TEXT, ZOOM_OUT, OUT_ICON_NAME, actionListener2);
        this.zoomOutButton.setAttribute(OUT_TOOLTIP, Resources.getString("Zoomer.zoom_out"));
        this.zoomOutButton.setAttribute(OUT_ICON_NAME, OUT_DEFAULT_ICON);
        this.setConfigureName(null);
        this.init();
    }

    protected void init() {
        this.zoomInButton.setEnabled(this.state.hasHigherLevel());
        this.zoomPickButton.setEnabled(true);
        this.zoomOutButton.setEnabled(this.state.hasLowerLevel());
        this.zoomMenu.initZoomItems();
    }

    public static String getConfigureTypeName() {
        return "Zoom capability";
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{ZOOM_START, ZOOM_LEVELS, IN_TOOLTIP, IN_BUTTON_TEXT, IN_ICON_NAME, ZOOM_IN, PICK_TOOLTIP, PICK_BUTTON_TEXT, PICK_ICON_NAME, ZOOM_PICK, OUT_TOOLTIP, OUT_BUTTON_TEXT, OUT_ICON_NAME, ZOOM_OUT};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"", "Preset zoom levels:  ", "Zoom in tooltip text:  ", "Zoom in button text:  ", "Zoom in Icon:  ", "Zoom in hotkey:  ", "Zoom select tooltip text", "Zoom select button text", "Zoom select Icon", "Zoom select hotkey", "Zoom out tooltip text:  ", "Zoom out button text:  ", "Zoom out Icon:  ", "Zoom out hotkey:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{null, LevelConfig.class, String.class, String.class, InIconConfig.class, KeyStroke.class, String.class, String.class, PickIconConfig.class, KeyStroke.class, String.class, String.class, OutIconConfig.class, KeyStroke.class};
    }

    @Override
    public void addTo(Buildable buildable) {
        GameModule.getGameModule().getGameState().addGameComponent(this);
        this.map = (Map)buildable;
        this.validator = new SingleChildInstance(this.map, this.getClass());
        this.map.setZoomer(this);
        this.map.getToolBar().add(this.zoomInButton);
        this.map.getToolBar().add(this.zoomPickButton);
        this.map.getToolBar().add(this.zoomOutButton);
    }

    @Override
    public String getAttributeValueString(String string) {
        if (ZOOM_START.equals(string)) {
            return String.valueOf(this.state.getLevelCount() - this.state.getInitialLevel());
        }
        if (ZOOM_LEVELS.equals(string)) {
            List<Double> list = this.state.getLevels();
            String[] stringArray = new String[list.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = list.get(i).toString();
            }
            return StringArrayConfigurer.arrayToString(stringArray);
        }
        if (this.zoomInButton.getAttributeValueString(string) != null) {
            return this.zoomInButton.getAttributeValueString(string);
        }
        if (this.zoomPickButton.getAttributeValueString(string) != null) {
            return this.zoomPickButton.getAttributeValueString(string);
        }
        return this.zoomOutButton.getAttributeValueString(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (ZOOM_START.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            if (object != null) {
                List<Double> list = this.state.getLevels();
                int n = Math.max(0, Math.min(list.size() - 1, list.size() - (Integer)object));
                this.state = new State(list, n);
                if (this.deprecatedFactor > 0.0 && this.deprecatedMax > 0) {
                    this.deprecatedFactor = 0.0;
                    this.deprecatedMax = 0;
                }
                this.init();
            }
        } else if (ZOOM_LEVELS.equals(string)) {
            if (object instanceof String) {
                object = StringArrayConfigurer.stringToArray((String)object);
            }
            if (object != null) {
                HashSet<Double> hashSet = new HashSet<Double>();
                for (String string2 : object) {
                    hashSet.add(Double.valueOf(string2));
                }
                this.state = new State(hashSet, Math.min(this.state.getInitialLevel(), hashSet.size() - 1));
                this.init();
            }
        } else if (FACTOR.equals(string)) {
            if (object instanceof String) {
                object = new Double((String)object);
            }
            if (object != null) {
                this.deprecatedFactor = (Double)object;
                if (this.deprecatedFactor > 0.0 && this.deprecatedMax > 0) {
                    this.adjustStateForFactorAndMax();
                }
            }
        } else if (MAX.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            if (object != null) {
                this.deprecatedMax = (Integer)object;
                if (this.deprecatedFactor > 0.0 && this.deprecatedMax > 0) {
                    this.adjustStateForFactorAndMax();
                }
            }
        } else {
            this.zoomInButton.setAttribute(string, object);
            this.zoomPickButton.setAttribute(string, object);
            this.zoomOutButton.setAttribute(string, object);
        }
    }

    private void adjustStateForFactorAndMax() {
        int n;
        double[] dArray = new double[this.deprecatedMax + 1];
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = Math.pow(this.deprecatedFactor, -(n - 1));
        }
        n = Math.min(this.state.getInitialLevel(), dArray.length - 1);
        this.state = new State(dArray, n);
        this.init();
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void removeFrom(Buildable buildable) {
        this.map = (Map)buildable;
        this.map.setZoomer(null);
        this.map.getToolBar().remove(this.zoomInButton);
        this.map.getToolBar().remove(this.zoomPickButton);
        this.map.getToolBar().remove(this.zoomOutButton);
    }

    public double getZoomFactor() {
        return this.state.getZoom();
    }

    protected Point getMapCenter() {
        Rectangle rectangle = this.map.getView().getVisibleRect();
        return this.map.mapCoordinates(new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2));
    }

    protected void updateZoomer(Point point) {
        this.zoomInButton.setEnabled(this.state.hasHigherLevel());
        this.zoomOutButton.setEnabled(this.state.hasLowerLevel());
        this.zoomMenu.updateZoom();
        Dimension dimension = this.map.getPreferredSize();
        this.map.getView().setBounds(0, 0, dimension.width, dimension.height);
        this.map.centerAt(point);
        this.map.repaint(true);
    }

    public void setZoomLevel(int n) {
        Point point = this.getMapCenter();
        this.state.setLevel(n);
        this.updateZoomer(point);
    }

    public void setZoomFactor(double d) {
        Point point = this.getMapCenter();
        this.state.setZoom(d);
        this.updateZoomer(point);
    }

    public void zoomIn() {
        if (this.state.hasHigherLevel()) {
            Point point = this.getMapCenter();
            this.state.higherLevel();
            this.updateZoomer(point);
        }
    }

    public void zoomOut() {
        if (this.state.hasLowerLevel()) {
            Point point = this.getMapCenter();
            this.state.lowerLevel();
            this.updateZoomer(point);
        }
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "Zoom");
    }

    @Override
    public void setup(boolean bl) {
        if (!bl) {
            this.zoomInButton.setEnabled(this.state.hasHigherLevel());
            this.zoomOutButton.setEnabled(this.state.hasLowerLevel());
        }
        this.zoomPickButton.setEnabled(bl);
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    protected class ZoomDialog
    extends JDialog
    implements ActionListener,
    ChangeListener {
        protected double result;
        protected final JSpinner ratioNumeratorSpinner;
        protected final JSpinner ratioDenominatorSpinner;
        protected final JSpinner percentSpinner;
        protected final SpinnerNumberModel ratioNumeratorModel;
        protected final SpinnerNumberModel ratioDenominatorModel;
        protected final SpinnerNumberModel percentModel;
        protected final JButton okButton;
        private static final long serialVersionUID = 1L;

        public ZoomDialog(Frame frame, String string, boolean bl) {
            super(frame, string, bl);
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            Insets insets = new Insets(0, 0, 11, 11);
            Insets insets2 = new Insets(0, 0, 0, 0);
            JLabel jLabel = new JLabel(Resources.getString("Zoomer.ZoomDialog.zoom_ratio"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = insets;
            gridBagConstraints.anchor = 21;
            jPanel.add((Component)jLabel, gridBagConstraints);
            Box box = new Box(0);
            jLabel.setLabelFor(box);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = insets2;
            gridBagConstraints.anchor = 21;
            jPanel.add((Component)box, gridBagConstraints);
            this.ratioNumeratorModel = new SpinnerNumberModel(1, 1, 256, 1);
            this.ratioNumeratorSpinner = new JSpinner(this.ratioNumeratorModel);
            this.ratioNumeratorSpinner.addChangeListener(this);
            box.add(this.ratioNumeratorSpinner);
            box.add(Box.createHorizontalStrut(5));
            JLabel jLabel2 = new JLabel(":");
            box.add(jLabel2);
            box.add(Box.createHorizontalStrut(5));
            this.ratioDenominatorModel = new SpinnerNumberModel(1, 1, 256, 1);
            this.ratioDenominatorSpinner = new JSpinner(this.ratioDenominatorModel);
            this.ratioDenominatorSpinner.addChangeListener(this);
            box.add(this.ratioDenominatorSpinner);
            JLabel jLabel3 = new JLabel(Resources.getString("Zoomer.ZoomDialog.zoom_percent"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = insets;
            gridBagConstraints.anchor = 21;
            jPanel.add((Component)jLabel3, gridBagConstraints);
            Box box2 = new Box(0);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = insets2;
            gridBagConstraints.anchor = 21;
            jPanel.add((Component)box2, gridBagConstraints);
            this.percentModel = new SpinnerNumberModel(Zoomer.this.state.getZoom() * 100.0, 0.39, 25600.0, 10.0);
            this.percentSpinner = new JSpinner(this.percentModel);
            jLabel3.setLabelFor(this.percentSpinner);
            this.percentSpinner.addChangeListener(this);
            box2.add(this.percentSpinner);
            this.updateRatio();
            box2.add(Box.createHorizontalStrut(5));
            JLabel jLabel4 = new JLabel("%");
            box2.add(jLabel4);
            Box box3 = new Box(0);
            box3.add(Box.createHorizontalGlue());
            this.okButton = new JButton(Resources.getString("General.ok"));
            this.okButton.addActionListener(this);
            this.getRootPane().setDefaultButton(this.okButton);
            box3.add(this.okButton);
            box3.add(Box.createHorizontalStrut(5));
            JButton jButton = new JButton(Resources.getString("General.cancel"));
            jButton.addActionListener(this);
            box3.add(jButton);
            Dimension dimension = this.okButton.getPreferredSize();
            Dimension dimension2 = jButton.getPreferredSize();
            Dimension dimension3 = new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
            this.okButton.setPreferredSize(dimension3);
            jButton.setPreferredSize(dimension3);
            JComponent jComponent = (JComponent)this.getContentPane();
            jComponent.setBorder(new EmptyBorder(12, 12, 11, 11));
            jComponent.setLayout(new BorderLayout(0, 11));
            jComponent.add((Component)jPanel, "Center");
            jComponent.add((Component)box3, "Last");
            this.setResizable(false);
            this.pack();
        }

        public double getResult() {
            return this.result;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.result = actionEvent.getSource() == this.okButton ? this.percentModel.getNumber().doubleValue() : 0.0;
            this.setVisible(false);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == this.ratioNumeratorSpinner || changeEvent.getSource() == this.ratioDenominatorSpinner) {
                this.updatePercent();
            } else if (changeEvent.getSource() == this.percentSpinner) {
                this.updateRatio();
            }
        }

        private void updatePercent() {
            this.percentSpinner.removeChangeListener(this);
            this.percentModel.setValue(new Double(this.ratioNumeratorModel.getNumber().doubleValue() / this.ratioDenominatorModel.getNumber().doubleValue() * 100.0));
            this.percentSpinner.addChangeListener(this);
        }

        private void updateRatio() {
            double d = this.percentModel.getNumber().doubleValue() / 100.0;
            boolean bl = false;
            if (d < 1.0) {
                d = 1.0 / d;
                bl = true;
            }
            int n = 1;
            int n2 = 0;
            int n3 = (int)Math.floor(d);
            int n4 = 1;
            double d2 = d - (double)n3;
            while (Math.abs(d2) >= 1.0E-4 && Math.abs((double)n3 / (double)n4 - d) > 1.0E-4) {
                d2 = 1.0 / d2;
                double d3 = Math.floor(d2);
                int n5 = (int)(d3 * (double)n3 + (double)n);
                int n6 = (int)(d3 * (double)n4 + (double)n2);
                if (n5 > 256 || n6 > 256 || n5 > 1 && n6 > 1 && n5 * n6 > 200) break;
                n = n3;
                n3 = n5;
                n2 = n4;
                n4 = n6;
                d2 -= d3;
            }
            if ((d = (double)n3 / (double)n4) > 256.0) {
                n3 = 256;
                n4 = 1;
            } else if (d < 0.00390625) {
                n3 = 1;
                n4 = 256;
            }
            if (bl) {
                int n7 = n3;
                n3 = n4;
                n4 = n7;
            }
            this.ratioNumeratorSpinner.removeChangeListener(this);
            this.ratioDenominatorSpinner.removeChangeListener(this);
            this.ratioNumeratorModel.setValue(new Integer(n3));
            this.ratioDenominatorModel.setValue(new Integer(n4));
            this.ratioNumeratorSpinner.addChangeListener(this);
            this.ratioDenominatorSpinner.addChangeListener(this);
        }
    }

    protected class ZoomMenu
    extends JPopupMenu
    implements ActionListener {
        protected final JRadioButtonMenuItem other;
        protected final JPopupMenu.Separator sep = new JPopupMenu.Separator();
        protected final ButtonGroup bg;
        private static final String OTHER = "Other...";
        private static final String FIT_WIDTH = "Fit Width";
        private static final String FIT_HEIGHT = "Fit Height";
        private static final String FIT_VISIBLE = "Fit Visible";
        private static final long serialVersionUID = 1L;

        public ZoomMenu() {
            this.add(this.sep);
            this.bg = new ButtonGroup();
            this.other = new JRadioButtonMenuItem(Resources.getString("Zoomer.ZoomMenu.other"));
            this.other.setActionCommand(OTHER);
            this.other.addActionListener(this);
            this.bg.add(this.other);
            this.add(this.other);
            this.addSeparator();
            JMenuItem jMenuItem = new JMenuItem(Resources.getString("Zoomer.ZoomMenu.fit_width"));
            jMenuItem.setActionCommand(FIT_WIDTH);
            jMenuItem.addActionListener(this);
            this.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem(Resources.getString("Zoomer.ZoomMenu.fit_height"));
            jMenuItem2.setActionCommand(FIT_HEIGHT);
            jMenuItem2.addActionListener(this);
            this.add(jMenuItem2);
            JMenuItem jMenuItem3 = new JMenuItem(Resources.getString("Zoomer.ZoomMenu.fit_visible"));
            jMenuItem3.setActionCommand(FIT_VISIBLE);
            jMenuItem3.addActionListener(this);
            this.add(jMenuItem3);
        }

        public void initZoomItems() {
            while (this.getComponent(0) != this.sep) {
                this.remove(0);
            }
            List<Double> list = Zoomer.this.state.getLevels();
            for (int i = 0; i < list.size(); ++i) {
                String string = Long.toString(Math.round(list.get(i) * 100.0)) + "%";
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
                jRadioButtonMenuItem.setActionCommand(Integer.toString(i));
                jRadioButtonMenuItem.addActionListener(this);
                this.bg.add(jRadioButtonMenuItem);
                this.insert(jRadioButtonMenuItem, 0);
            }
            ((JRadioButtonMenuItem)this.getComponent(Zoomer.this.state.getLevelCount() - Zoomer.this.state.getLevel() - 1)).setSelected(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Zoomer.this.setZoomLevel(Integer.parseInt(actionEvent.getActionCommand()));
                return;
            }
            catch (NumberFormatException numberFormatException) {
                String string = actionEvent.getActionCommand();
                if (OTHER.equals(string)) {
                    ZoomDialog zoomDialog = new ZoomDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, Zoomer.this.map.getView()), Resources.getString("Zoomer.ZoomDialog.title"), true);
                    zoomDialog.setVisible(true);
                    double d = zoomDialog.getResult() / 100.0;
                    if (d > 0.0 && d != Zoomer.this.state.getZoom()) {
                        Zoomer.this.setZoomFactor(d);
                    }
                } else if (FIT_WIDTH.equals(string)) {
                    Dimension dimension = Zoomer.this.map.getView().getVisibleRect().getSize();
                    Dimension dimension2 = Zoomer.this.map.mapSize();
                    Zoomer.this.setZoomFactor(dimension.getWidth() / dimension2.getWidth());
                } else if (FIT_HEIGHT.equals(string)) {
                    Dimension dimension = Zoomer.this.map.getView().getVisibleRect().getSize();
                    Dimension dimension3 = Zoomer.this.map.mapSize();
                    Zoomer.this.setZoomFactor(dimension.getHeight() / dimension3.getHeight());
                } else if (FIT_VISIBLE.equals(string)) {
                    Dimension dimension = Zoomer.this.map.getView().getVisibleRect().getSize();
                    Dimension dimension4 = Zoomer.this.map.mapSize();
                    Zoomer.this.setZoomFactor(Math.min(dimension.getWidth() / dimension4.getWidth(), dimension.getHeight() / dimension4.getHeight()));
                } else assert (false);
                return;
            }
        }

        public void updateZoom() {
            if (Zoomer.this.state.atLevel()) {
                ((JRadioButtonMenuItem)this.getComponent(Zoomer.this.state.getLevelCount() - Zoomer.this.state.getLevel() - 1)).setSelected(true);
            } else {
                this.other.setSelected(true);
            }
        }
    }

    protected static class LevelConfigurer
    extends Configurer {
        private Zoomer z;
        private JPanel panel;
        private LevelModel model;
        private JList levelList;
        private JButton addButton;
        private JButton removeButton;
        private JButton initialButton;
        private JTextField levelField;

        public LevelConfigurer(final Zoomer zoomer, String string, String string2) {
            super(string, string2);
            this.z = zoomer;
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 0));
            Box box = Box.createVerticalBox();
            Box box2 = Box.createHorizontalBox();
            this.addButton = new JButton(Resources.getString("General.add"));
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    LevelConfigurer.this.addLevel();
                }
            });
            this.addButton.setEnabled(false);
            box2.add(this.addButton);
            this.levelField = new JTextField(8);
            this.levelField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.levelField.getPreferredSize().height));
            this.levelField.getDocument().addDocumentListener(new DocumentListener(){
                private final String pattern = "^(\\d*[1-9]\\d*(/\\d*[1-9]\\d*|\\.\\d*)?|0*\\.\\d*[1-9]\\d*)$";

                public void changedUpdate(DocumentEvent documentEvent) {
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.validate();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.validate();
                }

                private void validate() {
                    String string = LevelConfigurer.this.levelField.getText();
                    LevelConfigurer.this.addButton.setEnabled(string.matches("^(\\d*[1-9]\\d*(/\\d*[1-9]\\d*|\\.\\d*)?|0*\\.\\d*[1-9]\\d*)$") && !zoomer.state.getLevels().contains(LevelConfigurer.this.parseLevel(string)));
                }
            });
            this.levelField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (LevelConfigurer.this.addButton.isEnabled()) {
                        LevelConfigurer.this.addLevel();
                    }
                }
            });
            box2.add(this.levelField);
            box.add(box2);
            Box box3 = Box.createHorizontalBox();
            this.removeButton = new JButton(Resources.getString("General.remove"));
            this.removeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    int n2 = LevelConfigurer.this.levelList.getSelectedIndex();
                    List<Double> list = zoomer.state.getLevels();
                    if (n2 == zoomer.state.getInitialLevel()) {
                        n = Math.min(n2, zoomer.state.getLevelCount() - 2);
                        list.remove(n2);
                    } else {
                        Double d = list.get(zoomer.state.getInitialLevel());
                        list.remove(n2);
                        n = list.indexOf(d);
                    }
                    zoomer.state = new State(list, n);
                    zoomer.init();
                    LevelConfigurer.this.model.updateModel();
                    LevelConfigurer.this.levelList.setSelectedIndex(Math.max(Math.min(n2, list.size() - 1), 0));
                    LevelConfigurer.this.updateButtons();
                }
            });
            box3.add(this.removeButton);
            this.initialButton = new JButton("Set Initial");
            this.initialButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = LevelConfigurer.this.levelList.getSelectedIndex();
                    zoomer.state = new State(zoomer.state.getLevels(), n);
                    zoomer.init();
                    LevelConfigurer.this.model.updateModel();
                    LevelConfigurer.this.updateButtons();
                }
            });
            box3.add(this.initialButton);
            box.add(box3);
            JLabel jLabel = new JLabel("An '*' indicates the initial zoom level.");
            jLabel.setAlignmentX(0.5f);
            box.add(Box.createVerticalStrut(jLabel.getPreferredSize().height));
            box.add(jLabel);
            box.add(Box.createVerticalStrut(jLabel.getPreferredSize().height));
            this.model = new LevelModel();
            this.levelList = new JList(this.model);
            this.levelList.setSelectionMode(0);
            this.levelList.setSelectedIndex(0);
            this.levelList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    LevelConfigurer.this.updateButtons();
                }
            });
            JSplitPane jSplitPane = new JSplitPane(1);
            jSplitPane.setLeftComponent(box);
            jSplitPane.setRightComponent(new JScrollPane(this.levelList));
            this.panel.add(jSplitPane);
            this.panel.setBorder(new TitledBorder(string2));
            this.updateButtons();
        }

        protected double parseLevel(String string) {
            String[] stringArray = string.split("/");
            try {
                return stringArray.length > 1 ? Double.parseDouble(stringArray[0]) / Double.parseDouble(stringArray[1]) : Double.parseDouble(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                ErrorDialog.bug(numberFormatException);
                return 0.0;
            }
        }

        protected void addLevel() {
            List<Double> list = this.z.state.getLevels();
            Double d = list.get(this.z.state.getInitialLevel());
            double d2 = this.parseLevel(this.levelField.getText());
            list.add(d2);
            Collections.sort(list);
            int n = list.indexOf(d);
            this.z.state = new State(list, n);
            this.z.init();
            this.model.updateModel();
            int n2 = list.indexOf(d2);
            this.levelList.setSelectedIndex(n2);
            this.levelField.setText("");
            this.updateButtons();
        }

        protected void updateButtons() {
            this.removeButton.setEnabled(this.z.state.getLevelCount() > 1);
            this.initialButton.setEnabled(this.levelList.getSelectedIndex() != this.z.state.getInitialLevel());
        }

        public Component getControls() {
            return this.panel;
        }

        public void setValue(Object object) {
        }

        public void setValue(String string) {
        }

        public String getValueString() {
            return null;
        }

        protected class LevelModel
        extends AbstractListModel {
            private static final long serialVersionUID = 1L;

            protected LevelModel() {
            }

            public void updateModel() {
                this.fireContentsChanged(this, 0, ((LevelConfigurer)LevelConfigurer.this).z.state.getLevelCount() - 1);
            }

            public Object getElementAt(int n) {
                return ((LevelConfigurer)LevelConfigurer.this).z.state.getLevels().get(n) + (((LevelConfigurer)LevelConfigurer.this).z.state.getInitialLevel() == n ? " *" : "");
            }

            public int getSize() {
                return ((LevelConfigurer)LevelConfigurer.this).z.state.getLevelCount();
            }
        }
    }

    public static class LevelConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new LevelConfigurer((Zoomer)autoConfigurable, string, string2);
        }
    }

    public static class OutIconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, Zoomer.OUT_DEFAULT_ICON);
        }
    }

    public static class PickIconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, Zoomer.PICK_DEFAULT_ICON);
        }
    }

    public static class InIconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, Zoomer.IN_DEFAULT_ICON);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class State {
        private double custom;
        private final double[] levels;
        private int cur;
        private final int initial;

        public State(double[] dArray, int n) {
            this.levels = dArray;
            Arrays.sort(this.levels);
            this.cur = this.initial = n;
            this.custom = -1.0;
        }

        public State(Collection<Double> collection, int n) {
            this.levels = new double[collection.size()];
            int n2 = 0;
            for (Double d : collection) {
                this.levels[n2++] = d;
            }
            Arrays.sort(this.levels);
            this.cur = this.initial = n;
            this.custom = -1.0;
        }

        public double getZoom() {
            return this.custom < 0.0 ? this.levels[this.cur] : this.custom;
        }

        public void setZoom(double d) {
            if (d <= 0.0) {
                d = Double.MIN_VALUE;
            }
            this.cur = Arrays.binarySearch(this.levels, d);
            if (this.cur < 0) {
                this.cur = -this.cur - 1;
                if (this.cur < this.levels.length && Math.abs(d - this.levels[this.cur]) < 0.005) {
                    this.custom = -1.0;
                } else if (this.cur > 0 && Math.abs(d - this.levels[this.cur - 1]) < 0.005) {
                    --this.cur;
                    this.custom = -1.0;
                } else {
                    this.custom = d;
                }
            } else {
                this.custom = -1.0;
            }
        }

        public int getLevel() {
            return this.cur;
        }

        public void setLevel(int n) {
            this.cur = n;
            this.custom = -1.0;
        }

        public int getInitialLevel() {
            return this.initial;
        }

        public int getLevelCount() {
            return this.levels.length;
        }

        public boolean atLevel() {
            return this.custom < 0.0;
        }

        public void lowerLevel() {
            if (this.custom >= 0.0) {
                this.custom = -1.0;
            }
            --this.cur;
        }

        public void higherLevel() {
            if (this.custom < 0.0) {
                ++this.cur;
            } else {
                this.custom = -1.0;
            }
        }

        public boolean hasLowerLevel() {
            return this.cur > 0;
        }

        public boolean hasHigherLevel() {
            return this.custom < 0.0 ? this.cur < this.levels.length - 1 : this.cur < this.levels.length;
        }

        public List<Double> getLevels() {
            ArrayList<Double> arrayList = new ArrayList<Double>(this.levels.length);
            for (double d : this.levels) {
                arrayList.add(d);
            }
            return arrayList;
        }
    }
}

