/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.board.GeometricGrid;
import VASSAL.build.module.map.boardPicker.board.GridEditor;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridContainer;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridNumbering;
import VASSAL.build.module.map.boardPicker.board.mapgrid.SquareGridNumbering;
import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.StringEnum;
import VASSAL.configure.VisibilityCondition;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SquareGrid
extends AbstractConfigurable
implements GeometricGrid,
GridEditor.EditableGrid {
    protected double dx = 48.0;
    protected double dy = 48.0;
    protected int snapScale = 0;
    protected Point origin = new Point(24, 24);
    protected boolean visible = false;
    protected boolean edgesLegal = false;
    protected boolean cornersLegal = false;
    protected boolean dotsVisible = false;
    protected Color color;
    protected GridContainer container;
    protected Map<Integer, Area> shapeCache = new HashMap<Integer, Area>();
    protected SquareGridEditor gridEditor;
    protected String rangeOption = "Metric";
    private GridNumbering gridNumbering;
    public static final String DX = "dx";
    public static final String DY = "dy";
    public static final String X0 = "x0";
    public static final String Y0 = "y0";
    public static final String VISIBLE = "visible";
    public static final String CORNERS = "cornersLegal";
    public static final String EDGES = "edgesLegal";
    public static final String COLOR = "color";
    public static final String DOTS_VISIBLE = "dotsVisible";
    public static final String RANGE = "range";
    public static final String RANGE_MANHATTAN = "Manhattan";
    public static final String RANGE_METRIC = "Metric";

    @Override
    public GridNumbering getGridNumbering() {
        return this.gridNumbering;
    }

    public void setGridNumbering(GridNumbering gridNumbering) {
        this.gridNumbering = gridNumbering;
    }

    @Override
    public double getDx() {
        return this.dx;
    }

    @Override
    public void setDx(double d) {
        this.dx = d;
    }

    @Override
    public double getDy() {
        return this.dy;
    }

    @Override
    public void setDy(double d) {
        this.dy = d;
    }

    @Override
    public Point getOrigin() {
        return new Point(this.origin);
    }

    @Override
    public void setOrigin(Point point) {
        this.origin.x = point.x;
        this.origin.y = point.y;
    }

    @Override
    public boolean isSideways() {
        return false;
    }

    @Override
    public void setSideways(boolean bl) {
    }

    @Override
    public GridContainer getContainer() {
        return this.container;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{X0, Y0, DX, DY, RANGE, EDGES, CORNERS, VISIBLE, DOTS_VISIBLE, COLOR};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"X offset:  ", "Y offset:  ", "Cell Width:  ", "Cell Height:  ", "Range Calculation Method:  ", "Edges are legal locations?", "Corners are legal locations?", "Show Grid?", "Draw Center Dots?", "Color:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{Integer.class, Integer.class, Double.class, Double.class, RangeOptions.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Color.class};
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (COLOR.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return SquareGrid.this.visible;
                }
            };
        }
        return super.getAttributeVisibility(string);
    }

    @Override
    public void addTo(Buildable buildable) {
        this.container = (GridContainer)((Object)buildable);
        this.container.setGrid(this);
    }

    @Override
    public void removeFrom(Buildable buildable) {
        ((GridContainer)((Object)buildable)).removeGrid(this);
    }

    public static String getConfigureTypeName() {
        return "Rectangular Grid";
    }

    @Override
    public String getGridName() {
        return SquareGrid.getConfigureTypeName();
    }

    @Override
    public String getConfigureName() {
        return null;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("RectangularGrid.htm");
    }

    @Override
    public String getAttributeValueString(String string) {
        if (X0.equals(string)) {
            return String.valueOf(this.origin.x);
        }
        if (Y0.equals(string)) {
            return String.valueOf(this.origin.y);
        }
        if (DY.equals(string)) {
            return String.valueOf(this.dy);
        }
        if (DX.equals(string)) {
            return String.valueOf(this.dx);
        }
        if (RANGE.equals(string)) {
            return this.rangeOption;
        }
        if (CORNERS.equals(string)) {
            return String.valueOf(this.cornersLegal);
        }
        if (EDGES.equals(string)) {
            return String.valueOf(this.edgesLegal);
        }
        if (VISIBLE.equals(string)) {
            return String.valueOf(this.visible);
        }
        if (DOTS_VISIBLE.equals(string)) {
            return String.valueOf(this.dotsVisible);
        }
        if (COLOR.equals(string)) {
            return this.visible ? ColorConfigurer.colorToString(this.color) : null;
        }
        return null;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (object == null) {
            return;
        }
        if (X0.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.origin.x = (Integer)object;
        } else if (Y0.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.origin.y = (Integer)object;
        } else if (DY.equals(string)) {
            if (object instanceof String) {
                object = new Double((String)object);
            }
            this.dy = (Double)object;
        } else if (DX.equals(string)) {
            if (object instanceof String) {
                object = new Double((String)object);
            }
            this.dx = (Double)object;
        } else if (RANGE.equals(string)) {
            this.rangeOption = (String)object;
        } else if (CORNERS.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.cornersLegal = (Boolean)object;
        } else if (EDGES.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.edgesLegal = (Boolean)object;
        } else if (VISIBLE.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.visible = (Boolean)object;
        } else if (DOTS_VISIBLE.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.dotsVisible = (Boolean)object;
        } else if (COLOR.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            this.color = (Color)object;
        }
        this.shapeCache.clear();
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{SquareGridNumbering.class};
    }

    @Override
    public Point getLocation(String string) throws MapGrid.BadCoords {
        if (this.gridNumbering == null) {
            throw new MapGrid.BadCoords();
        }
        return this.gridNumbering.getLocation(string);
    }

    @Override
    public int range(Point point, Point point2) {
        if (this.rangeOption.equals(RANGE_METRIC)) {
            return Math.max(Math.abs((int)Math.floor((double)(point2.x - point.x) / this.dx + 0.5)), Math.abs((int)Math.floor((double)(point2.y - point.y) / this.dy + 0.5)));
        }
        return Math.abs((int)Math.floor((double)(point2.x - point.x) / this.dx + 0.5)) + Math.abs((int)Math.floor((double)(point2.y - point.y) / this.dy + 0.5));
    }

    @Override
    public Area getGridShape(Point point, int n) {
        Area area = this.shapeCache.get(n);
        if (area == null) {
            area = this.getSingleSquareShape(0, 0);
            double d = this.getDx();
            double d2 = this.getDy();
            for (int i = -n; i < n + 1; ++i) {
                int n2 = (int)((double)i * d);
                int n3 = n;
                for (int j = -n3; j < n3 + 1; ++j) {
                    int n4 = (int)((double)j * d2);
                    area.add(this.getSingleSquareShape(n2, n4));
                }
            }
            this.shapeCache.put(n, area);
        }
        area = new Area(AffineTransform.getTranslateInstance(point.x, point.y).createTransformedShape(area));
        return area;
    }

    public Area getSingleSquareShape(int n, int n2) {
        double d = this.getDx();
        double d2 = this.getDy();
        Rectangle rectangle = new Rectangle((int)((double)n - d / 2.0), (int)((double)n2 - d2 / 2.0), (int)d, (int)d2);
        return new Area(rectangle);
    }

    @Override
    public Point snapTo(Point point) {
        int n = point.x - this.origin.x;
        int n2 = (int)Math.round((double)n / (0.5 * this.dx));
        int n3 = point.y - this.origin.y;
        int n4 = (int)Math.round((double)n3 / (0.5 * this.dy));
        Point point2 = null;
        if (!this.cornersLegal || !this.edgesLegal) {
            if (this.cornersLegal) {
                n2 = n4 % 2 == 0 ? 2 * (int)Math.round((double)n / this.dx) : 1 + 2 * (int)Math.round((double)n / this.dx - 0.5);
            } else if (this.edgesLegal) {
                if (n4 % 2 == 0) {
                    if (n2 % 2 == 0) {
                        n2 = 2 * (int)Math.round((double)n / this.dx);
                    }
                } else {
                    n2 = 2 * (int)Math.round((double)n / this.dx);
                }
            } else {
                n2 = 2 * (int)Math.round((double)n / this.dx);
                n4 = 2 * (int)Math.round((double)n3 / this.dy);
                if (this.snapScale > 0) {
                    int n5 = n - (int)Math.round((double)n2 * this.dx / 2.0);
                    n5 = (int)Math.round((double)n5 / (0.5 * this.dx / (double)this.snapScale));
                    n5 = Math.max(n5, 1 - this.snapScale);
                    n5 = Math.min(n5, this.snapScale - 1);
                    n5 = (int)Math.round((double)n5 * 0.5 * this.dx / (double)this.snapScale);
                    int n6 = n3 - (int)Math.round((double)n4 * this.dy / 2.0);
                    n6 = (int)Math.round((double)n6 / (0.5 * this.dy / (double)this.snapScale));
                    n6 = Math.max(n6, 1 - this.snapScale);
                    n6 = Math.min(n6, this.snapScale - 1);
                    n6 = (int)Math.round((double)n6 * 0.5 * this.dy / (double)this.snapScale);
                    point2 = new Point((int)Math.round((double)n2 * this.dx / 2.0 + (double)n5), (int)Math.round((double)n4 * this.dy / 2.0 + (double)n6));
                    point2.translate(this.origin.x, this.origin.y);
                }
            }
        }
        if (point2 == null) {
            point2 = new Point(this.origin.x + (int)Math.round((double)n2 * this.dx / 2.0), this.origin.y + (int)Math.round((double)n4 * this.dy / 2.0));
        }
        return point2;
    }

    @Override
    public boolean isLocationRestricted(Point point) {
        return true;
    }

    @Override
    public String locationName(Point point) {
        return this.gridNumbering == null ? null : this.gridNumbering.locationName(point);
    }

    @Override
    public String localizedLocationName(Point point) {
        return this.gridNumbering == null ? null : this.gridNumbering.localizedLocationName(point);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = true;
    }

    protected void reverse(Point point, Rectangle rectangle) {
        point.x = rectangle.x + rectangle.width - (point.x - rectangle.x);
        point.y = rectangle.y + rectangle.height - (point.y - rectangle.y);
    }

    @Override
    public void draw(Graphics graphics, Rectangle rectangle, Rectangle rectangle2, double d, boolean bl) {
        if (this.visible) {
            this.forceDraw(graphics, rectangle, rectangle2, d, bl);
        }
        if (this.gridNumbering != null) {
            this.gridNumbering.draw(graphics, rectangle, rectangle2, d, bl);
        }
    }

    public void forceDraw(Graphics graphics, Rectangle rectangle, Rectangle rectangle2, double d, boolean bl) {
        double d2;
        if (!rectangle.intersects(rectangle2)) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        Shape shape = graphics2D.getClip();
        if (shape != null) {
            Area area = new Area(shape);
            area.intersect(new Area(rectangle3));
            graphics2D.setClip(area);
        }
        double d3 = d * this.dx;
        double d4 = d * this.dy;
        double d5 = bl ? (double)rectangle.x + d * (double)this.origin.x + (double)rectangle.width - d3 * (double)Math.round(((double)rectangle.x + d * (double)this.origin.x + (double)rectangle.width - (double)rectangle3.x) / d3) + d3 / 2.0 : (double)rectangle.x + d * (double)this.origin.x + d3 * (double)Math.round(((double)(rectangle3.x - rectangle.x) - d * (double)this.origin.x) / d3) + d3 / 2.0;
        double d6 = rectangle3.x + rectangle3.width;
        double d7 = bl ? (double)rectangle.y + d * (double)this.origin.y + (double)rectangle.height - d4 * (double)Math.round(((double)rectangle.y + d * (double)this.origin.y + (double)rectangle.height - (double)rectangle3.y) / d4) + d4 / 2.0 : (double)rectangle.y + d * (double)this.origin.y + d4 * (double)Math.round(((double)(rectangle3.y - rectangle.y) - d * (double)this.origin.y) / d4) + d4 / 2.0;
        double d8 = rectangle3.y + rectangle3.height;
        Point point = new Point();
        Point point2 = new Point();
        graphics2D.setColor(this.color == null ? Color.black : this.color);
        for (d2 = d5; d2 < d6; d2 += d3) {
            point.move((int)Math.round(d2), rectangle3.y);
            point2.move((int)Math.round(d2), rectangle3.y + rectangle3.height);
            graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
        }
        for (d2 = d7; d2 < d8; d2 += d4) {
            graphics2D.drawLine(rectangle3.x, (int)Math.round(d2), rectangle3.x + rectangle3.width, (int)Math.round(d2));
        }
        if (this.dotsVisible) {
            d5 = bl ? (double)rectangle.x + d * (double)this.origin.x + (double)rectangle.width - d3 * (double)Math.round(((double)rectangle.x + d * (double)this.origin.x + (double)rectangle.width - (double)rectangle3.x) / d3) : (double)rectangle.x + d * (double)this.origin.x + d3 * (double)Math.round(((double)(rectangle3.x - rectangle.x) - d * (double)this.origin.x) / d3);
            d7 = bl ? (double)rectangle.y + d * (double)this.origin.y + (double)rectangle.height - d4 * (double)Math.round(((double)rectangle.y + d * (double)this.origin.y + (double)rectangle.height - (double)rectangle3.y) / d4) : (double)rectangle.y + d * (double)this.origin.y + d4 * (double)Math.round(((double)(rectangle3.y - rectangle.y) - d * (double)this.origin.y) / d4);
            for (d2 = d5; d2 < d6; d2 += d3) {
                for (double d9 = d7; d9 < d8; d9 += d4) {
                    point.move((int)Math.round(d2 - 0.5), (int)Math.round(d9 - 0.5));
                    graphics2D.fillRect(point.x, point.y, 2, 2);
                }
            }
        }
        graphics2D.setClip(shape);
    }

    @Override
    public Configurer getConfigurer() {
        boolean bl = this.config != null;
        Configurer configurer = super.getConfigurer();
        if (!bl) {
            JButton jButton = new JButton("Edit Grid");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SquareGrid.this.editGrid();
                }
            });
            ((Container)configurer.getControls()).add(jButton);
        }
        return configurer;
    }

    public void editGrid() {
        this.gridEditor = new SquareGridEditor(this);
        this.gridEditor.setVisible(true);
        AutoConfigurer autoConfigurer = (AutoConfigurer)this.getConfigurer();
        autoConfigurer.getConfigurer(DX).setValue(String.valueOf(this.dx));
        autoConfigurer.getConfigurer(DY).setValue(String.valueOf(this.dy));
        autoConfigurer.getConfigurer(X0).setValue(String.valueOf(this.origin.x));
        autoConfigurer.getConfigurer(Y0).setValue(String.valueOf(this.origin.y));
    }

    public int getSnapScale() {
        return this.snapScale;
    }

    public void setSnapScale(int n) {
        this.snapScale = n;
    }

    public class SquareGridEditor
    extends GridEditor {
        private static final long serialVersionUID = 1L;

        public SquareGridEditor(GridEditor.EditableGrid editableGrid) {
            super(editableGrid);
        }

        public void calculate() {
            if (this.isPerpendicular(this.hp1, this.hp2) && this.isPerpendicular(this.hp1, this.hp3) && !this.isPerpendicular(this.hp2, this.hp3) || this.isPerpendicular(this.hp2, this.hp1) && this.isPerpendicular(this.hp2, this.hp3) && !this.isPerpendicular(this.hp1, this.hp3) || this.isPerpendicular(this.hp3, this.hp1) && this.isPerpendicular(this.hp3, this.hp2) && !this.isPerpendicular(this.hp1, this.hp2)) {
                int n = Math.max(Math.abs(this.hp1.y - this.hp2.y), Math.abs(this.hp1.y - this.hp3.y));
                int n2 = Math.max(Math.abs(this.hp1.x - this.hp2.x), Math.abs(this.hp1.x - this.hp3.x));
                int n3 = Math.min(this.hp1.y, Math.min(this.hp2.y, this.hp3.y));
                int n4 = Math.min(this.hp1.x, Math.min(this.hp2.x, this.hp3.x));
                this.grid.setDx(n2);
                this.grid.setDy(n);
                this.setNewOrigin(new Point(n4 + n2 / 2, n3 + n / 2));
            } else {
                this.reportShapeError();
            }
        }
    }

    public static class RangeOptions
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{SquareGrid.RANGE_METRIC, SquareGrid.RANGE_MANHATTAN};
        }
    }
}

