/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.metadata;

import VASSAL.Info;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.metadata.ModuleMetaData;
import VASSAL.i18n.Translation;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.io.FastByteArrayOutputStream;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.logging.Logger;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class AbstractMetaData {
    protected static final String TRUE = "true";
    protected static final String FALSE = "false";
    protected static final String NAME_ATTR = "name";
    protected static final String VERSION_ATTR = "version";
    protected static final String VASSAL_VERSION_ATTR = "vassalVersion";
    protected static final String DESCRIPTION_ATTR = "description";
    protected static final String EXTENSION_ATTR = "extension";
    protected static final String MODULE_NAME_ATTR = "moduleName";
    protected static final String MODULE_VERSION_ATTR = "moduleVersion";
    protected static final String LANG_ATTR = "lang";
    protected static final String ROOT_ELEMENT = "data";
    protected static final String VERSION_ELEMENT = "version";
    protected static final String VASSAL_VERSION_ELEMENT = "VassalVersion";
    protected static final String MODULE_NAME_ELEMENT = "moduleName";
    protected static final String MODULE_VERSION_ELEMENT = "moduleVersion";
    protected static final String DESCRIPTION_ELEMENT = "description";
    protected static final String NAME_ELEMENT = "name";
    protected static final String DATE_SAVED_ELEMENT = "dateSaved";
    protected static final String BUILDFILE_MODULE_ELEMENT1 = "VASSAL.launch.BasicModule";
    protected static final String BUILDFILE_MODULE_ELEMENT2 = "VASSAL.build.GameModule";
    protected static final String BUILDFILE_EXTENSION_ELEMENT = "VASSAL.build.module.ModuleExtension";
    protected String version;
    protected String vassalVersion;
    protected Attribute descriptionAttr;
    protected static XMLReader parser;

    public AbstractMetaData() {
        this.setVassalVersion(Info.getVersion());
    }

    public String getVersion() {
        return this.version == null ? "" : this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getVassalVersion() {
        return this.vassalVersion == null ? "" : this.vassalVersion;
    }

    public void setVassalVersion(String string) {
        this.vassalVersion = string;
    }

    public void setDescription(Attribute attribute) {
        this.descriptionAttr = attribute;
    }

    public void setDescription(String string) {
        this.descriptionAttr = new Attribute("description", string);
    }

    public String getDescription() {
        return this.descriptionAttr == null ? "" : this.descriptionAttr.getValue();
    }

    public String getLocalizedDescription() {
        return this.descriptionAttr == null ? "" : this.descriptionAttr.getLocalizedValue();
    }

    public void save(ArchiveWriter archiveWriter) throws IOException {
        Object object;
        Document document = null;
        Element element = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            object = document.createElement(ROOT_ELEMENT);
            object.setAttribute("version", this.getMetaDataVersion());
            document.appendChild((Node)object);
            if (this.getVersion() != null) {
                element = document.createElement("version");
                element.appendChild(document.createTextNode(this.getVersion()));
                object.appendChild(element);
            }
            if (this.getVassalVersion() != null) {
                element = document.createElement(VASSAL_VERSION_ELEMENT);
                element.appendChild(document.createTextNode(this.getVassalVersion()));
                object.appendChild(element);
            }
            element = document.createElement(DATE_SAVED_ELEMENT);
            element.appendChild(document.createTextNode(String.valueOf(System.currentTimeMillis())));
            object.appendChild(element);
            if (this.descriptionAttr != null) {
                this.descriptionAttr.generateXML(document, (Element)object, "description");
            }
            this.addElements(document, (Element)object);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ErrorDialog.bug(parserConfigurationException);
            throw (IOException)new IOException().initCause(parserConfigurationException);
        }
        object = new FastByteArrayOutputStream();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(new DOMSource(document), new StreamResult((OutputStream)object));
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            ErrorDialog.bug(transformerConfigurationException);
            throw (IOException)new IOException().initCause(transformerConfigurationException);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            ErrorDialog.bug(transformerFactoryConfigurationError);
            throw (IOException)new IOException().initCause(transformerFactoryConfigurationError);
        }
        catch (TransformerException transformerException) {
            throw (IOException)new IOException().initCause(transformerException);
        }
        archiveWriter.addFile(this.getZipEntryName(), ((FastByteArrayOutputStream)object).toInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyModuleMetadata(ArchiveWriter archiveWriter) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(GameModule.getGameModule().getDataArchive().getInputStream("moduledata"));
            archiveWriter.addFile("moduledata", bufferedInputStream);
            bufferedInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                new ModuleMetaData(GameModule.getGameModule()).save(archiveWriter);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly(bufferedInputStream);
        }
        IOUtils.closeQuietly(bufferedInputStream);
    }

    public abstract String getZipEntryName();

    public abstract String getMetaDataVersion();

    protected abstract void addElements(Document var1, Element var2);

    static {
        try {
            parser = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException sAXException) {
            ErrorDialog.bug(sAXException);
        }
    }

    class BuildFileXMLHandler
    extends DefaultHandler {
        final StringBuilder accumulator = new StringBuilder();

        BuildFileXMLHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXEndException {
            this.accumulator.setLength(0);
        }

        protected String getAttr(Attributes attributes, String string) {
            String string2 = attributes.getValue(string);
            return string2 == null ? "" : string2;
        }

        public void endElement(String string, String string2, String string3) {
        }

        public void characters(char[] cArray, int n, int n2) {
            this.accumulator.append(cArray, n, n2);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            Logger.log(sAXParseException);
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            Logger.log(sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }
    }

    class XMLHandler
    extends DefaultHandler {
        final StringBuilder accumulator = new StringBuilder();
        protected String language = "";

        XMLHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            this.accumulator.setLength(0);
            this.language = this.getAttr(attributes, AbstractMetaData.LANG_ATTR);
        }

        protected String getAttr(Attributes attributes, String string) {
            String string2 = attributes.getValue(string);
            return string2 == null ? "" : string2;
        }

        public void endElement(String string, String string2, String string3) {
            String string4 = this.accumulator.toString().trim();
            if ("version".equals(string3)) {
                AbstractMetaData.this.setVersion(string4);
            } else if (AbstractMetaData.VASSAL_VERSION_ELEMENT.equals(string3)) {
                AbstractMetaData.this.setVassalVersion(string4);
            } else if ("description".equals(string3)) {
                if (AbstractMetaData.this.descriptionAttr == null) {
                    AbstractMetaData.this.setDescription(new Attribute("description", string4));
                } else {
                    AbstractMetaData.this.descriptionAttr.addTranslation(this.language, string4);
                }
            }
        }

        public void characters(char[] cArray, int n, int n2) {
            this.accumulator.append(cArray, n, n2);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            Logger.log(sAXParseException);
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            Logger.log(sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }
    }

    class Attribute {
        protected String attributeName;
        protected String value;
        protected HashMap<String, String> translations = new HashMap();

        public Attribute(Configurable configurable, String string) {
            this.attributeName = string;
            this.value = configurable.getAttributeValueString(this.attributeName);
            String string2 = configurable.getI18nData().getFullPrefix();
            if (string2.length() > 0) {
                string2 = string2 + ".";
            }
            string2 = string2 + this.attributeName;
            for (Translation translation : GameModule.getGameModule().getAllDescendantComponentsOf(Translation.class)) {
                this.addTranslation(translation.getLanguageCode(), translation.translate(string2));
            }
        }

        public Attribute(String string, String string2) {
            this.attributeName = string;
            this.value = string2;
        }

        public void addTranslation(String string, String string2) {
            if (string2 != null) {
                this.translations.put(string, string2);
            }
        }

        public String getValue() {
            return this.value;
        }

        public String getLocalizedValue() {
            String string = Locale.getDefault().getLanguage();
            String string2 = this.translations.get(string);
            return string2 == null ? this.getValue() : string2;
        }

        public void generateXML(Document document, Element element, String string) {
            if (this.value == null) {
                return;
            }
            Element element2 = null;
            element2 = document.createElement(string);
            element2.appendChild(document.createTextNode(this.value));
            element.appendChild(element2);
            for (String string2 : this.translations.keySet()) {
                String string3 = this.translations.get(string2);
                element2 = document.createElement(string);
                element2.setAttribute(AbstractMetaData.LANG_ATTR, string2);
                element2.appendChild(document.createTextNode(string3));
                element.appendChild(element2);
            }
        }
    }

    class SAXEndException
    extends SAXException {
        private static final long serialVersionUID = 1L;

        SAXEndException() {
        }
    }
}

