/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.noteswindow;

import VASSAL.build.BadDataReport;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.noteswindow.AddSecretNoteCommand;
import VASSAL.build.module.noteswindow.SecretNote;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.TextConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.WarningDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class SecretNotesController
implements GameComponent,
CommandEncoder,
AddSecretNoteCommand.Interface {
    public static final String COMMAND_PREFIX = "SNOTE\t";
    private Controls controls;
    private JPanel panel;
    private List<SecretNote> notes = new ArrayList<SecretNote>();
    private List<SecretNote> lastSavedNotes;
    public static final int COL_HANDLE = 0;
    public static final int COL_DTM = 1;
    public static final int COL_NAME = 2;
    public static final int COL_REVEALED = 3;
    public static final DateFormat INTERNAL_DATE_FORMATTER = DateFormat.getDateTimeInstance(3, 3, Locale.US);
    public static final DateFormat LOCAL_DATE_FORMATTER = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());

    public SecretNotesController() {
        this.controls = new Controls();
    }

    public Command getRestoreCommand() {
        AddSecretNoteCommand addSecretNoteCommand = null;
        for (SecretNote secretNote : this.notes) {
            AddSecretNoteCommand addSecretNoteCommand2 = new AddSecretNoteCommand(this, secretNote);
            if (addSecretNoteCommand == null) {
                addSecretNoteCommand = addSecretNoteCommand2;
                continue;
            }
            addSecretNoteCommand.append(addSecretNoteCommand2);
        }
        return addSecretNoteCommand;
    }

    public void setup(boolean bl) {
        if (!bl) {
            this.notes.clear();
            this.controls.refresh();
        }
    }

    public Command decode(String string) {
        AddSecretNoteCommand addSecretNoteCommand = null;
        if (string.startsWith(COMMAND_PREFIX)) {
            Object object;
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string.substring(COMMAND_PREFIX.length()), '\t');
            String string2 = decoder.nextToken();
            String string3 = decoder.nextToken();
            boolean bl = "true".equals(decoder.nextToken());
            String string4 = TextConfigurer.restoreNewlines(decoder.nextToken());
            String string5 = "";
            Date date = null;
            if (decoder.hasMoreTokens()) {
                object = decoder.nextToken();
                try {
                    date = INTERNAL_DATE_FORMATTER.parse((String)object);
                }
                catch (ParseException parseException) {
                    ErrorDialog.dataError(new BadDataReport("Illegal date format", (String)object, parseException));
                }
            }
            if (decoder.hasMoreTokens()) {
                string5 = decoder.nextToken();
            }
            object = new SecretNote(string2, string3, string4, bl, date, string5);
            addSecretNoteCommand = new AddSecretNoteCommand(this, (SecretNote)object);
        }
        return addSecretNoteCommand;
    }

    public String encode(Command command) {
        String string = null;
        if (command instanceof AddSecretNoteCommand) {
            SecretNote secretNote = ((AddSecretNoteCommand)command).getNote();
            SequenceEncoder sequenceEncoder = new SequenceEncoder('\t');
            String string2 = secretNote.getDate() == null ? "" : INTERNAL_DATE_FORMATTER.format(secretNote.getDate());
            string = COMMAND_PREFIX + sequenceEncoder.append(secretNote.getName()).append(secretNote.getOwner()).append(secretNote.isHidden()).append(TextConfigurer.escapeNewlines(secretNote.getText())).append(string2).append(secretNote.getHandle()).getValue();
        }
        return string;
    }

    public void addSecretNote(SecretNote secretNote) {
        int n = this.notes.indexOf(secretNote);
        if (n >= 0) {
            this.notes.set(n, secretNote);
        } else {
            this.notes.add(0, secretNote);
        }
        this.controls.refresh();
    }

    public JComponent getControls() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            JLabel jLabel = new JLabel(Resources.getString("Notes.visible_once_revealed"));
            jLabel.setAlignmentX(0.0f);
            this.panel.add(jLabel);
            this.panel.add(this.controls);
        }
        return this.panel;
    }

    public Command save() {
        AddSecretNoteCommand addSecretNoteCommand = null;
        for (SecretNote secretNote : this.notes) {
            int n = this.lastSavedNotes.indexOf(secretNote);
            if (n >= 0 && this.lastSavedNotes.get(n).isHidden() == secretNote.isHidden()) continue;
            Command command = new AddSecretNoteCommand(this, secretNote);
            if (addSecretNoteCommand == null) {
                addSecretNoteCommand = command;
            } else {
                addSecretNoteCommand.append(command);
            }
            String string = n < 0 ? "* " + Resources.getString("Notes.has_created", GlobalOptions.getInstance().getPlayerId(), secretNote.getName()) + " *" : "* " + Resources.getString("Notes.has_revealed", GlobalOptions.getInstance().getPlayerId(), secretNote.getName()) + " *";
            command = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), string);
            command.execute();
            addSecretNoteCommand.append(command);
        }
        return addSecretNoteCommand;
    }

    public void captureState() {
        this.lastSavedNotes = new ArrayList<SecretNote>(this.notes);
    }

    public void restoreState() {
        this.notes.clear();
        this.notes.addAll(this.lastSavedNotes);
        this.controls.refresh();
    }

    public SecretNote getNoteForName(String string) {
        for (SecretNote secretNote : this.notes) {
            if (!secretNote.getName().equals(string)) continue;
            return secretNote;
        }
        return null;
    }

    private class Controls
    extends JPanel
    implements ItemListener {
        private static final long serialVersionUID = 1L;
        private JTextArea text;
        private JTable table;
        private JButton revealButton;
        private String[] columnNames = new String[]{Resources.getString("Notes.player"), Resources.getString("Notes.date_time"), Resources.getString("Notes.note_name"), Resources.getString("Notes.revealed")};

        public Controls() {
            this.setLayout(new BoxLayout(this, 1));
            this.table = new JTable(new MyTableModel());
            this.initColumns(this.table);
            this.table.setSelectionMode(0);
            ListSelectionModel listSelectionModel = this.table.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    if (!listSelectionModel.isSelectionEmpty()) {
                        Controls.this.displaySelected();
                    }
                }
            });
            ScrollPane scrollPane = new ScrollPane(this.table);
            this.table.setPreferredScrollableViewportSize(new Dimension(500, 100));
            this.add(scrollPane);
            Box box = Box.createHorizontalBox();
            box.setAlignmentX(0.0f);
            JButton jButton = new JButton(Resources.getString("General.new"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Controls.this.createNewNote();
                }
            });
            box.add(jButton);
            this.revealButton = new JButton(Resources.getString("Notes.reveal"));
            this.revealButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Controls.this.revealSelectedNote();
                }
            });
            this.revealButton.setEnabled(false);
            box.add(this.revealButton);
            this.add(box);
            this.text = new JTextArea(6, 20);
            this.text.setEditable(false);
            ScrollPane scrollPane2 = new ScrollPane(this.text);
            scrollPane2.setBorder(new TitledBorder(Resources.getString("Notes.text")));
            this.add(scrollPane2);
        }

        private void initColumns(JTable jTable) {
            TableColumn tableColumn = null;
            for (int i = 0; i < this.columnNames.length; ++i) {
                int n;
                tableColumn = jTable.getColumnModel().getColumn(i);
                switch (i) {
                    case 0: {
                        n = 60;
                        break;
                    }
                    case 1: {
                        n = 100;
                        break;
                    }
                    case 2: {
                        n = 280;
                        break;
                    }
                    case 3: {
                        n = 60;
                        break;
                    }
                    default: {
                        n = 100;
                    }
                }
                tableColumn.setPreferredWidth(n);
            }
        }

        public void refresh() {
            this.table.setModel(new MyTableModel());
            this.initColumns(this.table);
            this.displaySelected();
        }

        private void revealSelectedNote() {
            int n = this.table.getSelectedRow();
            if (n < 0) {
                return;
            }
            String string = (String)this.table.getValueAt(n, 2);
            SecretNote secretNote = SecretNotesController.this.getNoteForName(string);
            if (secretNote.getOwner().equals(GameModule.getUserId()) && (secretNote = new SecretNote(secretNote.getName(), secretNote.getOwner(), secretNote.getText(), false, secretNote.getDate(), secretNote.getHandle())) != null) {
                int n2 = SecretNotesController.this.notes.indexOf(secretNote);
                SecretNotesController.this.notes.set(n2, secretNote);
                this.refresh();
            }
        }

        public void createNewNote() {
            Dialog dialog = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, this);
            final JDialog jDialog = dialog != null ? new JDialog(dialog, true) : new JDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this), true);
            jDialog.setTitle(Resources.getString("Notes.delayed_note"));
            final StringConfigurer stringConfigurer = new StringConfigurer(null, Resources.getString("Notes.name"));
            final TextConfigurer textConfigurer = new TextConfigurer(null, Resources.getString("Notes.text"));
            jDialog.setLayout(new BoxLayout(jDialog.getContentPane(), 1));
            jDialog.add(stringConfigurer.getControls());
            jDialog.add(textConfigurer.getControls());
            Box box = Box.createHorizontalBox();
            final JButton jButton = new JButton(Resources.getString("General.ok"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SecretNote secretNote = new SecretNote(stringConfigurer.getValueString(), GameModule.getUserId(), (String)textConfigurer.getValue(), true);
                    if (SecretNotesController.this.notes.contains(secretNote)) {
                        WarningDialog.show((Component)Controls.this, "Notes.note_exists", new Object[0]);
                    } else {
                        SecretNotesController.this.notes.add(0, secretNote);
                        Controls.this.refresh();
                        jDialog.dispose();
                    }
                }
            });
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    jButton.setEnabled(stringConfigurer.getValueString() != null && stringConfigurer.getValueString().length() > 0 && textConfigurer.getValueString() != null && textConfigurer.getValueString().length() > 0);
                }
            };
            stringConfigurer.addPropertyChangeListener(propertyChangeListener);
            textConfigurer.addPropertyChangeListener(propertyChangeListener);
            jButton.setEnabled(false);
            box.add(jButton);
            JButton jButton2 = new JButton(Resources.getString("General.cancel"));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jDialog.dispose();
                }
            });
            jDialog.add(box);
            jDialog.pack();
            jDialog.setLocationRelativeTo(jDialog.getOwner());
            jDialog.setVisible(true);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.displaySelected();
        }

        private void displaySelected() {
            this.revealButton.setEnabled(false);
            this.text.setText("");
            int n = this.table.getSelectedRow();
            if (n < 0) {
                return;
            }
            String string = (String)this.table.getValueAt(n, 2);
            SecretNote secretNote = SecretNotesController.this.getNoteForName(string);
            if (secretNote != null) {
                if (secretNote.getOwner().equals(GameModule.getUserId())) {
                    this.text.setText(secretNote.getText());
                    this.revealButton.setEnabled(secretNote.isHidden());
                } else {
                    this.text.setText(secretNote.isHidden() ? Resources.getString("Notes.message_not_revealed") : secretNote.getText());
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class MyTableModel
        extends AbstractTableModel {
            private static final long serialVersionUID = 1L;

            @Override
            public String getColumnName(int n) {
                return Controls.this.columnNames[n].toString();
            }

            @Override
            public int getRowCount() {
                return SecretNotesController.this.notes.size();
            }

            @Override
            public int getColumnCount() {
                return Controls.this.columnNames.length;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                SecretNote secretNote = (SecretNote)SecretNotesController.this.notes.get(n);
                switch (n2) {
                    case 0: {
                        return secretNote.getHandle();
                    }
                    case 1: {
                        return secretNote.getDate() == null ? "" : LOCAL_DATE_FORMATTER.format(secretNote.getDate());
                    }
                    case 2: {
                        return secretNote.getName();
                    }
                    case 3: {
                        return !secretNote.isHidden();
                    }
                }
                return null;
            }

            @Override
            public Class<?> getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
            }
        }
    }
}

