/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.turn;

import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.turn.TurnLevel;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.i18n.Resources;
import VASSAL.tools.FormattedString;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListTurnLevel
extends TurnLevel
implements ActionListener {
    protected static final String LIST = "list";
    protected static final String CONFIG_LIST = "configList";
    protected static final String CONFIG_FIRST = "configFirst";
    protected static final String PROMPT = "prompt";
    protected int first = 0;
    protected String[] list = new String[0];
    protected boolean[] active = new boolean[0];
    protected boolean configList = false;
    protected boolean configFirst = false;
    protected String prompt = null;
    protected JDialog configDialog;
    protected Component setControls;
    private VisibilityCondition promptCond = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return ListTurnLevel.this.configFirst;
        }
    };

    public ListTurnLevel() {
        this.turnFormat = new FormattedString("$value$");
    }

    @Override
    protected void reset() {
        super.reset();
        for (int i = 0; i < this.active.length; ++i) {
            this.active[i] = true;
        }
        this.setLow();
    }

    @Override
    protected void setLow() {
        this.current = this.first;
        super.setLow();
    }

    @Override
    protected void setHigh() {
        this.current = this.first;
        --this.current;
        if (this.current < 0) {
            this.current = this.list.length - 1;
        }
        super.setHigh();
    }

    @Override
    protected String getState() {
        int n;
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.current);
        sequenceEncoder.append(this.currentSubLevel);
        sequenceEncoder.append(this.first);
        String[] stringArray = new String[this.active.length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = this.active[n] + "";
        }
        sequenceEncoder.append(stringArray);
        for (n = 0; n < this.getTurnLevelCount(); ++n) {
            sequenceEncoder.append(this.getTurnLevel(n).getState());
        }
        return sequenceEncoder.getValue();
    }

    @Override
    protected void setState(String string) {
        int n;
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        this.current = decoder.nextInt(this.start);
        this.currentSubLevel = decoder.nextInt(0);
        this.first = decoder.nextInt(0);
        String[] stringArray = decoder.nextStringArray(0);
        this.active = new boolean[this.list.length];
        int n2 = Math.min(stringArray.length, this.active.length);
        for (n = 0; n < n2; ++n) {
            this.active[n] = stringArray[n].equals("true");
        }
        for (n = 0; n < this.getTurnLevelCount(); ++n) {
            this.getTurnLevel(n).setState(decoder.nextToken(""));
        }
        this.myValue.setPropertyValue(this.getValueString());
    }

    @Override
    protected String getValueString() {
        if (this.current >= 0 && this.current <= this.list.length - 1) {
            return this.list[this.current];
        }
        return "";
    }

    @Override
    protected String getLongestValueName() {
        String string = "X";
        for (int i = 0; i < this.list.length; ++i) {
            if (this.list[i].length() <= string.length()) continue;
            string = this.list[i];
        }
        return string;
    }

    @Override
    protected void advance() {
        super.advance();
        if (this.getTurnLevelCount() == 0 || this.getTurnLevelCount() > 0 && this.hasSubLevelRolledOver()) {
            int n = this.current;
            boolean bl = false;
            for (int i = 0; i < this.list.length && !bl; ++i) {
                if (++n >= this.list.length) {
                    n = 0;
                }
                if (n == this.first) {
                    this.rolledOver = true;
                }
                bl = this.active[n];
            }
            this.current = n;
            if (!bl) {
                this.rolledOver = true;
            }
        }
        this.myValue.setPropertyValue(this.getValueString());
    }

    @Override
    protected void retreat() {
        super.retreat();
        if (this.getTurnLevelCount() == 0 || this.getTurnLevelCount() > 0 && this.hasSubLevelRolledOver()) {
            int n = this.current;
            boolean bl = false;
            for (int i = 0; i < this.list.length && !bl; ++i) {
                if (n == this.first) {
                    this.rolledOver = true;
                }
                if (--n < 0 || n > this.list.length - 1) {
                    n = this.list.length - 1;
                }
                bl = this.active[n];
            }
            this.current = n;
        }
        this.myValue.setPropertyValue(this.getValueString());
    }

    @Override
    protected boolean isActive() {
        for (int i = 0; i < this.active.length; ++i) {
            if (!this.active[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void buildConfigMenu(JMenu jMenu) {
        JMenu jMenu2 = this.getConfigMenu();
        if (jMenu2 != null) {
            jMenu.add(jMenu2);
        }
        if (this.configFirst || this.configList) {
            JMenuItem jMenuItem = new JMenuItem(Resources.getString("TurnTracker.configure2", this.getConfigureName()));
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.configDialog = new ConfigDialog();
        this.configDialog.setVisible(true);
    }

    @Override
    protected Component getSetControl() {
        StringEnumConfigurer stringEnumConfigurer = new StringEnumConfigurer("", " " + this.getConfigureName() + ":  ", this.list);
        stringEnumConfigurer.setValue(this.list[this.current]);
        stringEnumConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = ((StringEnumConfigurer)propertyChangeEvent.getSource()).getValueString();
                for (int i = 0; i < ListTurnLevel.this.list.length; ++i) {
                    if (!string.equals(ListTurnLevel.this.list[i])) continue;
                    ListTurnLevel.this.current = i;
                    ListTurnLevel.this.myValue.setPropertyValue(ListTurnLevel.this.getValueString());
                }
            }
        });
        return stringEnumConfigurer.getControls();
    }

    @Override
    public String[] getAttributeDescriptions() {
        String[] stringArray = super.getAttributeDescriptions();
        String[] stringArray2 = new String[]{"List of Items", "Allow players to hide items in this list?", "Allow players to change which item goes first?", "Prompt to players to select which item goes first:  "};
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        Class<?>[] classArray = super.getAttributeTypes();
        Class[] classArray2 = new Class[]{String[].class, Boolean.class, Boolean.class, String.class};
        Class[] classArray3 = new Class[classArray.length + classArray2.length];
        System.arraycopy(classArray, 0, classArray3, 0, classArray.length);
        System.arraycopy(classArray2, 0, classArray3, classArray.length, classArray2.length);
        return classArray3;
    }

    @Override
    public String[] getAttributeNames() {
        String[] stringArray = super.getAttributeNames();
        String[] stringArray2 = new String[]{LIST, CONFIG_LIST, CONFIG_FIRST, PROMPT};
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (LIST.equals(string)) {
            if (object instanceof String) {
                object = StringArrayConfigurer.stringToArray((String)object);
            }
            this.list = object;
            this.active = new boolean[this.list.length];
            for (int i = 0; i < this.active.length; ++i) {
                this.active[i] = true;
            }
        } else if (CONFIG_LIST.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.configList = (Boolean)object;
        } else if (CONFIG_FIRST.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.configFirst = (Boolean)object;
        } else if (PROMPT.equals(string)) {
            this.prompt = (String)object;
        } else {
            super.setAttribute(string, object);
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (LIST.equals(string)) {
            return StringArrayConfigurer.arrayToString(this.list);
        }
        if (CONFIG_LIST.equals(string)) {
            return this.configList + "";
        }
        if (CONFIG_FIRST.equals(string)) {
            return this.configFirst + "";
        }
        if (PROMPT.equals(string)) {
            return this.prompt;
        }
        return super.getAttributeValueString(string);
    }

    public static String getConfigureTypeName() {
        return "List";
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("TurnTracker.htm", "List");
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (PROMPT.equals(string)) {
            return this.promptCond;
        }
        return null;
    }

    @Override
    public boolean isConfigurable() {
        if (this.configFirst || this.configList) {
            return true;
        }
        return super.isConfigurable();
    }

    @Override
    public ComponentI18nData getI18nData() {
        ComponentI18nData componentI18nData = super.getI18nData();
        componentI18nData.setAttributeTranslatable(LIST, true);
        return componentI18nData;
    }

    protected class ConfigDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;

        public ConfigDialog() {
            Object object;
            Object object2;
            super((Frame)GameModule.getGameModule().getFrame(), Resources.getString("TurnTracker.configure2", ListTurnLevel.this.getConfigureName()));
            this.setLayout(new BoxLayout(this.getContentPane(), 1));
            if (ListTurnLevel.this.configFirst) {
                if (ListTurnLevel.this.prompt == null) {
                    ListTurnLevel.this.prompt = "First " + ListTurnLevel.this.getConfigureName() + " each " + ListTurnLevel.this.parent.getConfigureName();
                }
                object2 = new StringEnumConfigurer("", ListTurnLevel.this.prompt + " :  ", ListTurnLevel.this.list);
                ((StringEnumConfigurer)object2).setValue(ListTurnLevel.this.list[ListTurnLevel.this.first]);
                ((Configurer)object2).addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        String string = ((StringEnumConfigurer)propertyChangeEvent.getSource()).getValueString();
                        for (int i = 0; i < ListTurnLevel.this.list.length; ++i) {
                            if (!ListTurnLevel.this.list[i].equals(string)) continue;
                            ListTurnLevel.this.first = i;
                        }
                    }
                });
                this.add(((StringEnumConfigurer)object2).getControls());
            }
            if (ListTurnLevel.this.configList) {
                this.add(new JLabel(Resources.getString("TurnTracker.turn_off")));
                for (int i = 0; i < ListTurnLevel.this.list.length; ++i) {
                    object = new BooleanConfigurer(null, ListTurnLevel.this.list[i], (Boolean)ListTurnLevel.this.active[i]);
                    ((Configurer)object).addPropertyChangeListener(new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            BooleanConfigurer booleanConfigurer = (BooleanConfigurer)propertyChangeEvent.getSource();
                            String string = booleanConfigurer.getName();
                            for (int i = 0; i < ListTurnLevel.this.list.length; ++i) {
                                if (!ListTurnLevel.this.list[i].equals(string)) continue;
                                ListTurnLevel.this.active[i] = ((BooleanConfigurer)propertyChangeEvent.getSource()).booleanValue();
                            }
                        }
                    });
                    this.add(((BooleanConfigurer)object).getControls());
                }
            }
            object2 = new JPanel();
            object = new JButton(Resources.getString("General.save"));
            ((JComponent)object).setToolTipText(Resources.getString("TurnTracker.save_changes"));
            ((Container)object2).add((Component)object);
            ((AbstractButton)object).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ConfigDialog.this.setVisible(false);
                }
            });
            JButton jButton = new JButton(Resources.getString("General.cancel"));
            jButton.setToolTipText(Resources.getString("TurnTracker.discard_changes"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ConfigDialog.this.setVisible(false);
                }
            });
            ((Container)object2).add(jButton);
            this.add((Component)object2);
            this.pack();
        }
    }
}

