/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.turn;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.Configurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.PlayerIdFormattedStringConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.counters.BasicPiece;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.tools.FormattedString;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TurnGlobalHotkey
extends AbstractConfigurable {
    public static final String NAME = "name";
    public static final String HOTKEY = "hotkey";
    public static final String MATCH = "match";
    public static final String REPORT_FORMAT = "reportFormat";
    protected PropertyExpression match = new PropertyExpression();
    protected KeyStroke hotkey;
    protected FormattedString format = new FormattedString();
    protected BasicPiece checkPiece = new BasicPiece();

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Description:  ", "Global Hotkey:  ", "Match Properties:  ", "Report Format:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, KeyStroke.class, PropertyExpression.class, ReportFormatConfig.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, HOTKEY, MATCH, REPORT_FORMAT};
    }

    @Override
    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (HOTKEY.equals(string)) {
            return HotKeyConfigurer.encode(this.hotkey);
        }
        if (MATCH.equals(string)) {
            return this.match.getExpression();
        }
        if (REPORT_FORMAT.equals(string)) {
            return this.format.getFormat();
        }
        return null;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (NAME.equals(string)) {
            this.setConfigureName((String)object);
        } else if (HOTKEY.equals(string)) {
            if (object instanceof String) {
                object = HotKeyConfigurer.decode((String)object);
            }
            this.hotkey = (KeyStroke)object;
        } else if (MATCH.equals(string)) {
            this.match.setExpression((String)object);
        } else if (REPORT_FORMAT.equals(string)) {
            this.format.setFormat((String)object);
        }
    }

    @Override
    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void removeFrom(Buildable buildable) {
    }

    @Override
    public void addTo(Buildable buildable) {
    }

    public static String getConfigureTypeName() {
        return "Global Hotkey";
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("TurnTracker.htm", "Hotkey");
    }

    public void apply() {
        if (this.match.isNull() || this.match.accept(this.checkPiece)) {
            GameModule.getGameModule().fireKeyStroke(this.hotkey);
            String string = this.format.getLocalizedText();
            if (string.length() > 0) {
                Chatter.DisplayText displayText = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), "* " + string);
                displayText.execute();
                GameModule.getGameModule().sendAndLog(displayText);
            }
        }
    }

    public static class ReportFormatConfig
    implements TranslatableConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new PlayerIdFormattedStringConfigurer(string, string2, new String[0]);
        }
    }
}

