/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.HttpRequestWrapper;
import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.chat.ServerStatus;
import VASSAL.chat.SimplePlayer;
import VASSAL.chat.SimpleRoom;
import VASSAL.i18n.Resources;
import VASSAL.tools.HashCode;
import VASSAL.tools.SequenceEncoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CgiServerStatus
implements ServerStatus {
    private static final long DAY = 86400000L;
    public static final String LAST_DAY = "Server.last_24_hours";
    public static final String LAST_WEEK = "Server.last_week";
    public static final String LAST_MONTH = "Server.last_month";
    private static final Map<String, Long> timeRanges = new HashMap<String, Long>();
    private static final String[] times = new String[]{Resources.getString("Server.last_24_hours"), Resources.getString("Server.last_week"), Resources.getString("Server.last_month")};
    private HttpRequestWrapper request;
    private SortedMap<Long, List<String[]>> records = new TreeMap<Long, List<String[]>>();
    private List<Interval> requests = new ArrayList<Interval>();

    public CgiServerStatus() {
        this.request = new HttpRequestWrapper("http://www.vassalengine.org/util/");
        timeRanges.put(Resources.getString(LAST_DAY), 86400000L);
        timeRanges.put(Resources.getString(LAST_WEEK), 604800000L);
        timeRanges.put(Resources.getString(LAST_MONTH), 2592000000L);
    }

    @Override
    public ServerStatus.ModuleSummary[] getStatus() {
        HashMap<String, ServerStatus.ModuleSummary> hashMap = new HashMap<String, ServerStatus.ModuleSummary>();
        try {
            for (String string : this.request.doGet("getCurrentConnections", new Properties())) {
                SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '\t');
                try {
                    String string2 = decoder.nextToken();
                    String string3 = decoder.nextToken();
                    String string4 = decoder.nextToken();
                    ServerStatus.ModuleSummary moduleSummary = hashMap.get(string2);
                    if (moduleSummary == null) {
                        hashMap.put(string2, this.createEntry(string2, string3, string4));
                        continue;
                    }
                    this.updateEntry(moduleSummary, string3, string4);
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this.sortEntriesByModuleName(hashMap);
    }

    @Override
    public ServerStatus.ModuleSummary[] getHistory(String string) {
        Long l = timeRanges.get(string);
        return l != null ? this.getHistory(l) : new ServerStatus.ModuleSummary[]{};
    }

    @Override
    public String[] getSupportedTimeRanges() {
        return times;
    }

    /*
     * WARNING - void declaration
     */
    private ServerStatus.ModuleSummary[] getHistory(long l) {
        Object object;
        String string;
        String string2;
        String string3;
        if (l <= 0L) {
            return this.getStatus();
        }
        long l2 = System.currentTimeMillis();
        Interval interval = new Interval(l2 - l, l2);
        ArrayList<Interval> arrayList = new ArrayList<Interval>();
        arrayList.add(interval);
        for (Interval object3 : this.requests) {
            ListIterator<Interval> listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                Interval interval2 = (Interval)listIterator.next();
                if (!interval2.intersects(object3)) continue;
                listIterator.remove();
                if (interval2.l < object3.l && object3.l <= interval2.r) {
                    listIterator.add(new Interval(interval2.l, object3.l));
                }
                if (interval2.l > object3.r || object3.r >= interval2.r) continue;
                listIterator.add(new Interval(object3.r, interval2.r));
            }
        }
        for (Interval interval3 : arrayList) {
            for (String string4 : this.getInterval(interval3)) {
                String[] stringArray = new SequenceEncoder.Decoder(string4, '\t');
                try {
                    string3 = stringArray.nextToken();
                    string2 = stringArray.nextToken();
                    string = stringArray.nextToken();
                    object = Long.valueOf(stringArray.nextToken());
                    ArrayList<String[]> arrayList2 = (ArrayList<String[]>)this.records.get(object);
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<String[]>();
                        this.records.put((Long)object, arrayList2);
                    }
                    arrayList2.add(new String[]{string3, string2, string});
                }
                catch (NoSuchElementException noSuchElementException) {
                    noSuchElementException.printStackTrace();
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
            this.requests.add(interval3);
        }
        for (int i = 0; i < this.requests.size(); ++i) {
            void var9_18;
            Interval interval4 = this.requests.get(i);
            int n = i + 1;
            while (var9_18 < this.requests.size()) {
                Interval interval5 = this.requests.get((int)var9_18);
                if (interval4.intersects(interval5)) {
                    this.requests.set(i, new Interval(Math.min(interval4.l, interval5.l), Math.max(interval4.r, interval5.r)));
                    this.requests.remove((int)var9_18--);
                }
                ++var9_18;
            }
        }
        HashMap<String, ServerStatus.ModuleSummary> hashMap = new HashMap<String, ServerStatus.ModuleSummary>();
        for (List<String[]> list : this.records.subMap(interval.l, interval.r).values()) {
            for (String[] stringArray : list) {
                string3 = stringArray[0];
                string2 = stringArray[1];
                string = stringArray[2];
                object = hashMap.get(string3);
                if (object == null) {
                    hashMap.put(string3, this.createEntry(string3, string2, string));
                    continue;
                }
                this.updateEntry((ServerStatus.ModuleSummary)object, string2, string);
            }
        }
        return this.sortEntriesByModuleName(hashMap);
    }

    private ServerStatus.ModuleSummary[] sortEntriesByModuleName(Map<String, ServerStatus.ModuleSummary> map) {
        ServerStatus.ModuleSummary[] moduleSummaryArray = map.values().toArray(new ServerStatus.ModuleSummary[map.size()]);
        Arrays.sort(moduleSummaryArray, new Comparator<ServerStatus.ModuleSummary>(){

            @Override
            public int compare(ServerStatus.ModuleSummary moduleSummary, ServerStatus.ModuleSummary moduleSummary2) {
                return moduleSummary.getModuleName().compareTo(moduleSummary2.getModuleName());
            }
        });
        return moduleSummaryArray;
    }

    private List<String> getInterval(Interval interval) {
        Properties properties = new Properties();
        properties.setProperty("start", Long.toString(interval.l));
        properties.setProperty("end", Long.toString(interval.r));
        try {
            return this.request.doGet("getConnectionHistory", properties);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private ServerStatus.ModuleSummary updateEntry(ServerStatus.ModuleSummary moduleSummary, String string, String string2) {
        SimpleRoom simpleRoom = moduleSummary.getRoom(string);
        if (simpleRoom == null) {
            simpleRoom = new SimpleRoom(string);
            simpleRoom.setPlayers(new Player[]{new SimplePlayer(string2)});
            moduleSummary.addRoom(simpleRoom);
        } else {
            simpleRoom.addPlayer(new SimplePlayer(string2));
        }
        return moduleSummary;
    }

    private ServerStatus.ModuleSummary createEntry(String string, String string2, String string3) {
        SimpleRoom simpleRoom = new SimpleRoom(string2);
        simpleRoom.setPlayers(new Player[]{new SimplePlayer(string3)});
        return new ServerStatus.ModuleSummary(string, new Room[]{simpleRoom});
    }

    private static class Interval {
        public final long l;
        public final long r;

        public Interval(long l, long l2) {
            if (l2 < l) {
                throw new IllegalArgumentException();
            }
            this.l = l;
            this.r = l2;
        }

        public boolean intersects(Interval interval) {
            return this.l <= interval.l && interval.l <= this.r || interval.l <= this.l && this.l <= interval.r;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Interval)) {
                return false;
            }
            Interval interval = (Interval)object;
            return interval.l == this.l && interval.r == this.r;
        }

        public int hashCode() {
            return HashCode.hash(this.l) ^ HashCode.hash(this.r);
        }

        public String toString() {
            return "[" + this.l + "," + this.r + "]";
        }
    }
}

