/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.ChatServerFactory;
import VASSAL.chat.DummyClient;
import VASSAL.chat.HttpRequestWrapper;
import VASSAL.chat.HybridClient;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ThrowableUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.jdesktop.swingworker.SwingWorker;

public class DynamicClient
extends HybridClient {
    private String serverConfigURL;
    private boolean connecting;

    public DynamicClient() {
        this("http://www.vassalengine.org/util/getServerImpl");
    }

    public DynamicClient(String string) {
        this.serverConfigURL = string;
    }

    protected ChatServerConnection buildDelegate() throws IOException {
        ChatServerConnection chatServerConnection = null;
        Properties properties = this.getServerConfig();
        chatServerConnection = ChatServerFactory.build(properties);
        return chatServerConnection;
    }

    private Properties getServerConfig() throws IOException {
        HttpRequestWrapper httpRequestWrapper = new HttpRequestWrapper(this.serverConfigURL);
        Properties properties = new Properties();
        properties.put("module", GameModule.getGameModule() == null ? "Test" : GameModule.getGameModule().getGameName());
        properties.put("vassalVersion", Info.getVersion());
        List<String> list = httpRequestWrapper.doGet(properties);
        if (list.isEmpty()) {
            throw new IOException(Resources.getString("Server.empty_response"));
        }
        properties = new Properties();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string).append('\n');
        }
        properties.load(new ByteArrayInputStream(stringBuilder.toString().getBytes()));
        return properties;
    }

    public void setConnected(final boolean bl) {
        if (bl && !this.isConnected()) {
            if (!this.connecting) {
                this.connecting = true;
                new SwingWorker<ChatServerConnection, Void>(){

                    protected ChatServerConnection doInBackground() throws Exception {
                        return DynamicClient.this.buildDelegate();
                    }

                    protected void done() {
                        try {
                            DynamicClient.this.setDelegate((ChatServerConnection)this.get());
                            DynamicClient.super.setConnected(bl);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (ExecutionException executionException) {
                            Throwable throwable = executionException.getCause();
                            DynamicClient.this.fireStatus(Resources.getString("Server.bad_address3"));
                            ErrorDialog.showDetails(throwable, ThrowableUtils.getStackTrace(throwable), "Error.network_communication_error", new Object[0]);
                            throwable.printStackTrace();
                        }
                        DynamicClient.this.connecting = false;
                    }
                }.execute();
            }
        } else {
            super.setConnected(bl);
            if (!this.isConnected()) {
                this.setDelegate(new DummyClient());
            }
        }
    }
}

