/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.build.GameModule;
import VASSAL.chat.HttpRequestWrapper;
import VASSAL.chat.WelcomeMessageServer;
import VASSAL.chat.messageboard.Message;
import VASSAL.chat.messageboard.MessageBoard;
import VASSAL.chat.peer2peer.PeerPoolInfo;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.tools.SequenceEncoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class HttpMessageServer
implements MessageBoard,
WelcomeMessageServer {
    private HttpRequestWrapper welcomeURL;
    private HttpRequestWrapper getMessagesURL;
    private HttpRequestWrapper postMessageURL;
    private PeerPoolInfo info;

    public HttpMessageServer(PeerPoolInfo peerPoolInfo) {
        this("http://www.vassalengine.org/util/getMessages", "http://www.vassalengine.org/util/postMessage", "http://www.vassalengine.org/util/motd", peerPoolInfo);
    }

    public HttpMessageServer(String string, String string2, String string3, PeerPoolInfo peerPoolInfo) {
        this.getMessagesURL = new HttpRequestWrapper(string);
        this.welcomeURL = new HttpRequestWrapper(string3);
        this.postMessageURL = new HttpRequestWrapper(string2);
        this.info = peerPoolInfo;
    }

    public Command getWelcomeMessage() {
        Command command = new NullCommand();
        try {
            if (GameModule.getGameModule() != null) {
                for (String string : this.welcomeURL.doGet(this.prepareInfo())) {
                    command = command.append(GameModule.getGameModule().decode(string));
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("IOException retrieving welcome message from " + this.welcomeURL);
        }
        return command;
    }

    public Message[] getMessages() {
        ArrayList<Message> arrayList = new ArrayList<Message>();
        try {
            for (String string : this.getMessagesURL.doGet(this.prepareInfo())) {
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
                    String string2 = stringTokenizer.nextToken();
                    String string3 = string2.substring(string2.indexOf("=") + 1);
                    String string4 = stringTokenizer.nextToken();
                    string4 = string4.substring(string4.indexOf("=") + 1);
                    string2 = stringTokenizer.nextToken("");
                    SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string2.substring(string2.indexOf("=") + 1), '|');
                    String string5 = "";
                    while (decoder.hasMoreTokens()) {
                        string5 = string5 + decoder.nextToken();
                        if (!decoder.hasMoreTokens()) continue;
                        string5 = string5 + "\n";
                    }
                    string5 = this.restorePercent(string5);
                    Date date = null;
                    try {
                        long l = Long.parseLong(string4);
                        TimeZone timeZone = TimeZone.getDefault();
                        date = new Date(l += (long)timeZone.getOffset(0, 1, 2, 6, 7, 14));
                    }
                    catch (NumberFormatException numberFormatException) {
                        date = new Date();
                    }
                    arrayList.add(new Message(string3, string5, date));
                }
                catch (NoSuchElementException noSuchElementException) {
                    System.err.println("Badly formatted message in HttpMessageServer:  " + string);
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("IOException retrieving messages from " + this.getMessagesURL);
        }
        return arrayList.toArray(new Message[arrayList.size()]);
    }

    private Properties prepareInfo() {
        Properties properties = new Properties();
        properties.put("module", this.info.getModuleName());
        return properties;
    }

    private String removePercent(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "%#", true);
        block4: while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            switch (string2.charAt(0)) {
                case '%': {
                    stringBuilder.append("/#/");
                    continue block4;
                }
                case '#': {
                    stringBuilder.append("/##/");
                    continue block4;
                }
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private String restorePercent(String string) {
        int n = string.indexOf("/#/");
        while (n >= 0) {
            string = string.substring(0, n) + "%" + string.substring(n + 3);
            n = string.indexOf("/#/");
        }
        n = string.indexOf("/##/");
        while (n >= 0) {
            string = string.substring(0, n) + "#" + string.substring(n + 4);
            n = string.indexOf("/##/");
        }
        return string;
    }

    public void postMessage(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        string = this.removePercent(string);
        SequenceEncoder sequenceEncoder = new SequenceEncoder('|');
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            sequenceEncoder.append(stringTokenizer.nextToken());
        }
        Properties properties = this.prepareInfo();
        properties.put("sender", this.info.getUserName());
        properties.put("content", sequenceEncoder.getValue());
        try {
            this.postMessageURL.doPost(properties);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

