/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.ChatServerFactory;
import VASSAL.chat.HybridClient;
import VASSAL.configure.Configurer;
import VASSAL.i18n.Resources;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ServerConfigurer
extends Configurer {
    private static final String CONNECTED = Resources.getString("Server.please_disconnect");
    private static final String DISCONNECTED = Resources.getString("Server.select_server_type");
    private static final String BUTTON = "Button";
    private static final String DYNAMIC_BUTTON = Resources.getString("Server.default");
    private static final String JABBER_BUTTON = "Jabber";
    private static final String DIRECT_BUTTON = Resources.getString("Server.direct");
    private static final String ENCODING = "ISO-8859-1";
    private Box controls;
    private JTextField jabberHost;
    private HybridClient client;
    private JRadioButton dynamicButton;
    private JRadioButton jabberButton;
    private JRadioButton directButton;
    private JLabel header;
    private JLabel jabberHostPrompt;

    public ServerConfigurer(String string, String string2, HybridClient hybridClient) {
        super(string, string2, new Properties());
        this.client = hybridClient;
        hybridClient.addPropertyChangeListener("Connected", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ServerConfigurer.this.enableControls(Boolean.TRUE.equals(propertyChangeEvent.getNewValue()));
            }
        });
        this.getControls();
        this.setValue(this.buildDynamicProperties());
    }

    public Component getControls() {
        if (this.controls == null) {
            this.controls = Box.createVerticalBox();
            this.header = new JLabel(DISCONNECTED);
            this.controls.add(this.header);
            ButtonGroup buttonGroup = new ButtonGroup();
            this.dynamicButton = new JRadioButton(DYNAMIC_BUTTON);
            this.dynamicButton.setAlignmentX(0.0f);
            this.dynamicButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        ServerConfigurer.this.noUpdate = true;
                        ServerConfigurer.this.setValue(ServerConfigurer.this.buildDynamicProperties());
                        ServerConfigurer.this.noUpdate = false;
                    }
                }
            });
            this.controls.add(this.dynamicButton);
            buttonGroup.add(this.dynamicButton);
            Box box = Box.createHorizontalBox();
            box.setAlignmentX(0.0f);
            this.jabberButton = new JRadioButton(JABBER_BUTTON);
            this.jabberButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        ServerConfigurer.this.noUpdate = true;
                        ServerConfigurer.this.setValue(ServerConfigurer.this.buildJabberProperties());
                        ServerConfigurer.this.noUpdate = false;
                    }
                }
            });
            buttonGroup.add(this.jabberButton);
            box.add(this.jabberButton);
            this.jabberHostPrompt = new JLabel(Resources.getString("Server.host"));
            box.add(this.jabberHostPrompt);
            this.jabberHost = new JTextField(18);
            this.jabberHost.setMaximumSize(new Dimension(this.jabberHost.getMaximumSize().width, this.jabberHost.getPreferredSize().height));
            this.jabberHost.setText("localhost:5222");
            this.jabberHost.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.updateValue();
                }

                private void updateValue() {
                    ServerConfigurer.this.noUpdate = true;
                    ServerConfigurer.this.setValue(ServerConfigurer.this.buildJabberProperties());
                    ServerConfigurer.this.noUpdate = false;
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.updateValue();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.updateValue();
                }
            });
            box.add(this.jabberHost);
            if ("true".equals(System.getProperty("enableJabber"))) {
                this.controls.add(box);
            }
            this.directButton = new JRadioButton(DIRECT_BUTTON);
            this.directButton.setAlignmentX(0.0f);
            this.directButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        ServerConfigurer.this.noUpdate = true;
                        ServerConfigurer.this.setValue(ServerConfigurer.this.buildPeerProperties());
                        ServerConfigurer.this.noUpdate = false;
                    }
                }
            });
            buttonGroup.add(this.directButton);
            this.controls.add(this.directButton);
        }
        return this.controls;
    }

    private void enableControls(boolean bl) {
        this.directButton.setEnabled(!bl);
        this.dynamicButton.setEnabled(!bl);
        this.jabberButton.setEnabled(!bl);
        this.jabberHostPrompt.setEnabled(!bl);
        this.jabberHost.setEnabled(!bl);
        this.header.setText(bl ? CONNECTED : DISCONNECTED);
    }

    private Properties buildJabberProperties() {
        Properties properties = new Properties();
        properties.setProperty(BUTTON, JABBER_BUTTON);
        String string = this.jabberHost.getText();
        String string2 = "5222";
        int n = string.indexOf(":");
        if (n > 0) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        properties.setProperty("type", "jabber");
        properties.setProperty("jabberHost", string);
        properties.setProperty("jabberPort", string2);
        return properties;
    }

    private Properties buildPeerProperties() {
        Properties properties = new Properties();
        properties.setProperty(BUTTON, DIRECT_BUTTON);
        properties.setProperty("type", "peer2peer");
        return properties;
    }

    private Properties buildDynamicProperties() {
        Properties properties = new Properties();
        properties.setProperty(BUTTON, DYNAMIC_BUTTON);
        properties.setProperty("type", "dynamic");
        return properties;
    }

    public String getValueString() {
        String string = "";
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.getServerInfo().store(byteArrayOutputStream, null);
            string = new String(byteArrayOutputStream.toByteArray(), ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    public void setValue(Object object) {
        super.setValue(object);
        if (!this.noUpdate && object instanceof Properties && this.controls != null) {
            Properties properties = (Properties)object;
            String string = properties.getProperty(BUTTON, DYNAMIC_BUTTON);
            if (DYNAMIC_BUTTON.equals(string)) {
                this.dynamicButton.setSelected(true);
            } else if (JABBER_BUTTON.equals(string)) {
                this.jabberButton.setSelected(true);
                this.jabberHost.setText(properties.getProperty("jabberHost", "localhost") + ":" + properties.getProperty("jabberPort", "5222"));
            } else if (DIRECT_BUTTON.equals(string)) {
                this.directButton.setSelected(true);
            }
        }
        if (this.client != null && !CONNECTED.equals(this.header.getText())) {
            this.client.setDelegate(ChatServerFactory.build(this.getServerInfo()));
        }
    }

    public void setValue(String string) {
        Properties properties = new Properties();
        try {
            properties.load(new ByteArrayInputStream(string.getBytes(ENCODING)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setValue(properties);
    }

    private Properties getServerInfo() {
        Properties properties = (Properties)this.getValue();
        if (properties == null) {
            properties = new Properties();
        }
        return properties;
    }
}

