/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.Player;
import VASSAL.chat.Room;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRoom
implements Room {
    private String name;
    private List<Player> players = new ArrayList<Player>();

    public SimpleRoom() {
    }

    public SimpleRoom(String string) {
        this(string, new Player[0]);
    }

    public SimpleRoom(String string, Player[] playerArray) {
        this.name = string;
        this.setPlayers(playerArray);
    }

    public SimpleRoom(Room room) {
        this.name = room.getName();
        this.players.addAll(room.getPlayerList());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setPlayers(Player[] playerArray) {
        this.players.clear();
        for (Player player : playerArray) {
            this.addPlayer(player);
        }
    }

    @Override
    public void addPlayer(Player player) {
        int n = this.players.indexOf(player);
        if (n < 0) {
            this.players.add(player);
        } else {
            this.players.set(n, player);
        }
    }

    @Override
    public void removePlayer(Player player) {
        this.players.remove(player);
    }

    public boolean contains(Player player) {
        return this.players.contains(player);
    }

    public String toString() {
        return this.name;
    }

    public int numPlayers() {
        return this.players.size();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof SimpleRoom) {
            return this.name == null ? false : this.name.equals(((SimpleRoom)object).name);
        }
        return false;
    }

    @Deprecated
    public Iterator<Player> getPlayers() {
        return this.players.iterator();
    }

    @Override
    public List<Player> getPlayerList() {
        return Collections.unmodifiableList(this.players);
    }
}

