/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.jabber;

import VASSAL.build.GameModule;
import VASSAL.chat.jabber.AccountInfo;
import VASSAL.chat.jabber.JabberClient;
import VASSAL.configure.Configurer;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.text.JTextComponent;
import org.jivesoftware.smack.util.StringUtils;

public class ModuleAccountInfo
implements AccountInfo {
    private Configurer realNameConfig = GameModule.getGameModule().getPrefs().getOption("RealName");
    private Configurer pwdConfig = GameModule.getGameModule().getPrefs().getOption("SecretName");

    public String getPassword() {
        return this.pwdConfig.getValueString();
    }

    public String getUserName() {
        return StringUtils.escapeNode((String)this.realNameConfig.getValueString()).toLowerCase();
    }

    public String getRealName() {
        return this.realNameConfig.getValueString();
    }

    public void init(JabberClient jabberClient) {
        jabberClient.addPropertyChangeListener("Connected", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ModuleAccountInfo.this.setControlsEnabled(!Boolean.TRUE.equals(propertyChangeEvent.getNewValue()));
            }
        });
    }

    private void setControlsEnabled(boolean bl) {
        this.setEditable(this.realNameConfig.getControls(), bl);
        this.setEditable(this.pwdConfig.getControls(), bl);
    }

    private void setEditable(Component component, boolean bl) {
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).setEnabled(bl);
        } else if (component instanceof Container) {
            int n = ((Container)component).getComponentCount();
            for (int i = 0; i < n; ++i) {
                this.setEditable(((Container)component).getComponent(i), bl);
            }
        }
    }

    public String getModule() {
        return GameModule.getGameModule().getGameName();
    }
}

