/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.chat.node.MsgSender;
import VASSAL.tools.PropertiesEncoder;
import VASSAL.tools.SequenceEncoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node
implements MsgSender {
    private static Logger logger = Logger.getLogger(MsgSender.class.getName());
    private String id;
    private String info;
    private Node parent;
    private List<Node> children = new ArrayList<Node>();

    public Node(Node node, String string, String string2) {
        this.parent = node;
        this.id = string;
        this.info = string2;
    }

    public String getId() {
        return this.id;
    }

    public String getInfo() {
        return this.info;
    }

    public String getInfoProperty(String string) {
        try {
            return new PropertiesEncoder(this.info).getProperties().getProperty(string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void setInfo(String string) {
        this.info = string;
    }

    public void setParent(Node node) {
        this.parent = node;
    }

    public Node getParent() {
        return this.parent;
    }

    public void remove(Node node) {
        logger.finer("Removing " + node + " from " + this);
        this.children.remove(node);
    }

    public void add(Node node) {
        if (node.parent != null) {
            node.parent.remove(node);
        }
        logger.finer("Adding " + node + " to " + this);
        this.children.add(node);
        node.setParent(this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Node)) {
            return false;
        }
        Node node = (Node)object;
        return !(this.id != null ? !this.id.equals(node.id) : node.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return super.toString() + "[id=" + this.id + "]";
    }

    public Node getChild(String string) {
        for (Node node : this.getChildren()) {
            if (!string.equals(node.getId())) continue;
            return node;
        }
        return null;
    }

    public Node getDescendant(String string) {
        String string2;
        Node node;
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '/');
        for (node = this; decoder.hasMoreTokens() && node != null; node = node.getChild(string2)) {
            string2 = decoder.nextToken();
        }
        return node;
    }

    @Override
    public void send(String string) {
        for (Node node : this.getChildren()) {
            node.send(string);
        }
    }

    public Node[] getLeafDescendants() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        this.addLeaves(this, arrayList);
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    private void addLeaves(Node node, List<Node> list) {
        if (node.isLeaf()) {
            list.add(node);
        } else {
            for (Node node2 : node.getChildren()) {
                this.addLeaves(node2, list);
            }
        }
    }

    public boolean isLeaf() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node[] getChildren() {
        List<Node> list = this.children;
        synchronized (list) {
            return this.children.toArray(new Node[this.children.size()]);
        }
    }

    public static Node build(Node node, String string) {
        Node node2 = null;
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '/');
        while (decoder.hasMoreTokens()) {
            String string2 = decoder.nextToken();
            node2 = node.getChild(string2);
            if (node2 == null) {
                node2 = new Node(node, string2, null);
                node.add(node2);
            }
            node = node2;
        }
        return node2;
    }

    public Node buildWithInfo(Node node, String string) {
        Node node2 = null;
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '/');
        while (decoder.hasMoreTokens()) {
            SequenceEncoder.Decoder decoder2 = new SequenceEncoder.Decoder(decoder.nextToken(), '=');
            String string2 = decoder2.nextToken();
            String string3 = decoder2.nextToken();
            node2 = node.getChild(string2);
            if (node2 == null) {
                node2 = new Node(node, string2, null);
                node.add(node2);
            }
            node2.setInfo(string3);
            node = node2;
        }
        return node2;
    }

    private List<Node> getPathList() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node = this; node != null && node.getId() != null; node = node.getParent()) {
            arrayList.add(node);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPath() {
        List<Node> list = this.children;
        synchronized (list) {
            SequenceEncoder sequenceEncoder = new SequenceEncoder('/');
            List<Node> list2 = this.getPathList();
            ListIterator<Node> listIterator = list2.listIterator(list2.size());
            while (listIterator.hasPrevious()) {
                sequenceEncoder.append(listIterator.previous().getId());
            }
            return sequenceEncoder.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPathAndInfo() {
        List<Node> list = this.children;
        synchronized (list) {
            SequenceEncoder sequenceEncoder = new SequenceEncoder('/');
            List<Node> list2 = this.getPathList();
            ListIterator<Node> listIterator = list2.listIterator(list2.size() - 1);
            while (listIterator.hasPrevious()) {
                Node node = listIterator.previous();
                SequenceEncoder sequenceEncoder2 = new SequenceEncoder(node.getId(), '=').append(node.getInfo());
                sequenceEncoder.append(sequenceEncoder2.getValue());
            }
            return sequenceEncoder.getValue();
        }
    }
}

