/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.ChatServerFactory;
import VASSAL.chat.CommandDecoder;
import VASSAL.chat.HttpMessageServer;
import VASSAL.chat.node.NodeServerInfo;
import VASSAL.chat.node.SocketNodeClient;
import VASSAL.chat.peer2peer.PeerPoolInfo;
import VASSAL.i18n.Resources;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;

public class NodeClientFactory
extends ChatServerFactory {
    private static NodeClientFactory instance;
    private static final String UNNAMED_MODULE;
    private static final String UNKNOWN_USER;
    public static final String NODE_TYPE = "node";
    public static final String NODE_HOST = "nodeHost";
    public static final String NODE_PORT = "nodePort";

    private NodeClientFactory() {
    }

    public ChatServerConnection buildServer(Properties properties) {
        final String string = properties.getProperty(NODE_HOST, "game.vassalengine.org");
        final int n = Integer.parseInt(properties.getProperty(NODE_PORT, "5050"));
        NodeServerInfo nodeServerInfo = new NodeServerInfo(){

            public String getHostName() {
                return string;
            }

            public int getPort() {
                return n;
            }
        };
        PeerPoolInfo peerPoolInfo = new PeerPoolInfo(){

            public String getModuleName() {
                return GameModule.getGameModule() == null ? UNNAMED_MODULE : GameModule.getGameModule().getGameName();
            }

            public String getUserName() {
                return GameModule.getGameModule() == null ? UNKNOWN_USER : (String)GameModule.getGameModule().getPrefs().getValue("RealName");
            }
        };
        HttpMessageServer httpMessageServer = new HttpMessageServer(peerPoolInfo);
        SocketNodeClient socketNodeClient = new SocketNodeClient(GameModule.getGameModule().getGameName(), GameModule.getUserId() + "." + System.currentTimeMillis(), GameModule.getGameModule(), nodeServerInfo, httpMessageServer, httpMessageServer);
        GameModule.getGameModule().getPrefs().getOption("RealName").fireUpdate();
        GameModule.getGameModule().getPrefs().getOption("Profile").fireUpdate();
        socketNodeClient.addPropertyChangeListener("Status", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                GameModule.getGameModule().warn((String)propertyChangeEvent.getNewValue());
            }
        });
        socketNodeClient.addPropertyChangeListener("Msg", new CommandDecoder());
        return socketNodeClient;
    }

    public static NodeClientFactory getInstance() {
        if (instance == null) {
            instance = new NodeClientFactory();
        }
        return instance;
    }

    static {
        UNNAMED_MODULE = Resources.getString("Chat.unknown_module");
        UNKNOWN_USER = Resources.getString("Chat.unknown_user");
    }
}

