/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.peer2peer;

import VASSAL.build.GameModule;
import VASSAL.chat.HttpRequestWrapper;
import VASSAL.chat.peer2peer.AcceptPeerThread;
import VASSAL.chat.peer2peer.P2PPlayer;
import VASSAL.chat.peer2peer.PeerPool;
import VASSAL.chat.ui.ChatControlsInitializer;
import VASSAL.chat.ui.ChatServerControls;
import VASSAL.i18n.Resources;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.litesoft.p2pchat.PeerInfo;
import org.litesoft.p2pchat.PendingPeerManager;

public class DirectPeerPool
implements PeerPool,
ChatControlsInitializer {
    private AcceptPeerThread acceptThread;
    private JButton inviteButton = new JButton(Resources.getString("Peer2Peer.invite_players"));
    private JDialog frame;
    private String myIp;

    public DirectPeerPool() {
        this.inviteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DirectPeerPool.this.frame.setVisible(true);
            }
        });
        this.inviteButton.setEnabled(false);
    }

    public void initialize(P2PPlayer p2PPlayer, PendingPeerManager pendingPeerManager) throws IOException {
        this.myIp = p2PPlayer.getInfo().getAddresses();
        try {
            this.myIp = this.discoverMyIpAddressFromRemote();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.acceptThread = new AcceptPeerThread(p2PPlayer.getInfo().getPort(), pendingPeerManager);
        p2PPlayer.getInfo().setPort(this.acceptThread.getPort());
        this.acceptThread.start();
        if (this.frame == null) {
            this.initComponents(p2PPlayer, pendingPeerManager);
            this.inviteButton.setEnabled(true);
        }
    }

    private String discoverMyIpAddressFromRemote() throws IOException {
        String string = null;
        HttpRequestWrapper httpRequestWrapper = new HttpRequestWrapper("http://www.vassalengine.org/util/getMyAddress");
        List<String> list = httpRequestWrapper.doGet(null);
        if (list.isEmpty()) {
            throw new IOException(Resources.getString("Server.empty_response"));
        }
        string = list.get(0);
        return string;
    }

    public void disconnect() {
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
            this.inviteButton.setEnabled(false);
        }
        if (this.acceptThread != null) {
            this.acceptThread.halt();
            this.acceptThread = null;
        }
    }

    public void connectFailed(PeerInfo peerInfo) {
        JOptionPane.showMessageDialog(this.frame, Resources.getString("Peer2Peer.could_not_reach", peerInfo.getAddresses(), String.valueOf(peerInfo.getPort())), Resources.getString("Peer2Peer.invite_failed"), 1);
    }

    public void initComponents(P2PPlayer p2PPlayer, final PendingPeerManager pendingPeerManager) {
        JFrame jFrame = null;
        if (GameModule.getGameModule() != null) {
            jFrame = GameModule.getGameModule().getFrame();
        }
        this.frame = new JDialog((Frame)jFrame, Resources.getString("Peer2Peer.direct_connection"));
        this.frame.setDefaultCloseOperation(1);
        this.frame.setLayout(new BoxLayout(this.frame.getContentPane(), 1));
        this.frame.add(this.createLabel(Resources.getString("Peer2Peer.your_ip_address", this.myIp, String.valueOf(p2PPlayer.getInfo().getPort()))));
        this.frame.add(this.createLabel(Resources.getString("Peer2Peer.other_players_address")));
        Box box = Box.createHorizontalBox();
        box.setAlignmentX(0.0f);
        JButton jButton = new JButton(Resources.getString("Peer2Peer.invite"));
        box.add(jButton);
        final JTextField jTextField = new JTextField(Resources.getString("Peer2Peer.address_port"));
        box.add(jTextField);
        this.frame.add(box);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PeerInfo peerInfo = PeerInfo.deFormat(jTextField.getText().replaceAll("\\s", ""));
                if (peerInfo != null) {
                    pendingPeerManager.addNewPeer(peerInfo);
                    jTextField.setText("");
                } else {
                    JOptionPane.showMessageDialog(DirectPeerPool.this.frame, Resources.getString("Peer2Peer.invalid_format"));
                }
            }
        };
        jButton.addActionListener(actionListener);
        jTextField.addActionListener(actionListener);
        this.frame.pack();
        this.frame.setLocationRelativeTo(jFrame);
    }

    private JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setAlignmentX(0.0f);
        return jLabel;
    }

    public void initializeControls(ChatServerControls chatServerControls) {
        chatServerControls.getToolbar().add(this.inviteButton);
    }

    public void uninitializeControls(ChatServerControls chatServerControls) {
        chatServerControls.getToolbar().remove(this.inviteButton);
    }
}

