/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.LockableRoom;
import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.chat.node.NodeClient;
import VASSAL.chat.node.NodeRoom;
import VASSAL.chat.ui.PlayerActionFactory;
import VASSAL.i18n.Resources;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTree;

public class KickAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private Player kickee;
    private ChatServerConnection client;

    public KickAction(ChatServerConnection chatServerConnection, Player player) {
        super(Resources.getString("Chat.kick"));
        String string;
        Room room;
        this.kickee = player;
        this.client = chatServerConnection;
        boolean bl = false;
        if (player != null && GameModule.getGameModule() != null && (room = chatServerConnection.getRoom()) instanceof LockableRoom && ((LockableRoom)((Object)room)).isLocked() && room instanceof NodeRoom && ((NodeRoom)room).contains(player) && (string = ((NodeRoom)room).getOwner()) != null && string.equals(chatServerConnection.getUserInfo().getId()) && !string.equals(player.getId())) {
            bl = true;
        }
        this.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isEnabled() && this.client instanceof NodeClient) {
            ((NodeClient)this.client).kick(this.kickee);
            GameModule.getGameModule().warn(Resources.getString("Chat.kick_sent", this.kickee.getName()));
        }
    }

    public static PlayerActionFactory factory(final ChatServerConnection chatServerConnection) {
        return new PlayerActionFactory(){

            public Action getAction(Player player, JTree jTree) {
                return new KickAction(chatServerConnection, player);
            }
        };
    }
}

