/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.chat.SimplePlayer;
import VASSAL.chat.SimpleRoom;
import VASSAL.chat.SimpleStatus;
import java.awt.Component;
import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class RoomTreeRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;
    private Icon away;
    private Icon looking;

    public RoomTreeRenderer() {
        URL uRL = this.getClass().getResource("/images/playerAway.gif");
        if (uRL != null) {
            this.away = new ImageIcon(uRL);
        }
        if ((uRL = this.getClass().getResource("/images/playerLooking.gif")) != null) {
            this.looking = new ImageIcon(uRL);
        }
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        this.putClientProperty("html.disable", Boolean.TRUE);
        object = ((DefaultMutableTreeNode)object).getUserObject();
        if (object instanceof Player) {
            if (((SimpleStatus)((Player)object).getStatus()).isAway()) {
                this.setIcon(this.away);
            } else if (((SimpleStatus)((SimplePlayer)object).getStatus()).isLooking()) {
                this.setIcon(this.looking);
            } else {
                this.setIcon(null);
            }
        } else if (object instanceof SimpleRoom) {
            List<Player> list = ((Room)object).getPlayerList();
            this.setText(this.getText() + " (" + list.size() + ")");
        }
        return this;
    }
}

