/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.command;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.command.Command;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class ConditionalCommand
extends Command {
    private Condition[] conditions;
    private Command delegate;

    public ConditionalCommand(Condition[] conditionArray, Command command) {
        this.conditions = conditionArray;
        this.delegate = command;
    }

    protected void executeCommand() {
        for (int i = 0; i < this.conditions.length; ++i) {
            if (this.conditions[i].isSatisfied()) continue;
            return;
        }
        this.delegate.execute();
    }

    protected Command myUndoCommand() {
        return null;
    }

    public Command getDelegate() {
        return this.delegate;
    }

    public Condition[] getConditions() {
        return this.conditions;
    }

    public static class Gt
    extends Condition {
        private String property;
        private String value;

        public Gt(String string, String string2) {
            this.property = string;
            this.value = string2;
        }

        public String getProperty() {
            return this.property;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isSatisfied() {
            String string = GameModule.getGameModule().getAttributeValueString(this.property);
            return Info.compareVersions(string, this.value) > 0;
        }
    }

    public static class Lt
    extends Condition {
        private String property;
        private String value;

        public Lt(String string, String string2) {
            this.property = string;
            this.value = string2;
        }

        public String getProperty() {
            return this.property;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isSatisfied() {
            String string = GameModule.getGameModule().getAttributeValueString(this.property);
            return Info.compareVersions(string, this.value) < 0;
        }
    }

    public static class Not
    extends Condition {
        private Condition sub;

        public Not(Condition condition) {
            this.sub = condition;
        }

        public boolean isSatisfied() {
            return !this.sub.isSatisfied();
        }

        public Condition getSubCondition() {
            return this.sub;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Eq
    extends Condition {
        private String property;
        private List<String> allowed;

        public Eq(String string, List<String> list) {
            this.property = string;
            this.allowed = list;
        }

        @Deprecated
        public Eq(String string, Vector vector) {
            this.property = string;
            this.allowed = vector;
        }

        public String getProperty() {
            return this.property;
        }

        public List<String> getValueList() {
            return Collections.unmodifiableList(this.allowed);
        }

        @Deprecated
        public Enumeration getValues() {
            return Collections.enumeration(this.allowed);
        }

        @Override
        public boolean isSatisfied() {
            String string = GameModule.getGameModule().getAttributeValueString(this.property);
            return this.allowed.contains(string);
        }
    }

    public static abstract class Condition {
        public abstract boolean isSatisfied();
    }
}

