/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.IllegalBuildException;
import VASSAL.build.module.Plugin;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.build.widget.CardSlot;
import VASSAL.build.widget.PieceSlot;
import VASSAL.configure.EditContainedPiecesAction;
import VASSAL.configure.EditPropertiesAction;
import VASSAL.configure.PropertiesWindow;
import VASSAL.configure.ShowHelpAction;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslateAction;
import VASSAL.launch.EditorWindow;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ReflectionUtils;
import VASSAL.tools.menu.MenuManager;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureTree
extends JTree
implements PropertyChangeListener,
MouseListener,
MouseMotionListener,
TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    protected Map<Configurable, DefaultMutableTreeNode> nodes = new HashMap<Configurable, DefaultMutableTreeNode>();
    protected DefaultMutableTreeNode copyData;
    protected DefaultMutableTreeNode cutData;
    protected HelpWindow helpWindow;
    protected EditorWindow editorWindow;
    protected Configurable selected;
    protected int selectedRow;
    protected String moveCmd;
    protected String deleteCmd;
    protected String pasteCmd;
    protected String copyCmd;
    protected String cutCmd;
    protected String helpCmd;
    protected String propertiesCmd;
    protected String translateCmd;
    protected KeyStroke cutKey;
    protected KeyStroke copyKey;
    protected KeyStroke pasteKey;
    protected KeyStroke deleteKey;
    protected KeyStroke moveKey;
    protected KeyStroke helpKey;
    protected KeyStroke propertiesKey;
    protected KeyStroke translateKey;
    protected Action cutAction;
    protected Action copyAction;
    protected Action pasteAction;
    protected Action deleteAction;
    protected Action moveAction;
    protected Action propertiesAction;
    protected Action translateAction;
    protected Action helpAction;
    public static Font POPUP_MENU_FONT = new Font("Dialog", 0, 11);
    protected static List<AdditionalComponent> additionalComponents = new ArrayList<AdditionalComponent>();

    public ConfigureTree(Configurable configurable, HelpWindow helpWindow) {
        this(configurable, helpWindow, null);
    }

    public ConfigureTree(Configurable configurable, HelpWindow helpWindow, EditorWindow editorWindow) {
        this.toggleClickCount = 3;
        this.helpWindow = helpWindow;
        this.editorWindow = editorWindow;
        this.setShowsRootHandles(true);
        this.setModel(new DefaultTreeModel(this.buildTreeNode(configurable)));
        this.setCellRenderer(this.buildRenderer());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addTreeSelectionListener(this);
        this.moveCmd = Resources.getString("Editor.move");
        this.deleteCmd = Resources.getString("Editor.delete");
        this.pasteCmd = Resources.getString("Editor.paste");
        this.copyCmd = Resources.getString("Editor.copy");
        this.cutCmd = Resources.getString("Editor.cut");
        this.propertiesCmd = Resources.getString("Editor.ModuleEditor.properties");
        this.translateCmd = Resources.getString("Editor.ModuleEditor.translate");
        this.helpCmd = Resources.getString("Editor.ModuleEditor.component_help");
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.cutKey = KeyStroke.getKeyStroke(88, n);
        this.copyKey = KeyStroke.getKeyStroke(67, n);
        this.pasteKey = KeyStroke.getKeyStroke(86, n);
        this.deleteKey = KeyStroke.getKeyStroke(127, 0);
        this.moveKey = KeyStroke.getKeyStroke(77, n);
        this.propertiesKey = KeyStroke.getKeyStroke(80, n);
        this.translateKey = KeyStroke.getKeyStroke(84, n);
        this.helpKey = KeyStroke.getKeyStroke(112, 0);
        this.copyAction = new KeyAction(this.copyCmd, this.copyKey);
        this.pasteAction = new KeyAction(this.pasteCmd, this.pasteKey);
        this.cutAction = new KeyAction(this.cutCmd, this.cutKey);
        this.deleteAction = new KeyAction(this.deleteCmd, this.deleteKey);
        this.moveAction = new KeyAction(this.moveCmd, this.moveKey);
        this.propertiesAction = new KeyAction(this.propertiesCmd, this.propertiesKey);
        this.translateAction = new KeyAction(this.translateCmd, this.translateKey);
        this.helpAction = new KeyAction(this.helpCmd, this.helpKey);
        this.getInputMap().put(this.cutKey, this.cutCmd);
        this.getInputMap().put(this.copyKey, this.copyCmd);
        this.getInputMap().put(this.pasteKey, this.pasteCmd);
        this.getInputMap().put(this.deleteKey, this.deleteCmd);
        this.getActionMap().put(this.cutCmd, this.cutAction);
        this.getActionMap().put(this.copyCmd, this.copyAction);
        this.getActionMap().put(this.pasteCmd, this.pasteAction);
        this.getActionMap().put(this.deleteCmd, this.deleteAction);
        this.getSelectionModel().setSelectionMode(1);
    }

    protected Renderer buildRenderer() {
        return new Renderer();
    }

    protected void notifyStateChanged(boolean bl) {
        if (this.editorWindow != null) {
            this.editorWindow.treeStateChanged(bl);
        }
    }

    protected Configurable getTarget(int n, int n2) {
        TreePath treePath = this.getPathForLocation(n, n2);
        Configurable configurable = null;
        if (treePath != null) {
            configurable = (Configurable)((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
        }
        return configurable;
    }

    protected DefaultMutableTreeNode buildTreeNode(Configurable configurable) {
        Configurable[] configurableArray;
        configurable.addPropertyChangeListener(this);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(configurable);
        for (Configurable configurable2 : configurableArray = configurable.getConfigureComponents()) {
            if (configurable2 instanceof Plugin) continue;
            defaultMutableTreeNode.add(this.buildTreeNode(configurable2));
        }
        this.nodes.put(configurable, defaultMutableTreeNode);
        return defaultMutableTreeNode;
    }

    protected void addAction(JPopupMenu jPopupMenu, Action action) {
        if (action != null) {
            jPopupMenu.add(action).setFont(POPUP_MENU_FONT);
        }
    }

    private void addActionGroup(JPopupMenu jPopupMenu, ArrayList<Action> arrayList) {
        boolean bl = true;
        for (Action action : arrayList) {
            if (action == null) continue;
            jPopupMenu.add(action).setFont(POPUP_MENU_FONT);
            bl = false;
        }
        if (!bl) {
            jPopupMenu.addSeparator();
        }
        arrayList.clear();
    }

    protected JPopupMenu buildPopupMenu(Configurable configurable) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.add(this.buildEditAction(configurable));
        arrayList.add(this.buildEditPiecesAction(configurable));
        this.addActionGroup(jPopupMenu, arrayList);
        arrayList.add(this.buildTranslateAction(configurable));
        this.addActionGroup(jPopupMenu, arrayList);
        arrayList.add(this.buildHelpAction(configurable));
        this.addActionGroup(jPopupMenu, arrayList);
        arrayList.add(this.buildDeleteAction(configurable));
        arrayList.add(this.buildCutAction(configurable));
        arrayList.add(this.buildCopyAction(configurable));
        arrayList.add(this.buildPasteAction(configurable));
        arrayList.add(this.buildMoveAction(configurable));
        this.addActionGroup(jPopupMenu, arrayList);
        for (Action action : this.buildAddActionsFor(configurable)) {
            this.addAction(jPopupMenu, action);
        }
        this.addAction(jPopupMenu, this.buildImportAction(configurable));
        return jPopupMenu;
    }

    protected Action buildMoveAction(final Configurable configurable) {
        AbstractAction abstractAction = null;
        if (this.getTreeNode(configurable).getParent() != null) {
            abstractAction = new AbstractAction(this.moveCmd){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    Object object;
                    final JDialog jDialog = new JDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, ConfigureTree.this), true);
                    jDialog.setTitle(configurable.getConfigureName() == null ? ConfigureTree.this.moveCmd : ConfigureTree.this.moveCmd + " " + configurable.getConfigureName());
                    jDialog.setLayout(new BoxLayout(jDialog.getContentPane(), 1));
                    Box box = Box.createHorizontalBox();
                    box.add(new JLabel("Move to position"));
                    box.add(Box.createHorizontalStrut(10));
                    final JComboBox<String> jComboBox = new JComboBox<String>();
                    TreeNode treeNode = ConfigureTree.this.getTreeNode(configurable).getParent();
                    for (int i = 0; i < treeNode.getChildCount(); ++i) {
                        Configurable configurable2 = (Configurable)((DefaultMutableTreeNode)treeNode.getChildAt(i)).getUserObject();
                        object = (configurable2.getConfigureName() != null ? configurable2.getConfigureName() : "") + " [" + ConfigureTree.getConfigureName(configurable2.getClass()) + "]";
                        jComboBox.addItem(i + 1 + ":  " + (String)object);
                    }
                    final DefaultMutableTreeNode defaultMutableTreeNode = ConfigureTree.this.getTreeNode(configurable);
                    final int n = defaultMutableTreeNode.getParent().getIndex(defaultMutableTreeNode);
                    jComboBox.setSelectedIndex(n);
                    box.add(jComboBox);
                    object = new JButton(Resources.getString("General.ok"));
                    ((AbstractButton)object).addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            Configurable configurable;
                            int n2 = jComboBox.getSelectedIndex();
                            if (n != n2 && ConfigureTree.this.remove(configurable = ConfigureTree.this.getParent(defaultMutableTreeNode), configurable)) {
                                ConfigureTree.this.insert(configurable, configurable, n2);
                            }
                            jDialog.dispose();
                        }
                    });
                    jDialog.add(box);
                    jDialog.add((Component)object);
                    jDialog.pack();
                    jDialog.setLocationRelativeTo(jDialog.getParent());
                    jDialog.setVisible(true);
                }
            };
        }
        return abstractAction;
    }

    protected Action buildCutAction(final Configurable configurable) {
        AbstractAction abstractAction = null;
        if (this.getTreeNode(configurable).getParent() != null) {
            abstractAction = new AbstractAction(this.cutCmd){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    ConfigureTree.this.cutData = ConfigureTree.this.getTreeNode(configurable);
                    ConfigureTree.this.copyData = null;
                    ConfigureTree.this.updateEditMenu();
                }
            };
        }
        return abstractAction;
    }

    protected Action buildCopyAction(final Configurable configurable) {
        AbstractAction abstractAction = null;
        if (this.getTreeNode(configurable).getParent() != null) {
            abstractAction = new AbstractAction(this.copyCmd){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    ConfigureTree.this.copyData = ConfigureTree.this.getTreeNode(configurable);
                    ConfigureTree.this.cutData = null;
                    ConfigureTree.this.updateEditMenu();
                }
            };
        }
        return abstractAction;
    }

    protected Action buildPasteAction(final Configurable configurable) {
        AbstractAction abstractAction = new AbstractAction(this.pasteCmd){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                if (ConfigureTree.this.cutData != null) {
                    DefaultMutableTreeNode defaultMutableTreeNode = ConfigureTree.this.getTreeNode(configurable);
                    Configurable configurable3 = (Configurable)ConfigureTree.this.cutData.getUserObject();
                    Configurable configurable2 = ConfigureTree.this.convertChild(configurable, configurable3);
                    if (ConfigureTree.this.remove(ConfigureTree.this.getParent(ConfigureTree.this.cutData), configurable3)) {
                        ConfigureTree.this.insert(configurable, configurable2, defaultMutableTreeNode.getChildCount());
                    }
                    ConfigureTree.this.copyData = ConfigureTree.this.getTreeNode(configurable2);
                } else if (ConfigureTree.this.copyData != null) {
                    Configurable configurable4 = (Configurable)ConfigureTree.this.copyData.getUserObject();
                    Buildable buildable = null;
                    try {
                        buildable = ConfigureTree.this.convertChild(configurable, (Configurable)configurable4.getClass().getConstructor(new Class[0]).newInstance(new Object[0]));
                    }
                    catch (Throwable throwable) {
                        ReflectionUtils.handleNewInstanceFailure(throwable, configurable4.getClass());
                    }
                    if (buildable != null) {
                        buildable.build(configurable4.getBuildElement(Builder.createNewDocument()));
                        ConfigureTree.this.insert(configurable, (Configurable)buildable, ConfigureTree.this.getTreeNode(configurable).getChildCount());
                        ConfigureTree.this.updateGpIds((Configurable)buildable);
                    }
                }
                ConfigureTree.this.cutData = null;
                ConfigureTree.this.updateEditMenu();
            }
        };
        abstractAction.setEnabled(this.isValidPasteTarget(configurable));
        return abstractAction;
    }

    protected boolean isValidPasteTarget(Configurable configurable) {
        return this.cutData != null && this.isValidParent(configurable, (Configurable)this.cutData.getUserObject()) || this.copyData != null && this.isValidParent(configurable, (Configurable)this.copyData.getUserObject());
    }

    protected Configurable convertChild(Configurable configurable, Configurable configurable2) {
        if (configurable2.getClass() == PieceSlot.class && this.isAllowedChildClass(configurable, CardSlot.class)) {
            return new CardSlot((PieceSlot)configurable2);
        }
        if (configurable2.getClass() == CardSlot.class && this.isAllowedChildClass(configurable, PieceSlot.class)) {
            return new PieceSlot((CardSlot)configurable2);
        }
        return configurable2;
    }

    protected boolean isAllowedChildClass(Configurable configurable, Class<?> clazz) {
        Class[] classArray = configurable.getAllowableConfigureComponents();
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] != clazz) continue;
            return true;
        }
        return false;
    }

    protected void updateGpIds(Configurable configurable) {
        if (configurable instanceof PieceSlot) {
            ((PieceSlot)configurable).updateGpId(GameModule.getGameModule());
        } else {
            for (Configurable configurable2 : configurable.getConfigureComponents()) {
                this.updateGpIds(configurable2);
            }
        }
    }

    protected Action buildImportAction(final Configurable configurable) {
        AbstractAction abstractAction = new AbstractAction("Add Imported Class"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                final Configurable configurable3 = ConfigureTree.this.importConfigurable();
                if (configurable3 != null) {
                    try {
                        configurable3.build(null);
                        final Configurable configurable2 = configurable;
                        if (configurable3.getConfigurer() != null) {
                            PropertiesWindow propertiesWindow = new PropertiesWindow((Frame)SwingUtilities.getAncestorOfClass(Frame.class, ConfigureTree.this), false, configurable3, ConfigureTree.this.helpWindow){
                                private static final long serialVersionUID = 1L;

                                public void save() {
                                    super.save();
                                    ConfigureTree.this.insert(configurable2, configurable3, ConfigureTree.this.getTreeNode(configurable2).getChildCount());
                                }

                                public void cancel() {
                                    this.dispose();
                                }
                            };
                            propertiesWindow.setVisible(true);
                        } else {
                            ConfigureTree.this.insert(configurable2, configurable3, ConfigureTree.this.getTreeNode(configurable2).getChildCount());
                        }
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(ConfigureTree.this.getTopLevelAncestor(), "Error adding " + ConfigureTree.getConfigureName(configurable3) + " to " + ConfigureTree.getConfigureName(configurable) + "\n" + exception.getMessage(), "Illegal configuration", 0);
                    }
                }
            }
        };
        return abstractAction;
    }

    protected List<Action> buildAddActionsFor(Configurable configurable) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        for (Class clazz : configurable.getAllowableConfigureComponents()) {
            arrayList.add(this.buildAddAction(configurable, clazz));
        }
        for (AdditionalComponent additionalComponent : additionalComponents) {
            if (!configurable.getClass().equals(additionalComponent.getParent())) continue;
            Class<? extends Buildable> clazz = additionalComponent.getChild();
            arrayList.add(this.buildAddAction(configurable, clazz));
        }
        return arrayList;
    }

    @Deprecated
    protected Enumeration<Action> buildAddActions(Configurable configurable) {
        return Collections.enumeration(this.buildAddActionsFor(configurable));
    }

    protected Action buildAddAction(final Configurable configurable, final Class<? extends Buildable> clazz) {
        AbstractAction abstractAction = new AbstractAction("Add " + ConfigureTree.getConfigureName(clazz)){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                Configurable configurable4 = null;
                try {
                    configurable4 = (Configurable)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable throwable) {
                    ReflectionUtils.handleNewInstanceFailure(throwable, clazz);
                }
                if (configurable4 != null) {
                    final Configurable configurable2 = configurable4;
                    configurable2.build(null);
                    if (configurable2 instanceof PieceSlot) {
                        ((PieceSlot)configurable2).updateGpId(GameModule.getGameModule());
                    }
                    final Configurable configurable3 = configurable;
                    if (configurable2.getConfigurer() != null) {
                        if (ConfigureTree.this.insert(configurable, configurable2, ConfigureTree.this.getTreeNode(configurable).getChildCount())) {
                            PropertiesWindow propertiesWindow = new PropertiesWindow((Frame)SwingUtilities.getAncestorOfClass(Frame.class, ConfigureTree.this), false, configurable2, ConfigureTree.this.helpWindow){
                                private static final long serialVersionUID = 1L;

                                public void save() {
                                    super.save();
                                }

                                public void cancel() {
                                    ConfigureTree.this.remove(configurable3, configurable2);
                                    this.dispose();
                                }
                            };
                            propertiesWindow.setVisible(true);
                        }
                    } else {
                        ConfigureTree.this.insert(configurable3, configurable2, ConfigureTree.this.getTreeNode(configurable3).getChildCount());
                    }
                }
            }
        };
        return abstractAction;
    }

    protected Action buildHelpAction(Configurable configurable) {
        ShowHelpAction showHelpAction;
        HelpFile helpFile = configurable.getHelpFile();
        if (helpFile == null) {
            showHelpAction = new ShowHelpAction(null, null);
            showHelpAction.setEnabled(false);
        } else {
            showHelpAction = new ShowHelpAction(helpFile.getContents(), null);
        }
        return showHelpAction;
    }

    protected Action buildCloneAction(final Configurable configurable) {
        final DefaultMutableTreeNode defaultMutableTreeNode = this.getTreeNode(configurable);
        if (defaultMutableTreeNode.getParent() != null) {
            return new AbstractAction("Clone"){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    Configurable configurable2 = null;
                    try {
                        configurable2 = (Configurable)configurable.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Throwable throwable) {
                        ReflectionUtils.handleNewInstanceFailure(throwable, configurable.getClass());
                    }
                    if (configurable2 != null) {
                        configurable2.build(configurable.getBuildElement(Builder.createNewDocument()));
                        ConfigureTree.this.insert(ConfigureTree.this.getParent(defaultMutableTreeNode), configurable2, defaultMutableTreeNode.getParent().getIndex(defaultMutableTreeNode) + 1);
                    }
                }
            };
        }
        return null;
    }

    protected Configurable getParent(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        return defaultMutableTreeNode2 == null ? null : (Configurable)defaultMutableTreeNode2.getUserObject();
    }

    protected Action buildDeleteAction(final Configurable configurable) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getTreeNode(configurable);
        final Configurable configurable2 = this.getParent(defaultMutableTreeNode);
        if (defaultMutableTreeNode.getParent() != null) {
            return new AbstractAction(this.deleteCmd){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ConfigureTree.this.selectedRow;
                    ConfigureTree.this.remove(configurable2, configurable);
                    if (n < ConfigureTree.this.getRowCount()) {
                        ConfigureTree.this.setSelectionRow(n);
                    } else {
                        ConfigureTree.this.setSelectionRow(n - 1);
                    }
                }
            };
        }
        return null;
    }

    protected Action buildEditPiecesAction(Configurable configurable) {
        if (this.canContainGamePiece(configurable)) {
            return new EditContainedPiecesAction(configurable);
        }
        return null;
    }

    protected Action buildEditAction(Configurable configurable) {
        return new EditPropertiesAction(configurable, this.helpWindow, (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this), this);
    }

    protected Action buildTranslateAction(Configurable configurable) {
        TranslateAction translateAction = new TranslateAction(configurable, this.helpWindow, this);
        translateAction.setEnabled(configurable.getI18nData().isTranslatable());
        return translateAction;
    }

    public boolean canContainGamePiece(Configurable configurable) {
        boolean bl = false;
        Class[] classArray = configurable.getAllowableConfigureComponents();
        for (int i = 0; i < classArray.length; ++i) {
            if (!PieceSlot.class.isAssignableFrom(classArray[i])) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected boolean remove(Configurable configurable, Configurable configurable2) {
        try {
            configurable2.removeFrom(configurable);
            configurable.remove(configurable2);
            ((DefaultTreeModel)this.getModel()).removeNodeFromParent(this.getTreeNode(configurable2));
            this.notifyStateChanged(true);
            return true;
        }
        catch (IllegalBuildException illegalBuildException) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "Cannot delete " + ConfigureTree.getConfigureName(configurable2) + " from " + ConfigureTree.getConfigureName(configurable) + "\n" + illegalBuildException.getMessage(), "Illegal configuration", 0);
            return false;
        }
    }

    protected boolean insert(Configurable configurable, Configurable configurable2, int n) {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode = this.buildTreeNode(configurable2);
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.getTreeNode(configurable);
        Configurable[] configurableArray = configurable.getConfigureComponents();
        boolean bl = true;
        ArrayList<Configurable> arrayList = new ArrayList<Configurable>();
        for (int i = n; i < configurableArray.length; ++i) {
            try {
                configurableArray[i].removeFrom(configurable);
                configurable.remove(configurableArray[i]);
            }
            catch (IllegalBuildException illegalBuildException) {
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "Can't insert " + ConfigureTree.getConfigureName(configurable2) + " before " + ConfigureTree.getConfigureName(configurableArray[i]), "Illegal configuration", 0);
                for (int j = n; j < i; ++j) {
                    configurable.add(configurableArray[j]);
                    configurableArray[j].addTo(configurable);
                }
                return false;
            }
            arrayList.add(configurableArray[i]);
        }
        try {
            configurable2.addTo(configurable);
            configurable.add(configurable2);
            defaultMutableTreeNode2.insert(defaultMutableTreeNode, n);
            object = new int[]{n};
            ((DefaultTreeModel)this.getModel()).nodesWereInserted(defaultMutableTreeNode2, (int[])object);
        }
        catch (IllegalBuildException illegalBuildException) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "Can't add " + ConfigureTree.getConfigureName(configurable2) + "\n" + illegalBuildException.getMessage(), "Illegal configuration", 0);
            bl = false;
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            Configurable configurable3 = (Configurable)object.next();
            configurable.add(configurable3);
            configurable3.addTo(configurable);
        }
        this.notifyStateChanged(true);
        return bl;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getTreeNode((Configurable)propertyChangeEvent.getSource());
        ((DefaultTreeModel)this.getModel()).nodeChanged(defaultMutableTreeNode);
    }

    public static String getConfigureName(Class<?> clazz) {
        try {
            return (String)clazz.getMethod("getConfigureTypeName", new Class[0]).invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            ErrorDialog.bug(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorDialog.bug(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorDialog.bug(invocationTargetException);
        }
        catch (NullPointerException nullPointerException) {
            ErrorDialog.bug(nullPointerException);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            ErrorDialog.bug(exceptionInInitializerError);
        }
        return clazz.getName().substring(clazz.getName().lastIndexOf(".") + 1);
    }

    public static String getConfigureName(Configurable configurable) {
        if (configurable.getConfigureName() != null && configurable.getConfigureName().length() > 0) {
            return configurable.getConfigureName();
        }
        return ConfigureTree.getConfigureName(configurable.getClass());
    }

    protected Configurable importConfigurable() {
        String string = JOptionPane.showInputDialog(this.getTopLevelAncestor(), (Object)"Enter fully-qualified name of Java class to import");
        if (string == null) {
            return null;
        }
        Object var2_2 = null;
        try {
            var2_2 = GameModule.getGameModule().getDataArchive().loadClass(string).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            ReflectionUtils.handleImportClassFailure(throwable, string);
        }
        if (var2_2 == null) {
            return null;
        }
        if (var2_2 instanceof Configurable) {
            return var2_2;
        }
        ErrorDialog.show("Error.not_a_configurable", string);
        return null;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Configurable configurable = this.getTarget(mouseEvent.getX(), mouseEvent.getY());
        if (configurable != null) {
            if (mouseEvent.getClickCount() == 2 && !mouseEvent.isMetaDown()) {
                Action action;
                if (configurable.getConfigurer() != null && (action = this.buildEditAction(configurable)) != null) {
                    action.actionPerformed(new ActionEvent(mouseEvent.getSource(), 1001, "Edit"));
                }
            } else if (mouseEvent.isMetaDown()) {
                this.setSelectionRow(this.getClosestRowForLocation(mouseEvent.getX(), mouseEvent.getY()));
                JPopupMenu jPopupMenu = this.buildPopupMenu(configurable);
                jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
                jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                        ConfigureTree.this.repaint();
                    }

                    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                        ConfigureTree.this.repaint();
                    }

                    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    }
                });
            }
        }
    }

    public DefaultMutableTreeNode getTreeNode(Configurable configurable) {
        return this.nodes.get(configurable);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    protected boolean isValidParent(Configurable configurable, Configurable configurable2) {
        if (configurable != null && configurable2 != null) {
            Class[] classArray = configurable.getAllowableConfigureComponents();
            for (int i = 0; i < classArray.length; ++i) {
                if (!classArray[i].isAssignableFrom(configurable2.getClass()) && (classArray[i] != CardSlot.class || configurable2.getClass() != PieceSlot.class)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void nodeUpdated(Configurable configurable) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getTreeNode(configurable);
        Configurable configurable2 = this.getParent(defaultMutableTreeNode);
        if (this.remove(configurable2, configurable)) {
            this.insert(configurable2, configurable, 0);
        }
    }

    public void externalInsert(Configurable configurable, Configurable configurable2) {
        this.insert(configurable, configurable2, this.getTreeNode(configurable).getChildCount());
    }

    public Action getHelpAction() {
        return this.helpAction;
    }

    public void populateEditMenu(EditorWindow editorWindow) {
        MenuManager menuManager = MenuManager.getInstance();
        menuManager.addAction("Editor.delete", this.deleteAction);
        menuManager.addAction("Editor.cut", this.cutAction);
        menuManager.addAction("Editor.copy", this.copyAction);
        menuManager.addAction("Editor.paste", this.pasteAction);
        menuManager.addAction("Editor.move", this.moveAction);
        menuManager.addAction("Editor.ModuleEditor.properties", this.propertiesAction);
        menuManager.addAction("Editor.ModuleEditor.translate", this.translateAction);
        this.updateEditMenu();
    }

    protected void doKeyAction(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (defaultMutableTreeNode != null) {
            Configurable configurable = (Configurable)defaultMutableTreeNode.getUserObject();
            Action action = null;
            if (this.cutCmd.equals(string)) {
                action = this.buildCutAction(configurable);
            } else if (this.copyCmd.equals(string)) {
                action = this.buildCopyAction(configurable);
            } else if (this.pasteCmd.equals(string) || string.equals(Character.valueOf(this.pasteKey.getKeyChar()))) {
                action = this.buildPasteAction(configurable);
            } else if (this.deleteCmd.equals(string)) {
                action = this.buildDeleteAction(configurable);
            } else if (this.moveCmd.equals(string)) {
                action = this.buildMoveAction(configurable);
            } else if (this.propertiesCmd.equals(string)) {
                action = this.buildEditAction(configurable);
            } else if (this.translateCmd.equals(string)) {
                action = this.buildTranslateAction(configurable);
            } else if (this.helpCmd.equals(string)) {
                action = this.buildHelpAction(configurable);
            }
            if (action != null) {
                action.actionPerformed(null);
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.selected = null;
        TreePath treePath = treeSelectionEvent.getPath();
        if (treePath != null) {
            this.selected = (Configurable)((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
            this.selectedRow = this.getRowForPath(treePath);
            this.updateEditMenu();
        }
    }

    protected void updateEditMenu() {
        this.deleteAction.setEnabled(this.selected != null);
        this.cutAction.setEnabled(this.selected != null);
        this.copyAction.setEnabled(this.selected != null);
        this.pasteAction.setEnabled(this.selected != null && this.isValidPasteTarget(this.selected));
        this.moveAction.setEnabled(this.selected != null);
        this.propertiesAction.setEnabled(this.selected != null && this.selected.getConfigurer() != null);
        this.translateAction.setEnabled(this.selected != null);
    }

    protected Configurable getParent(Configurable configurable) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getTreeNode(configurable).getParent();
        return (Configurable)defaultMutableTreeNode.getUserObject();
    }

    public static void addAdditionalComponent(Class<? extends Buildable> clazz, Class<? extends Buildable> clazz2) {
        additionalComponents.add(new AdditionalComponent(clazz, clazz2));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AdditionalComponent {
        Class<? extends Buildable> parent;
        Class<? extends Buildable> child;

        public AdditionalComponent(Class<? extends Buildable> clazz, Class<? extends Buildable> clazz2) {
            this.parent = clazz;
            this.child = clazz2;
        }

        public Class<? extends Buildable> getParent() {
            return this.parent;
        }

        public Class<? extends Buildable> getChild() {
            return this.child;
        }
    }

    public static interface Mutable {
    }

    static class Renderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        Renderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Configurable configurable;
            if (object instanceof DefaultMutableTreeNode && (configurable = (Configurable)((DefaultMutableTreeNode)object).getUserObject()) != null) {
                bl3 = configurable.getAllowableConfigureComponents().length == 0;
                object = (configurable.getConfigureName() != null ? configurable.getConfigureName() : "") + " [" + ConfigureTree.getConfigureName(configurable.getClass()) + "]";
            }
            return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        }
    }

    class KeyAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        protected String actionName;

        public KeyAction(String string, KeyStroke keyStroke) {
            super(string);
            this.actionName = string;
            this.putValue("AcceleratorKey", keyStroke);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ConfigureTree.this.doKeyAction(this.actionName);
        }
    }
}

