/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import VASSAL.i18n.Resources;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class HotKeyConfigurer
extends Configurer
implements KeyListener {
    private JTextField tf;
    private JPanel p;

    public HotKeyConfigurer(String string, String string2) {
        this(string, string2, KeyStroke.getKeyStroke('\u0000'));
    }

    public HotKeyConfigurer(String string, String string2, KeyStroke keyStroke) {
        super(string, string2, keyStroke);
    }

    public void setValue(Object object) {
        super.setValue(object);
        if (this.tf != null && !this.tf.getText().equals(this.keyToString())) {
            this.tf.setText(this.keyToString());
        }
    }

    public String keyToString() {
        return HotKeyConfigurer.getString((KeyStroke)this.getValue());
    }

    public String getValueString() {
        return HotKeyConfigurer.encode((KeyStroke)this.getValue());
    }

    public void setValue(String string) {
        this.setValue(string == null ? null : HotKeyConfigurer.decode(string));
    }

    public Component getControls() {
        if (this.p == null) {
            this.p = new JPanel();
            this.p.setLayout(new BoxLayout(this.p, 0));
            this.tf = new JTextField(8);
            this.tf.setMaximumSize(new Dimension(this.tf.getMaximumSize().width, this.tf.getPreferredSize().height));
            this.tf.setText(this.keyToString());
            this.tf.addKeyListener(this);
            this.p.add(new JLabel(this.getName()));
            this.p.add(this.tf);
        }
        return this.p;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 8: 
            case 127: {
                this.setValue(null);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 157: {
                break;
            }
            default: {
                this.setValue(KeyStroke.getKeyStrokeForEvent(keyEvent));
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.tf.setText(HotKeyConfigurer.getString((KeyStroke)this.getValue()));
    }

    public static String getString(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return null;
        }
        String string = KeyEvent.getKeyText(keyStroke.getKeyCode());
        string = string.replace(' ', '_');
        if ((keyStroke.getModifiers() & 1) > 0) {
            string = Resources.getString("Keys.shift") + " " + string;
        }
        if ((keyStroke.getModifiers() & 2) > 0) {
            string = Resources.getString("Keys.ctrl") + " " + string;
        }
        if ((keyStroke.getModifiers() & 4) > 0) {
            string = Resources.getString("Keys.meta") + " " + string;
        }
        if ((keyStroke.getModifiers() & 8) > 0) {
            string = Resources.getString("Keys.alt") + " " + string;
        }
        return string.toUpperCase();
    }

    public static KeyStroke decode(String string) {
        int n = string.indexOf(",");
        if (n < 0) {
            return null;
        }
        try {
            return KeyStroke.getKeyStroke(Integer.parseInt(string.substring(0, n)), Integer.parseInt(string.substring(n + 1)));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static String encode(KeyStroke keyStroke) {
        return keyStroke == null ? "" : keyStroke.getKeyCode() + "," + keyStroke.getModifiers();
    }
}

