/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.AutoConfigurable;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class TextConfigurer
extends Configurer
implements ConfigurerFactory {
    private JTextArea textArea;
    private JPanel p;
    private boolean wordWrap;
    private long lastUpdate = System.currentTimeMillis();
    private String updatedValue;
    private boolean updateQueued = false;
    private long updateFrequencey = 1000L;

    public TextConfigurer() {
        this(null, null, null);
    }

    public TextConfigurer(String string, String string2) {
        this(string, string2, "");
    }

    public TextConfigurer(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public TextConfigurer(String string, String string2, String string3, boolean bl) {
        this(string, string2, string3);
        this.setWordWrap(bl);
    }

    public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
        this.key = string;
        this.name = string2;
        return this;
    }

    public String getValueString() {
        return TextConfigurer.escapeNewlines((String)this.getValue());
    }

    public void setWordWrap(boolean bl) {
        this.wordWrap = bl;
    }

    public static String escapeNewlines(String string) {
        SequenceEncoder sequenceEncoder = new SequenceEncoder('|');
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r", true);
        boolean bl = true;
        block4: while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            switch (string2.charAt(0)) {
                case '\n': {
                    if (bl) {
                        sequenceEncoder.append("");
                    }
                    bl = true;
                    continue block4;
                }
                case '\r': {
                    continue block4;
                }
            }
            sequenceEncoder.append(string2);
            bl = false;
        }
        return sequenceEncoder.getValue() == null ? "" : sequenceEncoder.getValue();
    }

    public void setValue(String string) {
        String string2 = TextConfigurer.restoreNewlines(string);
        this.setValue((Object)string2);
    }

    public void setValue(Object object) {
        super.setValue(object);
        if (!this.noUpdate && this.textArea != null) {
            this.textArea.setText((String)object);
        }
    }

    public static String restoreNewlines(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '|');
        String string2 = "";
        while (decoder.hasMoreTokens()) {
            string2 = string2 + decoder.nextToken();
            if (!decoder.hasMoreTokens()) continue;
            string2 = string2 + "\n";
        }
        return string2;
    }

    public Component getControls() {
        if (this.p == null) {
            this.p = new JPanel();
            this.p.setLayout(new BoxLayout(this.p, 1));
            this.textArea = new JTextArea(6, 20);
            if (this.wordWrap) {
                this.textArea.setLineWrap(true);
                this.textArea.setWrapStyleWord(true);
            }
            this.textArea.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent keyEvent) {
                    TextConfigurer.this.queueForUpdate(TextConfigurer.this.textArea.getText());
                }
            });
            this.textArea.setText((String)this.getValue());
            ScrollPane scrollPane = new ScrollPane(this.textArea);
            if (this.name != null) {
                scrollPane.setBorder(new TitledBorder(this.name));
            }
            this.p.add(scrollPane);
        }
        return this.p;
    }

    private void queueForUpdate(String string) {
        this.updatedValue = string;
        if (System.currentTimeMillis() > this.lastUpdate + this.updateFrequencey) {
            this.executeUpdate();
        } else if (!this.updateQueued) {
            this.updateQueued = true;
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(TextConfigurer.this.updateFrequencey);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            TextConfigurer.this.executeUpdate();
                        }
                    });
                }
            };
            new Thread(runnable).start();
        }
    }

    private void executeUpdate() {
        this.noUpdate = true;
        this.setValue((Object)this.updatedValue);
        this.lastUpdate = System.currentTimeMillis();
        this.updateQueued = false;
        this.noUpdate = false;
    }
}

