/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.command.RemovePiece;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class Delete
extends Decorator
implements TranslatablePiece {
    public static final String ID = "delete;";
    protected KeyCommand[] keyCommands;
    protected KeyCommand deleteCommand;
    protected String commandName;
    protected KeyStroke key;

    public Delete() {
        this("delete;Delete;D", null);
    }

    public Delete(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public void mySetType(String string) {
        string = string.substring(ID.length());
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        this.commandName = decoder.nextToken();
        this.key = decoder.nextKeyStroke('D');
        this.keyCommands = null;
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.commandName).append(this.key);
        return ID + sequenceEncoder.getValue();
    }

    protected KeyCommand[] myGetKeyCommands() {
        if (this.keyCommands == null) {
            this.deleteCommand = new KeyCommand(this.commandName, this.key, Decorator.getOutermost(this), this);
            this.keyCommands = this.commandName.length() > 0 ? new KeyCommand[]{this.deleteCommand} : new KeyCommand[0];
        }
        this.deleteCommand.setEnabled(this.getMap() != null);
        return this.keyCommands;
    }

    public String myGetState() {
        return "";
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        RemovePiece removePiece = null;
        this.myGetKeyCommands();
        if (this.deleteCommand.matches(keyStroke)) {
            GamePiece gamePiece = Decorator.getOutermost(this);
            if (this.getParent() != null) {
                GamePiece gamePiece2 = this.getParent().getPieceBeneath(gamePiece);
                if (gamePiece2 == null) {
                    gamePiece2 = this.getParent().getPieceAbove(gamePiece);
                }
                if (gamePiece2 != null) {
                    final GamePiece gamePiece3 = gamePiece2;
                    Runnable runnable = new Runnable(){

                        public void run() {
                            if (GameModule.getGameModule().getGameState().getPieceForId(gamePiece3.getId()) != null) {
                                KeyBuffer.getBuffer().add(gamePiece3);
                            }
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            }
            removePiece = new RemovePiece(gamePiece);
            removePiece.execute();
        }
        return removePiece;
    }

    public void mySetState(String string) {
    }

    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
    }

    public String getName() {
        return this.piece.getName();
    }

    public Shape getShape() {
        return this.piece.getShape();
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public String getDescription() {
        return "Delete";
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GamePiece.htm", "Delete");
    }

    public PieceI18nData getI18nData() {
        return this.getI18nData(this.commandName, "Delete command");
    }

    public static class Ed
    implements PieceEditor {
        private StringConfigurer nameInput;
        private HotKeyConfigurer keyInput;
        private JPanel controls = new JPanel();

        public Ed(Delete delete) {
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            this.nameInput = new StringConfigurer(null, "Command name:  ", delete.commandName);
            this.controls.add(this.nameInput.getControls());
            this.keyInput = new HotKeyConfigurer(null, "Keyboard Command:  ", delete.key);
            this.controls.add(this.keyInput.getControls());
        }

        public Component getControls() {
            return this.controls;
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(this.nameInput.getValueString()).append((KeyStroke)this.keyInput.getValue());
            return Delete.ID + sequenceEncoder.getValue();
        }

        public String getState() {
            return "";
        }
    }
}

