/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.DoubleConfigurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.Labeler;
import VASSAL.counters.MovementMarkable;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.PieceI18nData;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.image.ImageUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class Footprint
extends MovementMarkable {
    public static final String ID = "footprint;";
    private KeyCommand[] commands;
    protected boolean globalVisibility = false;
    protected String startMapId = "";
    protected List<Point> pointList = new ArrayList<Point>();
    protected KeyStroke trailKey;
    protected String menuCommand;
    protected boolean initiallyVisible = false;
    protected boolean globallyVisible = false;
    protected int circleRadius;
    protected int selectedTransparency;
    protected int unSelectedTransparency;
    protected Color lineColor;
    protected Color fillColor;
    protected int edgePointBuffer;
    protected int edgeDisplayBuffer;
    protected static final char DEFAULT_TRAIL_KEY = 'T';
    protected static final String DEFAULT_MENU_COMMAND = "Movement Trail";
    protected static final Boolean DEFAULT_INITIALLY_VISIBLE = Boolean.FALSE;
    protected static final Boolean DEFAULT_GLOBALLY_VISIBLE = Boolean.FALSE;
    protected static final int DEFAULT_CIRCLE_RADIUS = 10;
    protected static final Color DEFAULT_FILL_COLOR = Color.WHITE;
    protected static final Color DEFAULT_LINE_COLOR = Color.BLACK;
    protected static final int DEFAULT_SELECTED_TRANSPARENCY = 100;
    protected static final int DEFULT_UNSELECTED_TRANSPARENCY = 50;
    protected static final int DEFAULT_EDGE_POINT_BUFFER = 20;
    protected static final int DEFAULT_EDGE_DISPLAY_BUFFER = 30;
    protected static final float LINE_WIDTH = 1.0f;
    protected int minX;
    protected int minY;
    protected int maxX;
    protected int maxY;
    protected Rectangle myBoundingBox;
    protected Font font;
    protected double lastZoom;
    protected boolean localVisibility;
    protected double lineWidth;
    private KeyCommand showTrailCommand;

    public Footprint() {
        super(ID, null);
    }

    public Footprint(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    @Deprecated
    protected Enumeration getPointList() {
        return Collections.enumeration(this.pointList);
    }

    public void mySetState(String string) {
        this.pointList.clear();
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        this.globalVisibility = decoder.nextBoolean(this.initiallyVisible);
        this.startMapId = decoder.nextToken("");
        int n = decoder.nextInt(0);
        for (int i = 0; i < n; ++i) {
            String string2 = decoder.nextToken("");
            if (string2.length() == 0) continue;
            SequenceEncoder.Decoder decoder2 = new SequenceEncoder.Decoder(string2, ',');
            int n2 = decoder2.nextInt(0);
            int n3 = decoder2.nextInt(0);
            this.pointList.add(new Point(n2, n3));
        }
    }

    public String myGetState() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.globalVisibility).append(this.startMapId).append(this.pointList.size());
        for (Point point : this.pointList) {
            sequenceEncoder.append(point.x + "," + point.y);
        }
        return sequenceEncoder.getValue();
    }

    public void mySetType(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        this.trailKey = decoder.nextKeyStroke('T');
        this.menuCommand = decoder.nextToken(DEFAULT_MENU_COMMAND);
        this.initiallyVisible = decoder.nextBoolean(DEFAULT_INITIALLY_VISIBLE);
        this.globallyVisible = decoder.nextBoolean(DEFAULT_GLOBALLY_VISIBLE);
        this.circleRadius = decoder.nextInt(10);
        this.fillColor = decoder.nextColor(DEFAULT_FILL_COLOR);
        this.lineColor = decoder.nextColor(DEFAULT_LINE_COLOR);
        this.selectedTransparency = decoder.nextInt(100);
        this.unSelectedTransparency = decoder.nextInt(50);
        this.edgePointBuffer = decoder.nextInt(20);
        this.edgeDisplayBuffer = decoder.nextInt(30);
        this.lineWidth = decoder.nextDouble(1.0);
        this.commands = null;
        this.showTrailCommand = null;
        if (this.initiallyVisible) {
            this.localVisibility = true;
            this.globalVisibility = true;
        }
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.trailKey).append(this.menuCommand).append(this.initiallyVisible).append(this.globallyVisible).append(this.circleRadius).append(this.fillColor).append(this.lineColor).append(this.selectedTransparency).append(this.unSelectedTransparency).append(this.edgePointBuffer).append(this.edgeDisplayBuffer).append(this.lineWidth);
        return ID + sequenceEncoder.getValue();
    }

    public void setProperty(Object object, Object object2) {
        if ("Moved".equals(object)) {
            this.setMoved(Boolean.TRUE.equals(object2));
            this.piece.setProperty(object, object2);
        } else {
            super.setProperty(object, object2);
        }
    }

    public Object getLocalizedProperty(Object object) {
        if ("Moved".equals(object)) {
            Object object2 = this.piece.getProperty(object);
            return object2 == null ? super.getProperty(object) : object2;
        }
        return super.getLocalizedProperty(object);
    }

    public Object getProperty(Object object) {
        if ("Moved".equals(object)) {
            Object object2 = this.piece.getProperty(object);
            return object2 == null ? super.getProperty(object) : object2;
        }
        return super.getProperty(object);
    }

    public void setMoved(boolean bl) {
        if (bl) {
            this.recordCurrentPosition();
            Map map = this.getMap();
            this.startMapId = map != null ? map.getId() : null;
        } else {
            this.clearTrail();
            this.myBoundingBox = null;
        }
        this.redraw();
    }

    protected void recordCurrentPosition() {
        Point point = this.getPosition();
        if (this.pointList.isEmpty()) {
            this.addPoint(point);
        } else {
            Point point2 = this.pointList.get(this.pointList.size() - 1);
            if (!point2.equals(point)) {
                this.addPoint(point);
            }
        }
    }

    protected void clearTrail() {
        this.pointList.clear();
        this.addPoint(this.getPosition());
        this.myBoundingBox = null;
        this.localVisibility = this.initiallyVisible;
        this.globalVisibility = this.initiallyVisible;
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("MovementTrail.htm");
    }

    protected void addPoint(Point point) {
        this.pointList.add(point);
        this.getMyBoundingBox();
        if (point.x + this.circleRadius > this.maxX) {
            this.maxX = point.x + this.circleRadius;
        }
        if (point.x - this.circleRadius < this.minX) {
            this.minX = point.x - this.circleRadius;
        }
        if (point.y + this.circleRadius > this.maxY) {
            this.maxY = point.y + this.circleRadius;
        }
        if (point.y - this.circleRadius < this.minY) {
            this.minY = point.y - this.circleRadius;
        }
        this.myBoundingBox = new Rectangle(this.minX, this.minY, this.maxX - this.minX, this.maxY - this.minY);
    }

    public void redraw() {
        Map map = this.getMap();
        if (map != null) {
            map.repaint(this.getMyBoundingBox());
        }
    }

    public String getDescription() {
        return "Movement trail";
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        int n3;
        int n4;
        int n5;
        int n6;
        this.piece.draw(graphics, n, n2, component, d);
        if (this.getMap() == null || this.getMap().getView() != component || !this.isTrailVisible()) {
            return;
        }
        String string = this.getMap().getId();
        if (!string.equals(this.startMapId)) {
            this.startMapId = string;
            this.clearTrail();
            return;
        }
        double d2 = d;
        if (this.getMap() != null && d != (d2 = this.getMap().getZoom())) {
            return;
        }
        string = this.getMap().getId();
        Graphics2D graphics2D = (Graphics2D)graphics;
        boolean bl = Boolean.TRUE.equals(Decorator.getOutermost(this).getProperty("Selected"));
        int n7 = Math.max(0, Math.min(100, bl ? this.selectedTransparency : this.unSelectedTransparency));
        float f = (float)n7 / 100.0f;
        Composite composite = graphics2D.getComposite();
        Stroke stroke = graphics2D.getStroke();
        Color color = graphics2D.getColor();
        int n8 = this.getMap().mapSize().height;
        int n9 = this.getMap().mapSize().width;
        int n10 = Integer.parseInt(this.getMap().getAttributeValueString("edgeHeight"));
        int n11 = Integer.parseInt(this.getMap().getAttributeValueString("edgeWidth"));
        int n12 = n10 < this.edgeDisplayBuffer ? n10 : this.edgeDisplayBuffer;
        int n13 = n11 < this.edgeDisplayBuffer ? n11 : this.edgeDisplayBuffer;
        int n14 = n11 - n13;
        int n15 = n10 - n12;
        int n16 = n9 - 2 * n11 + 2 * n13;
        int n17 = n8 - 2 * n10 + 2 * n12;
        Rectangle rectangle = new Rectangle((int)((double)n14 * d), (int)((double)n15 * d), (int)((double)n16 * d), (int)((double)n17 * d));
        Rectangle rectangle2 = new Rectangle(n11 - this.edgePointBuffer, n10 - this.edgePointBuffer, n9 + 2 * this.edgePointBuffer, n8 + 2 * this.edgePointBuffer);
        Rectangle rectangle3 = this.getMap().getView().getVisibleRect();
        Shape shape = graphics2D.getClip();
        graphics2D.setClip(rectangle.intersection(rectangle3));
        if (shape != null) {
            graphics2D.setClip(shape.getBounds().intersection(graphics.getClipBounds()));
        }
        graphics2D.setComposite(AlphaComposite.getInstance(3, f));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float f2 = Math.max(1.0f, (float)(d * this.lineWidth));
        graphics2D.setStroke(new BasicStroke(f2));
        graphics2D.setColor(this.lineColor);
        Object var36_30 = null;
        Point point = this.getPosition();
        Iterator<Point> iterator = this.pointList.iterator();
        Point point2 = iterator.next();
        while (iterator.hasNext()) {
            Point point3 = iterator.next();
            n6 = (int)((double)point2.x * d);
            n5 = (int)((double)point2.y * d);
            n4 = (int)((double)point3.x * d);
            n3 = (int)((double)point3.y * d);
            this.drawTrack(graphics, n6, n5, n4, n3, d);
            point2 = point3;
        }
        if (!point.equals(point2)) {
            n6 = (int)((double)point2.x * d);
            n5 = (int)((double)point2.y * d);
            n4 = (int)((double)point.x * d);
            n3 = (int)((double)point.y * d);
            this.drawTrack(graphics, n6, n5, n4, n3, d);
        }
        int n18 = -1;
        for (Point point4 : this.pointList) {
            Object object;
            ++n18;
            if (!rectangle2.contains(point4) || point4.equals(point)) continue;
            this.drawPoint(graphics, point4, d, n18);
            Image image = this.getTrailImage(n18);
            n6 = (int)((double)(point4.x - this.circleRadius) * d);
            n5 = (int)((double)(point4.y - this.circleRadius) * d);
            if (bl && image != null) {
                if (d == 1.0) {
                    graphics.drawImage(image, n6, n5, component);
                } else {
                    object = ImageUtils.transform((BufferedImage)image, d, 0.0);
                    graphics.drawImage((Image)object, n6, n5, component);
                }
            }
            object = this.getTrailText(n18);
            if (!bl || object == null) continue;
            if (this.font == null || this.lastZoom != d2) {
                n6 = (int)((double)point4.x * d);
                n5 = (int)((double)point4.y * d);
                Font font = new Font("Dialog", 0, (int)((double)this.circleRadius * 1.4 * d));
                Labeler.drawLabel(graphics, (String)object, n6, n5, font, 0, 0, this.lineColor, null, null);
            }
            this.lastZoom = d2;
        }
        graphics2D.setComposite(composite);
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color);
        graphics.setClip(shape);
    }

    protected void drawPoint(Graphics graphics, Point point, double d, int n) {
        int n2 = (int)((double)(point.x - this.circleRadius) * d);
        int n3 = (int)((double)(point.y - this.circleRadius) * d);
        int n4 = (int)((double)(this.circleRadius * 2) * d);
        graphics.setColor(this.fillColor);
        graphics.fillOval(n2, n3, n4, n4);
        graphics.setColor(this.lineColor);
        graphics.drawOval(n2, n3, n4, n4);
    }

    protected void drawTrack(Graphics graphics, int n, int n2, int n3, int n4, double d) {
        double d2 = -1.0;
        int n5 = (n3 - n) * (n3 - n) + (n4 - n2) * (n4 - n2);
        int n6 = -1;
        if (n5 != n6) {
            n6 = n5;
            d2 = Math.sqrt(n5);
        }
        int n7 = (int)((double)(this.circleRadius * (n3 - n)) * d / d2);
        int n8 = (int)((double)(this.circleRadius * (n4 - n2)) * d / d2);
        graphics.drawLine(n + n7, n2 + n8, n3 - n7, n4 - n8);
    }

    protected Image getTrailImage(int n) {
        return null;
    }

    protected String getTrailText(int n) {
        return null;
    }

    protected boolean isTrailVisible() {
        if (this.globallyVisible) {
            return this.globalVisibility || this.trailKey == null;
        }
        return this.localVisibility || this.trailKey == null;
    }

    public Rectangle boundingBox() {
        Rectangle rectangle = this.piece.boundingBox();
        if (this.isTrailVisible() && this.getMap() != null) {
            rectangle.add(this.getMyBoundingBox());
        }
        return rectangle;
    }

    public Rectangle getMyBoundingBox() {
        if (this.myBoundingBox == null) {
            Point point = this.piece.getPosition();
            this.myBoundingBox = new Rectangle(point.x, point.y, 60, 60);
            this.minX = this.myBoundingBox.x;
            this.minY = this.myBoundingBox.y;
            this.maxX = this.myBoundingBox.x + this.myBoundingBox.width;
            this.maxY = this.myBoundingBox.y + this.myBoundingBox.height;
        }
        return this.myBoundingBox;
    }

    public Shape getShape() {
        return this.piece.getShape();
    }

    public String getName() {
        return this.piece.getName();
    }

    public KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            if (this.trailKey != null) {
                this.showTrailCommand = new KeyCommand(this.menuCommand, this.trailKey, Decorator.getOutermost(this), this);
            }
            this.commands = this.showTrailCommand != null && this.menuCommand.length() > 0 ? new KeyCommand[]{this.showTrailCommand} : new KeyCommand[0];
        }
        if (this.showTrailCommand != null) {
            this.showTrailCommand.setEnabled(this.getMap() != null);
        }
        return this.commands;
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        this.myGetKeyCommands();
        if (this.showTrailCommand != null && this.showTrailCommand.matches(keyStroke)) {
            ChangeTracker changeTracker = new ChangeTracker(this);
            if (this.globallyVisible) {
                this.globalVisibility = !this.globalVisibility;
            } else {
                this.localVisibility = !this.localVisibility;
            }
            this.redraw();
            return changeTracker.getChangeCommand();
        }
        return null;
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public PieceI18nData getI18nData() {
        PieceI18nData pieceI18nData = super.getI18nData();
        pieceI18nData.add(this.menuCommand, "Show Movement Trail command");
        return pieceI18nData;
    }

    protected static class Ed
    implements PieceEditor {
        private HotKeyConfigurer trailKeyInput;
        private JPanel controls = new JPanel();
        private StringConfigurer mc;
        private BooleanConfigurer iv;
        private BooleanConfigurer gv;
        private IntConfigurer cr;
        private ColorConfigurer fc;
        private ColorConfigurer lc;
        private IntConfigurer st;
        private IntConfigurer ut;
        private IntConfigurer pb;
        private IntConfigurer db;
        private DoubleConfigurer lw;

        public Ed(Footprint footprint) {
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            this.trailKeyInput = new HotKeyConfigurer(null, "Key Command:  ", footprint.trailKey);
            this.controls.add(this.trailKeyInput.getControls());
            this.mc = new StringConfigurer(null, "Menu Command:  ", footprint.menuCommand);
            this.controls.add(this.mc.getControls());
            this.iv = new BooleanConfigurer(null, "Trails start visible?", (Boolean)footprint.initiallyVisible);
            this.controls.add(this.iv.getControls());
            this.gv = new BooleanConfigurer(null, "Trails are visible to all players?", (Boolean)footprint.globallyVisible);
            this.controls.add(this.gv.getControls());
            this.cr = new IntConfigurer(null, "Circle Radius:  ", new Integer(footprint.circleRadius));
            this.controls.add(this.cr.getControls());
            this.fc = new ColorConfigurer(null, "Circle Fill Color:  ", footprint.fillColor);
            this.controls.add(this.fc.getControls());
            this.lc = new ColorConfigurer(null, "Line Color:  ", footprint.lineColor);
            this.controls.add(this.lc.getControls());
            this.lw = new DoubleConfigurer(null, "Line thickness:  ", new Double(footprint.lineWidth));
            this.controls.add(this.lw.getControls());
            this.st = new IntConfigurer(null, "Selected Unit Trail Transparency (0-100):  ", new Integer(footprint.selectedTransparency));
            this.controls.add(this.st.getControls());
            this.ut = new IntConfigurer(null, "Unselected Unit Trail Transparency (0-100):  ", new Integer(footprint.unSelectedTransparency));
            this.controls.add(this.ut.getControls());
            Box box = Box.createHorizontalBox();
            this.pb = new IntConfigurer(null, "Display Trail Points Off-map for ", new Integer(footprint.edgePointBuffer));
            box.add(this.pb.getControls());
            box.add(new JLabel("pixels"));
            this.controls.add(box);
            box = Box.createHorizontalBox();
            this.db = new IntConfigurer(null, "Display Trails Off-map for  ", new Integer(footprint.edgeDisplayBuffer));
            box.add(this.db.getControls());
            box.add(new JLabel("pixels"));
            this.controls.add(box);
        }

        public String getState() {
            return String.valueOf(this.gv.booleanValue());
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(Footprint.ID).append((KeyStroke)this.trailKeyInput.getValue()).append(this.mc.getValueString()).append(this.iv.getValueString()).append(this.gv.getValueString()).append(this.cr.getValueString()).append(this.fc.getValueString()).append(this.lc.getValueString()).append(this.st.getValueString()).append(this.ut.getValueString()).append(this.pb.getValueString()).append(this.db.getValueString()).append(this.lw.getValueString());
            return sequenceEncoder.getValue();
        }

        public Component getControls() {
            return this.controls;
        }
    }
}

