/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.command.Command;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.counters.BoundsTracker;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.PieceCloner;
import VASSAL.i18n.Localization;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.TranslatablePiece;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public class KeyCommand
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private String name;
    protected String untranslatedName;
    protected String localizedMenuText;
    private KeyStroke stroke;
    private GamePiece target;
    private boolean global;
    private boolean enabled = true;
    protected TranslatablePiece i18nPiece;

    public KeyCommand(String string, KeyStroke keyStroke, GamePiece gamePiece) {
        this(string, keyStroke, gamePiece, null);
    }

    public KeyCommand(String string, KeyStroke keyStroke, GamePiece gamePiece, TranslatablePiece translatablePiece) {
        super(keyStroke == null ? string : string + "  " + HotKeyConfigurer.getString(keyStroke));
        this.target = gamePiece;
        this.name = string;
        this.stroke = keyStroke;
        this.i18nPiece = translatablePiece;
    }

    public KeyCommand(String string, KeyStroke keyStroke, GamePiece gamePiece, boolean bl) {
        this(string, keyStroke, gamePiece, null);
        this.setEnabled(bl);
    }

    public KeyCommand(KeyCommand keyCommand) {
        this(keyCommand.name, keyCommand.stroke, keyCommand.target, keyCommand.isEnabled());
        this.i18nPiece = keyCommand.i18nPiece;
    }

    public String getName() {
        return this.name;
    }

    public boolean matches(KeyStroke keyStroke) {
        return this.isEnabled() && keyStroke != null && keyStroke.equals(this.stroke);
    }

    public KeyStroke getKeyStroke() {
        return this.stroke;
    }

    public GamePiece getTarget() {
        return this.target;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean bl) {
        this.global = bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.stroke != null) {
            if (this.global) {
                GameModule.getGameModule().sendAndLog(KeyBuffer.getBuffer().keyCommand(this.stroke));
            } else {
                BoundsTracker boundsTracker = new BoundsTracker();
                GamePiece gamePiece = Decorator.getOutermost(this.target);
                boundsTracker.addPiece(gamePiece);
                gamePiece.setProperty("snapshot", PieceCloner.getInstance().clonePiece(gamePiece));
                Command command = gamePiece.keyEvent(this.stroke);
                if (this.target.getId() != null) {
                    GameModule.getGameModule().sendAndLog(command);
                }
                boundsTracker.addPiece(gamePiece);
                boundsTracker.repaint();
            }
        }
    }

    public String getLocalizedMenuText() {
        if (this.localizedMenuText == null && this.name != null) {
            String string = this.name;
            if (this.i18nPiece != null && GameModule.getGameModule().isLocalizationEnabled()) {
                String string2 = null;
                for (PieceI18nData.Property property : this.i18nPiece.getI18nData().getProperties()) {
                    if (!property.getName().equals(this.name)) continue;
                    string2 = "Piece." + property.getName();
                }
                if (string2 != null) {
                    string = Localization.getInstance().translate(string2, this.name);
                }
            }
            this.localizedMenuText = this.stroke == null ? string : string + "  " + HotKeyConfigurer.getString(this.stroke);
        }
        return this.localizedMenuText;
    }
}

