/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceFilter;
import VASSAL.tools.IterableEnumeration;
import java.util.Enumeration;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PieceIterator {
    private Iterator<? extends GamePiece> pi;
    private PieceFilter filter;

    public PieceIterator(Iterator<? extends GamePiece> iterator) {
        this.pi = iterator;
    }

    @Deprecated
    public <T extends GamePiece> PieceIterator(Enumeration<T> enumeration) {
        this(new IterableEnumeration<T>(enumeration));
    }

    public PieceIterator(final Iterator<? extends GamePiece> iterator, PieceFilter pieceFilter) {
        this.filter = pieceFilter;
        this.pi = new Iterator<GamePiece>(){
            private GamePiece next;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                while (iterator.hasNext()) {
                    this.next = (GamePiece)iterator.next();
                    if (PieceIterator.this.filter != null && !PieceIterator.this.filter.accept(this.next)) continue;
                    return true;
                }
                this.next = null;
                return false;
            }

            @Override
            public GamePiece next() {
                if (this.next != null) {
                    GamePiece gamePiece = this.next;
                    this.next = null;
                    return gamePiece;
                }
                while (true) {
                    if (PieceIterator.this.filter == null || PieceIterator.this.filter.accept(this.next)) {
                        GamePiece gamePiece = this.next;
                        this.next = null;
                        return gamePiece;
                    }
                    this.next = (GamePiece)iterator.next();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Deprecated
    public <T extends GamePiece> PieceIterator(Enumeration<T> enumeration, PieceFilter pieceFilter) {
        this(new IterableEnumeration<T>(enumeration), pieceFilter);
    }

    public GamePiece nextPiece() {
        return this.pi.hasNext() ? this.pi.next() : null;
    }

    public boolean hasMoreElements() {
        return this.pi.hasNext();
    }

    public static <T extends GamePiece> PieceIterator visible(Iterator<T> iterator) {
        return new PieceIterator(iterator, new PieceFilter(){

            public boolean accept(GamePiece gamePiece) {
                return !Boolean.TRUE.equals(gamePiece.getProperty("Invisible"));
            }
        });
    }

    @Deprecated
    public static <T extends GamePiece> PieceIterator visible(Enumeration<T> enumeration) {
        return PieceIterator.visible(new IterableEnumeration<T>(enumeration));
    }
}

