/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.DrawPile;
import VASSAL.command.Command;
import VASSAL.configure.ChooseComponentDialog;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.UniqueIdManager;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class ReturnToDeck
extends Decorator
implements TranslatablePiece {
    public static final String ID = "return;";
    protected String deckId;
    protected String returnCommand;
    protected String selectDeckPrompt = "Select destination";
    protected KeyStroke returnKey;
    protected DrawPile deck;
    protected KeyCommand[] commands;
    protected KeyCommand myCommand;

    public ReturnToDeck() {
        this("return;Return to Deck;R;", null);
    }

    public ReturnToDeck(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    protected KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            this.myCommand = new KeyCommand(this.returnCommand, this.returnKey, Decorator.getOutermost(this), this);
            this.commands = this.returnCommand.length() > 0 && this.returnKey != null ? new KeyCommand[]{this.myCommand} : new KeyCommand[0];
        }
        return this.commands;
    }

    public String myGetState() {
        return "";
    }

    public void mySetType(String string) {
        string = string.substring(ID.length());
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        this.returnCommand = decoder.nextToken();
        this.returnKey = decoder.nextKeyStroke(null);
        this.deckId = decoder.nextToken("");
        this.selectDeckPrompt = decoder.nextToken(this.selectDeckPrompt);
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        return ID + sequenceEncoder.append(this.returnCommand).append(this.returnKey).append(this.deckId).append(this.selectDeckPrompt).getValue();
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        this.myGetKeyCommands();
        Command command = null;
        if (this.myCommand.matches(keyStroke)) {
            DrawPile drawPile = this.deck;
            if (drawPile == null || this.deckId.length() == 0) {
                drawPile = this.findDeck();
            }
            if (drawPile == null) {
                return null;
            }
            Map map = this.getMap();
            Point point = this.getPosition();
            command = drawPile.addToContents(Decorator.getOutermost(this));
            Map map2 = drawPile.getMap();
            if (!(map2 == null || map2.getMoveKey() == null || map2 == map && this.getPosition().equals(point))) {
                command.append(Decorator.getOutermost(this).keyEvent(map2.getMoveKey()));
            }
            drawPile.getMap().repaint();
        }
        return command;
    }

    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
    }

    public String getName() {
        return this.piece.getName();
    }

    public Shape getShape() {
        return this.piece.getShape();
    }

    private DrawPile findDeck() {
        DrawPile drawPile = null;
        if (this.deckId.length() > 0) {
            drawPile = DrawPile.findDrawPile(this.deckId);
        }
        if (drawPile == null) {
            return this.promptForDrawPile();
        }
        this.deck = drawPile;
        return drawPile;
    }

    private DrawPile promptForDrawPile() {
        final JDialog jDialog = new JDialog((Frame)GameModule.getGameModule().getFrame(), true);
        jDialog.setTitle(Decorator.getInnermost(this).getName());
        jDialog.setLayout(new BoxLayout(jDialog.getContentPane(), 1));
        List<DrawPile> list = GameModule.getGameModule().getAllDescendantComponentsOf(DrawPile.class);
        if (list.size() == 0) {
            throw new IllegalStateException("No decks in module.");
        }
        class AvailableDeck {
            private DrawPile pile;

            public AvailableDeck(DrawPile drawPile) {
                this.pile = drawPile;
            }

            public String toString() {
                return this.pile.getConfigureName();
            }
        }
        AvailableDeck[] availableDeckArray = new AvailableDeck[list.size()];
        int n = 0;
        for (DrawPile object2 : list) {
            availableDeckArray[n++] = new AvailableDeck(object2);
        }
        final JList<AvailableDeck> jList = new JList<AvailableDeck>(availableDeckArray);
        jList.setSelectionMode(0);
        JLabel jLabel = new JLabel(this.selectDeckPrompt);
        jLabel.setAlignmentX(0.5f);
        jDialog.add(jLabel);
        jDialog.add(new ScrollPane(jList));
        Box box = Box.createHorizontalBox();
        box.setAlignmentX(0.5f);
        JButton jButton = new JButton(Resources.getString("General.ok"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AvailableDeck availableDeck = (AvailableDeck)jList.getSelectedValue();
                if (availableDeck != null) {
                    ReturnToDeck.this.deck = availableDeck.pile;
                }
                jDialog.dispose();
            }
        });
        box.add(jButton);
        jButton = new JButton(Resources.getString("General.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        box.add(jButton);
        jDialog.add(box);
        jDialog.pack();
        jDialog.setLocationRelativeTo(jDialog.getOwner());
        jDialog.setVisible(true);
        DrawPile drawPile = this.deck;
        this.deck = null;
        return drawPile;
    }

    public void mySetState(String string) {
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public String getDescription() {
        String string = "Return to Deck";
        if (this.deck != null) {
            this.findDeck();
            if (this.deck != null) {
                string = string + " - " + this.deck.getConfigureName();
            }
        }
        return string;
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ReturnToDeck.htm");
    }

    public PieceI18nData getI18nData() {
        return this.getI18nData(this.returnCommand, "Return to Deck command");
    }

    private static class Ed
    implements PieceEditor {
        private StringConfigurer menuName;
        private HotKeyConfigurer menuKey;
        private JPanel controls;
        private String deckId;
        private final JTextField tf = new JTextField(12);
        private StringConfigurer promptText;
        private JCheckBox prompt;

        public Ed(ReturnToDeck returnToDeck) {
            this.controls = new JPanel();
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            this.menuName = new StringConfigurer(null, "Menu Text:  ", returnToDeck.returnCommand);
            this.controls.add(this.menuName.getControls());
            this.menuKey = new HotKeyConfigurer(null, "Keyboard Command:  ", returnToDeck.returnKey);
            this.deckId = returnToDeck.deckId;
            this.controls.add(this.menuKey.getControls());
            JButton jButton = new JButton("Select Deck");
            this.tf.setEditable(false);
            this.updateDeckName();
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ChooseComponentDialog chooseComponentDialog = new ChooseComponentDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, Ed.this.controls), DrawPile.class);
                    chooseComponentDialog.setTitle("Select Deck");
                    chooseComponentDialog.setVisible(true);
                    if (chooseComponentDialog.getTarget() != null) {
                        Ed.this.deckId = UniqueIdManager.getIdentifier((UniqueIdManager.Identifyable)((Object)chooseComponentDialog.getTarget()));
                        Ed.this.updateDeckName();
                    }
                }
            });
            final Box box = Box.createHorizontalBox();
            box.add(jButton);
            box.add(this.tf);
            this.controls.add(box);
            this.promptText = new StringConfigurer(null, "Prompt for destination deck:  ", returnToDeck.selectDeckPrompt);
            this.prompt = new JCheckBox("Choose destination deck at game time");
            this.controls.add(this.prompt);
            this.controls.add(this.promptText.getControls());
            this.promptText.getControls().setVisible(returnToDeck.deckId == null || returnToDeck.deckId.length() == 0);
            box.setVisible(returnToDeck.deckId != null && returnToDeck.deckId.length() > 0);
            this.prompt.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    box.setVisible(!Ed.this.prompt.isSelected());
                    Ed.this.promptText.getControls().setVisible(Ed.this.prompt.isSelected());
                }
            });
            this.prompt.setSelected(returnToDeck.deckId == null || returnToDeck.deckId.length() == 0);
        }

        private void updateDeckName() {
            DrawPile drawPile = DrawPile.findDrawPile(this.deckId);
            this.tf.setText(drawPile != null ? drawPile.getConfigureName() : "<none>");
        }

        public Component getControls() {
            return this.controls;
        }

        public String getState() {
            return "";
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            return ReturnToDeck.ID + sequenceEncoder.append(this.menuName.getValueString()).append((KeyStroke)this.menuKey.getValue()).append(this.prompt.isSelected() ? "" : this.deckId).append(this.promptText.getValueString()).getValue();
        }
    }
}

