/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.i18n;

import VASSAL.build.GameModule;
import VASSAL.configure.SingleChildInstance;
import VASSAL.i18n.Language;
import VASSAL.i18n.Resources;
import VASSAL.i18n.Translatable;
import VASSAL.i18n.TranslatableAttribute;
import VASSAL.i18n.Translation;
import VASSAL.i18n.VassalResourceBundle;
import VASSAL.tools.logging.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;

public class Localization
extends Language {
    private static Localization instance;
    protected String moduleBundle;
    protected String languageBundle;
    protected String countryBundle;
    protected List<Translation> moduleTranslations = new ArrayList<Translation>();
    protected List<Translation> languageTranslations = new ArrayList<Translation>();
    protected List<Translation> countryTranslations = new ArrayList<Translation>();
    protected List<Translation> translations = new ArrayList<Translation>();
    protected VassalResourceBundle masterBundle;
    protected Set<TranslatableAttribute> translatableItems = new HashSet<TranslatableAttribute>();
    protected boolean translationInProgress = false;
    protected boolean translationComplete = false;

    private Localization() {
        this.moduleBundle = Resources.MODULE_BUNDLE;
        this.languageBundle = this.moduleBundle + "_" + Resources.getLocale().getLanguage();
        this.countryBundle = this.languageBundle + "_" + Resources.getLocale().getCountry();
        this.moduleBundle = this.moduleBundle + ".properties";
        this.languageBundle = this.languageBundle + ".properties";
        this.countryBundle = this.countryBundle + ".properties";
        this.validator = new SingleChildInstance(GameModule.getGameModule(), this.getClass());
    }

    public static Localization getInstance() {
        if (instance == null) {
            instance = new Localization();
        }
        return instance;
    }

    public String[] getTranslationList() {
        Collections.sort(this.translations);
        String[] stringArray = new String[this.translations.size()];
        int n = 0;
        for (Translation translation : this.translations) {
            stringArray[n++] = translation.getDescription();
        }
        return stringArray;
    }

    public Translation getTranslation(String string) {
        for (Translation translation : this.translations) {
            if (!translation.getDescription().equals(string)) continue;
            return translation;
        }
        return null;
    }

    public void saveTranslatableAttribute(Translatable translatable, String string, String string2) {
        if (GameModule.getGameModule().isLocalizationEnabled()) {
            TranslatableAttribute translatableAttribute = new TranslatableAttribute(translatable, string, string2);
            this.translatableItems.add(translatableAttribute);
        }
    }

    public void translate() throws IOException {
        if (GameModule.getGameModule().isLocalizationEnabled()) {
            for (Translation object : this.moduleTranslations) {
                this.addBundle(object.getBundle());
            }
            for (Translation translation : this.languageTranslations) {
                this.addBundle(translation.getBundle());
            }
            for (Translation translation : this.countryTranslations) {
                this.addBundle(translation.getBundle());
            }
            if (this.masterBundle != null) {
                this.translationInProgress = true;
                for (TranslatableAttribute translatableAttribute : this.translatableItems) {
                    if (!translatableAttribute.isTranslatable()) continue;
                    String string = translatableAttribute.getKey();
                    try {
                        String string2 = this.masterBundle.getString(string);
                        translatableAttribute.applyTranslation(string2);
                    }
                    catch (MissingResourceException missingResourceException) {}
                }
                this.translationInProgress = false;
                this.translationComplete = true;
                Logger.log("-- Translated");
            }
            this.translatableItems.clear();
            GameModule.getGameModule().initFrameTitle();
        }
    }

    public String translate(String string, String string2) {
        try {
            return this.masterBundle == null ? string2 : this.masterBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
    }

    protected void addBundle(VassalResourceBundle vassalResourceBundle) {
        if (this.masterBundle == null) {
            this.masterBundle = vassalResourceBundle;
        } else {
            vassalResourceBundle.setParent(this.masterBundle);
            this.masterBundle = vassalResourceBundle;
        }
    }

    public boolean isTranslationInProgress() {
        return this.translationInProgress;
    }

    public boolean isTranslationComplete() {
        return this.translationComplete;
    }

    public void addTranslation(Translation translation) {
        if (GameModule.getGameModule().isLocalizationEnabled()) {
            Resources.addSupportedLocale(translation.getLocale());
            if (this.moduleBundle.equals(translation.getBundleFileName())) {
                this.moduleTranslations.add(translation);
            } else if (this.languageBundle.equals(translation.getBundleFileName())) {
                this.languageTranslations.add(translation);
            } else if (this.countryBundle.equals(translation.getBundleFileName())) {
                this.countryTranslations.add(translation);
            }
        } else {
            this.translations.add(translation);
        }
    }

    public void removeTranslation(Translation translation) {
        this.translations.remove(translation);
    }
}

