/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.build.module.Documentation;
import VASSAL.i18n.Resources;
import VASSAL.launch.AboutVASSALAction;
import VASSAL.launch.ShowInBrowserAction;
import VASSAL.launch.ShutDownAction;
import VASSAL.tools.ApplicationIcons;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.WrapLayout;
import VASSAL.tools.menu.MenuBarProxy;
import VASSAL.tools.menu.MenuManager;
import VASSAL.tools.menu.MenuProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class PlayerWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    protected final JToolBar toolBar = new JToolBar();
    protected final JPanel controlPanel = new JPanel();

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public JPanel getControlPanel() {
        return this.controlPanel;
    }

    public PlayerWindow() {
        this.setTitle("VASSAL");
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(3);
        ApplicationIcons.setFor(this);
        MenuManager menuManager = MenuManager.getInstance();
        MenuBarProxy menuBarProxy = menuManager.getMenuBarProxyFor(this);
        MenuProxy menuProxy = new MenuProxy(Resources.getString("General.file"));
        menuProxy.setMnemonic(Resources.getString("General.file.shortcut").charAt(0));
        menuProxy.add(menuManager.addMarker("PredefinedSetup.start"));
        menuProxy.add(menuManager.addMarker("PredefinedSetup.end"));
        menuProxy.add(menuManager.addKey("GameState.new_game"));
        menuProxy.add(menuManager.addKey("GameState.load_game"));
        menuProxy.add(menuManager.addKey("GameState.save_game"));
        menuProxy.add(menuManager.addKey("GameState.close_game"));
        menuProxy.addSeparator();
        menuProxy.add(menuManager.addKey("BasicLogger.begin_logfile"));
        menuProxy.add(menuManager.addKey("BasicLogger.end_logfile"));
        if (Info.isMacOSX()) {
            menuProxy.add(menuManager.addMarker("Editor.File.start"));
            menuProxy.add(menuManager.addMarker("Editor.File.end"));
        } else {
            menuProxy.addSeparator();
            menuProxy.add(menuManager.addKey("Prefs.edit_preferences"));
            menuProxy.addSeparator();
            menuProxy.add(menuManager.addKey("General.quit"));
        }
        menuManager.addAction("General.quit", new ShutDownAction());
        MenuProxy menuProxy2 = new MenuProxy(Resources.getString("General.help"));
        menuProxy2.setMnemonic(Resources.getString("General.help.shortcut").charAt(0));
        menuProxy2.add(menuManager.addMarker("Documentation.VASSAL.start"));
        menuProxy2.add(menuManager.addKey("General.help"));
        menuProxy2.add(menuManager.addKey("Help.user_guide"));
        menuProxy2.add(menuManager.addMarker("Documentation.VASSAL.end"));
        menuProxy2.addSeparator();
        menuProxy2.add(menuManager.addMarker("Documentation.Module.start"));
        menuProxy2.add(menuManager.addMarker("Documentation.Module.end"));
        menuProxy2.add(menuManager.addKey("Documentation.about_module"));
        if (!Info.isMacOSX()) {
            menuProxy2.add(menuManager.addKey("AboutScreen.about_vassal"));
        }
        File file = Documentation.getDocumentationBaseDir();
        try {
            menuManager.addAction("General.help", new ShowInBrowserAction(Resources.getString("General.help"), file, "README.html", null));
        }
        catch (MalformedURLException malformedURLException) {
            ErrorDialog.bug(malformedURLException);
        }
        try {
            menuManager.addAction("Help.user_guide", new ShowInBrowserAction(Resources.getString("Help.user_guide"), file, "userguide/userguide.pdf", null));
        }
        catch (MalformedURLException malformedURLException) {
            ErrorDialog.bug(malformedURLException);
        }
        menuManager.addAction("AboutScreen.about_vassal", new AboutVASSALAction(this));
        menuBarProxy.add(menuProxy);
        menuBarProxy.add(menuManager.addMarker("Editor.MenuBar.start"));
        menuBarProxy.add(menuManager.addMarker("Editor.MenuBar.end"));
        menuBarProxy.add(menuProxy2);
        this.setJMenuBar(menuManager.getMenuBarFor(this));
        this.toolBar.setLayout(new WrapLayout(0, 0, 0));
        this.toolBar.setAlignmentX(0.0f);
        this.toolBar.setFloatable(false);
        this.add((Component)this.toolBar, "North");
        this.controlPanel.setLayout(new BorderLayout());
        this.controlPanel.setPreferredSize(new Dimension(800, 600));
        this.add((Component)this.controlPanel, "Center");
        this.pack();
    }
}

