/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.preferences;

import VASSAL.configure.Configurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.Prefs;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.SplashScreen;
import VASSAL.tools.WriteErrorDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;

public class PrefsEditor {
    private JDialog dialog;
    private List<Configurer> options = new ArrayList<Configurer>();
    private List<Configurer> extras = new ArrayList<Configurer>();
    private boolean iterating = false;
    private Map<Configurer, Object> savedValues = new HashMap<Configurer, Object>();
    private List<Prefs> prefs;
    private JTabbedPane optionsTab;
    private JDialog setupDialog;
    private ArchiveWriter archive;
    private Action editAction;

    public PrefsEditor(ArchiveWriter archiveWriter) {
        this.archive = archiveWriter;
        this.prefs = new ArrayList<Prefs>();
        this.optionsTab = new JTabbedPane();
    }

    public void initDialog(Frame frame) {
        if (this.dialog == null) {
            this.dialog = new JDialog(frame, true);
            this.dialog.setTitle(Resources.getString("Prefs.preferences"));
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    PrefsEditor.this.cancel();
                }
            });
            JButton jButton = new JButton(Resources.getString("General.ok"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PrefsEditor.this.save();
                }
            });
            JButton jButton2 = new JButton(Resources.getString("General.cancel"));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PrefsEditor.this.cancel();
                }
            });
            this.dialog.setLayout((LayoutManager)new MigLayout("insets dialog"));
            this.dialog.add((Component)this.optionsTab, "push, grow, wrap unrelated");
            this.dialog.add((Component)jButton, "tag ok, split");
            this.dialog.add((Component)jButton2, "tag cancel");
        }
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void addPrefs(Prefs prefs) {
        this.prefs.add(prefs);
    }

    public void addOption(String string, Configurer configurer, String string2) {
        if (string2 != null) {
            if (this.setupDialog == null) {
                this.setupDialog = new JDialog((Frame)null, true);
                this.setupDialog.setTitle(Resources.getString("Prefs.initial_setup"));
                this.setupDialog.setLayout(new BoxLayout(this.setupDialog.getContentPane(), 1));
                this.setupDialog.setDefaultCloseOperation(0);
                this.setupDialog.addComponentListener(new ComponentAdapter(){

                    public void componentShown(ComponentEvent componentEvent) {
                        SplashScreen.sendAllToBack();
                    }
                });
            }
            JPanel jPanel = new JPanel();
            jPanel.add(new JLabel(string2));
            this.setupDialog.add(jPanel);
            this.setupDialog.add(configurer.getControls());
            JButton jButton = new JButton(Resources.getString("General.ok"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PrefsEditor.this.setupDialog.setVisible(false);
                }
            });
            jPanel = new JPanel();
            jPanel.add(jButton);
            this.setupDialog.add(jPanel);
            this.setupDialog.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setupDialog.setLocation(dimension.width / 2 - this.setupDialog.getSize().width / 2, dimension.height / 2 - this.setupDialog.getSize().height / 2);
            this.setupDialog.setVisible(true);
            this.setupDialog.removeAll();
        }
        this.addOption(string, configurer);
    }

    public synchronized void addOption(String string, Configurer configurer) {
        if (string == null) {
            string = Resources.getString("Prefs.general_tab");
        }
        JPanel jPanel = null;
        int n = 0;
        for (n = 0; n < this.optionsTab.getTabCount(); ++n) {
            if (!string.equals(this.optionsTab.getTitleAt(n))) continue;
            jPanel = (JPanel)this.optionsTab.getComponentAt(n);
            break;
        }
        if (n >= this.optionsTab.getTabCount()) {
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            this.optionsTab.addTab(string, jPanel);
        }
        if (this.iterating) {
            this.extras.add(configurer);
        } else {
            this.options.add(configurer);
        }
        Box box = Box.createHorizontalBox();
        box.add(configurer.getControls());
        box.add(Box.createHorizontalGlue());
        jPanel.add(box);
    }

    private synchronized void storeValues() {
        this.savedValues.clear();
        for (Configurer configurer : this.options) {
            configurer.setFrozen(true);
            if (configurer.getValue() == null) continue;
            this.savedValues.put(configurer, configurer.getValue());
        }
    }

    public ArchiveWriter getArchive() {
        return this.archive;
    }

    protected synchronized void cancel() {
        for (Configurer configurer : this.options) {
            configurer.setValue(this.savedValues.get(configurer));
            configurer.setFrozen(false);
        }
        this.dialog.setVisible(false);
    }

    protected synchronized void save() {
        this.iterating = true;
        for (Configurer configurer : this.options) {
            if (this.savedValues.get(configurer) == null && configurer.getValue() != null || this.savedValues.get(configurer) != null && !this.savedValues.get(configurer).equals(configurer.getValue())) {
                configurer.fireUpdate();
            }
            configurer.setFrozen(false);
        }
        this.iterating = false;
        this.options.addAll(this.extras);
        this.extras.clear();
        try {
            this.write();
        }
        catch (IOException iOException) {
            WriteErrorDialog.error(iOException, this.archive.getName());
        }
        this.dialog.setVisible(false);
    }

    public Action getEditAction() {
        if (this.editAction == null) {
            this.editAction = new AbstractAction(Resources.getString("Prefs.edit_preferences")){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    PrefsEditor.this.storeValues();
                    PrefsEditor.this.dialog.pack();
                    Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                    PrefsEditor.this.dialog.setLocation(dimension.width / 2 - PrefsEditor.this.dialog.getWidth() / 2, 0);
                    PrefsEditor.this.dialog.setVisible(true);
                }
            };
            this.editAction.putValue("MnemonicKey", Resources.getString("Prefs.edit_preferences").charAt(0));
        }
        return this.editAction;
    }

    public void write() throws IOException {
        for (Prefs prefs : this.prefs) {
            prefs.save();
        }
        this.archive.write();
    }

    public void close() throws IOException {
        this.archive.close();
    }
}

