/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.preferences;

import VASSAL.Info;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.io.IOUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ReadOnlyPrefs {
    protected Properties storedValues = new Properties();
    protected String name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ReadOnlyPrefs(String string) {
        this.name = string;
        File file = new File(Info.getHomeDir(), "Preferences");
        ZipFile zipFile = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry == null) {
                throw new FileNotFoundException(string + " does not exist");
            }
            bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            this.storedValues.load(bufferedInputStream);
            bufferedInputStream.close();
            zipFile.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            IOUtils.closeQuietly(bufferedInputStream);
            IOUtils.closeQuietly(zipFile);
        }
        catch (IOException iOException) {
            ReadErrorDialog.error(iOException, file.getPath() + "/!" + string);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(bufferedInputStream);
                    IOUtils.closeQuietly(zipFile);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(bufferedInputStream);
            IOUtils.closeQuietly(zipFile);
        }
        IOUtils.closeQuietly(bufferedInputStream);
        IOUtils.closeQuietly(zipFile);
    }

    public String getStoredValue(String string) {
        return this.storedValues.getProperty(string);
    }

    public static ReadOnlyPrefs getGlobalPrefs() {
        return new ReadOnlyPrefs("VASSAL");
    }
}

