/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentSoftHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<K, SoftValue<K, V>> map = new ConcurrentHashMap<K, SoftValue<K, V>>();
    private final ReferenceQueue<V> queue = new ReferenceQueue();
    private Set<Map.Entry<K, V>> entrySet;

    private void processQueue() {
        SoftValue softValue;
        while ((softValue = (SoftValue)this.queue.poll()) != null) {
            this.map.remove(softValue.key, softValue);
        }
    }

    @Override
    public int size() {
        this.processQueue();
        return this.map.size();
    }

    @Override
    public boolean containsKey(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.processQueue();
        return this.map.containsKey(object);
    }

    @Override
    public V get(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        SoftValue softValue = (SoftValue)this.map.get(object);
        if (softValue != null) {
            Object t = softValue.get();
            if (t == null) {
                this.map.remove(object, softValue);
            }
            return (V)t;
        }
        return null;
    }

    @Override
    public V put(K k, V v) {
        if (k == null) {
            throw new NullPointerException();
        }
        if (v == null) {
            throw new NullPointerException();
        }
        this.processQueue();
        SoftValue softValue = this.map.put(k, new SoftValue(k, v, this.queue));
        return softValue == null ? null : (V)softValue.get();
    }

    @Override
    public V remove(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.processQueue();
        SoftValue softValue = (SoftValue)this.map.remove(object);
        return softValue == null ? null : (V)softValue.get();
    }

    @Override
    public void clear() {
        this.map.clear();
        while (this.queue.poll() != null) {
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.processQueue();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        private final Iterator<Map.Entry<K, SoftValue<K, V>>> i;
                        {
                            this.i = ConcurrentSoftHashMap.this.map.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            Map.Entry entry = this.i.next();
                            return new SimpleEntry(entry.getKey(), entry.getValue().get());
                        }

                        @Override
                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return ConcurrentSoftHashMap.this.size();
                }

                @Override
                public boolean contains(Object object) {
                    return ConcurrentSoftHashMap.this.containsValue(object);
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public V putIfAbsent(K k, V v) {
        if (k == null) {
            throw new NullPointerException();
        }
        if (v == null) {
            throw new NullPointerException();
        }
        this.processQueue();
        SoftValue softValue = this.map.putIfAbsent(k, new SoftValue(k, v, this.queue));
        return softValue == null ? null : (V)softValue.get();
    }

    @Override
    public boolean remove(Object object, Object object2) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object2 == null) {
            throw new NullPointerException();
        }
        this.processQueue();
        return this.map.remove(object, new SoftValue(object, object2, null));
    }

    @Override
    public boolean replace(K k, V v, V v2) {
        if (k == null) {
            throw new NullPointerException();
        }
        if (v == null) {
            throw new NullPointerException();
        }
        if (v2 == null) {
            throw new NullPointerException();
        }
        this.processQueue();
        return this.map.replace(k, new SoftValue(k, v, null), new SoftValue(k, v2, this.queue));
    }

    @Override
    public V replace(K k, V v) {
        if (k == null) {
            throw new NullPointerException();
        }
        if (v == null) {
            throw new NullPointerException();
        }
        this.processQueue();
        SoftValue softValue = this.map.replace(k, new SoftValue(k, v, this.queue));
        return softValue == null ? null : (V)softValue.get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        public SimpleEntry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        public SimpleEntry(Map.Entry<? extends K, ? extends V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return SimpleEntry.eq(this.key, entry.getKey()) && SimpleEntry.eq(this.value, entry.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private static boolean eq(Object object, Object object2) {
            return object == null ? object2 == null : object.equals(object2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SoftValue<K, V>
    extends SoftReference<V> {
        private final K key;

        private SoftValue(K k, V v, ReferenceQueue<V> referenceQueue) {
            super(v, referenceQueue);
            this.key = k;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || !(object instanceof SoftValue)) {
                return false;
            }
            SoftValue softValue = (SoftValue)object;
            return this.key.equals(softValue.key) && this.get() == null ? softValue.get() == null : this.get().equals(softValue.get());
        }

        public int hashCode() {
            return this.get() == null ? 0 : this.get().hashCode();
        }
    }
}

