/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.ErrorDialog;
import VASSAL.tools.io.IOUtils;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class Deobfuscator {
    private String plain;

    public Deobfuscator(InputStream inputStream) throws IOException {
        String string = null;
        try {
            string = IOUtils.toString(inputStream, "UTF-8");
            inputStream.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ErrorDialog.bug(unsupportedEncodingException);
            throw unsupportedEncodingException;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        int n = "!VCSK".length();
        if (string.startsWith("!VCSK") && string.length() > n + 1) {
            byte by = (byte)Integer.parseInt(string.substring(n, n + 2), 16);
            byte[] byArray = new byte[(string.length() - (n += 2)) / 2];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)(Integer.parseInt(string.substring(n++, ++n), 16) ^ by);
            }
            this.plain = new String(byArray, "UTF-8");
        } else {
            this.plain = string;
        }
    }

    public String getString() throws UnsupportedEncodingException {
        return this.plain;
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("Decoding " + stringArray[0]);
        Deobfuscator deobfuscator = new Deobfuscator(new FileInputStream(stringArray[0]));
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(stringArray[0]));
        bufferedWriter.write(deobfuscator.getString());
        bufferedWriter.close();
        System.out.println("Done!");
        System.exit(0);
    }
}

