/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameState;
import VASSAL.build.widget.PieceSlot;
import VASSAL.command.Command;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.Replace;
import VASSAL.counters.Stack;
import VASSAL.tools.ComponentPathBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SavedGameUpdater {
    public Properties getPieceSlotsMap() {
        Properties properties = new Properties();
        ArrayList<Configurable> arrayList = new ArrayList<Configurable>();
        this.findPieceSlots(arrayList, properties);
        return properties;
    }

    public void updateSavedGame(Properties properties, File file) throws IOException {
        GamePiece[] gamePieceArray;
        GameState gameState = GameModule.getGameModule().getGameState();
        gameState.setup(false, true);
        gameState.loadGameInBackground(file);
        while (!gameState.isGameStarted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        for (GamePiece gamePiece : gamePieceArray = gameState.getAllPieces().toArray(new GamePiece[0])) {
            if (gamePiece instanceof Stack) continue;
            String string = properties.getProperty(gamePiece.getType());
            if (string != null) {
                Configurable[] configurableArray = null;
                try {
                    PieceSlot pieceSlot;
                    configurableArray = ComponentPathBuilder.getInstance().getPath(string);
                    if (configurableArray == null || configurableArray.length <= 0 || !(configurableArray[configurableArray.length - 1] instanceof PieceSlot) || (pieceSlot = (PieceSlot)configurableArray[configurableArray.length - 1]).getPiece().getType().equals(gamePiece.getType())) continue;
                    if (!(gamePiece instanceof Decorator)) {
                        GameModule.getGameModule().getChatter().show("Unable to replace " + gamePiece.getName() + ": Basic piece only");
                        continue;
                    }
                    ReplaceTrait replaceTrait = new ReplaceTrait(gamePiece, pieceSlot.getPiece());
                    replaceTrait.replacePiece();
                }
                catch (ComponentPathBuilder.PathFormatException pathFormatException) {
                    GameModule.getGameModule().getChatter().show("Unable to replace " + gamePiece.getName() + ": " + pathFormatException.getMessage());
                }
                continue;
            }
            GameModule.getGameModule().getChatter().show("Unable to find slot for " + gamePiece.getName());
            GameModule.getGameModule().getChatter().show(gamePiece.getType());
        }
        gameState.saveGame(file);
        gameState.updateDone();
    }

    protected void findPieceSlots(List<Configurable> list, Properties properties) {
        GameModule gameModule;
        Configurable configurable = gameModule = list.size() == 0 ? GameModule.getGameModule() : list.get(list.size() - 1);
        if (gameModule instanceof PieceSlot) {
            PieceSlot pieceSlot = (PieceSlot)((Object)gameModule);
            GamePiece gamePiece = PieceCloner.getInstance().clonePiece(pieceSlot.getPiece());
            properties.setProperty(gamePiece.getType(), ComponentPathBuilder.getInstance().getId(list.toArray(new Configurable[list.size()])));
        } else if (gameModule instanceof Configurable) {
            Configurable configurable2 = gameModule;
            Configurable[] configurableArray = configurable2.getConfigureComponents();
            for (int i = 0; i < configurableArray.length; ++i) {
                list.add(configurableArray[i]);
                this.findPieceSlots(list, properties);
                list.remove(configurableArray[i]);
            }
        }
    }

    private static class ReplaceTrait
    extends Replace {
        private GamePiece replacement;

        public ReplaceTrait(GamePiece gamePiece, GamePiece gamePiece2) {
            super("replace;Replace;R;dummy;;0;0;true", gamePiece);
            this.setProperty("Outer", gamePiece);
            gamePiece.setProperty("Outer", null);
            this.replacement = gamePiece2;
        }

        public GamePiece createMarker() {
            GamePiece gamePiece = PieceCloner.getInstance().clonePiece(this.replacement);
            if (this.matchRotation) {
                this.matchTraits(this.getInner(), gamePiece);
            }
            return gamePiece;
        }

        public Command replacePiece() {
            return super.replacePiece();
        }
    }
}

