/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public final class GeneralFilter {
    private GeneralFilter() {
    }

    public static BufferedImage zoom(Rectangle rectangle, BufferedImage bufferedImage, Filter filter) {
        WritableRaster writableRaster = bufferedImage.getColorModel().createCompatibleWritableRaster(rectangle.width, rectangle.height);
        GeneralFilter.zoom(writableRaster, writableRaster.getBounds(), bufferedImage, filter);
        return new BufferedImage(bufferedImage.getColorModel(), writableRaster, bufferedImage.isAlphaPremultiplied(), null);
    }

    public static void zoom(WritableRaster writableRaster, Rectangle rectangle, BufferedImage bufferedImage, Filter filter) {
        int n = writableRaster.getMinX();
        int n2 = writableRaster.getMinY();
        int n3 = n + writableRaster.getWidth() - 1;
        int n4 = n2 + writableRaster.getHeight() - 1;
        int n5 = n3 - n + 1;
        int n6 = n4 - n2 + 1;
        int n7 = rectangle.width;
        int n8 = rectangle.height;
        int n9 = bufferedImage.getWidth();
        int n10 = bufferedImage.getHeight();
        float f = n9 == 1 ? (float)n7 : (float)(n7 - 1) / (float)(n9 - 1);
        float f2 = n10 == 1 ? (float)n8 : (float)(n8 - 1) / (float)(n10 - 1);
        float f3 = filter.getSamplingRadius();
        int n11 = Math.max(0, (int)Math.floor(((float)n - f3) / f));
        int n12 = Math.max(0, (int)Math.floor(((float)n2 - f3) / f2));
        int n13 = Math.min(n9 - 1, (int)Math.ceil(((float)n3 + f3) / f));
        int n14 = Math.min(n10 - 1, (int)Math.ceil(((float)n4 + f3) / f2));
        int n15 = n13 - n11 + 1;
        int n16 = n14 - n12 + 1;
        Raster raster = bufferedImage.getData(new Rectangle(n11, n12, n15, n16));
        int[] nArray = ((DataBufferInt)raster.getDataBuffer()).getData();
        int[] nArray2 = new int[n16];
        int[] nArray3 = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
        CList[] cListArray = GeneralFilter.calc_contrib(n6, f3, f2, n2, n12, n16, filter);
        CList[] cListArray2 = GeneralFilter.calc_contrib(n5, f3, f, n, n11, n15, filter);
        if (bufferedImage.getTransparency() == 1) {
            for (int i = 0; i < n5; ++i) {
                GeneralFilter.apply_horizontal_opaque(n16, cListArray2[i], nArray, n15, nArray2);
                GeneralFilter.apply_vertical_opaque(n6, cListArray, nArray2, nArray3, i, n5);
            }
        } else if (bufferedImage.isAlphaPremultiplied()) {
            for (int i = 0; i < n5; ++i) {
                GeneralFilter.apply_horizontal(n16, cListArray2[i], nArray, n15, nArray2);
                GeneralFilter.apply_vertical(n6, cListArray, nArray2, nArray3, i, n5);
            }
        } else {
            float f4;
            int n17;
            int n18;
            int n19;
            int[] nArray4 = new int[nArray.length];
            for (n19 = 0; n19 < nArray.length; ++n19) {
                n18 = nArray[n19];
                n17 = n18 >>> 24 & 0xFF;
                if (n17 == 255) {
                    nArray4[n19] = n18;
                    continue;
                }
                f4 = (float)n17 / 255.0f;
                nArray4[n19] = n17 << 24 | (int)((float)(n18 >>> 16 & 0xFF) * f4 + 0.5f) << 16 | (int)((float)(n18 >>> 8 & 0xFF) * f4 + 0.5f) << 8 | (int)((float)(n18 & 0xFF) * f4 + 0.5f);
            }
            for (n19 = 0; n19 < n5; ++n19) {
                GeneralFilter.apply_horizontal(n16, cListArray2[n19], nArray4, n15, nArray2);
                GeneralFilter.apply_vertical(n6, cListArray, nArray2, nArray3, n19, n5);
            }
            for (n19 = 0; n19 < nArray3.length; ++n19) {
                n18 = nArray3[n19];
                n17 = n18 >>> 24 & 0xFF;
                if (n17 == 255) continue;
                f4 = 255.0f / (float)n17;
                nArray3[n19] = n17 << 24 | (int)((float)(n18 >>> 16 & 0xFF) * f4 + 0.5f) << 16 | (int)((float)(n18 >>> 8 & 0xFF) * f4 + 0.5f) << 8 | (int)((float)(n18 & 0xFF) * f4 + 0.5f);
            }
        }
    }

    private static CList[] calc_contrib(int n, float f, float f2, int n2, int n3, int n4, Filter filter) {
        CList[] cListArray = new CList[n];
        for (int i = 0; i < cListArray.length; ++i) {
            cListArray[i] = new CList();
        }
        float f3 = 1.0f / (1.0f * Math.max(1.0f / f2, 1.0f));
        float f4 = f / f3;
        for (int i = 0; i < n; ++i) {
            int n5;
            int n6;
            float f5 = ((float)(i + n2) + 0.5f) / f2;
            int n7 = (int)Math.max(f5 - f4 + 0.5f, (float)n3);
            int n8 = (int)Math.min(f5 + f4 + 0.5f, (float)(n3 + n4));
            cListArray[i].n = n6 = n8 - n7;
            cListArray[i].pixel = n7 - n3;
            cListArray[i].weight = new float[n6];
            float f6 = 0.0f;
            for (n5 = 0; n5 < n6; ++n5) {
                cListArray[i].weight[n5] = filter.apply(f3 * ((float)(n7 + n5) - f5 + 0.5f));
                f6 += cListArray[i].weight[n5];
            }
            if (f6 == 0.0f || f6 == 1.0f) continue;
            n5 = 0;
            while (n5 < n6) {
                int n9 = n5++;
                cListArray[i].weight[n9] = cListArray[i].weight[n9] / f6;
            }
        }
        return cListArray;
    }

    private static void apply_horizontal(int n, CList cList, int[] nArray, int n2, int[] nArray2) {
        for (int i = 0; i < n; ++i) {
            int n3;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            CList cList2 = cList;
            int n4 = cList2.n;
            int n5 = nArray[cList2.pixel + i * n2];
            boolean bl = false;
            for (n3 = 0; n3 < n4; ++n3) {
                if (cList2.weight[n3] == 0.0f || nArray[cList2.pixel + n3 + i * n2] == n5) continue;
                bl = true;
                break;
            }
            if (bl) {
                for (n3 = 0; n3 < n4; ++n3) {
                    float f5 = cList2.weight[n3];
                    int n6 = nArray[cList2.pixel + n3 + i * n2];
                    f += (float)(n6 >>> 24 & 0xFF) * f5;
                    f2 += (float)(n6 >>> 16 & 0xFF) * f5;
                    f3 += (float)(n6 >>> 8 & 0xFF) * f5;
                    f4 += (float)(n6 & 0xFF) * f5;
                }
                nArray2[i] = (f > 255.0f ? 255 : (f < 0.0f ? 0 : (int)(f + 0.5f))) << 24 | (f2 > 255.0f ? 255 : (f2 < 0.0f ? 0 : (int)(f2 + 0.5f))) << 16 | (f3 > 255.0f ? 255 : (f3 < 0.0f ? 0 : (int)(f3 + 0.5f))) << 8 | (f4 > 255.0f ? 255 : (f4 < 0.0f ? 0 : (int)(f4 + 0.5f)));
                continue;
            }
            nArray2[i] = n5;
        }
    }

    private static void apply_horizontal_opaque(int n, CList cList, int[] nArray, int n2, int[] nArray2) {
        for (int i = 0; i < n; ++i) {
            int n3;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            CList cList2 = cList;
            int n4 = cList2.n;
            int n5 = nArray[cList2.pixel + i * n2];
            boolean bl = false;
            for (n3 = 0; n3 < n4; ++n3) {
                if (cList2.weight[n3] == 0.0f || nArray[cList2.pixel + n3 + i * n2] == n5) continue;
                bl = true;
                break;
            }
            if (bl) {
                for (n3 = 0; n3 < n4; ++n3) {
                    float f4 = cList2.weight[n3];
                    int n6 = nArray[cList2.pixel + n3 + i * n2];
                    f += (float)(n6 >>> 16 & 0xFF) * f4;
                    f2 += (float)(n6 >>> 8 & 0xFF) * f4;
                    f3 += (float)(n6 & 0xFF) * f4;
                }
                nArray2[i] = (f > 255.0f ? 255 : (f < 0.0f ? 0 : (int)(f + 0.5f))) << 16 | (f2 > 255.0f ? 255 : (f2 < 0.0f ? 0 : (int)(f2 + 0.5f))) << 8 | (f3 > 255.0f ? 255 : (f3 < 0.0f ? 0 : (int)(f3 + 0.5f)));
                continue;
            }
            nArray2[i] = n5;
        }
    }

    private static void apply_vertical(int n, CList[] cListArray, int[] nArray, int[] nArray2, int n2, int n3) {
        for (int i = 0; i < n; ++i) {
            int n4;
            int n5;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            CList cList = cListArray[i];
            int n6 = cList.n;
            int n7 = nArray[cList.pixel];
            boolean bl = false;
            for (n5 = 0; n5 < n6; ++n5) {
                if (cList.weight[n5] == 0.0f || nArray[cList.pixel + n5] == n7) continue;
                bl = true;
                break;
            }
            if (bl) {
                for (n5 = 0; n5 < n6; ++n5) {
                    float f5 = cList.weight[n5];
                    n4 = nArray[cList.pixel + n5];
                    f += (float)(n4 >>> 24 & 0xFF) * f5;
                    f2 += (float)(n4 >>> 16 & 0xFF) * f5;
                    f3 += (float)(n4 >>> 8 & 0xFF) * f5;
                    f4 += (float)(n4 & 0xFF) * f5;
                }
                int n8 = f > 255.0f ? 255 : (n5 = f < 0.0f ? 0 : (int)(f + 0.5f));
                nArray2[n2 + i * n3] = n5 << 24 | (f2 > (float)n5 ? n5 : (f2 < 0.0f ? 0 : (int)(f2 + 0.5f))) << 16 | (f3 > (float)n5 ? n5 : (f3 < 0.0f ? 0 : (int)(f3 + 0.5f))) << 8 | (f4 > (float)n5 ? n5 : (f4 < 0.0f ? 0 : (int)(f4 + 0.5f)));
                continue;
            }
            n5 = n7 >>> 24 & 0xFF;
            int n9 = n7 >>> 16 & 0xFF;
            n4 = n7 >>> 8 & 0xFF;
            int n10 = n7 & 0xFF;
            nArray2[n2 + i * n3] = n5 << 24 | (n9 > n5 ? n5 : n9) << 16 | (n4 > n5 ? n5 : n4) << 8 | (n10 > n5 ? n5 : n10);
        }
    }

    private static void apply_vertical_opaque(int n, CList[] cListArray, int[] nArray, int[] nArray2, int n2, int n3) {
        for (int i = 0; i < n; ++i) {
            int n4;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            CList cList = cListArray[i];
            int n5 = cList.n;
            int n6 = nArray[cList.pixel];
            boolean bl = false;
            for (n4 = 0; n4 < n5; ++n4) {
                if (cList.weight[n4] == 0.0f || nArray[cList.pixel + n4] == n6) continue;
                bl = true;
                break;
            }
            if (bl) {
                for (n4 = 0; n4 < n5; ++n4) {
                    float f4 = cList.weight[n4];
                    int n7 = nArray[cList.pixel + n4];
                    f += (float)(n7 >>> 16 & 0xFF) * f4;
                    f2 += (float)(n7 >>> 8 & 0xFF) * f4;
                    f3 += (float)(n7 & 0xFF) * f4;
                }
                nArray2[n2 + i * n3] = (f > 255.0f ? 255 : (f < 0.0f ? 0 : (int)(f + 0.5f))) << 16 | (f2 > 255.0f ? 255 : (f2 < 0.0f ? 0 : (int)(f2 + 0.5f))) << 8 | (f3 > 255.0f ? 255 : (f3 < 0.0f ? 0 : (int)(f3 + 0.5f)));
                continue;
            }
            nArray2[n2 + i * n3] = n6;
        }
    }

    public static void main(String[] stringArray) throws IOException {
        int n;
        BufferedImage bufferedImage = ImageIO.read(new File(stringArray[0]));
        float f = Float.parseFloat(stringArray[1]);
        int n2 = (int)((float)bufferedImage.getWidth() * f);
        int n3 = (int)((float)bufferedImage.getHeight() * f);
        switch (Integer.parseInt(stringArray[2])) {
            case 0: {
                n = 1;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        bufferedImage = bufferedImage2;
        BufferedImage bufferedImage3 = null;
        Lanczos3Filter lanczos3Filter = new Lanczos3Filter();
        for (int i = 0; i < 40; ++i) {
            long l = System.currentTimeMillis();
            bufferedImage3 = GeneralFilter.zoom(new Rectangle(0, 0, n2, n3), bufferedImage, lanczos3Filter);
            System.out.println(System.currentTimeMillis() - l);
        }
        System.out.println("Ready...");
        System.in.read();
        System.out.println("Starting...");
        long l = 0L;
        for (int i = 0; i < 10; ++i) {
            long l2 = System.currentTimeMillis();
            bufferedImage3 = GeneralFilter.zoom(new Rectangle(0, 0, n2, n3), bufferedImage, lanczos3Filter);
            l += System.currentTimeMillis() - l2;
        }
        System.out.println(l / 10L);
        System.out.println("Done.");
        System.in.read();
    }

    public static final class BSplineFilter
    extends Filter {
        public float apply(float f) {
            if (f < 0.0f) {
                f = -f;
            }
            if (f < 1.0f) {
                float f2 = f * f;
                return 0.5f * f2 * f - f2 + 0.6666667f;
            }
            if (f < 2.0f) {
                f = 2.0f - f;
                return 0.16666667f * (f * f * f);
            }
            return 0.0f;
        }

        public float getSamplingRadius() {
            return 2.0f;
        }
    }

    public static final class BellFilter
    extends Filter {
        public float apply(float f) {
            if (f < 0.0f) {
                f = -f;
            }
            if (f < 0.5f) {
                return 0.75f - f * f;
            }
            if (f < 1.5f) {
                return 0.5f * ((f -= 1.5f) * f);
            }
            return 0.0f;
        }

        public float getSamplingRadius() {
            return 1.5f;
        }
    }

    public static final class MitchellFilter
    extends Filter {
        private static final float B = 0.33333334f;
        private static final float C = 0.33333334f;
        private static final float P0 = 0.8888889f;
        private static final float P2 = -2.0f;
        private static final float P3 = 1.1666666f;
        private static final float Q0 = 1.7777778f;
        private static final float Q1 = -3.3333333f;
        private static final float Q2 = 2.0f;
        private static final float Q3 = -0.38888887f;

        public float apply(float f) {
            if (f < -2.0f) {
                return 0.0f;
            }
            if (f < -1.0f) {
                return 1.7777778f - f * (-3.3333333f - f * (2.0f - f * -0.38888887f));
            }
            if (f < 0.0f) {
                return 0.8888889f + f * f * (-2.0f - f * 1.1666666f);
            }
            if (f < 1.0f) {
                return 0.8888889f + f * f * (-2.0f + f * 1.1666666f);
            }
            if (f < 2.0f) {
                return 1.7777778f + f * (-3.3333333f + f * (2.0f + f * -0.38888887f));
            }
            return 0.0f;
        }

        public float getSamplingRadius() {
            return 2.0f;
        }
    }

    public static final class Lanczos3Filter
    extends Filter {
        private float sinc(float f) {
            if (f == 0.0f) {
                return 1.0f;
            }
            f = (float)((double)f * Math.PI);
            return (float)(Math.sin(f) / (double)f);
        }

        public float apply(float f) {
            if (f < -3.0f) {
                return 0.0f;
            }
            if (f < 0.0f) {
                return this.sinc(-f) * this.sinc(-f / 3.0f);
            }
            if (f < 3.0f) {
                return this.sinc(f) * this.sinc(f / 3.0f);
            }
            return 0.0f;
        }

        public float getSamplingRadius() {
            return 3.0f;
        }
    }

    public static final class TriangleFilter {
        public float apply(float f) {
            if (f < 0.0f) {
                f = -f;
            }
            if (f < 1.0f) {
                return 1.0f - f;
            }
            return 0.0f;
        }

        public float getSamplingRadius() {
            return 1.0f;
        }
    }

    public static final class BoxFilter
    extends Filter {
        public float apply(float f) {
            if (f > -0.5f && f <= 0.5f) {
                return 1.0f;
            }
            return 0.0f;
        }

        public float getSamplingRadius() {
            return 0.5f;
        }
    }

    public static final class HermiteFilter
    extends Filter {
        public float apply(float f) {
            if (f < 0.0f) {
                f = -f;
            }
            if (f < 1.0f) {
                return (2.0f * f - 3.0f) * f * f + 1.0f;
            }
            return 0.0f;
        }

        public float getSamplingRadius() {
            return 1.0f;
        }
    }

    public static abstract class Filter {
        public abstract float getSamplingRadius();

        public abstract float apply(float var1);
    }

    private static final class CList {
        public int n;
        public int pixel;
        public float[] weight;

        private CList() {
        }
    }
}

