/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image;

import VASSAL.build.BadDataReport;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.image.PNGChunkSkipInputStream;
import VASSAL.tools.image.PNGDecoder;
import VASSAL.tools.image.UnrecognizedImageTypeException;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.io.RereadableInputStream;
import java.awt.Dimension;
import java.awt.color.CMMException;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class ImageLoader {
    protected static final ImageLoader INSTANCE = new ImageLoader();
    protected static final boolean iTXtBug;
    protected static final Set<Integer> skip_iTXt;

    public static BufferedImage getImage(String string, InputStream inputStream) throws ImageIOException {
        return INSTANCE.load(string, inputStream);
    }

    public static Dimension getImageSize(String string, InputStream inputStream) throws ImageIOException {
        return INSTANCE.size(string, inputStream);
    }

    protected ImageLoader() {
    }

    protected BufferedImage loadImageIO(String string, InputStream inputStream) throws IOException {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(new MemoryCacheImageInputStream(inputStream));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            ErrorDialog.dataError(new BadDataReport("Broken image", string));
            throw (IOException)new IOException().initCause(arrayIndexOutOfBoundsException);
        }
        catch (CMMException cMMException) {
            ErrorDialog.dataError(new BadDataReport("Broken image", string));
            throw (IOException)new IOException().initCause(cMMException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorDialog.dataError(new BadDataReport("Broken image", string));
            throw (IOException)new IOException().initCause(illegalArgumentException);
        }
        if (bufferedImage == null) {
            throw new UnrecognizedImageTypeException();
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected BufferedImage load(String var1_1, InputStream var2_2) throws ImageIOException {
        var3_3 = null;
        var4_4 = null;
        try {
            var4_4 = new RereadableInputStream(var2_2);
            var4_4.mark(512);
            var5_5 = new DataInputStream(var4_4);
            var7_8 = false;
            var8_9 = 0;
            if (!PNGDecoder.decodeSignature(var5_5)) ** GOTO lbl45
            var6_10 = PNGDecoder.decodeChunk(var5_5);
            if (var6_10.type != 1229472850) ** GOTO lbl45
            if (var6_10.data[8] != 8 || var6_10.data[9] != 2) ** GOTO lbl41
            block10: while (true) {
                var6_10 = PNGDecoder.decodeChunk(var5_5);
                switch (var6_10.type) {
                    case 1951551059: {
                        var7_8 = true;
                        break block10;
                    }
                    case 1229209940: {
                        var7_8 = false;
                        break block10;
                    }
                    default: {
                        continue block10;
                    }
                }
                break;
            }
            if (!var7_8) ** GOTO lbl41
            if (var6_10.data.length != 6) {
                ErrorDialog.dataError(new BadDataReport("Broken image", var1_1));
                var9_11 = null;
            }
            ** GOTO lbl-1000
        }
        catch (UnrecognizedImageTypeException var5_6) {
            try {
                throw new UnrecognizedImageTypeException(var1_1, (Throwable)var5_6);
                catch (IOException var5_7) {
                    throw new ImageIOException(var1_1, (Throwable)var5_7);
                }
            }
            catch (Throwable var10_13) {
                IOUtils.closeQuietly(var4_4);
                throw var10_13;
            }
        }
        IOUtils.closeQuietly(var4_4);
        return var9_11;
lbl-1000:
        // 1 sources

        {
            var8_9 = -16777216 | (var6_10.data[1] & 255) << 16 | (var6_10.data[3] & 255) << 8 | var6_10.data[5] & 255;
lbl41:
            // 3 sources

            if (ImageLoader.iTXtBug) {
                var4_4.reset();
                var4_4 = new RereadableInputStream(new PNGChunkSkipInputStream(ImageLoader.skip_iTXt, var4_4));
                var4_4.mark(1);
            }
lbl45:
            // 5 sources

            var4_4.reset();
            var3_3 = this.loadImageIO(var1_1, var4_4);
            var4_4.close();
            if (var7_8) {
                var3_3 = this.fix_tRNS(var3_3, var8_9);
            }
            var9_12 = this.toCompatibleImage(var3_3);
        }
        IOUtils.closeQuietly(var4_4);
        return var9_12;
    }

    protected BufferedImage toCompatibleImage(BufferedImage bufferedImage) throws IOException {
        return ImageUtils.toCompatibleImage(bufferedImage);
    }

    protected BufferedImage fix_tRNS(BufferedImage bufferedImage, int n) throws IOException {
        if (bufferedImage.getType() != 2 && bufferedImage.getType() != 3) {
            int n2 = ImageUtils.getCompatibleTranslucentImageType();
            bufferedImage = ImageUtils.toType(bufferedImage, n2 == 2 || n2 == 3 ? n2 : 2);
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        int[] nArray = (int[])writableRaster.getDataElements(0, 0, n3, n4, new int[n3 * n4]);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            nArray[i] = 0;
        }
        writableRaster.setDataElements(0, 0, n3, n4, nArray);
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dimension size(String string, InputStream inputStream) throws ImageIOException {
        try {
            MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(inputStream);
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(memoryCacheImageInputStream);
            if (!iterator.hasNext()) {
                throw new UnrecognizedImageTypeException(string);
            }
            ImageReader imageReader = iterator.next();
            try {
                imageReader.setInput(memoryCacheImageInputStream);
                Dimension dimension = null;
                try {
                    dimension = new Dimension(imageReader.getWidth(0), imageReader.getHeight(0));
                }
                catch (CMMException cMMException) {
                    ErrorDialog.dataError(new BadDataReport("Broken image", string));
                    throw (IOException)new IOException().initCause(cMMException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ErrorDialog.dataError(new BadDataReport("Broken image", string));
                    throw (IOException)new IOException().initCause(illegalArgumentException);
                }
                inputStream.close();
                Dimension dimension2 = dimension;
                imageReader.dispose();
                return dimension2;
            }
            catch (Throwable throwable) {
                try {
                    imageReader.dispose();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new ImageIOException(string, (Throwable)iOException);
                }
            }
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    static {
        String string = System.getProperty("java.version");
        iTXtBug = string == null || string.startsWith("1.5");
        skip_iTXt = Collections.singleton(1767135348);
    }
}

