/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image;

import VASSAL.tools.ErrorDialog;
import VASSAL.tools.image.GeneralFilter;
import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageLoader;
import VASSAL.tools.image.ImageNotFoundException;
import VASSAL.tools.image.RenderingClues;
import VASSAL.tools.image.memmap.MappedBufferedImage;
import VASSAL.tools.imageop.Op;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import org.jdesktop.swingx.graphics.GraphicsUtilities;

public class ImageUtils {
    private static final double DEGTORAD = -Math.PI / 180;
    public static final BufferedImage NULL_IMAGE = ImageUtils.createCompatibleImage(1, 1);
    private static final GeneralFilter.Filter upscale = new GeneralFilter.MitchellFilter();
    private static final GeneralFilter.Filter downscale = new GeneralFilter.Lanczos3Filter();
    public static final String PREFER_MEMORY_MAPPED = "preferMemoryMapped";
    private static final int MAPPED = 0;
    private static final int RAM = 1;
    private static int largeImageLoadMethod = 1;
    public static final String SCALER_ALGORITHM = "scalerAlgorithm";
    private static final int MEDIUM = 1;
    private static final int GOOD = 2;
    private static int scalingQuality = 2;
    private static final Map<RenderingHints.Key, Object> defaultHints = new HashMap<RenderingHints.Key, Object>();
    protected static final int compatOpaqueImageType;
    protected static final int compatTranslImageType;

    private ImageUtils() {
    }

    public static boolean useMappedImages() {
        return largeImageLoadMethod == 0;
    }

    public static void setPreferMemoryMappedFiles(boolean bl) {
        largeImageLoadMethod = bl ? 0 : 1;
    }

    public static void setHighQualityScaling(boolean bl) {
        int n;
        int n2 = n = bl ? 2 : 1;
        if (n != scalingQuality) {
            scalingQuality = n;
            Op.clearCache();
            defaultHints.put(RenderingClues.KEY_EXT_INTERPOLATION, scalingQuality == 2 ? RenderingClues.VALUE_INTERPOLATION_LANCZOS_MITCHELL : RenderingClues.VALUE_INTERPOLATION_BILINEAR);
        }
    }

    public static RenderingHints getDefaultHints() {
        return new RenderingClues(defaultHints);
    }

    public static Rectangle transform(Rectangle rectangle, double d, double d2) {
        AffineTransform affineTransform = AffineTransform.getRotateInstance(-Math.PI / 180 * d2, rectangle.getCenterX(), rectangle.getCenterY());
        affineTransform.scale(d, d);
        return affineTransform.createTransformedShape(rectangle).getBounds();
    }

    public static BufferedImage transform(BufferedImage bufferedImage, double d, double d2) {
        return ImageUtils.transform(bufferedImage, d, d2, ImageUtils.getDefaultHints(), scalingQuality);
    }

    public static BufferedImage transform(BufferedImage bufferedImage, double d, double d2, RenderingHints renderingHints) {
        return ImageUtils.transform(bufferedImage, d, d2, renderingHints, scalingQuality);
    }

    public static BufferedImage transform(BufferedImage bufferedImage, double d, double d2, RenderingHints renderingHints, int n) {
        if (bufferedImage == null) {
            return null;
        }
        if (d == 1.0 && d2 == 0.0) {
            return bufferedImage;
        }
        if ((double)bufferedImage.getWidth() * d == 0.0 || (double)bufferedImage.getHeight() * d == 0.0) {
            return NULL_IMAGE;
        }
        if (renderingHints == null) {
            renderingHints = ImageUtils.getDefaultHints();
        }
        if (d == 1.0 && d2 % 90.0 == 0.0) {
            renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            Rectangle rectangle = ImageUtils.getBounds(bufferedImage);
            Rectangle rectangle2 = ImageUtils.transform(rectangle, d, d2);
            BufferedImage bufferedImage2 = ImageUtils.createCompatibleImage(rectangle2.width, rectangle2.height, bufferedImage.getTransparency() != 1);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(-rectangle2.x, -rectangle2.y);
            affineTransform.rotate(-Math.PI / 180 * d2, rectangle.getCenterX(), rectangle.getCenterY());
            affineTransform.scale(d, d);
            affineTransform.translate(rectangle.x, rectangle.y);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.setRenderingHints(renderingHints);
            graphics2D.drawImage(bufferedImage, affineTransform, null);
            graphics2D.dispose();
            return bufferedImage2;
        }
        if (renderingHints.get(RenderingClues.KEY_EXT_INTERPOLATION) == RenderingClues.VALUE_INTERPOLATION_LANCZOS_MITCHELL) {
            Object object;
            Rectangle rectangle;
            if (d2 != 0.0) {
                rectangle = ImageUtils.getBounds(bufferedImage);
                object = ImageUtils.transform(rectangle, 1.0, d2);
                BufferedImage bufferedImage3 = ImageUtils.createCompatibleImage(((Rectangle)object).width, ((Rectangle)object).height, bufferedImage.getTransparency() != 1 || d2 % 90.0 != 0.0);
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(-((Rectangle)object).x, -((Rectangle)object).y);
                affineTransform.rotate(-Math.PI / 180 * d2, rectangle.getCenterX(), rectangle.getCenterY());
                affineTransform.translate(rectangle.x, rectangle.y);
                Graphics2D graphics2D = bufferedImage3.createGraphics();
                graphics2D.setRenderingHints(renderingHints);
                graphics2D.drawImage(bufferedImage, affineTransform, null);
                graphics2D.dispose();
                bufferedImage = bufferedImage3;
            }
            if (d != 1.0) {
                bufferedImage = ImageUtils.coerceToIntType(bufferedImage);
                rectangle = ImageUtils.transform(ImageUtils.getBounds(bufferedImage), d, 0.0);
                object = GeneralFilter.zoom(rectangle, bufferedImage, d > 1.0 ? upscale : downscale);
                return ImageUtils.toCompatibleImage((BufferedImage)object);
            }
            return bufferedImage;
        }
        Rectangle rectangle = ImageUtils.getBounds(bufferedImage);
        Rectangle rectangle3 = ImageUtils.transform(rectangle, d, d2);
        BufferedImage bufferedImage4 = ImageUtils.createCompatibleImage(rectangle3.width, rectangle3.height, bufferedImage.getTransparency() != 1 || d2 % 90.0 != 0.0);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(-rectangle3.x, -rectangle3.y);
        affineTransform.rotate(-Math.PI / 180 * d2, rectangle.getCenterX(), rectangle.getCenterY());
        affineTransform.scale(d, d);
        affineTransform.translate(rectangle.x, rectangle.y);
        Graphics2D graphics2D = bufferedImage4.createGraphics();
        graphics2D.setRenderingHints(renderingHints);
        graphics2D.drawImage(bufferedImage, affineTransform, null);
        graphics2D.dispose();
        return bufferedImage4;
    }

    public static BufferedImage coerceToIntType(BufferedImage bufferedImage) {
        switch (bufferedImage.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return bufferedImage;
            }
            case 0: {
                if (!(bufferedImage instanceof MappedBufferedImage) || !(bufferedImage.getColorModel() instanceof DirectColorModel) || bufferedImage.getSampleModel().getDataType() != 3) break;
                return bufferedImage;
            }
        }
        return ImageUtils.toType(bufferedImage, bufferedImage.getTransparency() == 1 ? 1 : (ImageUtils.getCompatibleTranslucentImageType() == 2 ? 2 : 3));
    }

    public static Rectangle getBounds(BufferedImage bufferedImage) {
        return new Rectangle(-bufferedImage.getWidth() / 2, -bufferedImage.getHeight() / 2, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public static Rectangle getBounds(Dimension dimension) {
        return new Rectangle(-dimension.width / 2, -dimension.height / 2, dimension.width, dimension.height);
    }

    @Deprecated
    public static Dimension getImageSize(InputStream inputStream) throws IOException {
        return ImageUtils.getImageSize("", inputStream);
    }

    public static Dimension getImageSize(String string, InputStream inputStream) throws ImageIOException {
        return ImageLoader.getImageSize(string, inputStream);
    }

    @Deprecated
    public static BufferedImage getImage(InputStream inputStream) throws IOException {
        return ImageUtils.getImage("", inputStream);
    }

    public static BufferedImage getImageResource(String string) throws ImageIOException {
        InputStream inputStream = ImageUtils.class.getResourceAsStream(string);
        if (inputStream == null) {
            throw new ImageNotFoundException(string);
        }
        return ImageUtils.getImage(string, inputStream);
    }

    public static BufferedImage getImage(String string, InputStream inputStream) throws ImageIOException {
        return ImageLoader.getImage(string, inputStream);
    }

    public static BufferedImage toType(BufferedImage bufferedImage, int n) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static Image forceLoad(Image image) {
        return new ImageIcon(image).getImage();
    }

    public static boolean isTransparent(Image image) {
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            ErrorDialog.bug(interruptedException);
        }
        return pixelGrabber.getColorModel().hasAlpha();
    }

    public static boolean isTransparent(BufferedImage bufferedImage) {
        return bufferedImage.getTransparency() != 1;
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image == null) {
            return null;
        }
        if (image instanceof BufferedImage) {
            return ImageUtils.toCompatibleImage((BufferedImage)image);
        }
        image = ImageUtils.forceLoad(image);
        BufferedImage bufferedImage = ImageUtils.createCompatibleImage(image.getWidth(null), image.getHeight(null), ImageUtils.isTransparent(image));
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static int getCompatibleImageType() {
        return compatOpaqueImageType;
    }

    public static int getCompatibleTranslucentImageType() {
        return compatTranslImageType;
    }

    public static int getCompatibleImageType(boolean bl) {
        return bl ? compatTranslImageType : compatOpaqueImageType;
    }

    public static BufferedImage createCompatibleImage(int n, int n2) {
        return GraphicsUtilities.createCompatibleImage((int)n, (int)n2);
    }

    public static BufferedImage createCompatibleImage(int n, int n2, boolean bl) {
        return bl ? GraphicsUtilities.createCompatibleTranslucentImage((int)n, (int)n2) : GraphicsUtilities.createCompatibleImage((int)n, (int)n2);
    }

    public static BufferedImage createCompatibleTranslucentImage(int n, int n2) {
        return GraphicsUtilities.createCompatibleTranslucentImage((int)n, (int)n2);
    }

    public static BufferedImage toCompatibleImage(BufferedImage bufferedImage) {
        return GraphicsUtilities.toCompatibleImage((BufferedImage)bufferedImage);
    }

    public static boolean isCompatibleImage(BufferedImage bufferedImage) {
        if (bufferedImage instanceof MappedBufferedImage) {
            return ((MappedBufferedImage)bufferedImage).getRealType() == ImageUtils.getCompatibleImageType(bufferedImage.getTransparency() != 1);
        }
        return bufferedImage.getType() == ImageUtils.getCompatibleImageType(bufferedImage.getTransparency() != 1);
    }

    static {
        ImageUtils.setPreferMemoryMappedFiles(false);
        ImageUtils.setHighQualityScaling(true);
        defaultHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        defaultHints.put(RenderingClues.KEY_EXT_INTERPOLATION, RenderingClues.VALUE_INTERPOLATION_LANCZOS_MITCHELL);
        defaultHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        compatOpaqueImageType = ImageUtils.createCompatibleImage(1, 1).getType();
        compatTranslImageType = ImageUtils.createCompatibleTranslucentImage(1, 1).getType();
    }
}

