/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image.memmap;

import VASSAL.tools.io.TempFileManager;
import java.awt.image.DataBuffer;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;

public class MappedDataBufferInt
extends DataBuffer {
    private IntBuffer buf = null;
    private final File file;
    private final int bankSize;
    private final int bankNum;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappedDataBufferInt(int n, int n2) throws IOException {
        super(3, n);
        this.bankSize = n;
        this.bankNum = n2;
        this.file = TempFileManager.getInstance().createTempFile("mem", null);
        this.file.deleteOnExit();
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "rw");
        try {
            this.buf = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, 4 * this.bankSize * n2).asIntBuffer();
        }
        finally {
            randomAccessFile.close();
            if (this.buf == null) {
                this.dispose();
            }
        }
    }

    public void dispose() {
        this.file.delete();
    }

    protected void finalize() {
        this.dispose();
    }

    public int getElem(int n, int n2) {
        if (n >= this.bankNum) {
            throw new IllegalArgumentException();
        }
        return this.buf.get(n * this.bankSize + n2);
    }

    public void setElem(int n, int n2, int n3) {
        if (n >= this.bankNum) {
            throw new IllegalArgumentException();
        }
        this.buf.put(n * this.bankSize + n2, n3);
    }
}

