/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image.memmap;

import VASSAL.build.BadDataReport;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageLoader;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.image.UnrecognizedImageTypeException;
import VASSAL.tools.image.memmap.MappedBufferedImage;
import VASSAL.tools.image.memmap.MappedImageUtils;
import VASSAL.tools.io.TempFileManager;
import java.awt.color.CMMException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.FileCacheImageInputStream;

public class MappedImageLoader
extends ImageLoader {
    protected static final MappedImageLoader INSTANCE = new MappedImageLoader();

    public static MappedBufferedImage getImage(String string, InputStream inputStream) throws ImageIOException {
        return (MappedBufferedImage)INSTANCE.load(string, inputStream);
    }

    protected MappedImageLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MappedBufferedImage loadImageIO(String string, InputStream inputStream) throws IOException {
        FileCacheImageInputStream fileCacheImageInputStream = new FileCacheImageInputStream(inputStream, TempFileManager.getInstance().getSessionRoot());
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(fileCacheImageInputStream);
        if (!iterator.hasNext()) {
            throw new UnrecognizedImageTypeException();
        }
        ImageReader imageReader = iterator.next();
        if (imageReader == null) {
            return null;
        }
        try {
            imageReader.setInput(fileCacheImageInputStream);
            int n = imageReader.getWidth(0);
            int n2 = imageReader.getHeight(0);
            ImageTypeSpecifier imageTypeSpecifier = imageReader.getImageTypes(0).next();
            ColorModel colorModel = imageTypeSpecifier.getColorModel();
            SampleModel sampleModel = imageTypeSpecifier.getSampleModel().createCompatibleSampleModel(n, n2);
            int n3 = imageTypeSpecifier.getBufferedImageType();
            MappedBufferedImage mappedBufferedImage = new MappedBufferedImage(colorModel, sampleModel, n3);
            ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
            imageReadParam.setDestination(mappedBufferedImage);
            Object var14_14 = null;
            try {
                mappedBufferedImage = (MappedBufferedImage)imageReader.read(0, imageReadParam);
            }
            catch (CMMException cMMException) {
                ErrorDialog.dataError(new BadDataReport("Broken image", string));
                throw (IOException)new IOException().initCause(cMMException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorDialog.dataError(new BadDataReport("Broken image", string));
                throw (IOException)new IOException().initCause(illegalArgumentException);
            }
            if (mappedBufferedImage == null) {
                throw new UnrecognizedImageTypeException();
            }
            MappedBufferedImage mappedBufferedImage2 = mappedBufferedImage;
            return mappedBufferedImage2;
        }
        finally {
            imageReader.dispose();
        }
    }

    protected MappedBufferedImage toCompatibleImage(BufferedImage bufferedImage) throws IOException {
        return MappedImageUtils.toCompatibleImage((MappedBufferedImage)bufferedImage);
    }

    protected MappedBufferedImage fix_tRNS(BufferedImage bufferedImage, int n) throws IOException {
        int n2;
        MappedBufferedImage mappedBufferedImage = (MappedBufferedImage)bufferedImage;
        if (mappedBufferedImage.getRealType() != 2 && mappedBufferedImage.getRealType() != 3) {
            n2 = ImageUtils.getCompatibleTranslucentImageType();
            mappedBufferedImage = MappedImageUtils.toType(mappedBufferedImage, n2 == 2 || n2 == 3 ? n2 : 2);
        }
        n2 = mappedBufferedImage.getWidth();
        int n3 = mappedBufferedImage.getHeight();
        int[] nArray = new int[n2];
        for (int i = 0; i < n3; ++i) {
            mappedBufferedImage.getRGB(0, i, nArray.length, 1, nArray, 0, nArray.length);
            for (int j = 0; j < n2; ++j) {
                if (nArray[j] != n) continue;
                nArray[j] = 0;
            }
            mappedBufferedImage.setRGB(0, i, nArray.length, 1, nArray, 0, nArray.length);
        }
        return mappedBufferedImage;
    }
}

