/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image.memmap;

import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.image.memmap.MappedBufferedImage;
import VASSAL.tools.image.memmap.MappedImageLoader;
import java.io.IOException;
import java.io.InputStream;

public class MappedImageUtils {
    private MappedImageUtils() {
    }

    public static MappedBufferedImage getImage(String string, InputStream inputStream) throws ImageIOException {
        return MappedImageLoader.getImage(string, inputStream);
    }

    public static MappedBufferedImage createCompatibleImage(int n, int n2) {
        return new MappedBufferedImage(n, n2, ImageUtils.getCompatibleImageType());
    }

    public static MappedBufferedImage createCompatibleImage(int n, int n2, boolean bl) {
        return new MappedBufferedImage(n, n2, ImageUtils.getCompatibleImageType(bl));
    }

    public static MappedBufferedImage createCompatibleTranslucentImage(int n, int n2) {
        return new MappedBufferedImage(n, n2, ImageUtils.getCompatibleTranslucentImageType());
    }

    public static MappedBufferedImage toCompatibleImage(MappedBufferedImage mappedBufferedImage) throws IOException {
        if (ImageUtils.isCompatibleImage(mappedBufferedImage)) {
            return mappedBufferedImage;
        }
        return MappedImageUtils.toType(mappedBufferedImage, ImageUtils.getCompatibleImageType(ImageUtils.isTransparent(mappedBufferedImage)));
    }

    public static MappedBufferedImage toType(MappedBufferedImage mappedBufferedImage, int n) throws IOException {
        return MappedImageUtils.rowByRowCopy(mappedBufferedImage, new MappedBufferedImage(mappedBufferedImage.getWidth(), mappedBufferedImage.getHeight(), n));
    }

    private static MappedBufferedImage rowByRowCopy(MappedBufferedImage mappedBufferedImage, MappedBufferedImage mappedBufferedImage2) {
        int n = mappedBufferedImage.getHeight();
        int[] nArray = new int[mappedBufferedImage.getWidth()];
        for (int i = 0; i < n; ++i) {
            mappedBufferedImage.getRGB(0, i, nArray.length, 1, nArray, 0, nArray.length);
            mappedBufferedImage2.setRGB(0, i, nArray.length, 1, nArray, 0, nArray.length);
        }
        return mappedBufferedImage2;
    }
}

