/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image.svg;

import VASSAL.build.GameModule;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.logging.Logger;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.gvt.renderer.ConcreteImageRendererFactory;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.gvt.renderer.ImageRendererFactory;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.keys.BooleanKey;
import org.apache.batik.transcoder.keys.PaintKey;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;

public class SVGRenderer {
    private static final SAXSVGDocumentFactory docFactory = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());
    private static final ImageRendererFactory rendFactory = new ConcreteImageRendererFactory();
    private final Document doc;
    private final float defaultW;
    private final float defaultH;
    private final Rasterizer r = new Rasterizer();
    private static final double DEGTORAD = Math.PI / 180;
    public static final TranscodingHints.Key KEY_BACKGROUND_COLOR = new PaintKey();
    public static final TranscodingHints.Key KEY_FORCE_TRANSPARENT_WHITE = new BooleanKey();

    public SVGRenderer(URL uRL, InputStream inputStream) throws IOException {
        this(uRL.toString(), inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVGRenderer(String string, InputStream inputStream) throws IOException {
        Object object;
        try {
            object = docFactory;
            synchronized (object) {
                this.doc = docFactory.createDocument(string, inputStream);
            }
            inputStream.close();
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        object = this.doc.getDocumentElement();
        this.defaultW = Float.parseFloat(object.getAttributeNS(null, "width").replaceFirst("px", ""));
        this.defaultH = Float.parseFloat(object.getAttributeNS(null, "height").replaceFirst("px", ""));
    }

    public BufferedImage render() {
        return this.render(0.0, 1.0);
    }

    public BufferedImage render(double d, double d2) {
        AffineTransform affineTransform = AffineTransform.getRotateInstance(d * (Math.PI / 180), (double)this.defaultW / 2.0, (double)this.defaultH / 2.0);
        this.r.setTransform(affineTransform);
        affineTransform = new AffineTransform(affineTransform);
        affineTransform.scale(d2, d2);
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, this.defaultW, this.defaultH);
        Rectangle2D rectangle2D = affineTransform.createTransformedShape(float_).getBounds2D();
        this.r.addTranscodingHint(Rasterizer.KEY_WIDTH, Float.valueOf((float)rectangle2D.getWidth()));
        this.r.addTranscodingHint(Rasterizer.KEY_HEIGHT, Float.valueOf((float)rectangle2D.getHeight()));
        try {
            this.r.transcode(new TranscoderInput(this.doc), null);
            return this.r.getBufferedImage();
        }
        catch (TranscoderException transcoderException) {
            Logger.log(transcoderException);
            return null;
        }
    }

    public BufferedImage render(double d, double d2, Rectangle2D rectangle2D) {
        AffineTransform affineTransform = AffineTransform.getRotateInstance(d * (Math.PI / 180), (double)this.defaultW / 2.0, (double)this.defaultH / 2.0);
        this.r.setTransform(affineTransform);
        affineTransform = new AffineTransform(affineTransform);
        affineTransform.scale(d2, d2);
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, this.defaultW, this.defaultH);
        this.r.addTranscodingHint(Rasterizer.KEY_WIDTH, Float.valueOf((float)rectangle2D.getWidth()));
        this.r.addTranscodingHint(Rasterizer.KEY_HEIGHT, Float.valueOf((float)rectangle2D.getHeight()));
        this.r.addTranscodingHint(Rasterizer.KEY_AOI, rectangle2D);
        try {
            this.r.transcode(new TranscoderInput(this.doc), null);
            return this.r.getBufferedImage();
        }
        catch (TranscoderException transcoderException) {
            Logger.log(transcoderException);
            return null;
        }
    }

    private class Rasterizer
    extends SVGAbstractTranscoder {
        private DocumentLoader docLoader;
        private BufferedImage image;
        private AffineTransform xform;

        public Rasterizer() {
            this.docLoader = new DataArchiveDocumentLoader(this.userAgent);
        }

        protected BridgeContext createBridgeContext() {
            return new BridgeContext(this.userAgent, this.docLoader);
        }

        protected void transcode(Document document, String string, TranscoderOutput transcoderOutput) throws TranscoderException {
            super.transcode(document, string, transcoderOutput);
            int n = (int)((double)this.width + 0.5);
            int n2 = (int)((double)this.height + 0.5);
            ImageRenderer imageRenderer = rendFactory.createStaticImageRenderer();
            imageRenderer.updateOffScreen(n, n2);
            if (this.xform != null) {
                this.curTxf.concatenate(this.xform);
            }
            imageRenderer.setTransform(this.curTxf);
            imageRenderer.setTree(this.root);
            this.root = null;
            Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height);
            try {
                imageRenderer.repaint(this.curTxf.createInverse().createTransformedShape(float_));
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new TranscoderException((Exception)noninvertibleTransformException);
            }
            BufferedImage bufferedImage = imageRenderer.getOffScreen();
            imageRenderer = null;
            BufferedImage bufferedImage2 = ImageUtils.createCompatibleImage(n, n2, !this.hints.containsKey((Object)KEY_BACKGROUND_COLOR));
            Graphics2D graphics2D = GraphicsUtil.createGraphics((BufferedImage)bufferedImage2);
            if (this.hints.containsKey((Object)KEY_BACKGROUND_COLOR)) {
                Paint paint = (Paint)this.hints.get((Object)KEY_BACKGROUND_COLOR);
                graphics2D.setComposite(AlphaComposite.SrcOver);
                graphics2D.setPaint(paint);
                graphics2D.fillRect(0, 0, n, n2);
            }
            if (bufferedImage != null) {
                graphics2D.drawRenderedImage(bufferedImage, new AffineTransform());
            }
            graphics2D.dispose();
            bufferedImage = null;
            this.writeImage(bufferedImage2, transcoderOutput);
        }

        private void writeImage(BufferedImage bufferedImage, TranscoderOutput transcoderOutput) {
            this.image = bufferedImage;
        }

        public BufferedImage getBufferedImage() {
            return this.image;
        }

        public void setTransform(AffineTransform affineTransform) {
            this.xform = affineTransform;
        }
    }

    private static class DataArchiveDocumentLoader
    extends DocumentLoader {
        public DataArchiveDocumentLoader(UserAgent userAgent) {
            super(userAgent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Document loadDocument(String string) throws MalformedURLException, IOException {
            Document document;
            String string2 = new File(new URL(string).getPath()).getName();
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(GameModule.getGameModule().getDataArchive().getImageInputStream(string2));
                Document document2 = this.loadDocument(string, bufferedInputStream);
                bufferedInputStream.close();
                document = document2;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly(bufferedInputStream);
            return document;
        }
    }
}

