/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.tools.HashCode;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.AbstractTileOpImpl;
import VASSAL.tools.imageop.AbstractTiledOpImpl;
import VASSAL.tools.imageop.CropOpBitmapImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.RotateOp;
import VASSAL.tools.opcache.Op;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrthoRotateOpBitmapImpl
extends AbstractTiledOpImpl
implements RotateOp {
    private final ImageOp sop;
    private final int angle;
    private final int hash;

    public OrthoRotateOpBitmapImpl(ImageOp imageOp, int n) {
        if (imageOp == null) {
            throw new IllegalArgumentException();
        }
        if ((n = (360 + n % 360) % 360) % 90 != 0) {
            throw new IllegalArgumentException();
        }
        this.sop = imageOp;
        this.angle = n / 90;
        this.hash = HashCode.hash(imageOp) ^ HashCode.hash(n);
    }

    @Override
    public List<Op<?>> getSources() {
        return Collections.singletonList(this.sop);
    }

    @Override
    public BufferedImage eval() throws Exception {
        BufferedImage bufferedImage = this.sop.getImage(null);
        if (this.size == null) {
            this.fixSize();
        }
        BufferedImage bufferedImage2 = ImageUtils.createCompatibleImage(this.size.width, this.size.height, bufferedImage.getTransparency() != 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.rotate(1.5707963267948966 * (double)this.angle, (double)bufferedImage.getWidth() / 2.0, (double)bufferedImage.getHeight() / 2.0);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    @Override
    protected void fixSize() {
        this.size = this.getSizeFromCache();
        if (this.size == null) {
            this.size = this.sop.getSize();
            if (this.angle == 1 || this.angle == 3) {
                this.size.setSize(this.size.height, this.size.width);
            }
        }
    }

    @Override
    public double getAngle() {
        return this.angle * 90;
    }

    @Override
    public RenderingHints getHints() {
        return null;
    }

    @Override
    protected ImageOp createTileOp(int n, int n2) {
        return new TileOp(this, n, n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof OrthoRotateOpBitmapImpl)) {
            return false;
        }
        OrthoRotateOpBitmapImpl orthoRotateOpBitmapImpl = (OrthoRotateOpBitmapImpl)object;
        return (double)this.angle == orthoRotateOpBitmapImpl.getAngle() && this.sop.equals(orthoRotateOpBitmapImpl.sop);
    }

    public int hashCode() {
        return this.hash;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TileOp
    extends AbstractTileOpImpl {
        private final ImageOp sop;
        private final int angle;
        private final int hash;

        public TileOp(OrthoRotateOpBitmapImpl orthoRotateOpBitmapImpl, int n, int n2) {
            int n3;
            int n4;
            int n5;
            int n6;
            if (orthoRotateOpBitmapImpl == null) {
                throw new IllegalArgumentException();
            }
            if (n < 0 || n >= orthoRotateOpBitmapImpl.getNumXTiles() || n2 < 0 || n2 >= orthoRotateOpBitmapImpl.getNumYTiles()) {
                throw new IndexOutOfBoundsException();
            }
            this.angle = orthoRotateOpBitmapImpl.angle;
            switch (this.angle) {
                case 0: {
                    n6 = n * orthoRotateOpBitmapImpl.tileSize.width;
                    n5 = n2 * orthoRotateOpBitmapImpl.tileSize.height;
                    n4 = Math.min((n + 1) * orthoRotateOpBitmapImpl.tileSize.width, orthoRotateOpBitmapImpl.size.width);
                    n3 = Math.min((n2 + 1) * orthoRotateOpBitmapImpl.tileSize.height, orthoRotateOpBitmapImpl.size.height);
                    break;
                }
                case 1: {
                    n6 = n2 * orthoRotateOpBitmapImpl.tileSize.height;
                    n5 = n * orthoRotateOpBitmapImpl.tileSize.width;
                    n4 = Math.min((n2 + 1) * orthoRotateOpBitmapImpl.tileSize.height, orthoRotateOpBitmapImpl.size.height);
                    n3 = Math.min((n + 1) * orthoRotateOpBitmapImpl.tileSize.width, orthoRotateOpBitmapImpl.size.width);
                    break;
                }
                case 2: {
                    n4 = orthoRotateOpBitmapImpl.size.width - n * orthoRotateOpBitmapImpl.tileSize.width;
                    n3 = orthoRotateOpBitmapImpl.size.height - n2 * orthoRotateOpBitmapImpl.tileSize.height;
                    n6 = orthoRotateOpBitmapImpl.size.width - Math.min((n + 1) * orthoRotateOpBitmapImpl.tileSize.width, orthoRotateOpBitmapImpl.size.width);
                    n5 = orthoRotateOpBitmapImpl.size.height - Math.min((n2 + 1) * orthoRotateOpBitmapImpl.tileSize.height, orthoRotateOpBitmapImpl.size.height);
                    break;
                }
                default: {
                    n4 = orthoRotateOpBitmapImpl.size.height - n2 * orthoRotateOpBitmapImpl.tileSize.height;
                    n3 = orthoRotateOpBitmapImpl.size.width - n * orthoRotateOpBitmapImpl.tileSize.width;
                    n6 = orthoRotateOpBitmapImpl.size.height - Math.min((n2 + 1) * orthoRotateOpBitmapImpl.tileSize.height, orthoRotateOpBitmapImpl.size.height);
                    n5 = orthoRotateOpBitmapImpl.size.width - Math.min((n + 1) * orthoRotateOpBitmapImpl.tileSize.width, orthoRotateOpBitmapImpl.size.width);
                }
            }
            this.size = new Dimension(n4 - n6, n3 - n5);
            this.sop = new CropOpBitmapImpl(orthoRotateOpBitmapImpl.sop, n6, n5, n4, n3);
            this.hash = HashCode.hash(this.sop) ^ HashCode.hash(this.angle);
        }

        @Override
        public List<Op<?>> getSources() {
            return Collections.singletonList(this.sop);
        }

        @Override
        public BufferedImage eval() throws Exception {
            BufferedImage bufferedImage = this.sop.getImage(null);
            BufferedImage bufferedImage2 = ImageUtils.createCompatibleImage(this.size.width, this.size.height, bufferedImage.getTransparency() != 1);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.rotate(1.5707963267948966 * (double)this.angle, (double)bufferedImage.getWidth() / 2.0, (double)bufferedImage.getHeight() / 2.0);
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.dispose();
            return bufferedImage2;
        }

        @Override
        protected void fixSize() {
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || !(object instanceof TileOp)) {
                return false;
            }
            TileOp tileOp = (TileOp)object;
            return this.angle == tileOp.angle && this.sop.equals(tileOp.sop);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

