/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.tools.HashCode;
import VASSAL.tools.image.GeneralFilter;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.AbstractTileOpImpl;
import VASSAL.tools.imageop.AbstractTiledOpImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.ScaleOp;
import VASSAL.tools.opcache.Op;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaleOpBitmapImpl
extends AbstractTiledOpImpl
implements ScaleOp {
    private final ImageOp sop;
    private final double scale;
    private final RenderingHints hints;
    private final int hash;
    private static final RenderingHints defaultHints = ImageUtils.getDefaultHints();

    public ScaleOpBitmapImpl(ImageOp imageOp, double d) {
        this(imageOp, d, defaultHints);
    }

    public ScaleOpBitmapImpl(ImageOp imageOp, double d, RenderingHints renderingHints) {
        if (imageOp == null) {
            throw new IllegalArgumentException("Attempt to scale null image");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("Cannot scale image at " + d);
        }
        this.sop = imageOp;
        this.scale = d;
        this.hints = renderingHints;
        this.hash = HashCode.hash(d) ^ HashCode.hash(renderingHints) ^ HashCode.hash(imageOp);
    }

    @Override
    public List<Op<?>> getSources() {
        return Collections.singletonList(this.sop);
    }

    @Override
    public BufferedImage eval() throws Exception {
        return ImageUtils.transform(this.sop.getImage(null), this.scale, 0.0, this.hints);
    }

    @Override
    protected void fixSize() {
        this.size = this.getSizeFromCache();
        if (this.size == null) {
            this.size = ImageUtils.transform(new Rectangle(this.sop.getSize()), this.scale, 0.0).getSize();
        }
    }

    @Override
    protected ImageOp createTileOp(int n, int n2) {
        return new TileOp(this, n, n2);
    }

    @Override
    public RenderingHints getHints() {
        return this.hints;
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ScaleOpBitmapImpl)) {
            return false;
        }
        ScaleOpBitmapImpl scaleOpBitmapImpl = (ScaleOpBitmapImpl)object;
        return this.scale == scaleOpBitmapImpl.getScale() && this.sop.equals(scaleOpBitmapImpl.sop) && this.hints.equals(scaleOpBitmapImpl.getHints());
    }

    public int hashCode() {
        return this.hash;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TileOp
    extends AbstractTileOpImpl {
        private final ImageOp sop;
        private final int dx0;
        private final int dy0;
        private final int dw;
        private final int dh;
        private final double scale;
        private final RenderingHints hints;
        private final int hash;
        private static final GeneralFilter.Filter downFilter = new GeneralFilter.Lanczos3Filter();
        private static final GeneralFilter.Filter upFilter = new GeneralFilter.MitchellFilter();

        public TileOp(ScaleOpBitmapImpl scaleOpBitmapImpl, int n, int n2) {
            if (scaleOpBitmapImpl == null) {
                throw new IllegalArgumentException();
            }
            if (n < 0 || n >= scaleOpBitmapImpl.getNumXTiles() || n2 < 0 || n2 >= scaleOpBitmapImpl.getNumYTiles()) {
                throw new IndexOutOfBoundsException();
            }
            this.sop = scaleOpBitmapImpl.sop;
            this.scale = scaleOpBitmapImpl.getScale();
            this.hints = scaleOpBitmapImpl.getHints();
            Rectangle rectangle = new Rectangle(0, 0, (int)((double)this.sop.getWidth() * this.scale), (int)((double)this.sop.getHeight() * this.scale));
            this.dx0 = n * scaleOpBitmapImpl.getTileWidth();
            this.dy0 = n2 * scaleOpBitmapImpl.getTileHeight();
            this.dw = Math.min(scaleOpBitmapImpl.getTileWidth(), rectangle.width - this.dx0);
            this.dh = Math.min(scaleOpBitmapImpl.getTileHeight(), rectangle.height - this.dy0);
            this.size = new Dimension(this.dw, this.dh);
            int n3 = 1;
            n3 = 31 * n3 + HashCode.hash(this.sop);
            n3 = 31 * n3 + HashCode.hash(this.dx0);
            n3 = 31 * n3 + HashCode.hash(this.dy0);
            n3 = 31 * n3 + HashCode.hash(this.dw);
            this.hash = n3 = 31 * n3 + HashCode.hash(this.dh);
        }

        @Override
        public List<Op<?>> getSources() {
            return Collections.singletonList(this.sop);
        }

        @Override
        public BufferedImage eval() throws Exception {
            if (this.dw < 1 || this.dh < 1) {
                return ImageUtils.NULL_IMAGE;
            }
            BufferedImage bufferedImage = ImageUtils.coerceToIntType(this.sop.getImage(null));
            Rectangle rectangle = new Rectangle(0, 0, (int)((double)this.sop.getWidth() * this.scale), (int)((double)this.sop.getHeight() * this.scale));
            WritableRaster writableRaster = bufferedImage.getColorModel().createCompatibleWritableRaster(this.dw, this.dh).createWritableTranslatedChild(this.dx0, this.dy0);
            GeneralFilter.zoom(writableRaster, rectangle, bufferedImage, this.scale < 1.0 ? downFilter : upFilter);
            return ImageUtils.toCompatibleImage(new BufferedImage(bufferedImage.getColorModel(), writableRaster.createWritableTranslatedChild(0, 0), bufferedImage.isAlphaPremultiplied(), null));
        }

        @Override
        protected void fixSize() {
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || !(object instanceof TileOp)) {
                return false;
            }
            TileOp tileOp = (TileOp)object;
            return this.dx0 == tileOp.dx0 && this.dy0 == tileOp.dy0 && this.dw == tileOp.dw && this.dh == tileOp.dh && this.scale == tileOp.scale && this.sop.equals(tileOp.sop);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

