/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.build.GameModule;
import VASSAL.tools.DataArchive;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageNotFoundException;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.AbstractTiledOpImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.SourceOp;
import VASSAL.tools.imageop.SourceTileOpBitmapImpl;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceOpBitmapImpl
extends AbstractTiledOpImpl
implements SourceOp {
    protected final String name;
    protected final int hash;
    protected final DataArchive archive;

    public SourceOpBitmapImpl(String string) {
        this(string, GameModule.getGameModule().getDataArchive());
    }

    public SourceOpBitmapImpl(String string, DataArchive dataArchive) {
        if (string == null || string.length() == 0 || dataArchive == null) {
            throw new IllegalArgumentException();
        }
        this.name = string;
        this.archive = dataArchive;
        this.hash = string.hashCode() ^ dataArchive.hashCode();
    }

    @Override
    public List<VASSAL.tools.opcache.Op<?>> getSources() {
        return Collections.emptyList();
    }

    @Override
    public BufferedImage eval() throws ImageIOException {
        InputStream inputStream = null;
        try {
            inputStream = this.archive.getImageInputStream(this.name);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ImageNotFoundException(this.name, (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new ImageIOException(this.name, (Throwable)iOException);
        }
        return ImageUtils.getImage(this.name, inputStream);
    }

    @Override
    protected void fixSize() {
        this.size = this.getSizeFromCache();
        if (this.size == null) {
            this.size = this.getImageSize();
        }
    }

    protected Dimension getImageSize() {
        try {
            InputStream inputStream = null;
            try {
                inputStream = this.archive.getImageInputStream(this.name);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ImageNotFoundException(this.name, (Throwable)fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new ImageIOException(this.name, (Throwable)iOException);
            }
            return ImageUtils.getImageSize(this.name, inputStream);
        }
        catch (IOException iOException) {
            if (!Op.handleException(iOException)) {
                ErrorDialog.bug(iOException);
            }
            return new Dimension();
        }
    }

    @Override
    protected ImageOp createTileOp(int n, int n2) {
        return new SourceTileOpBitmapImpl(this, n, n2);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof SourceOpBitmapImpl)) {
            return false;
        }
        SourceOpBitmapImpl sourceOpBitmapImpl = (SourceOpBitmapImpl)object;
        return this.archive == sourceOpBitmapImpl.archive && this.name.equals(sourceOpBitmapImpl.name);
    }

    public int hashCode() {
        return this.hash;
    }
}

