/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imports.adc2;

import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.Widget;
import VASSAL.build.module.ChartWindow;
import VASSAL.build.module.DiceButton;
import VASSAL.build.module.Map;
import VASSAL.build.module.MultiActionButton;
import VASSAL.build.module.PieceWindow;
import VASSAL.build.module.PlayerHand;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.PrototypeDefinition;
import VASSAL.build.module.PrototypesContainer;
import VASSAL.build.module.ToolbarMenu;
import VASSAL.build.module.map.BoardPicker;
import VASSAL.build.module.map.CounterDetailViewer;
import VASSAL.build.module.map.DrawPile;
import VASSAL.build.module.map.LOS_Thread;
import VASSAL.build.module.map.LayeredPieceCollection;
import VASSAL.build.module.map.MassKeyCommand;
import VASSAL.build.module.map.SetupStack;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.ZonedGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.build.module.turn.ListTurnLevel;
import VASSAL.build.module.turn.TurnTracker;
import VASSAL.build.widget.CardSlot;
import VASSAL.build.widget.Chart;
import VASSAL.build.widget.HtmlChart;
import VASSAL.build.widget.ListWidget;
import VASSAL.build.widget.PieceSlot;
import VASSAL.build.widget.TabWidget;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.Decorator;
import VASSAL.counters.Delete;
import VASSAL.counters.DynamicProperty;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.Embellishment;
import VASSAL.counters.Footprint;
import VASSAL.counters.FreeRotator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Hideable;
import VASSAL.counters.Marker;
import VASSAL.counters.MovementMarkable;
import VASSAL.counters.Obscurable;
import VASSAL.counters.PropertySheet;
import VASSAL.counters.Replace;
import VASSAL.counters.ReturnToDeck;
import VASSAL.counters.UsePrototype;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.filechooser.ExtensionFileFilter;
import VASSAL.tools.imports.FileFormatException;
import VASSAL.tools.imports.Importer;
import VASSAL.tools.imports.adc2.ADC2Utils;
import VASSAL.tools.imports.adc2.MapBoard;
import VASSAL.tools.imports.adc2.SymbolSet;
import VASSAL.tools.io.IOUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class ADC2Module
extends Importer {
    private static final String FLIP_DEFINITIONS = "Flip Definitions";
    private static final String ADD_NEW_PIECES = "Add New Pieces";
    private static final String PC_NAME = "$pcName$";
    private static final String CHARTS = "Charts";
    private static final String TRAY = "Tray";
    private static final String FORCE_POOL_PNG = "forcePool.png";
    private static final String FORCE_POOL = "Force Pool";
    private static final String DECKS = "Decks";
    private static final int FORCE_POOL_BLOCK_END = 30000;
    public static final String DRAW_ON_TOP_OF_OTHERS = "Draw on top of others?";
    public static final String PIECE = "Pieces";
    public static final double[] FACING_ANGLES;
    private final HashSet<String> uniquePieceNames = new HashSet();
    public static boolean usePieceNames;
    private HashMap<Integer, SymbolSet> cardDecks = new HashMap();
    protected static final int ALL_PLAYERS = 200;
    protected static final int NO_PLAYERS = 201;
    public static final String COMMON_PROPERTIES = "Common Properties";
    private String name;
    private MapBoard map = null;
    private int gameTurn = -1;
    private final ArrayList<PieceClass> pieceClasses = new ArrayList();
    private final ArrayList<Piece> pieces = new ArrayList();
    private final ArrayList<Player> players = new ArrayList();
    private final HashMap<Integer, ArrayList<Piece>> stacks = new HashMap();
    private final HashMap<Integer, ArrayList<Piece>> forcePoolHashMap = new HashMap();
    private ForcePoolList forcePools = new ForcePoolList();
    private final String[] classValues = new String[8];
    private final String[] pieceValues = new String[8];
    private FacingDirection[] allowedFacings;
    private HashMap<StateFlag, HashMap<Dimension, String>> hiddenFlagImages;
    private int version;
    private int classCombatSummaryValues;
    private int pieceCombatSummaryValues;
    private final StatusDots[] statusDots = new StatusDots[6];
    private final ArrayList<String> turnNames = new ArrayList();
    private boolean useLOS;
    private String deckName;
    private int nCardSets;
    private final String[] infoPages = new String[10];
    private String infoPageName;
    public static final Color FLAG_BACKGROUND;
    public static final Color FLAG_FOREGROUND;
    private int nFlipDefs = 0;
    private PieceWindow flipDefs;
    private PieceWindow pieceWin;

    protected PieceClass getClassFromIndex(int n) {
        if (n < 0 || n >= this.pieceClasses.size()) {
            return null;
        }
        return this.pieceClasses.get(n);
    }

    protected SymbolSet getCardDeck(int n) throws IOException {
        SymbolSet symbolSet = this.cardDecks.get(n);
        if (symbolSet == null) {
            File file = this.action.getCaseInsensitiveFile(new File(this.deckName + "-c" + (n + 1) + ".set"), this.file, true, new ExtensionFileFilter("ADC2 Symbol Set", new String[]{".set"}));
            if (file == null) {
                throw new FileNotFoundException("Unable to locate deck symbol set.");
            }
            symbolSet = new SymbolSet();
            symbolSet.importCardSet(this.action, file);
            this.cardDecks.put(n, symbolSet);
        }
        return symbolSet;
    }

    private String getFlagTab(int n, StateFlag stateFlag) throws IOException {
        Dimension dimension;
        String string;
        HashMap<Dimension, String> hashMap;
        if (this.hiddenFlagImages == null) {
            this.hiddenFlagImages = new HashMap();
        }
        if ((hashMap = this.hiddenFlagImages.get(stateFlag)) == null) {
            hashMap = new HashMap();
            this.hiddenFlagImages.put(stateFlag, hashMap);
        }
        if ((string = hashMap.get(dimension = new Dimension(0, n))) == null) {
            int n2 = 15;
            int n3 = n < 43 ? (n - n2) / 2 : n2 - 1;
            int n4 = 10;
            BufferedImage bufferedImage = new BufferedImage(n4, n, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.translate(0, n3 * stateFlag.tab);
            stateFlag.drawFlagImage(graphics2D);
            string = ADC2Module.getUniqueImageFileName(stateFlag.name + 0 + "x" + n);
            hashMap.put(dimension, string);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            GameModule.getGameModule().getArchiveWriter().addImage(string, byArray);
        }
        return string;
    }

    private String getFlagLayer(Dimension dimension, StateFlag stateFlag) throws IOException {
        String string;
        HashMap<Dimension, String> hashMap;
        if (this.hiddenFlagImages == null) {
            this.hiddenFlagImages = new HashMap();
        }
        if ((hashMap = this.hiddenFlagImages.get(stateFlag)) == null) {
            hashMap = new HashMap();
            this.hiddenFlagImages.put(stateFlag, hashMap);
        }
        if ((string = hashMap.get(dimension)) == null) {
            int n = 15;
            int n2 = dimension.height < 43 ? (dimension.height - n) / 2 : n - 1;
            int n3 = 10;
            BufferedImage bufferedImage = new BufferedImage(dimension.width + 2 * n3, dimension.height, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.translate(dimension.width + n3, n2 * stateFlag.tab);
            stateFlag.drawFlagImage(graphics2D);
            string = ADC2Module.getUniqueImageFileName(stateFlag.name + dimension.width + "x" + dimension.height);
            hashMap.put(dimension, string);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            GameModule.getGameModule().getArchiveWriter().addImage(string, byArray);
        }
        return string;
    }

    public boolean usePieceValues() {
        for (int i = 0; i < this.pieceValues.length; ++i) {
            if (this.pieceValues[i] == null || this.pieceValues[i].equals("")) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load(File file) throws IOException {
        super.load(file);
        DataInputStream dataInputStream = null;
        try {
            dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            this.name = ADC2Module.stripExtension(file.getName());
            byte by = dataInputStream.readByte();
            if (by != -3 && by != -2) {
                throw new FileFormatException("Invalid Game Module Header");
            }
            this.version = dataInputStream.readUnsignedShort();
            String string = ADC2Module.readWindowsFileName(dataInputStream);
            String string2 = ADC2Module.forceExtension(string, "map");
            this.map = new MapBoard();
            File file2 = this.action.getCaseInsensitiveFile(new File(string2), file, true, new ExtensionFileFilter("ADC2 Map Board", new String[]{".map"}));
            if (file2 == null) {
                throw new FileNotFoundException("Unable to locate map file.");
            }
            this.map.importFile(this.action, file2);
            try {
                this.readGameTurnBlock(dataInputStream);
                this.readClassBlock(dataInputStream);
                this.readClassValueBlock(dataInputStream);
                this.readPieceBlock(dataInputStream);
                this.readPieceValueBlock(dataInputStream);
                this.readPlayerBlock(dataInputStream);
                this.readReplayBlock(dataInputStream);
                this.readPoolBlock(dataInputStream);
                this.readStackBlock(dataInputStream);
                this.readCombatSummaryBlock(dataInputStream);
                this.readFacingBlock(dataInputStream);
                this.readSoundSettingBlock(dataInputStream);
                this.readFlipDefinitionBlock(dataInputStream);
                this.readPieceStatusDotsBlock(dataInputStream);
                this.readDiceBlock(dataInputStream);
                this.readTurnNameBlock(dataInputStream);
                this.readLOSBlock(dataInputStream);
                this.readLOSFlagBlock(dataInputStream);
                this.readDeckNameBlock(dataInputStream);
                this.readPoolOwnerBlock(dataInputStream);
                this.readAutoRevealWhenMovingLOSFlagBlock(dataInputStream);
                this.readCombatRevealFlagBlock(dataInputStream);
                this.readInfoPageBlock(dataInputStream);
                this.readInfoSizeBlock(dataInputStream);
                this.readAllianceBlock(dataInputStream);
                this.readDrawOptionsBlock(dataInputStream);
                this.readPieceStatusDotsBlock(dataInputStream);
            }
            catch (ADC2Utils.NoMoreBlocksException noMoreBlocksException) {
                // empty catch block
            }
            dataInputStream.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(dataInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(dataInputStream);
    }

    private void readDrawOptionsBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Draw Options");
        boolean bl = dataInputStream.readByte() != 0;
        boolean bl2 = dataInputStream.readByte() != 0;
        boolean bl3 = dataInputStream.readByte() != 0;
        int n = dataInputStream.readUnsignedByte();
        boolean bl4 = (n & 1) > 0;
        boolean bl5 = (n & 2) == 0;
        dataInputStream.read(new byte[4]);
    }

    protected void readAllianceBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Alliances");
        ADC2Utils.readBase250Word(dataInputStream);
        for (int i = 0; i < this.players.size(); ++i) {
            dataInputStream.readUnsignedShort();
            for (int j = 0; j < this.players.size(); ++j) {
                if (dataInputStream.readUnsignedShort() <= 0) continue;
                this.players.get(i).setAlly(this.players.get(j));
            }
        }
    }

    protected void readInfoSizeBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Info Size");
        dataInputStream.read(new byte[4]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readInfoPageBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Info Page");
        this.infoPageName = ADC2Module.readWindowsFileName(dataInputStream);
        if (this.infoPageName.length() > 0) {
            File file = this.action.getCaseInsensitiveFile(new File(ADC2Module.forceExtension(this.infoPageName, "ipx")), this.file, true, new ExtensionFileFilter("Info page file (*.ipx;*.IPX)", new String[]{".ipx"}));
            if (file != null) {
                DataInputStream dataInputStream2 = null;
                try {
                    dataInputStream2 = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                    try {
                        while (true) {
                            if (dataInputStream2.readUnsignedByte() != 59) {
                                continue;
                            }
                            int n = dataInputStream2.readUnsignedByte();
                            int n2 = dataInputStream2.readUnsignedByte();
                            byte[] byArray = new byte[8];
                            dataInputStream2.read(byArray);
                            byte[] byArray2 = new byte[n2];
                            dataInputStream2.read(byArray2);
                            String string = new String(byArray2);
                            if (n < 0 || n >= 10 || this.infoPages[n] != null) continue;
                            this.infoPages[n] = string;
                        }
                    }
                    catch (EOFException eOFException) {
                        dataInputStream2.close();
                        IOUtils.closeQuietly(dataInputStream2);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(dataInputStream2);
                    throw throwable;
                }
            } else {
                this.infoPageName = null;
            }
        }
    }

    protected void readCombatRevealFlagBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Combat Reveal Option Flag");
        dataInputStream.readByte();
    }

    protected void readAutoRevealWhenMovingLOSFlagBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Auto Reveal When Moving (LOS) Flag");
        dataInputStream.readByte();
    }

    protected void readPoolOwnerBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Pool Owner");
        Iterator iterator = this.forcePools.iterator();
        for (int i = 0; i < this.forcePools.size(); ++i) {
            Pool pool = (Pool)iterator.next();
            int n = dataInputStream.readUnsignedByte();
            if (!(pool instanceof Cards)) continue;
            ((Cards)pool).setOwner(n);
        }
    }

    protected void readDeckNameBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Deck Name");
        this.deckName = ADC2Module.stripExtension(ADC2Module.readWindowsFileName(dataInputStream));
    }

    protected void readLOSFlagBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "LOS Flags");
        dataInputStream.readByte();
        byte by = dataInputStream.readByte();
        if (by == 3 || by == 4) {
            this.useLOS = true;
        }
    }

    protected void readLOSBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "LOS");
        dataInputStream.read(new byte[18]);
        dataInputStream.readUnsignedShort();
        dataInputStream.readByte();
        ADC2Utils.readBase250Word(dataInputStream);
        ADC2Module.readNullTerminatedString(dataInputStream, 20);
        dataInputStream.readByte();
        ADC2Utils.readBase250Word(dataInputStream);
        if (this.version > 518) {
            ADC2Utils.readBase250Word(dataInputStream);
            byte[] byArray = new byte[10];
            dataInputStream.read(byArray);
        }
        int n = ADC2Utils.readBase250Word(dataInputStream);
        for (int i = 0; i < n; ++i) {
            ADC2Utils.readBase250Word(dataInputStream);
            ADC2Utils.readBase250Word(dataInputStream);
            ADC2Utils.readBase250Word(dataInputStream);
            ADC2Utils.readBase250Word(dataInputStream);
            ADC2Utils.readBase250Word(dataInputStream);
            byte[] byArray = new byte[3];
            dataInputStream.read(byArray);
        }
    }

    protected void readTurnNameBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Turn Names");
        int n = ADC2Utils.readBase250Word(dataInputStream);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            String string = ADC2Module.readNullTerminatedString(dataInputStream, 50);
            if (string.equals("")) {
                bl = true;
                continue;
            }
            if (bl) continue;
            this.turnNames.add(string);
        }
    }

    protected void readDiceBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Dice");
        dataInputStream.readByte();
        dataInputStream.readByte();
        dataInputStream.readUnsignedByte();
        dataInputStream.readUnsignedByte();
    }

    protected void readPieceStatusDotsBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Piece Status Dots");
        byte[] byArray = new byte[3];
        for (int i = 0; i < 6; ++i) {
            byte by = dataInputStream.readByte();
            int n = ADC2Utils.readBase250Word(dataInputStream);
            int n2 = dataInputStream.readUnsignedByte();
            byte by2 = dataInputStream.readByte();
            dataInputStream.read(byArray);
            this.statusDots[i] = new StatusDots(by, n, ADC2Utils.getColorFromIndex(n2), by2, byArray[2]);
        }
    }

    protected void readFlipDefinitionBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Flip Definition");
        dataInputStream.readUnsignedByte();
        this.nFlipDefs = ADC2Utils.readBase250Word(dataInputStream);
        for (int i = 0; i < this.nFlipDefs; ++i) {
            int n = ADC2Utils.readBase250Word(dataInputStream);
            int n2 = ADC2Utils.readBase250Word(dataInputStream);
            if (n < 0 || n >= this.pieceClasses.size() || n2 < 0 || n2 >= this.pieceClasses.size()) continue;
            this.pieceClasses.get(n).setFlipClass(n2);
            this.pieceClasses.get(n2).setBackFlipClass(n);
        }
    }

    protected void readSoundSettingBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Sound Settings");
        for (int i = 0; i < 3; ++i) {
            dataInputStream.readUnsignedByte();
        }
        dataInputStream.read(new byte[3]);
        dataInputStream.readUnsignedByte();
    }

    protected void readFacingBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Facing");
        int n = dataInputStream.readUnsignedByte();
        this.allowedFacings = new FacingDirection[n + 1];
        this.allowedFacings[0] = FacingDirection.NONE;
        for (int i = 0; i < n; ++i) {
            ADC2Module.readNullTerminatedString(dataInputStream);
            int n2 = dataInputStream.readUnsignedByte();
            if (i == 0 || this.allowedFacings[i] != FacingDirection.NONE) {
                switch (n2) {
                    case 2: {
                        this.allowedFacings[i + 1] = FacingDirection.VERTEX;
                        break;
                    }
                    case 3: {
                        this.allowedFacings[i + 1] = FacingDirection.BOTH;
                        break;
                    }
                    default: {
                        this.allowedFacings[i + 1] = FacingDirection.FLAT_SIDES;
                        break;
                    }
                }
            } else {
                this.allowedFacings[i + 1] = FacingDirection.NONE;
            }
            dataInputStream.readUnsignedByte();
            dataInputStream.readUnsignedByte();
            dataInputStream.readUnsignedByte();
            dataInputStream.read(new byte[3]);
        }
    }

    protected void readCombatSummaryBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Fast Zoom");
        dataInputStream.readUnsignedByte();
        this.classCombatSummaryValues = dataInputStream.readUnsignedByte();
        this.pieceCombatSummaryValues = dataInputStream.readUnsignedByte();
        dataInputStream.readUnsignedByte();
    }

    protected void readStackBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Stack");
        int n = ADC2Utils.readBase250Word(dataInputStream);
        for (int i = 0; i < n; ++i) {
            ADC2Utils.readBase250Word(dataInputStream);
            ADC2Utils.readBase250Word(dataInputStream);
            for (int j = 0; j < 3; ++j) {
                dataInputStream.readUnsignedByte();
            }
            ADC2Utils.readBase250Word(dataInputStream);
        }
    }

    protected void readReplayBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Replay");
        int n = this.version > 515 ? ADC2Utils.readBase250Integer(dataInputStream) : ADC2Utils.readBase250Word(dataInputStream);
        dataInputStream.read(new byte[n]);
    }

    protected void readPoolBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, FORCE_POOL);
        int n = ADC2Utils.readBase250Word(dataInputStream);
        block4: for (int i = 0; i < n; ++i) {
            String string = ADC2Module.readNullTerminatedString(dataInputStream, 25);
            byte by = dataInputStream.readByte();
            dataInputStream.read(new byte[2]);
            int n2 = ADC2Utils.readBase250Word(dataInputStream);
            if (n2 == 30000) break;
            switch (by) {
                case 2: {
                    this.forcePools.add(new HandPool(string, this.forcePoolHashMap.get(i)));
                    continue block4;
                }
                case 3: {
                    this.forcePools.add(new DeckPool(string, this.forcePoolHashMap.get(i)));
                    continue block4;
                }
                default: {
                    this.forcePools.add(new ForcePool(string, this.forcePoolHashMap.get(i)));
                }
            }
        }
    }

    protected void readPlayerBlock(DataInputStream dataInputStream) throws IOException {
        String string;
        ADC2Utils.readBlockHeader(dataInputStream, "Player");
        ADC2Utils.readBase250Word(dataInputStream);
        do {
            string = ADC2Module.readNullTerminatedString(dataInputStream, 25);
            dataInputStream.read(new byte[20]);
            dataInputStream.readByte();
            ADC2Utils.readBase250Word(dataInputStream);
            SymbolSet.SymbolData symbolData = this.getSet().getGamePiece(ADC2Utils.readBase250Word(dataInputStream));
            ADC2Module.readNullTerminatedString(dataInputStream);
            dataInputStream.readUnsignedByte();
            int n = dataInputStream.readUnsignedByte();
            dataInputStream.readByte();
            if (string.length() <= 0) continue;
            Player player = new Player(string, symbolData, n);
            this.players.add(player);
        } while (string.length() > 0);
    }

    protected void readPieceBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, PIECE);
        int n = ADC2Utils.readBase250Word(dataInputStream);
        for (int i = 0; i < n; ++i) {
            HideState hideState;
            String string = ADC2Module.readNullTerminatedString(dataInputStream, 25);
            PieceClass pieceClass = this.getClassFromIndex(ADC2Utils.readBase250Word(dataInputStream));
            if (pieceClass == null) {
                throw new FileFormatException("Invalid Class Index");
            }
            if (string.equals(pieceClass.getName())) {
                string = "";
            }
            int[] nArray = new int[8];
            for (int j = 0; j < nArray.length; ++j) {
                nArray[j] = dataInputStream.readInt();
            }
            ValueType[] valueTypeArray = new ValueType[8];
            block12: for (int j = 0; j < valueTypeArray.length; ++j) {
                switch (dataInputStream.readUnsignedByte()) {
                    case 1: {
                        valueTypeArray[j] = ValueType.NUMERIC;
                        continue block12;
                    }
                    case 2: {
                        valueTypeArray[j] = ValueType.TEXT;
                        continue block12;
                    }
                    case 3: {
                        valueTypeArray[j] = ValueType.YESNO;
                        continue block12;
                    }
                    case 10: {
                        if (j == 0) {
                            valueTypeArray[j] = ValueType.CARD;
                            continue block12;
                        }
                    }
                    default: {
                        valueTypeArray[j] = ValueType.NOT_USED;
                    }
                }
            }
            switch (dataInputStream.readUnsignedByte()) {
                case 0: {
                    hideState = HideState.NOT_HIDDEN;
                    break;
                }
                case 1: {
                    hideState = HideState.INFO_HIDDEN;
                    break;
                }
                default: {
                    hideState = HideState.HIDDEN;
                }
            }
            dataInputStream.read(new byte[2]);
            int n2 = ADC2Utils.readBase250Word(dataInputStream);
            int n3 = dataInputStream.readUnsignedByte();
            int n4 = dataInputStream.readUnsignedByte();
            if (n4 > FACING_ANGLES.length) {
                n4 = 0;
            }
            Piece piece = new Piece(n2, string, pieceClass, hideState, n3, n4);
            for (int j = 0; j < nArray.length; ++j) {
                piece.setValue(j, nArray[j]);
                ((Piece)piece).types[j] = valueTypeArray[j];
            }
            this.pieces.add(piece);
        }
    }

    protected void readClassValueBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Class Value");
        for (int i = 0; i < this.classValues.length; ++i) {
            this.classValues[i] = ADC2Module.readNullTerminatedString(dataInputStream, 15);
        }
    }

    protected void readPieceValueBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Piece Value");
        for (int i = 0; i < this.pieceValues.length; ++i) {
            this.pieceValues[i] = ADC2Module.readNullTerminatedString(dataInputStream, 15);
        }
    }

    protected void readClassBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Class");
        int n = ADC2Utils.readBase250Word(dataInputStream);
        for (int i = 0; i < n; ++i) {
            PieceClass pieceClass;
            int n2;
            int n3;
            int n4;
            int n5 = ADC2Utils.readBase250Word(dataInputStream);
            String string = ADC2Module.readNullTerminatedString(dataInputStream, 25);
            int[] nArray = new int[8];
            for (n4 = 0; n4 < nArray.length; ++n4) {
                nArray[n4] = dataInputStream.readInt();
            }
            n4 = 0;
            int n6 = 0;
            ValueType[] valueTypeArray = new ValueType[8];
            block7: for (n3 = 0; n3 < valueTypeArray.length; ++n3) {
                n2 = dataInputStream.readUnsignedByte();
                if (n3 == 0 && n2 == 10) {
                    n4 = 1;
                }
                if (n4 != 0) {
                    if (n3 == 1) {
                        n6 = n2;
                    }
                    if (n6 < this.nCardSets) continue;
                    this.nCardSets = n6 + 1;
                    continue;
                }
                switch (n2) {
                    case 1: {
                        valueTypeArray[n3] = ValueType.NUMERIC;
                        continue block7;
                    }
                    case 2: {
                        valueTypeArray[n3] = ValueType.TEXT;
                        continue block7;
                    }
                    case 3: {
                        valueTypeArray[n3] = ValueType.YESNO;
                        continue block7;
                    }
                    default: {
                        valueTypeArray[n3] = ValueType.NOT_USED;
                    }
                }
            }
            n3 = dataInputStream.readUnsignedByte();
            n2 = ADC2Utils.readBase250Word(dataInputStream);
            int n7 = dataInputStream.readUnsignedByte();
            if (n4 != 0) {
                pieceClass = new CardClass(string, n5, n6);
            } else {
                pieceClass = new PieceClass(string, this.getSet().getGamePiece(n5), n3, n2, n7);
                for (int j = 0; j < nArray.length; ++j) {
                    pieceClass.setValue(j, nArray[j]);
                    ((PieceClass)pieceClass).types[j] = valueTypeArray[j];
                }
            }
            this.pieceClasses.add(pieceClass);
        }
    }

    protected void readGameTurnBlock(DataInputStream dataInputStream) throws IOException {
        ADC2Utils.readBlockHeader(dataInputStream, "Game Turn");
        this.gameTurn = ADC2Utils.readBase250Word(dataInputStream);
    }

    protected void writePrototypesToArchive(GameModule gameModule) {
        PrototypesContainer prototypesContainer = gameModule.getAllDescendantComponentsOf(PrototypesContainer.class).iterator().next();
        PrototypeDefinition prototypeDefinition = new PrototypeDefinition();
        ADC2Module.insertComponent(prototypeDefinition, prototypesContainer);
        prototypeDefinition.setConfigureName(COMMON_PROPERTIES);
        EditablePiece editablePiece = new BasicPiece();
        Delete delete = new Delete();
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append("Delete").append(KeyStroke.getKeyStroke("DELETE"));
        delete.mySetType("delete;" + sequenceEncoder.getValue());
        delete.setInner(editablePiece);
        editablePiece = delete;
        if (this.forcePools.count(ForcePool.class) > 0) {
            editablePiece = new ReturnToDeck("return;Return to Force Pool;R;;Select Force Pool", editablePiece);
        }
        sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(KeyStroke.getKeyStroke(84, 2)).append("Movement Trail").append(false).append(false).append(10).append(Color.WHITE).append(Color.BLACK).append(100).append(0);
        editablePiece = new Footprint("footprint;" + sequenceEncoder.getValue(), editablePiece);
        sequenceEncoder = new SequenceEncoder(',');
        sequenceEncoder.append("Type");
        editablePiece = new Marker("mark;" + sequenceEncoder.getValue(), editablePiece);
        editablePiece.setProperty("Type", PIECE);
        prototypeDefinition.setPiece(editablePiece);
    }

    public void writeToArchive() throws IOException {
        GameModule gameModule = GameModule.getGameModule();
        gameModule.setAttribute("name", this.name);
        this.writePrototypesToArchive(gameModule);
        this.getMap().writeToArchive();
        this.configureStatusFlagButtons();
        this.configureMapLayers();
        this.pieceWin = gameModule.getAllDescendantComponentsOf(PieceWindow.class).iterator().next();
        this.configureFlipDefinitions(gameModule);
        this.writeClassesToArchive(gameModule);
        this.writeForcePoolsToArchive(gameModule);
        this.writeDecksToArchive(gameModule);
        this.writeHandsToArchive(gameModule);
        this.writeInfoPagesToArchive(gameModule);
        this.writeToolbarMenuToArchive(gameModule);
        this.writeSetupStacksToArchive(gameModule);
        this.writePlayersToArchive(gameModule);
        this.configureMouseOverStackViewer(gameModule);
        this.configureMainMap(gameModule);
        this.configureDiceRoller(gameModule);
        if (this.turnNames.size() > 1) {
            this.configureTurnCounter(gameModule);
        }
        if (this.useLOS) {
            ADC2Module.insertComponent(new LOS_Thread(), gameModule);
        }
    }

    private void configureFlipDefinitions(GameModule gameModule) {
        if (this.nFlipDefs > 0) {
            this.flipDefs = new PieceWindow();
            ADC2Module.insertComponent(this.flipDefs, gameModule);
            this.flipDefs.setAttribute("name", FLIP_DEFINITIONS);
            this.flipDefs.setAttribute("hidden", Boolean.TRUE);
            this.flipDefs.setAttribute("text", "");
            this.flipDefs.setAttribute("tooltip", "");
            ListWidget listWidget = new ListWidget();
            ADC2Module.insertComponent(listWidget, this.flipDefs);
        }
    }

    private void configureMainMap(GameModule gameModule) throws IOException {
        Map map = this.getMainMap();
        map.setAttribute("markUnmovedIcon", StateFlag.MOVE.getStatusIconName());
    }

    private void configureStatusFlagButtons() throws IOException {
        String string = StateFlag.ATTACK.getStatusIconName();
        MassKeyCommand massKeyCommand = new MassKeyCommand();
        ADC2Module.insertComponent(massKeyCommand, this.getMainMap());
        massKeyCommand.setAttribute("tooltip", "Clear attacked status");
        massKeyCommand.setAttribute("buttonText", "Attacked");
        massKeyCommand.setAttribute("buttonHotkey", null);
        massKeyCommand.setAttribute("icon", string);
        massKeyCommand.setAttribute("name", "Attacked");
        massKeyCommand.setAttribute("hotkey", KeyStroke.getKeyStroke(65, 128));
        massKeyCommand.setAttribute("filter", "Mark Attacked_Active = true");
        massKeyCommand.setAttribute("deckCount", new Integer(-1));
        massKeyCommand.setAttribute("reportSingle", Boolean.TRUE);
        massKeyCommand.setAttribute("reportFormat", "");
        string = StateFlag.DEFEND.getStatusIconName();
        massKeyCommand = new MassKeyCommand();
        ADC2Module.insertComponent(massKeyCommand, this.getMainMap());
        massKeyCommand.setAttribute("tooltip", "Clear defended status");
        massKeyCommand.setAttribute("buttonText", "Defended");
        massKeyCommand.setAttribute("buttonHotkey", null);
        massKeyCommand.setAttribute("icon", string);
        massKeyCommand.setAttribute("name", "Defended");
        massKeyCommand.setAttribute("hotkey", KeyStroke.getKeyStroke(68, 128));
        massKeyCommand.setAttribute("filter", "Mark Defended_Active = true");
        massKeyCommand.setAttribute("deckCount", new Integer(-1));
        massKeyCommand.setAttribute("reportSingle", Boolean.TRUE);
        massKeyCommand.setAttribute("reportFormat", "");
        MultiActionButton multiActionButton = new MultiActionButton();
        ADC2Module.insertComponent(multiActionButton, this.getMainMap());
        multiActionButton.setAttribute("text", "");
        multiActionButton.setAttribute("tooltip", "Clear combat status flags.");
        multiActionButton.setAttribute("icon", StateFlag.COMBAT.getStatusIconName());
        multiActionButton.setAttribute("hotkey", KeyStroke.getKeyStroke(67, 128));
        multiActionButton.setAttribute("menuItems", StringArrayConfigurer.arrayToString(new String[]{"Attacked", "Defended"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeInfoPagesToArchive(GameModule gameModule) throws IOException {
        if (this.infoPageName != null && !this.infoPageName.equals("")) {
            ChartWindow chartWindow = new ChartWindow();
            ADC2Module.insertComponent(chartWindow, gameModule);
            chartWindow.setAttribute("name", CHARTS);
            chartWindow.setAttribute("text", CHARTS);
            chartWindow.setAttribute("tooltip", CHARTS);
            chartWindow.setAttribute("hotkey", KeyStroke.getKeyStroke(67, 128));
            TabWidget tabWidget = new TabWidget();
            ADC2Module.insertComponent(tabWidget, chartWindow);
            for (int i = 0; i < this.infoPages.length; ++i) {
                Widget widget;
                File file = this.action.getCaseInsensitiveFile(new File(ADC2Module.forceExtension(this.infoPageName, "b" + i)), this.file, false, null);
                if (file == null) {
                    file = this.action.getCaseInsensitiveFile(new File(ADC2Module.forceExtension(this.infoPageName, "t" + i)), this.file, false, null);
                }
                if (file == null) continue;
                Boolean bl = Character.toLowerCase(ADC2Module.getExtension(file.getName()).charAt(0)) == 'b';
                if (bl.booleanValue()) {
                    widget = new Chart();
                    ADC2Module.insertComponent(widget, tabWidget);
                    widget.setAttribute("chartName", this.infoPages[i]);
                    gameModule.getArchiveWriter().addImage(file.getPath(), file.getName());
                    widget.setAttribute("fileName", file);
                } else {
                    widget = new HtmlChart();
                    ADC2Module.insertComponent(widget, tabWidget);
                    widget.setAttribute("chartName", this.infoPages[i]);
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("<html><body>");
                    BufferedReader bufferedReader = null;
                    try {
                        bufferedReader = new BufferedReader(new FileReader(file));
                        String string = null;
                        do {
                            if ((string = bufferedReader.readLine()) == null || string.length() <= 0) continue;
                            string = string.replaceAll(" (?: )", "&nbsp;");
                            string = string.replaceAll("(?<=&nbsp;) ", "&nbsp;");
                            string = string.replaceFirst("^ ", "&nbsp;");
                            stringBuilder.append("<p>" + string + "</p>");
                        } while (string != null);
                        stringBuilder.append("</body></html>");
                        gameModule.getArchiveWriter().addFile(file.getName(), stringBuilder.toString().getBytes());
                        widget.setAttribute("fileName", file.getName());
                        bufferedReader.close();
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(bufferedReader);
                        throw throwable;
                    }
                    IOUtils.closeQuietly(bufferedReader);
                }
                tabWidget.propertyChange(new PropertyChangeEvent(widget, "name", "", this.infoPages[i]));
            }
        }
    }

    protected void configureMapLayers() {
        LayeredPieceCollection layeredPieceCollection = this.getLayeredPieceCollection();
        String string = layeredPieceCollection.getAttributeValueString("layerOrder");
        string = string.equals("") ? "0,1" : string + ",0,1";
        layeredPieceCollection.setAttribute("layerOrder", string);
    }

    protected void configureTurnCounter(GameModule gameModule) {
        TurnTracker turnTracker = new TurnTracker();
        ADC2Module.insertComponent(turnTracker, gameModule);
        turnTracker.setAttribute("turnFormat", "$level1$");
        ListTurnLevel listTurnLevel = new ListTurnLevel();
        ADC2Module.insertComponent(listTurnLevel, turnTracker);
        listTurnLevel.setAttribute("property", "currentTurn");
        String[] stringArray = new String[this.turnNames.size()];
        listTurnLevel.setAttribute("list", StringArrayConfigurer.arrayToString(this.turnNames.toArray(stringArray)));
    }

    protected void configureDiceRoller(GameModule gameModule) {
        DiceButton diceButton = new DiceButton();
        ADC2Module.insertComponent(diceButton, gameModule);
        diceButton.setAttribute("name", "Roll");
        diceButton.setAttribute("prompt", Boolean.TRUE);
        diceButton.setAttribute("tooltip", "Roll the dice");
        diceButton.setAttribute("text", "Roll");
        diceButton.setAttribute("reportFormat", "** $name$ $nDice$d$nSides$ (+$plus$ each) = $result$ *** <$playerName$>");
    }

    protected void configureMouseOverStackViewer(GameModule gameModule) {
        int n;
        CounterDetailViewer counterDetailViewer = gameModule.getAllDescendantComponentsOf(CounterDetailViewer.class).iterator().next();
        counterDetailViewer.setAttribute("display", "by using a property filter");
        counterDetailViewer.setAttribute("propertyFilter", "Type = Pieces");
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 1;
        for (n = 0; n < this.classValues.length; ++n) {
            if (this.classValues[n] != null && !this.classValues[n].equals("") && (this.classCombatSummaryValues & n2) > 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('-');
                }
                stringBuilder.append("$sum(" + this.classValues[n] + ")$");
            }
            n2 <<= 1;
        }
        n2 = 1;
        for (n = 0; n < this.pieceValues.length; ++n) {
            if (this.pieceValues[n] != null && !this.pieceValues[n].equals("") && (this.pieceCombatSummaryValues & n2) > 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('-');
                }
                stringBuilder.append("$sum(" + this.pieceValues[n] + ")$");
            }
            n2 <<= 1;
        }
        counterDetailViewer.setAttribute("showtext", Boolean.TRUE);
        if (stringBuilder.length() > 0) {
            stringBuilder.append(' ');
        }
        counterDetailViewer.setAttribute("minDisplayPieces", "1");
        counterDetailViewer.setAttribute("summaryReportFormat", stringBuilder.toString() + "($LocationName$)");
        if (usePieceNames) {
            counterDetailViewer.setAttribute("counterReportFormat", PC_NAME);
        }
        counterDetailViewer.setAttribute("unrotatePieces", Boolean.TRUE);
        counterDetailViewer.setAttribute("bgColor", Color.WHITE);
    }

    protected void writeClassesToArchive(GameModule gameModule) throws IOException {
        this.pieceWin.setAttribute("name", ADD_NEW_PIECES);
        ListWidget listWidget = new ListWidget();
        ADC2Module.insertComponent(listWidget, this.pieceWin);
        for (PieceClass pieceClass : this.pieceClasses) {
            pieceClass.writeToArchive(listWidget);
        }
    }

    protected void writePlayersToArchive(GameModule gameModule) {
        PlayerRoster playerRoster = gameModule.getAllDescendantComponentsOf(PlayerRoster.class).iterator().next();
        SequenceEncoder sequenceEncoder = new SequenceEncoder(',');
        for (Player player : this.players) {
            if (player.allies.first() != player) continue;
            sequenceEncoder.append(player.getName());
        }
        for (int i = 0; i < 2; ++i) {
            playerRoster.setAttribute("sides", sequenceEncoder.getValue());
        }
    }

    protected void writeHandsToArchive(GameModule gameModule) throws IOException {
        int n = this.forcePools.count(HandPool.class);
        if (n == 0) {
            return;
        }
        Iterator<Pool> iterator = this.forcePools.iterator(HandPool.class);
        while (iterator.hasNext()) {
            Object object;
            HandPool handPool = (HandPool)iterator.next();
            PlayerHand playerHand = new PlayerHand();
            ADC2Module.insertComponent(playerHand, gameModule);
            if (handPool.getOwner() == Player.ALL_PLAYERS) {
                object = new String[this.players.size()];
                for (int i = 0; i < this.players.size(); ++i) {
                    object[i] = this.players.get(i).getName();
                }
                playerHand.setAttribute("side", StringArrayConfigurer.arrayToString(object));
            } else {
                playerHand.setAttribute("side", handPool.getOwner().getName());
            }
            playerHand.setAttribute("visible", Boolean.TRUE);
            playerHand.setAttribute("mapName", handPool.name);
            playerHand.setAttribute("markMoved", "Never");
            playerHand.setAttribute("launch", Boolean.TRUE);
            playerHand.setAttribute("buttonName", handPool.getButtonName());
            object = playerHand.getBoardPicker();
            Board board = new Board();
            ADC2Module.insertComponent(board, (Buildable)object);
            board.setConfigureName(handPool.name);
            List<Piece> list = handPool.getPieces();
            if (this.pieces.size() <= 0) continue;
            SetupStack setupStack = new SetupStack();
            ADC2Module.insertComponent(setupStack, playerHand);
            Dimension dimension = this.getMaxDeckSize();
            Point point = new Point(dimension.width / 2 + 10, dimension.height / 2 + 10);
            setupStack.setAttribute("name", handPool.name);
            setupStack.setAttribute("owningBoard", board.getConfigureName());
            setupStack.setAttribute("x", Integer.toString(point.x));
            setupStack.setAttribute("y", Integer.toString(point.y));
            for (Piece piece : list) {
                piece.writeToArchive(setupStack);
            }
        }
    }

    protected void writeDecksToArchive(GameModule gameModule) throws IOException {
        Object object;
        Object object2;
        Object object3;
        int n = this.forcePools.count(DeckPool.class);
        if (n == 0) {
            return;
        }
        Map map = new Map();
        ADC2Module.insertComponent(map, gameModule);
        map.setMapName(DECKS);
        map.setAttribute("markMoved", "Never");
        map.setAttribute("launch", Boolean.TRUE);
        map.setAttribute("buttonName", DECKS);
        map.setAttribute("hotkey", KeyStroke.getKeyStroke(68, 128));
        BoardPicker boardPicker = map.getBoardPicker();
        Dimension dimension = this.getMaxDeckSize();
        boolean bl = dimension.width > dimension.height;
        JPanel jPanel = new JPanel();
        JPanel[] jPanelArray = new JPanel[n];
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Iterator<Pool> iterator = this.forcePools.iterator(DeckPool.class);
        for (int i = 0; i < n; ++i) {
            object3 = iterator.next();
            jPanelArray[i] = new JPanel();
            jPanelArray[i].setPreferredSize(dimension);
            jPanelArray[i].setMaximumSize(dimension);
            jPanelArray[i].setBorder(BorderFactory.createLoweredBevelBorder());
            if (bl) {
                gridBagConstraints.gridy = i * 2;
                gridBagConstraints.gridx = 1;
            } else {
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridx = i;
            }
            gridBagConstraints.insets.bottom = 2;
            gridBagConstraints.insets.top = 5;
            jPanel.add((Component)jPanelArray[i], gridBagConstraints);
            object2 = ((Cards)object3).getOwner() == Player.ALL_PLAYERS ? ((Pool)object3).name : (((Cards)object3).getOwner() == Player.NO_PLAYERS ? ((Pool)object3).name : ((Pool)object3).name + " (" + ((Cards)object3).getOwner().getName() + ")");
            object = new JLabel((String)object2);
            ((JLabel)object).setHorizontalAlignment(0);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets.top = 2;
            gridBagConstraints.insets.bottom = 5;
            jPanel.add((Component)object, gridBagConstraints);
        }
        Dimension dimension2 = jPanel.getPreferredSize();
        jPanel.setSize(dimension2);
        jPanel.doLayout();
        object3 = new BufferedImage(dimension2.width, dimension2.height, 1);
        object2 = ((BufferedImage)object3).createGraphics();
        jPanel.printAll((Graphics)object2);
        object = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)object3, "png", (OutputStream)object);
        byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
        gameModule.getArchiveWriter().addImage("decks.png", byArray);
        Board board = new Board();
        ADC2Module.insertComponent(board, boardPicker);
        board.setConfigureName(DECKS);
        board.setAttribute("image", "decks.png");
        Rectangle rectangle = new Rectangle();
        iterator = this.forcePools.iterator(DeckPool.class);
        for (int i = 0; i < n; ++i) {
            Pool pool = iterator.next();
            DrawPile drawPile = new DrawPile();
            ADC2Module.insertComponent(drawPile, map);
            JPanel jPanel2 = jPanelArray[i];
            jPanel2.getBounds(rectangle);
            drawPile.setAttribute("owningBoard", DECKS);
            drawPile.setAttribute("x", rectangle.x + rectangle.width / 2);
            drawPile.setAttribute("y", rectangle.y + rectangle.height / 2);
            drawPile.setAttribute("width", rectangle.width);
            drawPile.setAttribute("height", rectangle.height);
            drawPile.setAttribute("faceDown", "Always");
            drawPile.setAttribute("drawFaceUp", Boolean.FALSE);
            drawPile.setAttribute("shuffle", "Never");
            drawPile.setAttribute("reversible", Boolean.FALSE);
            drawPile.setAttribute("allowMultiple", Boolean.TRUE);
            drawPile.setAttribute("allowSelect", ((Cards)pool).getOwner() == Player.ALL_PLAYERS);
            drawPile.setAttribute("reshufflable", Boolean.FALSE);
            drawPile.setAttribute("name", pool.name);
            drawPile.setAttribute("shuffle", "Via right-click Menu");
            drawPile.setAttribute("shuffleFormat", "$playerName$ reshuffles $deckName$");
            drawPile.setAttribute("shuffleHotkey", KeyStroke.getKeyStroke(83, 128));
            for (Piece piece : pool.getPieces()) {
                piece.writeToArchive(drawPile);
            }
        }
    }

    protected void writeToolbarMenuToArchive(GameModule gameModule) {
        int n = this.forcePools.count(HandPool.class);
        if (n == 0) {
            return;
        }
        ToolbarMenu toolbarMenu = new ToolbarMenu();
        ADC2Module.insertComponent(toolbarMenu, gameModule);
        toolbarMenu.setAttribute("text", "Windows");
        toolbarMenu.setAttribute("tooltip", "Open trays, decks, charts, and hands.");
        String[] stringArray = new String[n + 3];
        stringArray[0] = TRAY;
        stringArray[1] = DECKS;
        int n2 = 2;
        if (this.infoPageName != null) {
            stringArray[2] = CHARTS;
            n2 = 3;
        }
        Iterator<Pool> iterator = this.forcePools.iterator(HandPool.class);
        for (int i = 0; i < n; ++i) {
            stringArray[i + n2] = iterator.next().getButtonName();
        }
        toolbarMenu.setAttribute("menuItems", StringArrayConfigurer.arrayToString(stringArray));
    }

    private Dimension getMaxDeckSize() throws IOException {
        Dimension dimension = new Dimension(0, 0);
        for (int i = 0; i < this.nCardSets; ++i) {
            this.getCardDeck(i).getMaxSize(dimension);
        }
        return dimension;
    }

    /*
     * WARNING - void declaration
     */
    protected void writeForcePoolsToArchive(GameModule gameModule) throws IOException {
        void object3;
        int n = this.forcePools.count(ForcePool.class);
        if (n == 0) {
            return;
        }
        GameModule gameModule2 = GameModule.getGameModule();
        Map map = new Map();
        ADC2Module.insertComponent(map, gameModule2);
        map.setMapName(TRAY);
        map.setAttribute("markMoved", "Never");
        map.setAttribute("launch", Boolean.TRUE);
        map.setAttribute("buttonName", TRAY);
        map.setAttribute("hotkey", KeyStroke.getKeyStroke(84, 128));
        BoardPicker boardPicker = map.getBoardPicker();
        Dimension dimension = this.getSet().getModalSize();
        dimension.height = dimension.height * 3 / 2;
        dimension.width = dimension.width * 3 / 2;
        JPanel jPanel = new JPanel();
        JPanel[] jPanelArray = new JPanel[n];
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        int n2 = (int)Math.sqrt(n);
        Iterator<Pool> iterator = this.forcePools.iterator(ForcePool.class);
        boolean i = false;
        while (object3 < n) {
            ForcePool bufferedImage = (ForcePool)iterator.next();
            jPanelArray[object3] = new JPanel();
            jPanelArray[object3].setBorder(BorderFactory.createLoweredBevelBorder());
            gridBagConstraints.gridy = object3 / n2 * 2;
            gridBagConstraints.gridx = object3 % n2;
            gridBagConstraints.insets.bottom = 2;
            gridBagConstraints.insets.top = 5;
            jPanel.add((Component)jPanelArray[object3], gridBagConstraints);
            JLabel graphics2D = new JLabel(bufferedImage.name);
            graphics2D.setHorizontalAlignment(0);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets.top = 2;
            gridBagConstraints.insets.bottom = 5;
            jPanel.add((Component)graphics2D, gridBagConstraints);
            Dimension dimension2 = graphics2D.getPreferredSize();
            if (dimension2.width > dimension.width) {
                dimension.width = dimension2.width;
            }
            ++object3;
        }
        for (JPanel jPanel2 : jPanelArray) {
            jPanel2.setPreferredSize(dimension);
        }
        Dimension dimension3 = jPanel.getPreferredSize();
        jPanel.setSize(dimension3);
        jPanel.doLayout();
        BufferedImage bufferedImage = new BufferedImage(dimension3.width, dimension3.height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        jPanel.printAll(graphics2D);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        gameModule2.getArchiveWriter().addImage(FORCE_POOL_PNG, byArray);
        Board board = new Board();
        ADC2Module.insertComponent(board, boardPicker);
        board.setConfigureName(TRAY);
        board.setAttribute("image", FORCE_POOL_PNG);
        Rectangle rectangle = new Rectangle();
        iterator = this.forcePools.iterator(ForcePool.class);
        for (int j = 0; j < n; ++j) {
            ForcePool forcePool = (ForcePool)iterator.next();
            DrawPile drawPile = new DrawPile();
            ADC2Module.insertComponent(drawPile, map);
            JPanel jPanel3 = jPanelArray[j];
            jPanel3.getBounds(rectangle);
            drawPile.setAttribute("owningBoard", TRAY);
            drawPile.setAttribute("x", rectangle.x + rectangle.width / 2);
            drawPile.setAttribute("y", rectangle.y + rectangle.height / 2);
            drawPile.setAttribute("width", rectangle.width);
            drawPile.setAttribute("height", rectangle.height);
            drawPile.setAttribute("faceDown", "Never");
            drawPile.setAttribute("drawFaceUp", Boolean.TRUE);
            drawPile.setAttribute("shuffle", "Never");
            drawPile.setAttribute("reversible", Boolean.FALSE);
            drawPile.setAttribute("allowMultiple", Boolean.FALSE);
            drawPile.setAttribute("reshufflable", Boolean.FALSE);
            drawPile.setAttribute("name", forcePool.name);
            for (Piece piece : forcePool.getPieces()) {
                piece.writeToArchive(drawPile);
            }
        }
    }

    protected void writeSetupStacksToArchive(GameModule gameModule) throws IOException {
        Map map = this.getMainMap();
        Point point = this.getMap().getCenterOffset();
        for (int n : this.stacks.keySet()) {
            Point point2 = this.getMap().indexToPosition(n);
            if (point2 == null) continue;
            ArrayList<Piece> arrayList = this.stacks.get(n);
            SetupStack setupStack = new SetupStack();
            ADC2Module.insertComponent(setupStack, map);
            point2.translate(point.x, point.y);
            String string = map.locationName(point2);
            setupStack.setAttribute("name", string);
            Board board = this.getMap().getBoard();
            setupStack.setAttribute("owningBoard", board.getConfigureName());
            MapGrid mapGrid = board.getGrid();
            Zone zone = null;
            if (mapGrid instanceof ZonedGrid) {
                zone = ((ZonedGrid)mapGrid).findZone(point2);
            }
            setupStack.setAttribute("x", Integer.toString(point2.x));
            setupStack.setAttribute("y", Integer.toString(point2.y));
            if (zone != null) {
                try {
                    if (mapGrid.getLocation(string) != null) {
                        assert (mapGrid.locationName(mapGrid.getLocation(string)).equals(string));
                        setupStack.setAttribute("useGridLocation", true);
                        setupStack.setAttribute("location", string);
                    }
                }
                catch (MapGrid.BadCoords badCoords) {
                    // empty catch block
                }
            }
            for (Piece piece : arrayList) {
                piece.writeToArchive(setupStack);
            }
        }
    }

    protected MapBoard getMap() {
        return this.map;
    }

    protected SymbolSet getSet() {
        return this.getMap().getSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidImportFile(File file) throws IOException {
        boolean bl;
        DataInputStream dataInputStream = null;
        try {
            dataInputStream = new DataInputStream(new FileInputStream(file));
            byte by = dataInputStream.readByte();
            boolean bl2 = by == -3 || by == -2;
            dataInputStream.close();
            bl = bl2;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(dataInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(dataInputStream);
        return bl;
    }

    static {
        int n;
        FACING_ANGLES = new double[46];
        for (n = 0; n < 3; ++n) {
            ADC2Module.FACING_ANGLES[n + 1] = (double)(-n) * 90.0;
            ADC2Module.FACING_ANGLES[n + 5] = -((double)n * 90.0 + 45.0);
        }
        for (n = 0; n < 6; ++n) {
            ADC2Module.FACING_ANGLES[n + 10] = (double)(-n) * 60.0;
            ADC2Module.FACING_ANGLES[n + 20] = -(((double)n * 60.0 - 15.0) % 360.0);
            ADC2Module.FACING_ANGLES[n + 30] = -((double)n * 60.0 + 30.0);
            ADC2Module.FACING_ANGLES[n + 40] = -((double)n * 60.0 + 15.0);
        }
        usePieceNames = false;
        FLAG_BACKGROUND = new Color(1.0f, 1.0f, 0.8f, 0.8f);
        FLAG_FOREGROUND = new Color(0.5f, 0.0f, 0.5f, 1.0f);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FacingDirection {
        FLAT_SIDES,
        VERTEX,
        BOTH,
        NONE;

    }

    public static class StateFlag {
        public static final StateFlag MOVE = new StateFlag("M", FLAG_BACKGROUND, FLAG_FOREGROUND, 0);
        public static final StateFlag ATTACK = new StateFlag("A", FLAG_BACKGROUND, FLAG_FOREGROUND, 1);
        public static final StateFlag DEFEND = new StateFlag("D", FLAG_BACKGROUND, FLAG_FOREGROUND, 1);
        public static final StateFlag INFO = new StateFlag("h", FLAG_BACKGROUND, FLAG_FOREGROUND, 2);
        public static final StateFlag MARKER = new StateFlag("H", FLAG_BACKGROUND, FLAG_FOREGROUND, 2);
        public static final StateFlag COMBAT = new StateFlag("C", FLAG_BACKGROUND, FLAG_FOREGROUND, 1);
        private final String name;
        private final Color background;
        private final Color foreground;
        private final int tab;
        private String imageName;
        private final ArrayList<StatusDots> statusDots = new ArrayList();

        public StateFlag(String string, Color color, Color color2, int n) {
            this.name = string;
            this.background = color;
            this.foreground = color2;
            this.tab = n;
        }

        public String getStatusIconName() throws IOException {
            if (this.imageName == null) {
                BufferedImage bufferedImage = new BufferedImage(10, 15, 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                this.drawFlagImage(graphics2D);
                this.imageName = Importer.getUniqueImageFileName(this.name, ".png");
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                GameModule.getGameModule().getArchiveWriter().addImage(this.imageName, byArray);
            }
            return this.imageName;
        }

        public void addStatusDots(StatusDots statusDots) {
            this.statusDots.add(statusDots);
        }

        public void drawFlagImage(Graphics2D graphics2D) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setColor(this.background);
            graphics2D.fillRoundRect(-10, 0, 20, 15, 6, 6);
            graphics2D.setColor(this.foreground);
            graphics2D.drawRoundRect(-10, 0, 19, 14, 6, 6);
            graphics2D.setFont(new Font("Dialog", 0, 9));
            Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(this.name, graphics2D);
            graphics2D.drawString(this.name, 5 - (int)(rectangle2D.getWidth() / 2.0) - 1, 11);
            graphics2D.setBackground(new Color(0, 0, 0, 0));
            graphics2D.clearRect(-10, 0, 10, 15);
        }
    }

    public class PieceClass {
        public PieceClass backReplace;
        public static final String CLASS_PROPERTIES = "Class Properties";
        protected static final int NO_HIDDEN_SYMBOL = 30001;
        protected static final int PLAYER_DEFAULT_HIDDEN_SYMBOL = 30000;
        private final int[] values = new int[8];
        private final ValueType[] types = new ValueType[8];
        private final String name;
        protected SymbolSet.SymbolData symbol;
        protected int owner;
        private final int hiddenSymbol;
        private final int facing;
        private PieceClass flipClass;
        private Piece defaultPiece;
        private String uniqueName;
        private boolean flipClassAdded = false;
        private Piece flipDefinition;

        public PieceClass(String string, SymbolSet.SymbolData symbolData, int n, int n2, int n3) {
            this.name = string;
            this.symbol = symbolData;
            this.owner = n;
            this.hiddenSymbol = n2;
            this.facing = n3;
        }

        public Decorator getReplaceWithPreviousDecorator() throws IOException {
            PieceClass pieceClass = this.getBackFlipClass();
            if (pieceClass == null) {
                return null;
            }
            if (this.getFlipClass() == pieceClass) {
                return null;
            }
            GameModule gameModule = GameModule.getGameModule();
            String string = pieceClass.getFlipClassTreeConfigurePath();
            SequenceEncoder sequenceEncoder = new SequenceEncoder(string, ';');
            sequenceEncoder.append("null").append(0).append(0).append(true).append((KeyStroke)null).append("").append("").append(2).append(true);
            pieceClass.writeFlipDefinition(gameModule);
            return new Replace("replace;Flip Back;B;" + sequenceEncoder.getValue(), null);
        }

        private String getFlipClassTreeConfigurePath() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(PieceWindow.class.getName(), ':');
            sequenceEncoder.append(ADC2Module.FLIP_DEFINITIONS);
            SequenceEncoder sequenceEncoder2 = new SequenceEncoder(sequenceEncoder.getValue(), '/');
            sequenceEncoder = new SequenceEncoder(ListWidget.class.getName(), ':');
            sequenceEncoder2.append(sequenceEncoder.getValue());
            sequenceEncoder = new SequenceEncoder(PieceSlot.class.getName(), ':');
            sequenceEncoder.append(this.getUniqueName());
            sequenceEncoder2.append(sequenceEncoder.getValue());
            String string = sequenceEncoder2.getValue();
            return string;
        }

        public Decorator getReplaceWithOtherDecorator() throws IOException {
            GameModule gameModule = GameModule.getGameModule();
            PieceClass pieceClass = this.getFlipClass();
            if (pieceClass == null) {
                return null;
            }
            String string = pieceClass.getFlipClassTreeConfigurePath();
            SequenceEncoder sequenceEncoder = new SequenceEncoder(string, ';');
            sequenceEncoder.append("null").append(0).append(0).append(true).append((KeyStroke)null).append("").append("").append(2).append(true);
            pieceClass.writeFlipDefinition(gameModule);
            return new Replace("replace;Flip;F;" + sequenceEncoder.getValue(), null);
        }

        private void writeFlipDefinition(GameModule gameModule) throws IOException {
            if (!this.flipClassAdded) {
                this.flipClassAdded = true;
                ListWidget listWidget = ADC2Module.this.flipDefs.getAllDescendantComponentsOf(ListWidget.class).iterator().next();
                this.getFlipDefinition().writeToArchive(listWidget);
            }
        }

        public PieceClass getBackFlipClass() {
            if (this.backReplace == this) {
                return null;
            }
            return this.backReplace;
        }

        public DynamicProperty getDynamicPropertyDecorator() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append("Layer");
            SequenceEncoder sequenceEncoder2 = new SequenceEncoder(',');
            sequenceEncoder2.append(true).append(0).append(1).append(true);
            sequenceEncoder.append(sequenceEncoder2.getValue());
            SequenceEncoder sequenceEncoder3 = new SequenceEncoder(':');
            KeyStroke keyStroke = KeyStroke.getKeyStroke(61, 64);
            SequenceEncoder sequenceEncoder4 = new SequenceEncoder(',');
            sequenceEncoder4.append('I').append(1);
            sequenceEncoder3.append("Draw on top").append(keyStroke.getKeyCode() + "," + keyStroke.getModifiers()).append(sequenceEncoder4.getValue());
            sequenceEncoder.append(new SequenceEncoder(sequenceEncoder3.getValue(), ',').getValue());
            DynamicProperty dynamicProperty = new DynamicProperty();
            dynamicProperty.mySetType("PROP;" + sequenceEncoder.getValue());
            return dynamicProperty;
        }

        public String getUniqueName() {
            if (this.uniqueName == null) {
                this.uniqueName = this.getName();
                int n = 1;
                while (ADC2Module.this.uniquePieceNames.contains(this.uniqueName)) {
                    this.uniqueName = this.getName() + " (" + n++ + ")";
                }
                ADC2Module.this.uniquePieceNames.add(this.uniqueName);
            }
            return this.uniqueName;
        }

        public boolean checkHidden(Piece piece) {
            return piece.hideState == HideState.HIDDEN || piece.inForcePool() && this.getOwner().hiddenInForcePools();
        }

        public PropertySheet getPropertySheetDecorator() {
            Object object;
            SequenceEncoder sequenceEncoder = new SequenceEncoder('~');
            SequenceEncoder sequenceEncoder2 = new SequenceEncoder('~');
            for (int i = 0; i < ADC2Module.this.classValues.length; ++i) {
                if (ADC2Module.this.classValues[i] == null || ADC2Module.this.classValues[i].equals("")) continue;
                sequenceEncoder.append("0" + ADC2Module.this.classValues[i]);
                object = this.getValue(i);
                if (object instanceof String) {
                    sequenceEncoder2.append((String)object);
                    continue;
                }
                if (object instanceof Integer) {
                    sequenceEncoder2.append(object.toString());
                    continue;
                }
                if (object instanceof Boolean) {
                    sequenceEncoder2.append(object.equals(Boolean.TRUE) ? "yes" : "no");
                    continue;
                }
                sequenceEncoder2.append("");
            }
            PropertySheet propertySheet = null;
            if (sequenceEncoder.getValue() != null && sequenceEncoder.getValue().length() > 0) {
                propertySheet = new PropertySheet();
                object = new SequenceEncoder(';');
                ((SequenceEncoder)object).append(sequenceEncoder.getValue() == null ? "" : sequenceEncoder.getValue());
                ((SequenceEncoder)object).append(CLASS_PROPERTIES);
                ((SequenceEncoder)object).append('C');
                ((SequenceEncoder)object).append(0);
                ((SequenceEncoder)object).append("").append("").append("");
                propertySheet.mySetType("propertysheet;" + ((SequenceEncoder)object).getValue());
                propertySheet.mySetState(sequenceEncoder2.getValue());
            }
            return propertySheet;
        }

        public UsePrototype getUsePrototypeDecorator() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder("prototype;".replaceAll(";", ""), ';');
            sequenceEncoder.append(ADC2Module.COMMON_PROPERTIES);
            UsePrototype usePrototype = new UsePrototype();
            usePrototype.mySetType(sequenceEncoder.getValue());
            return usePrototype;
        }

        public Embellishment getAttackedEmbellishmentDecorator() throws IOException {
            return this.getCombatEmbellishmentDecorator("Mark Attacked", "A", StateFlag.ATTACK);
        }

        public Embellishment getDefendedEmbellishmentDecorator() throws IOException {
            return this.getCombatEmbellishmentDecorator("Mark Defended", "D", StateFlag.DEFEND);
        }

        private Embellishment getCombatEmbellishmentDecorator(String string, String string2, StateFlag stateFlag) throws IOException {
            BufferedImage bufferedImage = this.getSymbol().getImage();
            int n = (bufferedImage.getWidth() + 1) / 2 + 5;
            int n2 = 0;
            String string3 = ADC2Module.this.getFlagTab(bufferedImage.getHeight(), stateFlag);
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(string).append(2).append(string2).append("").append(0).append("").append("").append(0).append("").append("").append("").append("").append(false).append(n).append(n2).append(StringArrayConfigurer.arrayToString(new String[]{string3})).append(StringArrayConfigurer.arrayToString(new String[]{""})).append(false).append(string).append((KeyStroke)null).append("").append(false).append("").append(1);
            Embellishment embellishment = new Embellishment();
            embellishment.mySetType("emb2;" + sequenceEncoder.getValue());
            return embellishment;
        }

        public Obscurable getPieceValueMask() throws IOException {
            if (this.getOwner().useHiddenPieces()) {
                SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
                sequenceEncoder.append(KeyStroke.getKeyStroke(73, 2));
                sequenceEncoder.append(this.getImageName());
                sequenceEncoder.append("Hide Info");
                BufferedImage bufferedImage = this.getSymbol().getImage();
                sequenceEncoder.append("G" + ADC2Module.this.getFlagLayer(new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight()), StateFlag.INFO));
                if (this.name == null) {
                    sequenceEncoder.append(this.getName());
                } else {
                    sequenceEncoder.append("Unknown Piece");
                }
                sequenceEncoder.append("sides:" + this.getOwner().getName());
                Obscurable obscurable = new Obscurable();
                obscurable.mySetType("obs;" + sequenceEncoder.getValue());
                return obscurable;
            }
            return null;
        }

        public MovementMarkable getMovementMarkableDecorator() throws IOException {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            BufferedImage bufferedImage = this.getSymbol().getImage();
            int n = (bufferedImage.getWidth() + 1) / 2;
            int n2 = -bufferedImage.getHeight() / 2;
            String string = ADC2Module.this.getFlagTab(bufferedImage.getHeight(), StateFlag.MOVE);
            sequenceEncoder.append(string).append(n).append(n2);
            MovementMarkable movementMarkable = new MovementMarkable();
            movementMarkable.mySetType("markmoved;" + sequenceEncoder.getValue());
            return movementMarkable;
        }

        public Decorator getHiddenDecorator() throws IOException {
            if (this.getOwner().useHiddenPieces()) {
                Decorator decorator;
                String string = this.getOwner() == Player.ALL_PLAYERS || this.getOwner() == Player.NO_PLAYERS ? "side:" : "sides:" + this.getOwner().getName();
                SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
                sequenceEncoder.append(KeyStroke.getKeyStroke(72, 2));
                if (this.getHiddenSymbol() == null) {
                    sequenceEncoder.append("Hide Piece");
                    sequenceEncoder.append(new Color(255, 255, 255));
                    sequenceEncoder.append(string);
                    decorator = new Hideable();
                    decorator.mySetType("hide;" + sequenceEncoder.getValue());
                } else {
                    sequenceEncoder.append(this.getHiddenSymbol().getFileName());
                    sequenceEncoder.append("Hide Piece");
                    BufferedImage bufferedImage = this.getSymbol().getImage();
                    sequenceEncoder.append("G" + ADC2Module.this.getFlagLayer(new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight()), StateFlag.MARKER));
                    sequenceEncoder.append(this.getHiddenName());
                    sequenceEncoder.append(string);
                    decorator = new Obscurable();
                    ((Obscurable)decorator).mySetType("obs;" + sequenceEncoder.getValue());
                }
                return decorator;
            }
            return null;
        }

        public FreeRotator getFreeRotatorDecorator() {
            int n;
            int n2 = ADC2Module.this.getMap().getNFaces();
            switch (this.getAllowedFacings()) {
                case NONE: {
                    return null;
                }
                case FLAT_SIDES: {
                    n = n2 == 4 ? 4 : 12;
                    break;
                }
                default: {
                    n = n2 == 4 ? 8 : 24;
                }
            }
            String string = "rotate;" + n + ";];[;Rotate CW;Rotate CCW;;;;";
            FreeRotator freeRotator = new FreeRotator();
            freeRotator.mySetType(string);
            return freeRotator;
        }

        public String getHiddenName() {
            return "Unknown Piece";
        }

        protected void setValue(int n, int n2) {
            this.values[n] = n2;
            this.types[n] = ValueType.NUMERIC;
        }

        public FacingDirection getAllowedFacings() {
            if (ADC2Module.this.allowedFacings == null) {
                return FacingDirection.NONE;
            }
            if (this.facing >= ADC2Module.this.allowedFacings.length) {
                return FacingDirection.NONE;
            }
            return ADC2Module.this.allowedFacings[this.facing];
        }

        public SymbolSet.SymbolData getHiddenSymbol() throws IOException {
            if (this.hiddenSymbol == 30000) {
                return this.getOwner().getHiddenSymbol();
            }
            if (this.hiddenSymbol == 30001) {
                return null;
            }
            return ADC2Module.this.getSet().getGamePiece(this.hiddenSymbol);
        }

        public String getImageName() throws IOException {
            if (this.getSymbol() == null) {
                return null;
            }
            return this.symbol.getFileName();
        }

        public Player getOwner() {
            if (this.owner == 201) {
                return Player.NO_PLAYERS;
            }
            if (this.owner >= ADC2Module.this.players.size()) {
                return Player.ALL_PLAYERS;
            }
            return (Player)ADC2Module.this.players.get(this.owner);
        }

        public Player getPlayer(Piece piece) {
            return this.getOwner();
        }

        protected void setFlipClass(int n) {
            if (n >= 0 && n < ADC2Module.this.pieceClasses.size()) {
                this.flipClass = (PieceClass)ADC2Module.this.pieceClasses.get(n);
            }
        }

        protected void setBackFlipClass(int n) {
            this.backReplace = (PieceClass)ADC2Module.this.pieceClasses.get(n);
            assert (this.backReplace.getFlipClass() == this);
        }

        public PieceClass getFlipClass() {
            if (this.flipClass == this) {
                return null;
            }
            return this.flipClass;
        }

        public String getName() {
            return this.name;
        }

        protected void setValue(int n, String string) {
            byte[] byArray = string.getBytes();
            int n2 = 0;
            for (int i = 0; i < 4; ++i) {
                n2 = (n2 << 8) + byArray[i];
            }
            this.values[n] = n2;
            this.types[n] = ValueType.TEXT;
        }

        protected void setValue(int n, boolean bl) {
            this.values[n] = bl ? 1 : 0;
            this.types[n] = ValueType.YESNO;
        }

        public int getValueAsInt(int n) {
            return this.values[n];
        }

        public String getValueAsString(int n) {
            byte[] byArray = new byte[4];
            int n2 = 0;
            int n3 = 0x7F000000;
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)((this.values[n] & n3) >> (3 - i) * 8);
                if (byArray[i] < 32 || byArray[i] > 126) break;
                ++n2;
                n3 >>= 8;
            }
            return new String(byArray, 0, n2);
        }

        public int getNValues() {
            int n = 0;
            for (ValueType valueType : this.types) {
                if (valueType == ValueType.NOT_USED) continue;
                ++n;
            }
            return n;
        }

        public boolean getValueAsBoolean(int n) {
            return this.values[n] > 0;
        }

        public Object getValue(int n) {
            if (this.types[n] == null) {
                return null;
            }
            switch (this.types[n]) {
                case NUMERIC: {
                    return this.getValueAsInt(n);
                }
                case TEXT: {
                    return this.getValueAsString(n);
                }
                case YESNO: {
                    return this.getValueAsBoolean(n);
                }
            }
            return null;
        }

        protected void writeToArchive(ListWidget listWidget) throws IOException {
            this.getDefaultPiece().writeToArchive(listWidget);
        }

        protected Piece getDefaultPiece() {
            if (this.defaultPiece == null) {
                this.defaultPiece = new Piece(this);
            }
            return this.defaultPiece;
        }

        protected Piece getFlipDefinition() {
            if (this.flipDefinition == null) {
                this.flipDefinition = new Piece(this);
            }
            return this.flipDefinition;
        }

        protected SymbolSet.SymbolData getSymbol() throws IOException {
            return this.symbol;
        }
    }

    public class CardClass
    extends PieceClass {
        private final int setIndex;
        private final int symbolIndex;

        public CardClass(String string, int n, int n2) {
            super(string, null, 200, 30001, 0);
            this.setIndex = n2;
            this.symbolIndex = n;
        }

        public String getHiddenName() {
            if (this.getOwner() == Player.NO_PLAYERS || this.getOwner() == Player.ALL_PLAYERS) {
                return "Unknown card";
            }
            return "Unknown " + this.getOwner().getName() + " card";
        }

        public SymbolSet.SymbolData getHiddenSymbol() throws IOException {
            return ADC2Module.this.getCardDeck(this.setIndex).getGamePiece(0);
        }

        protected SymbolSet.SymbolData getSymbol() throws IOException {
            if (this.symbol == null) {
                SymbolSet symbolSet = ADC2Module.this.getCardDeck(this.setIndex);
                this.symbol = symbolSet.getGamePiece(this.symbolIndex);
            }
            return this.symbol;
        }

        protected void setValue(int n, boolean bl) {
            assert (false);
        }

        protected void setValue(int n, int n2) {
            assert (false);
        }

        protected void setValue(int n, String string) {
            assert (false);
        }

        public FreeRotator getFreeRotatorDecorator() {
            return null;
        }

        public Obscurable getPieceValueMask() throws IOException {
            return null;
        }

        public boolean checkHidden(Piece piece) {
            if (piece.getForcePool() == null) {
                return piece.hideState == HideState.HIDDEN;
            }
            if (piece.getForcePool() instanceof HandPool) {
                Player player = this.getPlayer(piece);
                return player != Player.ALL_PLAYERS && player != Player.NO_PLAYERS;
            }
            return false;
        }

        public PropertySheet getPropertySheetDecorator() {
            return null;
        }

        public Obscurable getHiddenDecorator() throws IOException {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(KeyStroke.getKeyStroke(72, 2));
            sequenceEncoder.append(this.getHiddenSymbol().getFileName());
            sequenceEncoder.append("Hide Piece");
            BufferedImage bufferedImage = this.getSymbol().getImage();
            sequenceEncoder.append("G" + ADC2Module.this.getFlagLayer(new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight()), StateFlag.MARKER));
            sequenceEncoder.append(this.getHiddenName());
            if (this.getOwner() == Player.NO_PLAYERS || this.getOwner() == Player.ALL_PLAYERS) {
                sequenceEncoder.append("side:");
            } else {
                sequenceEncoder.append("sides:" + this.getOwner().getName());
            }
            Obscurable obscurable = new Obscurable();
            obscurable.mySetType("obs;" + sequenceEncoder.getValue());
            return obscurable;
        }

        public Player getOwner() {
            return Player.ALL_PLAYERS;
        }

        public Player getPlayer(Piece piece) {
            if (piece.inForcePool() && piece.getForcePool() instanceof HandPool) {
                return ((HandPool)piece.getForcePool()).getOwner();
            }
            return this.getOwner();
        }
    }

    public static class Player {
        public static final Player ALL_PLAYERS = new Player("All Players", null, 0);
        public static final Player NO_PLAYERS = new Player("No Player", null, 0);
        public static final Player UNKNOWN = new Player("Unknown", null, 0);
        private static int nPlayers = 0;
        private final String name;
        private final SymbolSet.SymbolData hiddenSymbol;
        private final int hiddenPieceOptions;
        private final int order;
        private TreeSet<Player> allies = new TreeSet<Player>(new Comparator<Player>(){

            @Override
            public int compare(Player player, Player player2) {
                return player.order - player2.order;
            }
        });

        public Player(String string, SymbolSet.SymbolData symbolData, int n) {
            this.name = string;
            this.hiddenSymbol = symbolData;
            this.hiddenPieceOptions = n;
            this.order = nPlayers++;
            this.allies.add(this);
        }

        public boolean useHiddenPieces() {
            return (this.hiddenPieceOptions & 1) > 0;
        }

        public boolean hiddenWhenPlaced() {
            return (this.hiddenPieceOptions & 2) > 0;
        }

        public boolean hiddenInForcePools() {
            return (this.hiddenPieceOptions & 4) > 0 || this.hiddenWhenPlaced();
        }

        public boolean isGameMaster() {
            return (this.hiddenPieceOptions & 8) > 0;
        }

        public SymbolSet.SymbolData getHiddenSymbol() {
            return this.hiddenSymbol;
        }

        public String getName() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Player player : this.allies) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('/');
                }
                stringBuilder.append(player.name);
            }
            return stringBuilder.toString();
        }

        public void setAlly(Player player) {
            this.allies.add(player);
        }

        public boolean isAlly(Player player) {
            if (this.allies == null) {
                return false;
            }
            return this.allies.contains(player);
        }

        public String toString() {
            return this.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HideState {
        NOT_HIDDEN,
        INFO_HIDDEN,
        HIDDEN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValueType {
        NOT_USED,
        NUMERIC,
        TEXT,
        YESNO,
        CARD;

    }

    public class Piece {
        private static final String PIECE_PROPERTIES = "Piece Properties";
        public final PieceClass pieceClass;
        public final HideState hideState;
        private final int[] values = new int[8];
        private final ValueType[] types = new ValueType[8];
        private final String name;
        private final int flags;
        private final int facing;
        private GamePiece gamePiece;
        private PieceSlot pieceSlot;
        private final int position;
        private PropertySheet classPS = null;
        private PropertySheet piecePS = null;
        private Marker pieceNameMarker = null;

        public Piece(PieceClass pieceClass) {
            this.name = null;
            this.pieceClass = pieceClass;
            this.flags = 0;
            this.hideState = null;
            this.position = -1;
            this.facing = 0;
        }

        public Piece(int n, String string, PieceClass pieceClass, HideState hideState, int n2, int n3) {
            this.name = string == null || string.equals("") ? null : string;
            this.position = n;
            this.pieceClass = pieceClass;
            this.flags = n2;
            assert (hideState != null);
            this.hideState = hideState;
            this.facing = n3;
            HashMap hashMap = this.inForcePool() ? ADC2Module.this.forcePoolHashMap : ADC2Module.this.stacks;
            ArrayList<Piece> arrayList = (ArrayList<Piece>)hashMap.get(n);
            if (arrayList == null) {
                arrayList = new ArrayList<Piece>();
                arrayList.add(this);
                hashMap.put(n, arrayList);
            } else {
                arrayList.add(0, this);
            }
        }

        public Pool getForcePool() {
            if (this.inForcePool()) {
                return (Pool)ADC2Module.this.forcePools.get(this.position);
            }
            return null;
        }

        public boolean isCard() {
            return this.types[0] == ValueType.CARD;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Piece)) {
                return false;
            }
            return this.getUniqueClassName().equals(((Piece)object).getUniqueClassName()) && this.pieceClass == ((Piece)object).pieceClass;
        }

        protected void setValue(int n, int n2) {
            this.values[n] = n2;
            this.types[n] = ValueType.NUMERIC;
        }

        protected void writeToArchive(SetupStack setupStack) throws IOException {
            GamePiece gamePiece = this.getGamePiece();
            if (gamePiece == null) {
                return;
            }
            assert (this.pieceSlot == null);
            this.pieceSlot = new PieceSlot(gamePiece);
            ADC2Module.insertComponent(this.pieceSlot, setupStack);
        }

        protected void writeToArchive(DrawPile drawPile) throws IOException {
            GamePiece gamePiece = this.getGamePiece();
            if (gamePiece == null) {
                return;
            }
            assert (this.pieceSlot == null);
            this.pieceSlot = new CardSlot();
            this.pieceSlot.setPiece(gamePiece);
            ADC2Module.insertComponent(this.pieceSlot, drawPile);
        }

        public Player getPlayer() {
            return this.pieceClass.getOwner();
        }

        public boolean inForcePool() {
            return (this.flags & 8) > 0;
        }

        protected GamePiece getGamePiece() throws IOException {
            if (this.gamePiece == null) {
                this.gamePiece = this.getBasicPiece();
                if (this.gamePiece == null) {
                    return null;
                }
                this.appendDecorator(this.getPieceNameMarker());
                this.appendDecorator(this.getDynamicProperty());
                this.appendDecorator(this.getPieceValueMask());
                this.appendDecorator(this.getMovementMarkable());
                this.appendDecorator(this.getDefendedEmbellishment());
                this.appendDecorator(this.getAttackedEmbellishment());
                this.appendDecorator(this.getFreeRotator());
                this.appendDecorator(this.getUsePrototype());
                this.appendDecorator(this.getPiecePropertySheet());
                this.appendDecorator(this.getReplaceWithPrevious());
                this.appendDecorator(this.getReplaceWithOther());
                this.appendDecorator(this.getClassPropertySheet());
                this.appendDecorator(this.getHidden());
            }
            return this.gamePiece;
        }

        private Decorator getReplaceWithPrevious() throws IOException {
            return this.pieceClass.getReplaceWithPreviousDecorator();
        }

        private Decorator getReplaceWithOther() throws IOException {
            return this.pieceClass.getReplaceWithOtherDecorator();
        }

        private Marker getPieceNameMarker() {
            if (this.pieceNameMarker == null) {
                if (this.name != null && this.name.length() > 0) {
                    usePieceNames = true;
                }
                this.pieceNameMarker = new Marker("mark;pcName", null);
                SequenceEncoder sequenceEncoder = new SequenceEncoder(',');
                sequenceEncoder.append(this.name == null ? "" : this.name);
                this.pieceNameMarker.mySetState(sequenceEncoder.getValue());
            }
            return this.pieceNameMarker;
        }

        private void appendDecorator(Decorator decorator) {
            if (decorator != null) {
                decorator.setInner(this.gamePiece);
                this.gamePiece = decorator;
            }
        }

        protected Decorator getHidden() throws IOException {
            Player player;
            Decorator decorator = this.pieceClass.getHiddenDecorator();
            if (decorator != null && this.isHidden() && (player = this.pieceClass.getPlayer(this)) != Player.ALL_PLAYERS && player != Player.NO_PLAYERS) {
                decorator.mySetState(player.getName());
            }
            return decorator;
        }

        private boolean isHidden() {
            return this.pieceClass.checkHidden(this);
        }

        protected Obscurable getPieceValueMask() throws IOException {
            if (ADC2Module.this.usePieceValues()) {
                Obscurable obscurable = this.pieceClass.getPieceValueMask();
                if (obscurable != null && this.hideState == HideState.INFO_HIDDEN) {
                    obscurable.mySetState(this.getPlayer().getName());
                }
                return obscurable;
            }
            return null;
        }

        protected UsePrototype getUsePrototype() {
            return this.pieceClass.getUsePrototypeDecorator();
        }

        public double getFacingAngle() {
            if (this.facing >= FACING_ANGLES.length) {
                return 0.0;
            }
            return FACING_ANGLES[this.facing];
        }

        protected Embellishment getDefendedEmbellishment() throws IOException {
            Embellishment embellishment = this.pieceClass.getDefendedEmbellishmentDecorator();
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(this.hasDefended() ? 1 : -1).append("");
            embellishment.mySetState(sequenceEncoder.getValue());
            return embellishment;
        }

        protected Embellishment getAttackedEmbellishment() throws IOException {
            Embellishment embellishment = this.pieceClass.getAttackedEmbellishmentDecorator();
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(this.hasAttacked() ? 1 : -1).append("");
            embellishment.mySetState(sequenceEncoder.getValue());
            return embellishment;
        }

        protected FreeRotator getFreeRotator() {
            FreeRotator freeRotator = this.pieceClass.getFreeRotatorDecorator();
            if (freeRotator != null) {
                freeRotator.setAngle(this.getFacingAngle());
            }
            return freeRotator;
        }

        protected MovementMarkable getMovementMarkable() throws IOException {
            MovementMarkable movementMarkable = this.pieceClass.getMovementMarkableDecorator();
            if (movementMarkable != null) {
                movementMarkable.setMoved(this.hasMoved());
            }
            return movementMarkable;
        }

        protected PropertySheet getPiecePropertySheet() {
            if (this.piecePS == null) {
                Object object;
                this.piecePS = new PropertySheet();
                SequenceEncoder sequenceEncoder = new SequenceEncoder('~');
                SequenceEncoder sequenceEncoder2 = new SequenceEncoder('~');
                for (int i = 0; i < ADC2Module.this.pieceValues.length; ++i) {
                    if (ADC2Module.this.pieceValues[i] == null || ADC2Module.this.pieceValues[i].equals("")) continue;
                    sequenceEncoder.append("0" + ADC2Module.this.pieceValues[i]);
                    object = this.getValue(i);
                    if (object instanceof String) {
                        sequenceEncoder2.append((String)object);
                        continue;
                    }
                    if (object instanceof Integer) {
                        sequenceEncoder2.append(object.toString());
                        continue;
                    }
                    if (object instanceof Boolean) {
                        sequenceEncoder2.append(object.equals(Boolean.TRUE) ? "yes" : "no");
                        continue;
                    }
                    sequenceEncoder2.append("");
                }
                String string = sequenceEncoder.getValue();
                object = this.piecePS.myGetState();
                if (object == null) {
                    object = sequenceEncoder2.getValue();
                } else if (sequenceEncoder2.getValue() != null) {
                    object = this.piecePS.myGetState() + "~" + sequenceEncoder2.getValue();
                }
                if (string != null && string.length() > 0) {
                    sequenceEncoder = new SequenceEncoder(';');
                    sequenceEncoder.append(string);
                    sequenceEncoder.append(PIECE_PROPERTIES);
                    sequenceEncoder.append('P');
                    sequenceEncoder.append(0);
                    sequenceEncoder.append("").append("").append("");
                    this.piecePS.mySetType("propertysheet;" + sequenceEncoder.getValue());
                    this.piecePS.mySetState((String)object);
                } else {
                    this.piecePS = null;
                }
            }
            return this.piecePS;
        }

        protected PropertySheet getClassPropertySheet() {
            if (this.classPS == null) {
                this.classPS = this.pieceClass.getPropertySheetDecorator();
            }
            return this.classPS;
        }

        protected DynamicProperty getDynamicProperty() {
            DynamicProperty dynamicProperty = this.pieceClass.getDynamicPropertyDecorator();
            dynamicProperty.setInner(this.gamePiece);
            dynamicProperty.setValue(this.drawOnTopOfOthers() ? "1" : "0");
            return dynamicProperty;
        }

        protected GamePiece getBasicPiece() throws IOException {
            String string = this.pieceClass.getImageName();
            if (string == null) {
                return null;
            }
            SequenceEncoder sequenceEncoder = new SequenceEncoder("piece;", ';');
            sequenceEncoder.append("").append("").append(string).append(this.getUniqueClassName());
            return new BasicPiece(sequenceEncoder.getValue());
        }

        public boolean hasAttacked() {
            return (this.flags & 1) > 0;
        }

        public boolean hasDefended() {
            return !this.hasAttacked() && (this.flags & 2) > 0;
        }

        public boolean hasMoved() {
            return (this.flags & 4) > 0;
        }

        public boolean drawOnTopOfOthers() {
            return (this.flags & 0x10) > 0;
        }

        public String getUniqueClassName() {
            return this.pieceClass.getUniqueName();
        }

        public String getClassName() {
            return this.pieceClass.getName();
        }

        protected void setValue(int n, String string) {
            byte[] byArray = string.getBytes();
            int n2 = 0;
            for (int i = 0; i < 4; ++i) {
                n2 = (n2 << 8) + byArray[i];
            }
            this.values[n] = n2;
            this.types[n] = ValueType.TEXT;
        }

        protected void setValue(int n, boolean bl) {
            this.values[n] = bl ? 1 : 0;
            this.types[n] = ValueType.YESNO;
        }

        private int getValueAsInt(int n) {
            return this.values[n];
        }

        private String getValueAsString(int n) {
            byte[] byArray = new byte[4];
            int n2 = 0x7F000000;
            int n3 = 0;
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)((this.values[n] & n2) >> (3 - i) * 8);
                if (byArray[i] < 32 || byArray[i] > 126) break;
                ++n3;
                n2 >>= 8;
            }
            return new String(byArray, 0, n3);
        }

        private boolean getValueAsBoolean(int n) {
            return this.values[n] > 0;
        }

        public Object getValue(int n) {
            if (this.types[n] == null) {
                return null;
            }
            switch (this.types[n]) {
                case NUMERIC: {
                    return this.getValueAsInt(n);
                }
                case TEXT: {
                    return this.getValueAsString(n);
                }
                case YESNO: {
                    return this.getValueAsBoolean(n);
                }
            }
            return null;
        }

        protected void writeToArchive(ListWidget listWidget) throws IOException {
            GamePiece gamePiece = this.getGamePiece();
            if (gamePiece == null) {
                return;
            }
            this.pieceSlot = new PieceSlot(gamePiece);
            ADC2Module.insertComponent(this.pieceSlot, listWidget);
        }

        protected PieceSlot getPieceSlot() {
            return this.pieceSlot;
        }
    }

    public class StatusDots {
        public static final int NOT_USED = 0;
        public static final int MOVED = 1;
        public static final int IN_COMBAT = 2;
        public static final int ATTACKED = 3;
        public static final int DEFENDED = 4;
        public static final int CLASS_VALUE = 5;
        public static final int PIECE_VALUE = 6;
        public static final int DO_NOT_DRAW = 0;
        public static final int TOP_LEFT = 1;
        public static final int TOP_CENTER = 2;
        public static final int TOP_RIGHT = 3;
        public static final int CENTER_LEFT = 4;
        public static final int CENTER_CENTER = 5;
        public static final int CENTER_RIGHT = 6;
        public static final int BOTTOM_LEFT = 7;
        public static final int BOTTOM_CENTER = 8;
        public static final int BOTTOM_RIGHT = 9;
        private final int type;
        private final int show;
        private final Color color;
        private final int position;
        private final int size;

        protected StatusDots(int n, int n2, Color color, int n3, int n4) {
            this.type = n;
            this.show = n2;
            this.color = color;
            this.position = n3;
            this.size = n4;
        }

        public Color getColor() {
            return this.color;
        }

        public int getPosition() {
            return this.position;
        }

        public int getShow() {
            return this.show;
        }

        public int getSize() {
            return this.size;
        }

        public int getType() {
            return this.type & 0xF;
        }

        public String getStatusPropertyName() {
            if (this.getType() == 5) {
                return ADC2Module.this.classValues[this.type >>> 4];
            }
            if (this.getType() == 6) {
                return ADC2Module.this.pieceValues[this.type >>> 4];
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ForcePool
    extends Pool {
        @Override
        boolean isUseable() {
            if (this.getPieces().size() > 0) {
                return true;
            }
            if (this.name == null) {
                return false;
            }
            for (int i = 0; i < this.name.length(); ++i) {
                if (!Character.isLetterOrDigit(this.name.charAt(i))) continue;
                return true;
            }
            return false;
        }

        ForcePool(String string, ArrayList<Piece> arrayList) {
            super(string, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class HandPool
    extends Cards {
        HandPool(String string, ArrayList<Piece> arrayList) {
            super(string, arrayList);
        }

        @Override
        String getButtonName() {
            return super.getButtonName() + " (" + this.getOwner().getName() + " Hand)";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DeckPool
    extends Cards {
        DeckPool(String string, ArrayList<Piece> arrayList) {
            super(string, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Cards
    extends Pool {
        protected Player owner;

        Cards(String string, ArrayList<Piece> arrayList) {
            super(string, arrayList);
            if (arrayList != null) {
                Iterator<Piece> iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().isCard()) continue;
                    iterator.remove();
                }
            }
        }

        public void setOwner(int n) {
            this.owner = n == 201 ? Player.NO_PLAYERS : (n >= 200 ? Player.ALL_PLAYERS : (n >= ADC2Module.this.players.size() ? Player.UNKNOWN : (Player)ADC2Module.this.players.get(n)));
        }

        public Player getOwner() {
            return this.owner;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Pool {
        public final String name;
        public final ArrayList<Piece> pieces;

        Pool(String string, ArrayList<Piece> arrayList) {
            this.name = string;
            this.pieces = arrayList;
        }

        List<Piece> getPieces() {
            if (this.pieces == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.pieces);
        }

        String getButtonName() {
            return this.name;
        }

        boolean isUseable() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ForcePoolList
    extends ArrayList<Pool> {
        private static final long serialVersionUID = 1L;

        protected ForcePoolList() {
        }

        public int count(Class<?> clazz) {
            int n = 0;
            Iterator<Pool> iterator = this.iterator(clazz);
            while (iterator.hasNext()) {
                Pool pool = iterator.next();
                if (pool.getClass() != clazz || !pool.isUseable()) continue;
                ++n;
            }
            return n;
        }

        public Iterator<Pool> iterator(Class<?> clazz) {
            return new ForcePoolIterator(clazz);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ForcePoolIterator
        implements Iterator<Pool> {
            private final Class<?> type;
            private int cursor = 0;

            private ForcePoolIterator(Class<?> clazz) {
                this.type = clazz;
                this.setNext();
            }

            private void setNext() {
                while (!(this.cursor >= ForcePoolList.this.size() || ((Pool)ForcePoolList.this.get(this.cursor)).getClass() == this.type && ((Pool)ForcePoolList.this.get(this.cursor)).isUseable())) {
                    ++this.cursor;
                }
            }

            @Override
            public boolean hasNext() {
                return this.cursor < ForcePoolList.this.size();
            }

            @Override
            public Pool next() {
                Pool pool = (Pool)ForcePoolList.this.get(this.cursor);
                ++this.cursor;
                this.setNext();
                return pool;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

